/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ldap.ClassFlag;

public final class LDAPClassFlags
implements Cloneable {
    public static final int EFFECTIVE_CLASS = 1;
    public static final int AUXILIARY_CLASS = 2;
    public static final int CONTAINER_CLASS = 4;
    public static final int NONREMOVABLE_CLASS = 8;
    private static final int CLONE_NOT_SUPPORTED = 1;
    private int flags;
    private static final ClassFlag[] classFlagTable = new ClassFlag[]{new ClassFlag(1, "Effective"), new ClassFlag(2, "Auxiliary"), new ClassFlag(4, "Container"), new ClassFlag(8, "Non-removable")};

    public LDAPClassFlags(int flags) {
        this.flags = flags;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LDAPClassFlags) {
            LDAPClassFlags classFlags = (LDAPClassFlags)obj;
            return classFlags.flags == this.flags;
        }
        return false;
    }

    public boolean isFlagSet(int flagId) {
        return 0 != (this.flags & flagId);
    }

    public void setFlag(int flagId) {
        this.flags |= flagId;
    }

    public void clearFlag(int flagId) {
        this.flags &= ~flagId;
    }

    public Object clone() {
        try {
            return (LDAPClassFlags)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AdminError(1, this.getClass());
        }
    }

    public String[] getStrings() {
        int indx;
        int count = 0;
        for (indx = 0; indx < classFlagTable.length; ++indx) {
            if (0 == (this.flags & LDAPClassFlags.classFlagTable[indx].flag)) continue;
            ++count;
        }
        String[] flagStrings = new String[count];
        count = 0;
        for (indx = 0; indx < classFlagTable.length; ++indx) {
            if (0 == (this.flags & LDAPClassFlags.classFlagTable[indx].flag)) continue;
            flagStrings[count++] = LDAPClassFlags.classFlagTable[indx].string;
        }
        return flagStrings;
    }
}

