/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.DefaultNSObject;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ldap.LDAPAttributeDefinition;
import com.novell.admin.ns.ldap.LDAPNamespaceException;
import com.novell.admin.ns.ldap.LDAPSyntax;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import java.util.Enumeration;
import java.util.Vector;

public class LDAPNSObject
extends DefaultNSObject {
    public LDAPNSObject(ObjectEntry objEntry, Vector initialAttributes, long rev) {
        super(objEntry, initialAttributes, rev);
    }

    public void initObjectClassAttribute(ObjectAttribute objClassAttr) {
        this.attributes.put("objectclass", objClassAttr);
    }

    public boolean addAuxiliaryClassDefinition(ClassDefinition classDef, ObjectAttribute[] attributes) throws NamespaceException {
        boolean attrsAdded = super.addAuxiliaryClassDefinition(classDef, attributes);
        ObjectAttribute objClassAttr = this.getAttribute("objectClass");
        if (objClassAttr == null) {
            throw LDAPNamespaceException.NO_RIGHTS_TO_ADD_AUXILIARY_CLASS;
        }
        Syntax syn = objClassAttr.getAttributeDefinition().getSyntax();
        objClassAttr.addComponent(new StringValue(syn, classDef.getName()));
        return attrsAdded;
    }

    public boolean deleteAuxiliaryClassDefinition(ClassDefinition classDef) throws NamespaceException {
        boolean classDeleted = super.deleteAuxiliaryClassDefinition(classDef);
        if (classDeleted) {
            ObjectAttribute objClassAttr = this.getAttribute("objectClass");
            if (objClassAttr == null) {
                throw LDAPNamespaceException.NO_RIGHTS_TO_REMOVE_AUXILIARY_CLASS;
            }
            objClassAttr.removeComponent(new StringValue(LDAPSyntax.SYN_CLASS_NAME, classDef.getName()));
        }
        return classDeleted;
    }

    public NSObject clone(ObjectEntry newIdentity) throws NamespaceException {
        int i;
        ObjectType[] newObjectTypes;
        LDAPNSObject newNSObject = null;
        if (newIdentity.getObjectType() != this.objectEntry.getObjectType()) {
            throw NamespaceException.OBJECTTYPE_NOT_VALID;
        }
        ObjectType[] oldObjectTypes = this.objectEntry.getSubTypes();
        if (oldObjectTypes.length != (newObjectTypes = newIdentity.getSubTypes()).length) {
            throw NamespaceException.OBJECTTYPE_NOT_VALID;
        }
        Vector<ObjectType> objectTypeVec = new Vector<ObjectType>(oldObjectTypes.length);
        for (i = 0; i < oldObjectTypes.length; ++i) {
            objectTypeVec.addElement(oldObjectTypes[i]);
        }
        for (i = 0; i < oldObjectTypes.length; ++i) {
            if (objectTypeVec.contains(newObjectTypes[i])) continue;
            throw NamespaceException.OBJECTTYPE_NOT_VALID;
        }
        newNSObject = (LDAPNSObject)this.clone();
        newNSObject.objectEntry = newIdentity;
        Enumeration myenum = newNSObject.attributes.elements();
        while (myenum.hasMoreElements()) {
            ObjectAttribute attr = (ObjectAttribute)myenum.nextElement();
            LDAPAttributeDefinition attrDef = (LDAPAttributeDefinition)attr.getAttributeDefinition();
            if (!attrDef.isReadOnly()) continue;
            newNSObject.attributes.remove(attrDef.getName().toLowerCase());
        }
        ObjectAttribute objectClassAttr = (ObjectAttribute)newNSObject.attributes.get("objectclass");
        String objectClassVal = newIdentity.getObjectType().getName();
        StringValue strVal = null;
        Enumeration valEnum = objectClassAttr.getValueComponents();
        while (valEnum.hasMoreElements() && !(strVal = (StringValue)valEnum.nextElement()).getValue().equals(objectClassVal)) {
        }
        objectClassAttr.removeAllComponents();
        objectClassAttr.addComponent(strVal);
        return newNSObject;
    }
}

