/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.ListStrategy;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ldap.LDAPSyntax;
import com.novell.admin.ns.ldap.NameAndUIDFacade;
import java.util.Vector;

final class NameAndUIDStrategy
extends ListStrategy {
    NameAndUIDStrategy() {
    }

    public ValueComponent createValueComponent() {
        ValueList list = new ValueList(LDAPSyntax.SYN_NAME_UID);
        list.initList(LDAPSyntax.SYN_DN.createValueComponent());
        return list;
    }

    public ValueComponent createValueComponent(Object paramObj) throws ComponentCreationException {
        String dn = null;
        String bits = null;
        if (paramObj instanceof Vector) {
            Vector v = (Vector)paramObj;
            if (v.elementAt(0) instanceof String) {
                dn = (String)v.elementAt(0);
            }
            if (v.size() > 1 && v.elementAt(1) instanceof String) {
                bits = (String)v.elementAt(1);
            }
        } else if (paramObj instanceof String) {
            String params;
            dn = params = (String)paramObj;
            int lastPound = params.lastIndexOf("#");
            if (lastPound > -1) {
                bits = params.substring(lastPound + 1);
                if (bits.startsWith("'")) {
                    dn = params.substring(0, lastPound);
                } else {
                    bits = null;
                }
            }
        } else {
            throw new ComponentCreationException();
        }
        ValueList list = new ValueList(LDAPSyntax.SYN_NAME_UID);
        list.initList(LDAPSyntax.SYN_DN.createValueComponent(dn));
        if (bits != null) {
            list.initList(LDAPSyntax.SYN_BIT_STRING.createValueComponent(bits));
        }
        return list;
    }

    public Object createFacade(ValueComponent comp) throws IncompatibleComponentException {
        return new NameAndUIDFacade((ValueList)comp);
    }

    public boolean canInsertComponent(ValueList list, ValueComponent comp) {
        return true;
    }

    public boolean canRemoveComponent(ValueList list, ValueComponent comp) {
        return true;
    }

    public String toString(ValueComponent vc) {
        if (vc instanceof ValueList) {
            ValueList list = (ValueList)vc;
            String dn = list.getElementAt(0).toString();
            int count = list.getComponentCount();
            if (count == 1) {
                return dn;
            }
            return dn + "#" + list.getElementAt(1).toString();
        }
        return vc.toString();
    }
}

