/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.ListStrategy;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ldap.LDAPSyntax;
import com.novell.admin.ns.nds.ObjectACLFacade;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

final class ObjectACLStrategy
extends ListStrategy {
    private static final int INHERIT_CTL_BIT = 64;

    ObjectACLStrategy() {
    }

    public ValueComponent createValueComponent() {
        ValueList list = new ValueList(LDAPSyntax.SYN_NDS_ACL);
        list.initList(LDAPSyntax.SYN_DIRECTORY_STRING.createValueComponent());
        list.initList(LDAPSyntax.SYN_DN.createValueComponent());
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueComponent createValueComponent(Object paramObj) throws ComponentCreationException {
        Long priv = null;
        String scope = null;
        String subject = null;
        String attrName = null;
        if (paramObj instanceof String) {
            StringTokenizer st = new StringTokenizer((String)paramObj, "#");
            priv = new Long(st.nextToken());
            scope = st.nextToken();
            subject = st.nextToken();
            attrName = st.nextToken();
            int bit = -1;
            if (attrName.equalsIgnoreCase("[Entry Rights]") || attrName.equalsIgnoreCase("[All Attributes Rights]")) {
                if (scope.equalsIgnoreCase("entry")) {
                    bit = 1;
                } else if (scope.equalsIgnoreCase("subtree")) {
                    bit = 0;
                }
            } else if (scope.equalsIgnoreCase("entry")) {
                bit = 0;
            } else if (scope.equalsIgnoreCase("subtree")) {
                bit = 1;
            }
            if (bit == 1) {
                priv = new Long((long)(priv | 0x40L));
            } else if (bit == 0) {
                priv = new Long((long)(priv & 0xFFFFFFFFFFFFFFBFL));
            }
        } else if (paramObj instanceof Vector) {
            Vector compList = null;
            compList = (Vector)paramObj;
            if (compList.size() != 3) {
                throw new ComponentCreationException();
            }
            Vector vector = compList;
            synchronized (vector) {
                Enumeration e = compList.elements();
                while (e.hasMoreElements()) {
                    Object comp = e.nextElement();
                    if (comp instanceof String) {
                        if (attrName == null) {
                            attrName = (String)comp;
                            continue;
                        }
                        subject = (String)comp;
                        continue;
                    }
                    if (!(comp instanceof Long)) continue;
                    priv = (Long)comp;
                }
            }
        } else {
            throw new ComponentCreationException();
        }
        ValueList list = new ValueList(LDAPSyntax.SYN_NDS_ACL);
        list.initList(LDAPSyntax.SYN_DIRECTORY_STRING.createValueComponent(attrName));
        list.initList(LDAPSyntax.SYN_DN.createValueComponent(subject));
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent(priv));
        return list;
    }

    public Object createFacade(ValueComponent comp) throws IncompatibleComponentException {
        return new ObjectACLFacade((ValueList)comp);
    }

    public String toString(ValueComponent vc) {
        if (vc instanceof ValueList) {
            ValueList list = (ValueList)vc;
            String attrName = ((StringValue)list.getElementAt(0)).getValue();
            String subject = ((StringValue)list.getElementAt(1)).getValue();
            long privs = ((LongValue)list.getElementAt(2)).getValue();
            long inheritBit = privs & 0x40L;
            String scope = "subtree";
            if (attrName.equalsIgnoreCase("[All Attributes Rights]") || attrName.equalsIgnoreCase("[Entry Rights]")) {
                if (inheritBit != 0L) {
                    scope = "entry";
                }
            } else if (inheritBit == 0L) {
                scope = "entry";
            }
            return privs + "#" + scope + "#" + subject + "#" + attrName;
        }
        return vc.toString();
    }
}

