/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ValueListFacade;

public final class OtherMailboxFacade
extends ValueListFacade {
    private static final int COMP_CREATE = 1;

    public OtherMailboxFacade(ValueList comp) throws IncompatibleComponentException {
        super(comp);
        String name = comp.getSyntax().getName();
        if (!name.equals("Other Mailbox")) {
            throw new IncompatibleComponentException();
        }
    }

    public static ValueList createValueList(String mailboxType, String mailbox, Syntax syn) {
        try {
            String otherMB = mailboxType + "$" + mailbox;
            ValueComponent vc = syn.createValueComponent(otherMB);
            return (ValueList)vc;
        }
        catch (ComponentCreationException e) {
            throw new AdminError(1, "com.novell.admin.ns.ldap.OtherMailboxFacade");
        }
    }

    public String getMailboxType() {
        StringValue v = (StringValue)this.valueList.getElementAt(0);
        return v.getValue();
    }

    public void setMailboxType(String mailboxType) {
        this.replaceStringValue(mailboxType, 0);
    }

    public String getMailbox() {
        StringValue v = (StringValue)this.valueList.getElementAt(1);
        return v.getValue();
    }

    public void setMailbox(String mailbox) {
        this.replaceStringValue(mailbox, 1);
    }
}

