/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.ListStrategy;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ldap.LDAPSyntax;
import com.novell.admin.ns.ldap.OtherMailboxFacade;
import java.util.StringTokenizer;
import java.util.Vector;

final class OtherMailboxStrategy
extends ListStrategy {
    OtherMailboxStrategy() {
    }

    public ValueComponent createValueComponent() {
        ValueList list = new ValueList(LDAPSyntax.SYN_OTHER_MAILBOX);
        list.initList(LDAPSyntax.SYN_PRINTABLE_STRING.createValueComponent());
        list.initList(LDAPSyntax.SYN_IA5_STRING.createValueComponent());
        return list;
    }

    public ValueComponent createValueComponent(Object paramObj) throws ComponentCreationException {
        String type = null;
        String box = null;
        if (paramObj instanceof String) {
            StringTokenizer st = new StringTokenizer((String)paramObj, "$");
            if (st.hasMoreTokens()) {
                type = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                box = st.nextToken();
            }
        } else if (paramObj instanceof Vector) {
            Vector compList = (Vector)paramObj;
            if (compList.size() < 2) {
                throw new ComponentCreationException();
            }
            if (compList.get(0) instanceof String) {
                type = (String)compList.get(0);
            }
            if (compList.get(1) instanceof String) {
                box = (String)compList.get(1);
            }
        } else {
            throw new ComponentCreationException();
        }
        ValueList list = new ValueList(LDAPSyntax.SYN_OTHER_MAILBOX);
        list.initList(LDAPSyntax.SYN_PRINTABLE_STRING.createValueComponent(type));
        list.initList(LDAPSyntax.SYN_IA5_STRING.createValueComponent(box));
        return list;
    }

    public Object createFacade(ValueComponent comp) throws IncompatibleComponentException {
        return new OtherMailboxFacade((ValueList)comp);
    }

    public String toString(ValueComponent vc) {
        if (vc instanceof ValueList) {
            ValueList list = (ValueList)vc;
            return list.getElementAt(0) + "$" + list.getElementAt(1);
        }
        return vc.toString();
    }
}

