/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.ListStrategy;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ldap.LDAPSyntax;
import com.novell.admin.ns.nds.PostalAddressFacade;
import java.util.Enumeration;
import java.util.Vector;

final class PostalAddressStrategy
extends ListStrategy {
    PostalAddressStrategy() {
    }

    public ValueComponent createValueComponent() {
        ValueList list = new ValueList(LDAPSyntax.SYN_POSTAL_ADDRESS);
        for (int i = 0; i < 6; ++i) {
            list.initList(LDAPSyntax.SYN_DIRECTORY_STRING.createValueComponent());
        }
        return list;
    }

    public ValueComponent createValueComponent(Object paramObj) throws ComponentCreationException {
        if (paramObj instanceof String) {
            Vector<String> v = new Vector<String>(6);
            String str = (String)((Object)paramObj);
            int startIndex = 0;
            int delim = 0;
            while (delim >= 0) {
                delim = str.indexOf(36, startIndex);
                if (delim >= 0) {
                    v.addElement(str.substring(startIndex, delim));
                } else {
                    v.addElement(str.substring(startIndex));
                }
                startIndex = delim + 1;
            }
            paramObj = v;
        } else if (!(paramObj instanceof Vector)) {
            throw new ComponentCreationException();
        }
        Vector compList = paramObj;
        ValueList list = new ValueList(LDAPSyntax.SYN_POSTAL_ADDRESS);
        Enumeration e = compList.elements();
        for (int i = 0; i < 6; ++i) {
            Object comp = null;
            if (e.hasMoreElements()) {
                comp = e.nextElement();
                if (comp instanceof String) {
                    list.initList(LDAPSyntax.SYN_DIRECTORY_STRING.createValueComponent(comp));
                } else {
                    comp = null;
                }
            }
            if (comp != null) continue;
            list.initList(LDAPSyntax.SYN_DIRECTORY_STRING.createValueComponent());
        }
        if (e.hasMoreElements()) {
            throw new ComponentCreationException();
        }
        return list;
    }

    public String toString(ValueComponent vc) {
        if (vc instanceof ValueList) {
            ValueComponent line;
            int count;
            ValueList list = (ValueList)vc;
            for (count = list.getComponentCount(); count > 1 && (line = list.getElementAt(count - 1)).toString().length() <= 0; --count) {
            }
            String str = list.getElementAt(0).toString();
            for (int i = 1; i < count; ++i) {
                str = str + "$" + list.getElementAt(i).toString();
            }
            return str;
        }
        return vc.toString();
    }

    public Object createFacade(ValueComponent comp) throws IncompatibleComponentException {
        return new PostalAddressFacade((ValueList)comp);
    }
}

