/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.ListStrategy;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ldap.LDAPSyntax;
import com.novell.admin.ns.nds.ReplicaPointerFacade;
import java.util.Enumeration;
import java.util.Vector;

final class ReplicaPointerStrategy
extends ListStrategy {
    ReplicaPointerStrategy() {
    }

    public ValueComponent createValueComponent() {
        ValueList list = new ValueList(LDAPSyntax.SYN_NDS_REPLICA_POINTER);
        list.initList(LDAPSyntax.SYN_DN.createValueComponent());
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent());
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent());
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent());
        list.initList(LDAPSyntax.SYN_NET_ADDRESS.createValueComponent());
        return list;
    }

    public ValueComponent createValueComponent(Object vectorObj) throws ComponentCreationException {
        Vector compList = (Vector)vectorObj;
        ValueList list = new ValueList(LDAPSyntax.SYN_NDS_REPLICA_POINTER);
        String serverName = null;
        Integer replicaType = null;
        Integer replicaNumber = null;
        Integer replicaCount = null;
        ValueList hint = null;
        if (!(vectorObj instanceof Vector)) {
            throw new ComponentCreationException();
        }
        Enumeration e = compList.elements();
        while (e.hasMoreElements()) {
            ValueList vl;
            Object comp = e.nextElement();
            if (comp instanceof String) {
                serverName = (String)comp;
                continue;
            }
            if (comp instanceof Integer) {
                if (replicaType == null) {
                    replicaType = (Integer)comp;
                    continue;
                }
                if (replicaNumber == null) {
                    replicaNumber = (Integer)comp;
                    continue;
                }
                if (replicaCount == null) {
                    replicaCount = (Integer)comp;
                    continue;
                }
                throw new ComponentCreationException();
            }
            if (!(comp instanceof ValueList) || (vl = (ValueList)comp).getSyntax() != LDAPSyntax.SYN_NET_ADDRESS) continue;
            hint = vl;
        }
        list.initList(LDAPSyntax.SYN_DN.createValueComponent(serverName));
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent(replicaType));
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent(replicaNumber));
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent(replicaCount));
        list.initList(hint);
        return list;
    }

    public Object createFacade(ValueComponent comp) throws IncompatibleComponentException {
        return new ReplicaPointerFacade((ValueList)comp);
    }
}

