/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.ListStrategy;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ldap.GSERValue;
import com.novell.admin.ns.ldap.LDAPSyntax;
import com.novell.admin.ns.nds.PathFacade;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

final class TaggedNameAndStringStrategy
extends ListStrategy {
    private static final int WITHIN_BOUNDS = 1;
    private int encoding;

    public TaggedNameAndStringStrategy(int encoding) {
        this.encoding = encoding;
    }

    public ValueComponent createValueComponent() {
        ValueList list = this.encoding == 1 ? new ValueList(LDAPSyntax.SYN_TAGGED_NAME_AND_STRING) : new ValueList(LDAPSyntax.SYN_NVDS_TAGGED_NAME_AND_STRING);
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent());
        list.initList(LDAPSyntax.SYN_DN.createValueComponent());
        list.initList(LDAPSyntax.SYN_DIRECTORY_STRING.createValueComponent());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueComponent createValueComponent(Object paramObj) throws ComponentCreationException {
        Long num = null;
        String dn = null;
        String str = null;
        ValueList list = this.encoding == 1 ? new ValueList(LDAPSyntax.SYN_TAGGED_NAME_AND_STRING) : new ValueList(LDAPSyntax.SYN_NVDS_TAGGED_NAME_AND_STRING);
        if (paramObj instanceof Vector) {
            Vector compList = (Vector)paramObj;
            if (compList.size() != 3) {
                throw new ComponentCreationException();
            }
            Vector vector = compList;
            synchronized (vector) {
                Enumeration e = compList.elements();
                while (e.hasMoreElements()) {
                    Object comp = e.nextElement();
                    if (comp instanceof Long) {
                        num = (Long)comp;
                        continue;
                    }
                    if (!(comp instanceof String)) continue;
                    if (dn == null) {
                        dn = (String)comp;
                        continue;
                    }
                    str = (String)comp;
                }
            }
        } else if (paramObj instanceof String) {
            String strval = (String)paramObj;
            if (strval.charAt(0) == '{') {
                GSERValue gval = new GSERValue(strval);
                num = new Long((String)gval.get("type"));
                dn = (String)gval.get("dn");
                str = (String)gval.get("value");
            } else {
                StringTokenizer st = new StringTokenizer(strval, "#");
                if (strval.charAt(0) == '#') {
                    dn = "";
                } else {
                    if (st.countTokens() != 3) {
                        throw new ComponentCreationException();
                    }
                    dn = st.nextToken();
                }
                num = new Long(st.nextToken());
                str = st.nextToken();
            }
        } else {
            throw new ComponentCreationException();
        }
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent(num));
        list.initList(LDAPSyntax.SYN_DN.createValueComponent(dn));
        list.initList(LDAPSyntax.SYN_DIRECTORY_STRING.createValueComponent(str));
        return list;
    }

    public Object createFacade(ValueComponent comp) throws IncompatibleComponentException {
        return new PathFacade((ValueList)comp);
    }

    public boolean isWithinBounds(ValueComponent comp, long lowerBound, long upperBound) {
        ValueList vl;
        if (comp instanceof ValueList && (vl = (ValueList)comp).getSyntax() == LDAPSyntax.SYN_TAGGED_NAME_AND_STRING) {
            StringValue v = (StringValue)vl.getElementAt(0);
            return v.isWithinBounds(lowerBound, upperBound);
        }
        throw new AdminError(1, this.getClass());
    }

    public String toString(ValueComponent vc) {
        if (vc instanceof ValueList) {
            ValueList list = (ValueList)vc;
            if (this.encoding == 2) {
                String dn = list.getElementAt(1).toString().replaceAll("\"", "\"\"");
                String str = list.getElementAt(2).toString().replaceAll("\"", "\"\"");
                return "{ type " + list.getElementAt(0) + ", dn \"" + dn + "\", value \"" + str + "\" }";
            }
            return list.getElementAt(1) + "#" + list.getElementAt(0) + "#" + list.getElementAt(2);
        }
        return vc.toString();
    }
}

