/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.ListStrategy;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ldap.GSERValue;
import com.novell.admin.ns.ldap.LDAPSyntax;
import com.novell.admin.ns.nds.TypedNameFacade;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

final class TypedNameStrategy
extends ListStrategy {
    private int encoding;

    public TypedNameStrategy(int encoding) {
        this.encoding = encoding;
    }

    public ValueComponent createValueComponent() {
        ValueList list = this.encoding == 1 ? new ValueList(LDAPSyntax.SYN_TYPED_NAME) : new ValueList(LDAPSyntax.SYN_NVDS_TYPED_NAME);
        list.initList(LDAPSyntax.SYN_DN.createValueComponent());
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent());
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueComponent createValueComponent(Object paramObj) throws ComponentCreationException {
        String object = null;
        Long level = null;
        Long interval = null;
        ValueList list = this.encoding == 1 ? new ValueList(LDAPSyntax.SYN_TYPED_NAME) : new ValueList(LDAPSyntax.SYN_NVDS_TYPED_NAME);
        if (paramObj instanceof Vector) {
            Vector compList = (Vector)paramObj;
            if (compList.size() != 3) {
                throw new ComponentCreationException();
            }
            Vector vector = compList;
            synchronized (vector) {
                Enumeration e = compList.elements();
                while (e.hasMoreElements()) {
                    Object comp = e.nextElement();
                    if (comp instanceof String) {
                        object = (String)comp;
                        continue;
                    }
                    if (!(comp instanceof Long)) continue;
                    if (level == null) {
                        level = (Long)comp;
                        continue;
                    }
                    interval = (Long)comp;
                }
            }
        } else if (paramObj instanceof String) {
            String str = (String)paramObj;
            if (str.charAt(0) == '{') {
                GSERValue gval = new GSERValue(str);
                object = (String)gval.get("dn");
                level = new Long((String)gval.get("level"));
                interval = new Long((String)gval.get("interval"));
            } else {
                StringTokenizer st = new StringTokenizer((String)paramObj, "#");
                object = ((String)paramObj).charAt(0) == '#' ? "" : st.nextToken();
                level = new Long(st.nextToken());
                interval = new Long(st.nextToken());
            }
        } else {
            throw new ComponentCreationException();
        }
        list.initList(LDAPSyntax.SYN_DN.createValueComponent(object));
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent(level));
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent(interval));
        return list;
    }

    public Object createFacade(ValueComponent comp) throws IncompatibleComponentException {
        return new TypedNameFacade((ValueList)comp);
    }

    public String toString(ValueComponent vc) {
        if (vc instanceof ValueList) {
            ValueList list = (ValueList)vc;
            if (this.encoding == 2) {
                String dn = list.getElementAt(0).toString().replaceAll("\"", "\"\"");
                return "{ level " + list.getElementAt(1) + ", interval " + list.getElementAt(2) + ", dn \"" + dn + "\" }";
            }
            return list.getElementAt(0) + "#" + list.getElementAt(1) + "#" + list.getElementAt(2);
        }
        return vc.toString();
    }
}

