/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap.jndi;

import com.novell.admin.common.exceptions.AdminNamespaceExceptionReference;
import com.novell.admin.common.exceptions.LDAPSPIException;
import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.SimpleSPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.event.DirectoryEvent;
import com.novell.admin.event.DirectoryEventImpl;
import com.novell.admin.event.DirectoryEventListener;
import com.novell.admin.event.DirectoryModifyEventImpl;
import com.novell.admin.event.ModifiedAttributeDefinition;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.BooleanValue;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.DateValue;
import com.novell.admin.ns.HexValue;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.MOOManager;
import com.novell.admin.ns.MOOManagerCallBack;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NSObjectCache;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.ObjectOperation;
import com.novell.admin.ns.PartitionService;
import com.novell.admin.ns.Rights;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ldap.LDAPAttributeDefinition;
import com.novell.admin.ns.ldap.LDAPClassDefinition;
import com.novell.admin.ns.ldap.LDAPClassFlags;
import com.novell.admin.ns.ldap.LDAPNSObject;
import com.novell.admin.ns.ldap.LDAPNamespace;
import com.novell.admin.ns.ldap.LDAPRes;
import com.novell.admin.ns.ldap.LDAPSchemaDefinition;
import com.novell.admin.ns.ldap.LDAPSyntax;
import com.novell.admin.ns.ldap.LDAPschema;
import com.novell.admin.ns.ldap.jndi.ChildObjectEntryEnumerationImpl;
import com.novell.admin.ns.ldap.jndi.LDAPObjectRightsImpl;
import com.novell.admin.ns.ldap.jndi.LDAPPropertyRightsImpl;
import com.novell.admin.ns.ldap.jndi.LDAPSchemaImpl;
import com.novell.admin.ns.ldap.jndi.NVDSPrivs;
import com.novell.admin.ns.ldap.jndi.XMLPayloadRequest;
import com.novell.admin.ns.ldap.jndi.XMLPayloadResponse;
import com.novell.admin.ns.nds.ObjectACLFacade;
import com.novell.admin.ns.nds.ObjectFlags;
import com.novell.application.console.snapin.Debug;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectEntryParentAndSimpleName;
import com.novell.application.console.snapin.ObjectType;
import com.novell.application.console.snapin.ResultModifier;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.application.console.snapin.context.GetChildrenContext;
import com.novell.service.ndssdk.jndi.ldap.ext.GetEffectiveRightsRequest;
import com.novell.service.ndssdk.jndi.ldap.ext.GetEffectiveRightsResponse;
import com.novell.service.ndssdk.jndi.ldap.ext.LdapAttributeRights;
import com.novell.service.ndssdk.jndi.ldap.ext.LdapEntryRights;
import com.sun.jndi.ldap.BasicControl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Vector;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.NoSuchAttributeException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;

public final class LDAPNamespaceImpl
implements LDAPNamespace {
    protected Shell shell;
    protected NSObjectCache nsObjectLookupTable = new NSObjectCache();
    protected LdapContext ctx = null;
    protected static NameParser parser = null;
    protected LDAPschema currentSchema = null;
    protected ObjectEntry whoami = null;
    private Hashtable directoryEventListeners = new Hashtable();
    static Hashtable authenticatedUserCache = new Hashtable();
    private String[] namingContexts = null;
    private BaseAndDseObjectClass[] namingContextBaseClass = null;
    private ArrayList supportedExtensionList = new ArrayList();
    private ArrayList supportedControlList = new ArrayList();
    private UniqueSPIException uniqueSPIException = new UniqueSPIException("com.novell.admin.common.exceptions.NSIClientResourceBundle");
    private SimpleSPIException nsSpiException = new SimpleSPIException("com.novell.admin.ns.NSResourceBundle");
    private LDAPSPIException ldapSpiException = new LDAPSPIException("com.novell.admin.ns.ldap.LDAPResourceBundle");
    private ObjectEntry emptyOE = new ObjectEntry("", new ObjectType("top", this, true), 4L);
    private static final Control MANAGE_DSA_IT_CONTROL = new BasicControl("2.16.840.1.113730.3.4.2", false, null);
    private static final Control INCLUDE_SUBENTRIES_CONTROL = new BasicControl("2.16.840.1.113719.1.27.101.35", false, null);
    private static final Control RESOLVE_ALIAS_CONTROL = new BasicControl("2.16.840.1.113719.1.27.101.19", false, null);
    private static final int BROWSE_RIGHT = 1;
    private static final int ADD_RIGHT = 2;
    private static final int DELETE_RIGHT = 4;
    private static final int RENAME_RIGHT = 8;
    private static final int OBJ_SUPERVISOR_RIGHT = 16;
    private static final int COMPARE_RIGHT = 1;
    private static final int READ_RIGHT = 2;
    private static final int WRITE_RIGHT = 4;
    private static final int SELF_RIGHT = 8;
    private static final int ATTR_SUPERVISOR_RIGHT = 32;
    private static final int INHERIT_CTL = 64;
    private static final int DYNAMIC_GROUP = 0x20000000;

    public String getSnapinName() {
        return LDAPRes.getString("s1");
    }

    public String getSnapinDescription() {
        return LDAPRes.getString("s2");
    }

    public boolean initSnapin(InitSnapinInfo info) {
        this.shell = info.getShell();
        return true;
    }

    public ObjectEntry[] getInitialObjectEntries() throws SPIException {
        if (this.ctx == null) {
            return new ObjectEntry[0];
        }
        return new ObjectEntry[]{this.emptyOE};
    }

    public ObjectEntry[] getInitialObjectEntries(ObjectEntry oe, GetChildrenContext childrenCtx) throws SPIException {
        return this.getInitialObjectEntries();
    }

    public void shutdownSnapin() {
    }

    public void authenticate(ObjectEntry obj) throws SPIException {
    }

    public void authenticate(ObjectEntry obj, boolean ssl) throws SPIException {
    }

    public void authenticate(String principal, String host, String credentials) throws SPIException {
        this.authenticate(principal, host, credentials, false);
    }

    public void authenticate(Object authenticatedObject) throws SPIException {
        if (!(authenticatedObject instanceof InitialLdapContext)) {
            throw this.nsSpiException.newException("spi2");
        }
        this.authenticateWithContext((InitialLdapContext)authenticatedObject);
    }

    public void authenticate(String principal, String host, String credentials, boolean ssl) throws SPIException {
        InitialLdapContext initLDAPCtx;
        String IPaddr;
        String port;
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        String[] hostPort = host.split(":");
        String hostName = hostPort[0];
        String string = port = ssl ? "636" : "389";
        if (hostPort.length == 2) {
            port = hostPort[1];
        }
        try {
            IPaddr = InetAddress.getByName(hostName).getHostAddress();
        }
        catch (UnknownHostException e) {
            throw this.nsSpiException.newException("spi2");
        }
        env.put("java.naming.provider.url", "ldap://" + IPaddr + ":" + port);
        if (ssl) {
            env.put("java.naming.security.protocol", "ssl");
        }
        if (principal != null && principal.length() > 0 && (credentials == null || credentials.length() == 0)) {
            throw this.nsSpiException.newException("spi2");
        }
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", principal);
        env.put("java.naming.security.credentials", credentials);
        env.put("java.naming.referral", "throw");
        env.put("java.naming.ldap.derefAliases", "never");
        try {
            initLDAPCtx = new InitialLdapContext(env, null);
        }
        catch (Exception e) {
            throw this.nsSpiException.newException("spi2");
        }
        this.authenticateWithContext(initLDAPCtx);
    }

    private void authenticateWithContext(InitialLdapContext initLDAPCtx) throws SPIException {
        String IPaddr;
        this.ctx = initLDAPCtx;
        try {
            IPaddr = this.getIPAddressFromProviderURL(initLDAPCtx);
            parser = this.ctx.getNameParser("");
            this.getDSEInfo(this.ctx);
        }
        catch (Exception e) {
            throw this.nsSpiException.newException("spi2");
        }
        try {
            this.currentSchema = new LDAPSchemaImpl(this, this.ctx, "", IPaddr);
        }
        catch (NamingException e) {
            throw this.ldapSpiException.newException(90, this.getClass().getName(), "90", e);
        }
        String binlist = this.getBinaryAttrList(this.currentSchema);
        try {
            if (binlist != null) {
                this.ctx.addToEnvironment("java.naming.ldap.attributes.binary", binlist);
            }
            this.getInitialObjectEntries();
            this.setControl("2.16.840.1.113730.3.4.2");
        }
        catch (NamingException bin) {
            throw this.nsSpiException.newException("spi1");
        }
    }

    private String getBinaryAttrList(LDAPschema sch) throws SPIException {
        StringBuffer sb = new StringBuffer();
        AttributeDefinition[] attrDefs = sch.getSchemaDefinition().getAttributeDefinitions();
        for (int i = 0; i < attrDefs.length; ++i) {
            LDAPSyntax syn = (LDAPSyntax)attrDefs[i].getSyntax();
            if (syn == null || !syn.isBinarySyntax()) continue;
            sb.append(attrDefs[i].getName()).append(" ");
        }
        return new String(sb);
    }

    private void getDSEInfo(DirContext ctx) throws NamingException {
        try {
            int i;
            int i2;
            NamingEnumeration<?> ne;
            String[] attrsToRead = new String[]{"namingContexts", "supportedExtension", "supportedControl"};
            Attributes attrs = ctx.getAttributes("", attrsToRead);
            Attribute attr = attrs.get("supportedExtension");
            if (attr != null) {
                ne = attr.getAll();
                while (ne.hasMore()) {
                    this.supportedExtensionList.add(ne.next());
                }
            }
            if ((attr = attrs.get("supportedControl")) != null) {
                ne = attr.getAll();
                while (ne.hasMore()) {
                    this.supportedControlList.add(ne.next());
                }
            }
            Attribute ncAttr = attrs.get("namingContexts");
            this.namingContexts = new String[ncAttr.size()];
            this.namingContextBaseClass = new BaseAndDseObjectClass[ncAttr.size()];
            for (i2 = 0; i2 < ncAttr.size(); ++i2) {
                this.namingContexts[i2] = ncAttr.get(i2).toString();
            }
            for (i2 = 0; i2 < ncAttr.size(); ++i2) {
                this.namingContextBaseClass[i2] = this.getBaseAndDseObjectClass(this.namingContexts[i2]);
            }
            ArrayList<String> ncList = new ArrayList<String>();
            ArrayList<BaseAndDseObjectClass> ncClass = new ArrayList<BaseAndDseObjectClass>();
            for (i = 0; i < ncAttr.size(); ++i) {
                String base = this.namingContextBaseClass[i].getBaseClass();
                if (base.equalsIgnoreCase("systemContainer") || base.equalsIgnoreCase("serviceCollection")) continue;
                ncList.add(this.namingContexts[i]);
                ncClass.add(this.namingContextBaseClass[i]);
            }
            this.namingContexts = ncList.toArray(new String[0]);
            this.namingContextBaseClass = ncClass.toArray(new BaseAndDseObjectClass[0]);
            for (i = 1; i < this.namingContexts.length; ++i) {
                if (this.namingContexts[i].length() >= this.namingContexts[0].length()) continue;
                String tmp = this.namingContexts[0];
                this.namingContexts[0] = this.namingContexts[i];
                this.namingContexts[i] = tmp;
            }
        }
        catch (SPIException nse) {
            throw new NamingException("getDSEInfo");
        }
    }

    public void authenticateServer(String serverName) throws SPIException {
        this.authenticateServer(serverName, false);
    }

    public void authenticateServer(String serverName, boolean ssl) throws SPIException {
    }

    public void unAuthenticate(ObjectEntry obj) throws SPIException {
        if (this.ctx != null) {
            try {
                this.ctx.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        this.clearState();
    }

    public void unAuthenticate(ObjectEntry obj, String password) throws SPIException {
        this.unAuthenticate(obj);
    }

    public ObjectEntry getAuthenticatedIdentity(ObjectEntry obj) throws SPIException {
        if (this.whoami == null) {
            String principal = null;
            if (this.ctx != null) {
                try {
                    Hashtable<?, ?> ht = this.ctx.getEnvironment();
                    principal = (String)ht.get("java.naming.security.principal");
                    this.whoami = principal == null || principal.length() == 0 ? this.emptyOE : this.getObjectEntry(principal);
                }
                catch (LDAPSPIException se) {
                    if (se.getErrorCode() == 32) {
                        ObjectType ot = new ObjectType("inetOrgPerson", obj.getNamespace(), false);
                        this.whoami = new ObjectEntry(principal, ot);
                        return this.whoami;
                    }
                    throw se;
                }
                catch (NamingException ne) {
                    throw this.resolveSPIException(ne, "");
                }
            }
        }
        return this.whoami;
    }

    public void create(NSObject obj) throws SPIException, SnapinVetoException {
        BasicAttributes attrSet = new BasicAttributes();
        ObjectEntry oe = obj.getObjectEntry();
        DirectoryEventImpl event = new DirectoryEventImpl();
        String retVal = this.notifyDirectoryEventListeners(32, obj.getObjectEntry(), null, event);
        if (retVal != null && retVal.length() > 0) {
            throw new SnapinVetoException(retVal);
        }
        try {
            String[] attrNames = obj.getAttributes();
            for (int i = 0; i < attrNames.length; ++i) {
                attrSet.put(this.convertToJndiAttribute(obj.getAttribute(attrNames[i])));
            }
            this.ctx.createSubcontext(oe.getFullName(), (Attributes)attrSet);
            this.notifyDirectoryEventListeners(16, obj.getObjectEntry(), null, event);
        }
        catch (NamingException ne) {
            throw this.resolveSPIException(ne, "");
        }
    }

    public NSObject createNSObject(ObjectEntry objEntry, Vector attributes, long rev) throws NamespaceException {
        return this.createNSObject(objEntry, attributes, true);
    }

    public NSObject createNSObject(ObjectEntry objEntry, Vector attributes, boolean bValidate) throws NamespaceException {
        LDAPNSObject newNSObject = new LDAPNSObject(objEntry, attributes, 0L);
        if (newNSObject.getAttribute("objectClass") == null) {
            try {
                String baseClass = objEntry.getObjectType().getName();
                String[] superClasses = this.getClassDefinition(objEntry, baseClass).getSuperClasses();
                ValueComponent[] objClassVals = new ValueComponent[superClasses.length + 1];
                LDAPSchemaDefinition schema = (LDAPSchemaDefinition)this.getSchemaDefinition(objEntry);
                AttributeDefinition attrDef = schema.getAttributeDefinition("objectClass");
                objClassVals[objClassVals.length - 1] = new StringValue(attrDef.getSyntax(), baseClass);
                for (int i = 0; i < superClasses.length; ++i) {
                    objClassVals[i] = new StringValue(attrDef.getSyntax(), superClasses[i]);
                }
                ObjectAttribute objClassAttr = new ObjectAttribute(attrDef, objClassVals);
                newNSObject.initObjectClassAttribute(objClassAttr);
                objClassAttr.addPropertyChangeListener(newNSObject);
            }
            catch (SPIException x) {
                throw NamespaceException.MISSING_OBJECT_CLASS_ATTRIBUTE;
            }
        }
        return newNSObject;
    }

    public NSObject createNSObject(ObjectEntry objEntry, Vector attributes) throws NamespaceException {
        return this.createNSObject(objEntry, attributes, true);
    }

    public String getFullName(ObjectEntry oe) {
        StringBuffer dn = new StringBuffer();
        while (oe != null) {
            String component = oe.getAsIsName();
            if (dn.length() != 0 && component.length() != 0) {
                dn.append(",");
            }
            dn.append(component);
            oe = oe.getAsIsParent();
        }
        return dn.toString();
    }

    public String getUnrootedName(ObjectEntry oe) {
        return oe.getFullName();
    }

    public String getFullyTypedName(ObjectEntry oe) {
        return this.getFullName(oe);
    }

    public int getMaxNameLength(ObjectEntry parentOE, AttributeDefinition attrDef) throws SPIException {
        int length = 256 - this.getFullName(parentOE).length();
        if (attrDef != null) {
            if (attrDef.isSized()) {
                length = Math.min(length, (int)attrDef.getUpperBound());
            }
        } else {
            length = Math.min(length, 64);
        }
        return length;
    }

    public PartitionService getPartitionService(ObjectEntry obj) throws SPIException {
        throw this.resolveSPIException(null, "");
    }

    public ObjectType[] getObjectType(ObjectEntry tree, String[] objectFDN) throws SPIException {
        ObjectType[] ot = new ObjectType[objectFDN.length];
        for (int i = 0; i < objectFDN.length; ++i) {
            if (-1 != objectFDN[i].indexOf("[Public]")) {
                ot[i] = new ObjectType("", this, false);
                continue;
            }
            String baseClass = this.getBaseAndDseObjectClass(objectFDN[i]).getBaseClass();
            ot[i] = this.currentSchema.getSchemaDefinition().getObjectType(baseClass);
        }
        return ot;
    }

    public SchemaDefinition getSchemaDefinition(ObjectEntry obj) throws SPIException {
        return this.currentSchema.getSchemaDefinition();
    }

    public Object getContext(ObjectEntry oe) throws SPIException {
        return this.ctx;
    }

    public Object getContext() {
        return this.ctx;
    }

    public ClassDefinition getClassDefinition(ObjectEntry objEntry, String className) throws SPIException, NamespaceException {
        return this.currentSchema.getClassDefinition(className);
    }

    public AttributeDefinition getAttributeDefinition(ObjectEntry objEntry, String attrName) throws SPIException, NamespaceException {
        return this.currentSchema.getAttributeDefinition(attrName);
    }

    public ObjectAttribute[] getAttributes(ObjectEntry obj, String[] attrStrings) throws SPIException, NamespaceException {
        ObjectAttribute[] attrs;
        try {
            int index = 0;
            Attributes attrSet = this.getAttributeSet(this.getFullName(obj), attrStrings);
            attrs = new ObjectAttribute[attrSet.size()];
            NamingEnumeration<? extends Attribute> attrEnum = attrSet.getAll();
            while (attrEnum.hasMoreElements()) {
                Attribute attr = (Attribute)attrEnum.nextElement();
                LDAPAttributeDefinition attrDef = (LDAPAttributeDefinition)this.currentSchema.getAttributeDefinition(attr.getID());
                if (attrDef.getAttributeFlag().isFlagSet(16)) continue;
                attrs[index++] = this.convertLDAPAttributeToObjectAttribute(attr, attrDef);
            }
        }
        catch (Exception x) {
            throw this.resolveSPIException(x, "");
        }
        return attrs;
    }

    public ObjectAttribute[] getAttributes(ObjectEntry obj, String[] attrStrings, ObjectEntry serverOE) throws SPIException, NamespaceException {
        return this.getAttributes(obj, attrStrings);
    }

    public ObjectAttribute[] getAttributes(ObjectEntry obj, String[] attrStrings, int getAttrFlags, ObjectEntry serverOE) throws SPIException, NamespaceException {
        return this.getAttributes(obj, attrStrings);
    }

    public ObjectAttribute[] getAttributes(ObjectEntry obj, String[] attrStrings, int getAttrFlags, AdminNamespaceExceptionReference aneRef, ObjectEntry serverOE) throws SPIException, NamespaceException {
        return this.getAttributes(obj, attrStrings);
    }

    public ObjectAttribute[] getAttributes(ObjectEntry obj) throws SPIException {
        try {
            return this.getAttributes(obj, null);
        }
        catch (NamespaceException e) {
            throw this.resolveSPIException(e, "");
        }
    }

    public ObjectAttribute getAttribute(ObjectEntry obj, String attrStr) throws SPIException {
        ObjectAttribute[] e;
        String[] attrs = new String[]{attrStr};
        try {
            e = this.getAttributes(obj, attrs);
        }
        catch (NamespaceException x) {
            throw this.resolveSPIException(x, "");
        }
        if (e.length > 0) {
            return e[0];
        }
        return null;
    }

    public void setAttributes(ObjectEntry obj, ObjectAttribute[] attributes) throws SPIException {
        int[] modifyMode = new int[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            modifyMode[i] = 2;
        }
        this.setAttributes(obj, attributes, modifyMode, null);
    }

    public void setAttribute(ObjectEntry obj, ObjectAttribute attribute) throws SPIException {
        this.setAttributes(obj, new ObjectAttribute[]{attribute}, new int[]{2}, null);
    }

    public ObjectType[] getObjectTypes(ObjectEntry obj) throws SPIException {
        LDAPSchemaDefinition schemaDef = (LDAPSchemaDefinition)this.currentSchema.getSchemaDefinition();
        ClassDefinition[] classes = schemaDef.getEffectiveClasses(obj.getObjectType().getName());
        ObjectType[] objectTypes = new ObjectType[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            objectTypes[i] = schemaDef.getObjectType(classes[i].getName());
        }
        return objectTypes;
    }

    public ObjectType getObjectType(ObjectEntry obj, String item) throws SPIException {
        return this.currentSchema.getSchemaDefinition().getObjectType(item);
    }

    public ObjectEntryEnumeration getChildren(ObjectEntry obj) throws SPIException {
        return this.getChildren(obj, (ResultModifier)null);
    }

    public ObjectEntryEnumeration getChildContainers(ObjectEntry parent, ResultModifier modifiers) throws SPIException {
        ChildObjectEntryEnumerationImpl objEntryEnum;
        if (!parent.getObjectType().isContainer()) {
            throw this.nsSpiException.newException("spi13");
        }
        try {
            objEntryEnum = new ChildObjectEntryEnumerationImpl(parent, modifiers, true);
        }
        catch (Exception x) {
            throw this.resolveSPIException(x, "");
        }
        return objEntryEnum;
    }

    public ObjectEntryEnumeration getChildren(ObjectEntry oe, ResultModifier modifiers) throws SPIException {
        ChildObjectEntryEnumerationImpl oe_enum;
        try {
            oe_enum = new ChildObjectEntryEnumerationImpl(oe, modifiers, false);
        }
        catch (Exception e) {
            throw this.resolveSPIException(e, "");
        }
        return oe_enum;
    }

    public ObjectEntryEnumeration getChildren(ObjectEntry obj, GetChildrenContext childrenCtx) throws SPIException {
        throw this.resolveSPIException(null, "");
    }

    public String getDereferencedAliasObjectDN(ObjectEntry oe) throws SPIException {
        ObjectAttribute[] attrs;
        String[] attrList = new String[]{"aliasedObjectName"};
        try {
            attrs = this.getAttributes(oe, attrList);
        }
        catch (NamespaceException e) {
            throw this.resolveSPIException(e, "");
        }
        return attrs[0].toString();
    }

    public NSObject getDetails(ObjectEntry objEntry) throws SPIException {
        ObjectAttribute[] attrs;
        long revision = 0L;
        String[] attrList = new String[]{"*", "acl", "dseObjectClass", "ref"};
        try {
            attrs = this.getAttributes(objEntry, attrList);
        }
        catch (NamespaceException e) {
            throw this.resolveSPIException(e, "");
        }
        Vector<ObjectAttribute> attributeVec = new Vector<ObjectAttribute>(attrs.length);
        for (int i = 0; i < attrs.length; ++i) {
            if (attrs[i] == null) continue;
            attributeVec.addElement(attrs[i]);
        }
        return new LDAPNSObject(objEntry, attributeVec, revision);
    }

    public NSObject getDelayedAttibuteDetails(ObjectEntry objEntry, String[] delayedAttrStrings) throws SPIException {
        return this.getDelayedAttibuteDetails(objEntry, delayedAttrStrings, null);
    }

    public NSObject getDelayedAttibuteDetails(ObjectEntry objEntry, String[] delayedAttrStrings, ObjectEntry serverOE) throws SPIException {
        if (delayedAttrStrings == null) {
            delayedAttrStrings = new String[]{};
        }
        try {
            ClassDefinition tmpClassDef;
            ArrayList<ClassDefinition> classDefList = new ArrayList<ClassDefinition>(10);
            classDefList.add(this.getClassDefinition(objEntry, objEntry.getObjectType().getName()));
            ObjectAttribute[] tmpattrarr = this.getAttributes(objEntry, new String[]{"objectClass"}, serverOE);
            if (tmpattrarr.length == 0 || tmpattrarr[0] == null) {
                throw this.nsSpiException.newException("spi14");
            }
            Enumeration objClassVals = tmpattrarr[0].getValueComponents();
            while (objClassVals.hasMoreElements()) {
                tmpClassDef = this.getClassDefinition(objEntry, objClassVals.nextElement().toString());
                if (!tmpClassDef.isAuxiliary()) continue;
                classDefList.add(tmpClassDef);
            }
            HashMap<String, String> attrToGetMap = new HashMap<String, String>(100);
            ListIterator classdefIt = classDefList.listIterator();
            while (classdefIt.hasNext()) {
                int delayidx;
                boolean foundInDelayed;
                tmpClassDef = (ClassDefinition)classdefIt.next();
                AttributeDefinition[] manAttrs = tmpClassDef.getMandatoryAttributes();
                AttributeDefinition[] optAttrs = tmpClassDef.getOptionalAttributes();
                for (int midx = 0; midx < manAttrs.length; ++midx) {
                    foundInDelayed = false;
                    String maName = manAttrs[midx].getName();
                    for (delayidx = 0; delayidx < delayedAttrStrings.length; ++delayidx) {
                        if (!maName.equalsIgnoreCase(delayedAttrStrings[delayidx])) continue;
                        foundInDelayed = true;
                        break;
                    }
                    if (foundInDelayed) continue;
                    attrToGetMap.put(maName.toLowerCase(), maName);
                }
                for (int oidx = 0; oidx < optAttrs.length; ++oidx) {
                    foundInDelayed = false;
                    String oaName = optAttrs[oidx].getName();
                    for (delayidx = 0; delayidx < delayedAttrStrings.length; ++delayidx) {
                        if (!oaName.equalsIgnoreCase(delayedAttrStrings[delayidx])) continue;
                        foundInDelayed = true;
                        break;
                    }
                    if (foundInDelayed) continue;
                    attrToGetMap.put(oaName.toLowerCase(), oaName);
                }
            }
            String[] attrToReadArr = new String[attrToGetMap.size()];
            Collection attrValCollection = attrToGetMap.values();
            attrToReadArr = attrValCollection.toArray(attrToReadArr);
            ObjectAttribute[] objAttrsRead = this.getAttributes(objEntry, attrToReadArr, serverOE);
            Vector<Object> attributeVec = new Vector<Object>(objAttrsRead.length + delayedAttrStrings.length);
            for (int aridx = 0; aridx < objAttrsRead.length; ++aridx) {
                if (objAttrsRead[aridx] == null) continue;
                attributeVec.addElement(objAttrsRead[aridx]);
            }
            for (int daidx = 0; daidx < delayedAttrStrings.length; ++daidx) {
                if (delayedAttrStrings[daidx] == null) continue;
                attributeVec.addElement(delayedAttrStrings[daidx]);
            }
            return new LDAPNSObject(objEntry, attributeVec, 0L);
        }
        catch (NamespaceException x) {
            throw this.resolveSPIException(x, "");
        }
    }

    public NSObject getDetails(ObjectEntry obj, Object key) throws SPIException {
        NSObject nsObject = null;
        nsObject = this.nsObjectLookupTable.getDetails(key, obj);
        if (nsObject == null) {
            nsObject = this.getDetails(obj);
            this.nsObjectLookupTable.setDetails(key, nsObject);
        }
        return nsObject;
    }

    public void freeDetails(Object key, ObjectEntry obj) {
        this.nsObjectLookupTable.freeDetails(key, obj);
    }

    public void freeDetails(Object key) {
        this.nsObjectLookupTable.freeDetails(key);
    }

    public void changePassword(ObjectEntry obj) throws SPIException {
        throw this.resolveSPIException(null, "");
    }

    public void changePassword(ObjectEntry obj, String oldPassword, String newPassword) throws SPIException {
        try {
            ModificationItem[] modItemArray = new ModificationItem[]{new ModificationItem(3, new BasicAttribute("userPassword", oldPassword)), new ModificationItem(1, new BasicAttribute("userPassword", newPassword))};
            this.ctx.modifyAttributes(this.getFullName(obj), modItemArray);
        }
        catch (NamingException ne) {
            throw this.resolveSPIException(ne, "");
        }
    }

    public void setPassword(ObjectEntry obj) throws SPIException {
        throw this.resolveSPIException(null, "");
    }

    public void setPassword(ObjectEntry obj, boolean showSetException) throws SPIException {
        throw this.resolveSPIException(null, "");
    }

    public void setPassword(ObjectEntry obj, String password) throws SPIException {
        try {
            ModificationItem[] modItemArray = new ModificationItem[]{new ModificationItem(2, new BasicAttribute("userPassword", password))};
            this.ctx.modifyAttributes(this.getFullName(obj), modItemArray);
        }
        catch (NamingException ne) {
            throw this.resolveSPIException(ne, "");
        }
    }

    public SPIException createSPIException(int errCode) {
        return this.uniqueSPIException.newException(errCode, "", null);
    }

    public String getUniqueID() {
        return name;
    }

    public ObjectEntry getObjectEntry(String dn) throws SPIException {
        return this.getObjectEntry(null, dn);
    }

    public ObjectEntry getObjectEntry(ObjectEntry parentOE, String rdn) throws SPIException {
        String parentName;
        if (rdn == null || rdn.equalsIgnoreCase("[Root]")) {
            rdn = "";
        }
        if (rdn.length() == 0 && parentOE != null) {
            return parentOE;
        }
        if (parentOE == null) {
            parentOE = this.emptyOE;
        }
        String fullname = rdn;
        if (parentOE != null && (parentName = parentOE.getFullName()).length() > 0) {
            if ((parentOE.getAsIsParent() == null || ObjectFlags.isNamingContext(parentOE.getObjectFlags())) && rdn.toLowerCase().endsWith(parentName.toLowerCase()) && (rdn = rdn.substring(0, rdn.length() - parentName.length())).endsWith(",")) {
                rdn = rdn.substring(0, rdn.length() - 1);
            }
            fullname = rdn.length() > 0 ? rdn + "," + parentName : parentName;
        }
        BaseAndDseObjectClass ocInfo = this.getBaseAndDseObjectClass(fullname);
        String baseClass = ocInfo.getBaseClass();
        SchemaDefinition schemaDef = this.currentSchema.getSchemaDefinition();
        ObjectType ot = schemaDef.getObjectType(baseClass);
        long flags = 0L;
        if (ot.isContainer()) {
            flags |= 4L;
        }
        if (ocInfo.isGlue()) {
            flags |= 0x20L;
        }
        return new ObjectEntry(rdn, ot, parentOE, flags, true);
    }

    public ObjectEntryParentAndSimpleName getParentAndSimpleName(ObjectEntry oe) {
        String newSimpleName = oe.getAsIsName();
        ObjectEntry newParentOE = oe.getAsIsParent();
        if (oe.isComplexName()) {
            String asIsContainerPartOfName = null;
            try {
                Name dnName = parser.parse(newSimpleName);
                int last = dnName.size() - 1;
                newSimpleName = dnName.get(last);
                dnName.remove(last);
                asIsContainerPartOfName = dnName.toString();
            }
            catch (NamingException ne) {
                // empty catch block
            }
            if (asIsContainerPartOfName != null) {
                try {
                    newParentOE = this.getObjectEntry(newParentOE, asIsContainerPartOfName);
                }
                catch (SPIException spie) {
                    newSimpleName = oe.getAsIsName();
                    newParentOE = oe.getAsIsParent();
                    Debug.out("Warning: Unable to create parent OE for " + newSimpleName);
                    Debug.out("    " + spie.toString());
                }
            }
        }
        return new ObjectEntryParentAndSimpleName(newParentOE, newSimpleName);
    }

    String[] getNamingContextBaseClass() {
        String[] baseClassArray = new String[this.namingContextBaseClass.length];
        for (int i = 0; i < this.namingContextBaseClass.length; ++i) {
            baseClassArray[i] = this.namingContextBaseClass[i].getBaseClass();
        }
        return baseClassArray;
    }

    public boolean setControl(String controlOID) throws NamingException {
        Control thisControl;
        if (this.isControlSet(controlOID)) {
            return true;
        }
        if (controlOID.equals("2.16.840.1.113730.3.4.2")) {
            thisControl = MANAGE_DSA_IT_CONTROL;
        } else if (controlOID.equals("2.16.840.1.113719.1.27.101.35")) {
            thisControl = INCLUDE_SUBENTRIES_CONTROL;
        } else if (controlOID.equals("2.16.840.1.113719.1.27.101.19")) {
            thisControl = RESOLVE_ALIAS_CONTROL;
        } else {
            throw new NamingException(controlOID);
        }
        Control[] ctrls = this.ctx.getRequestControls();
        if (ctrls == null) {
            ctrls = new Control[]{};
        }
        Control[] newCtrls = new Control[ctrls.length + 1];
        for (int i = 0; i < ctrls.length; ++i) {
            newCtrls[i] = ctrls[i];
        }
        newCtrls[ctrls.length] = thisControl;
        this.ctx.setRequestControls(newCtrls);
        return false;
    }

    public boolean clearControl(String controlOID) throws NamingException {
        if (!this.isControlSet(controlOID)) {
            return false;
        }
        Control[] ctrls = this.ctx.getRequestControls();
        if (ctrls == null || ctrls.length == 0) {
            return false;
        }
        Control[] newCtrls = new Control[ctrls.length - 1];
        int j = 0;
        for (int i = 0; i < ctrls.length; ++i) {
            if (ctrls[i].getID().equals(controlOID)) continue;
            newCtrls[j++] = ctrls[i];
        }
        this.ctx.setRequestControls(newCtrls);
        return true;
    }

    public boolean isControlSet(String controlOID) throws NamingException {
        Control[] ctrls = this.ctx.getRequestControls();
        if (ctrls == null) {
            return false;
        }
        for (int i = 0; i < ctrls.length; ++i) {
            if (!ctrls[i].getID().equals(controlOID)) continue;
            return true;
        }
        return false;
    }

    public ArrayList getSupportedExtensions() {
        return this.supportedExtensionList;
    }

    public ArrayList getSupportedControls() {
        return this.supportedControlList;
    }

    public String[] getNamingContexts() {
        return this.namingContexts;
    }

    public ValueList[] getNVDSEffectivePrivileges(ObjectEntry obj, boolean allLegalAttrs) throws SPIException {
        new NVDSPrivs();
        return NVDSPrivs.getNVDSEffectivePrivileges(this, obj, allLegalAttrs, null, null);
    }

    public ValueList[] getNVDSEffectivePrivileges(ObjectEntry obj, String[] attrs, String[] classes) throws SPIException {
        return NVDSPrivs.getNVDSEffectivePrivileges(this, obj, false, attrs, classes);
    }

    public Rights getObjectEffectiveRights(ObjectEntry obj, ObjectEntry trustee) throws SPIException {
        try {
            if (this.supportedExtensionList.contains("2.16.840.1.113719.1.27.100.33")) {
                GetEffectiveRightsResponse resp = (GetEffectiveRightsResponse)this.ctx.extendedOperation((ExtendedRequest)new GetEffectiveRightsRequest(this.getFullName(obj), this.getFullName(trustee), "[Entry Rights]"));
                return new LDAPObjectRightsImpl((LdapEntryRights)resp.getRights());
            }
            if (this.supportedControlList.contains("2.16.840.1.113719.1.27.101.33")) {
                ValueList[] vl = this.getNVDSEffectivePrivileges(obj, false);
                if (vl.length > 0) {
                    ObjectACLFacade fac = new ObjectACLFacade(vl[0]);
                    int priv = (int)fac.getPrivileges();
                    return new LDAPObjectRightsImpl(new LdapEntryRights(priv));
                }
                return new LDAPObjectRightsImpl(new LdapEntryRights(0));
            }
            int allObjectRights = 31;
            return new LDAPObjectRightsImpl(new LdapEntryRights(allObjectRights));
        }
        catch (NamingException ne) {
            throw this.resolveSPIException(ne, "getObjectEffectiveRights");
        }
        catch (IOException ioe) {
            throw this.resolveSPIException(ioe, "getObjectEffectiveRights");
        }
        catch (IncompatibleComponentException e) {
            throw this.resolveSPIException(e, "getObjectEffectiveRights");
        }
    }

    public Rights[] getPropertyEffectiveRights(ObjectEntry objForInquire, ObjectEntry trustee, String[] attrNames) throws SPIException {
        Rights[] rights;
        block17: {
            rights = new LDAPPropertyRightsImpl[]{};
            try {
                if (this.supportedExtensionList.contains("2.16.840.1.113719.1.27.100.33")) {
                    rights = new LDAPPropertyRightsImpl[attrNames.length];
                    String objStr = this.getFullName(objForInquire);
                    String trusteeStr = this.getFullName(trustee);
                    for (int i = 0; i < attrNames.length; ++i) {
                        if (attrNames[i] == null) {
                            attrNames[i] = "[All Attributes Rights]";
                        }
                        GetEffectiveRightsResponse resp = null;
                        try {
                            resp = (GetEffectiveRightsResponse)this.ctx.extendedOperation((ExtendedRequest)new GetEffectiveRightsRequest(objStr, trusteeStr, attrNames[i]));
                            rights[i] = new LDAPPropertyRightsImpl((LdapAttributeRights)resp.getRights(), attrNames[i]);
                            continue;
                        }
                        catch (NoSuchAttributeException ex) {
                            int iRights = 0;
                            try {
                                this.getAttributeDefinition(objForInquire, attrNames[i]);
                                iRights = 2;
                            }
                            catch (NamespaceException e) {
                                // empty catch block
                            }
                            rights[i] = new LDAPPropertyRightsImpl(new LdapAttributeRights(iRights), attrNames[i]);
                        }
                    }
                    break block17;
                }
                if (this.supportedControlList.contains("2.16.840.1.113719.1.27.101.33")) {
                    int i;
                    ValueList[] vl = this.getNVDSEffectivePrivileges(objForInquire, attrNames, null);
                    rights = new LDAPPropertyRightsImpl[attrNames.length];
                    block9: for (i = 0; i < vl.length; ++i) {
                        ObjectACLFacade fac = new ObjectACLFacade(vl[i]);
                        int priv = (int)fac.getPrivileges();
                        String retAttrName = fac.getProtectedAttrName();
                        for (int j = 0; j < attrNames.length; ++j) {
                            if (!attrNames[j].equalsIgnoreCase(retAttrName)) continue;
                            rights[j] = new LDAPPropertyRightsImpl(new LdapAttributeRights(priv), retAttrName);
                            continue block9;
                        }
                    }
                    for (i = 0; i < rights.length; ++i) {
                        if (rights[i] != null) continue;
                        rights[i] = new LDAPPropertyRightsImpl(new LdapAttributeRights(0), attrNames[i]);
                    }
                } else {
                    rights = new LDAPPropertyRightsImpl[attrNames.length];
                    int allPropertyRights = 47;
                    for (int i = 0; i < attrNames.length; ++i) {
                        rights[i] = new LDAPPropertyRightsImpl(new LdapAttributeRights(allPropertyRights), attrNames[i]);
                    }
                }
            }
            catch (NamingException ne) {
                throw this.resolveSPIException(ne, "getPropertyEffectiveRights-1");
            }
            catch (IOException ioe) {
                throw this.resolveSPIException(ioe, "getPropertyEffectiveRights-2");
            }
            catch (IncompatibleComponentException e) {
                throw this.resolveSPIException(e, "getPropertyEffectiveRights-3");
            }
        }
        return rights;
    }

    public void updateMOO(MOOManager MOOManagerObj, MOOManagerCallBack callBack) {
        String[] deletedAttrs;
        int[] ldapMode;
        ObjectAttribute[] attrs;
        int oeCnt = 0;
        int updateInterval = callBack.getUpdateInterval();
        ArrayList<ObjectAttribute> attrList = new ArrayList<ObjectAttribute>();
        ArrayList<Integer> ldapModeList = new ArrayList<Integer>();
        ArrayList<String> deletedAttrList = new ArrayList<String>();
        ObjectOperation[] ops = MOOManagerObj.getAllObjectOperations();
        try {
            int i;
            block11: for (i = 0; i < ops.length; ++i) {
                int opMode = ops[i].getMode();
                switch (opMode) {
                    case 1: {
                        ldapModeList.add(new Integer(1));
                        attrList.add(ops[i].getObjectAttribute());
                        continue block11;
                    }
                    case 2: {
                        ldapModeList.add(new Integer(3));
                        attrList.add(ops[i].getObjectAttribute());
                        continue block11;
                    }
                    case 3: {
                        ldapModeList.add(new Integer(2));
                        attrList.add(ops[i].getObjectAttribute());
                        continue block11;
                    }
                    case 4: {
                        deletedAttrList.add(ops[i].getObjectAttribute().getName());
                        continue block11;
                    }
                    case 5: {
                        continue block11;
                    }
                }
            }
            attrs = attrList.toArray(new ObjectAttribute[0]);
            ldapMode = new int[ldapModeList.size()];
            for (i = 0; i < ldapMode.length; ++i) {
                ldapMode[i] = (Integer)ldapModeList.get(i);
            }
            deletedAttrs = deletedAttrList.toArray(new String[0]);
        }
        catch (Exception e) {
            callBack.finished(0);
            return;
        }
        ObjectEntryEnumeration oeEnum = MOOManagerObj.getObjectEntryEnumeration();
        if (!oeEnum.hasMoreElements()) {
            callBack.finished(0);
            return;
        }
        try {
            while (oeEnum.hasMoreElements()) {
                ObjectEntry oe = (ObjectEntry)oeEnum.nextElement();
                ++oeCnt;
                DirectoryEventImpl event = new DirectoryEventImpl();
                String retVal = this.notifyDirectoryEventListeners(37, oe, null, event);
                if (retVal != null) {
                    if ("VETO_RESPONSE_RESPONSE".equals(retVal)) continue;
                    if ("VETO_APPLY_ALL_RESPONSE".equals(retVal)) {
                        return;
                    }
                }
                this.modifyAttributes(oe, attrs, ldapMode, deletedAttrs);
                if (updateInterval != 0 && oeCnt % updateInterval == 0 && callBack.update(oe, oeCnt) == 1) {
                    callBack.finished(oeCnt);
                    return;
                }
                this.notifyDirectoryEventListeners(21, oe, null, event);
            }
        }
        catch (SPIException se) {
            // empty catch block
        }
        callBack.finished(oeCnt);
    }

    public synchronized void update(NSObject obj) throws SPIException, SnapinVetoException {
        ObjectAttribute attr;
        int i;
        String[] deletedAttributeNames;
        String[] modifiedAttributeNames;
        DirectoryModifyEventImpl event = new DirectoryModifyEventImpl();
        String veto = this.notifyDirectoryEventListeners(36, obj.getObjectEntry(), null, obj, event);
        if (veto != null && veto.length() > 0) {
            throw new SnapinVetoException(veto);
        }
        String[] addedAttributeNames = obj.getAddedAttributes();
        int numAddMod = addedAttributeNames.length + (modifiedAttributeNames = obj.getModifiedAttributes()).length;
        if (numAddMod + (deletedAttributeNames = obj.getDeletedAttributes()).length == 0) {
            return;
        }
        ObjectAttribute[] attrs = new ObjectAttribute[numAddMod];
        int[] modifyMode = new int[numAddMod];
        for (i = 0; i < addedAttributeNames.length; ++i) {
            attrs[i] = obj.getAttribute(addedAttributeNames[i]);
            modifyMode[i] = 1;
        }
        for (i = 0; i < modifiedAttributeNames.length; ++i) {
            attrs[addedAttributeNames.length + i] = obj.getAttribute(modifiedAttributeNames[i]);
            modifyMode[addedAttributeNames.length + i] = 2;
        }
        this.setAttributes(obj.getObjectEntry(), attrs, modifyMode, deletedAttributeNames);
        for (i = 0; i < addedAttributeNames.length; ++i) {
            obj.clearAddedAttribute(addedAttributeNames[i]);
            attr = obj.getAttribute(addedAttributeNames[i]);
            attr.clearAddedAttributeValues();
            attr.clearDeletedAttributeValues();
            attr.resetBeginningAttributeValues();
        }
        for (i = 0; i < modifiedAttributeNames.length; ++i) {
            attr = obj.getAttribute(modifiedAttributeNames[i]);
            attr.clearDeletedAttributeValues();
            attr.clearAddedAttributeValues();
            attr.clearModifiedAttributeValues();
            if (attr.getComponentCount() == 0) {
                try {
                    obj.deleteAttribute(modifiedAttributeNames[i]);
                    obj.clearDeletedAttribute(modifiedAttributeNames[i]);
                }
                catch (Exception x) {
                    throw this.resolveSPIException(x, "");
                }
            }
            obj.clearModifiedAttribute(modifiedAttributeNames[i]);
            attr.resetBeginningAttributeValues();
        }
        for (i = 0; i < deletedAttributeNames.length; ++i) {
            obj.clearDeletedAttribute(deletedAttributeNames[i]);
        }
        this.notifyDirectoryEventListeners(20, obj.getObjectEntry(), obj.getObjectEntry(), obj, event);
    }

    public String[] getNameComponents(ObjectEntry oe) {
        String[] name = null;
        Name dnName = null;
        try {
            dnName = parser.parse(this.getFullName(oe));
        }
        catch (NamingException ne) {
            return name;
        }
        int n = dnName.size();
        name = new String[n];
        Enumeration<String> e = dnName.getAll();
        while (e.hasMoreElements()) {
            name[--n] = e.nextElement();
        }
        return name;
    }

    public ObjectEntry createObjectEntry(ObjectEntry parent, String child, String className) throws NamespaceException, SPIException {
        AttributeDefinition[] namingAttrs;
        LDAPSchemaDefinition schemaDef = (LDAPSchemaDefinition)this.currentSchema.getSchemaDefinition();
        if (child == null || child.equals("")) {
            throw NamespaceException.INVALID_NAME;
        }
        ObjectType ot = schemaDef.getObjectType(className);
        LDAPClassDefinition classDef = (LDAPClassDefinition)this.currentSchema.getClassDefinition(className);
        if (ot == null || classDef == null) {
            throw NamespaceException.INVALID_OBJECT_TYPE;
        }
        if (!className.equalsIgnoreCase("Alias") && !classDef.canBeContainedBy(parent.getObjectType().getName())) {
            throw NamespaceException.BAD_CONTAINMENT;
        }
        LDAPClassFlags flags = classDef.getClassFlags();
        boolean typedName = false;
        for (int i = 0; i < child.length(); ++i) {
            if (child.charAt(i) == '\\') {
                ++i;
                continue;
            }
            if (child.charAt(i) != '=') continue;
            typedName = true;
            break;
        }
        if (!typedName && (namingAttrs = classDef.getNamingAttributes()).length > 0) {
            child = namingAttrs[0].getName() + "=" + child;
        }
        return new ObjectEntry(child, ot, parent, flags.getFlags());
    }

    public void delete(ObjectEntry oe) throws SPIException, SnapinVetoException {
        try {
            DirectoryEventImpl event = new DirectoryEventImpl();
            String retVal = this.notifyDirectoryEventListeners(33, oe, null, event);
            if (retVal != null && retVal.length() > 0) {
                throw new SnapinVetoException(retVal);
            }
            this.ctx.destroySubcontext(oe.getFullName());
            this.notifyDirectoryEventListeners(17, oe, null, event);
        }
        catch (NamingException ne) {
            throw this.resolveSPIException(ne, "");
        }
    }

    public boolean doesExist(ObjectEntry parentEntry, String rdn) throws SPIException {
        String parentName;
        boolean rval = false;
        String fullname = rdn;
        if ((rdn == null || rdn.length() == 0) && parentEntry != null) {
            fullname = parentEntry.getFullName();
        } else if (parentEntry != null && (parentName = parentEntry.getFullName()).length() > 0) {
            if ((parentEntry.getAsIsParent() == null || ObjectFlags.isNamingContext(parentEntry.getObjectFlags())) && rdn.toLowerCase().endsWith(parentName.toLowerCase()) && (rdn = rdn.substring(0, rdn.length() - parentName.length())).endsWith(",")) {
                rdn = rdn.substring(0, rdn.length() - 1);
            }
            fullname = rdn.length() > 0 ? rdn + "," + parentName : parentName;
        }
        try {
            this.ctx.lookup(fullname);
            rval = true;
        }
        catch (NameNotFoundException nnfe) {
            rval = false;
        }
        catch (NamingException ne) {
            throw this.resolveSPIException(ne, "");
        }
        return rval;
    }

    public ObjectEntry move(ObjectEntry objToMove, ObjectEntry destination) throws SPIException, SnapinVetoException {
        ObjectEntry retVal = null;
        try {
            DirectoryEventImpl event = new DirectoryEventImpl();
            String veto = this.notifyDirectoryEventListeners(34, objToMove, null, event);
            if (veto != null && veto.length() > 0) {
                throw new SnapinVetoException(veto);
            }
            this.ctx.rename(objToMove.getFullName(), objToMove.getName() + "," + destination.getFullName());
            retVal = this.createObjectEntry(destination, objToMove.getName(), objToMove.getObjectType().getName());
            this.notifyDirectoryEventListeners(18, objToMove, null, event);
        }
        catch (NamingException ne) {
            throw this.resolveSPIException(ne, "");
        }
        catch (NamespaceException nse) {
            throw this.resolveSPIException(nse, "");
        }
        return retVal;
    }

    public ObjectEntry rename(ObjectEntry fromObjEntry, String newName) throws SPIException, SnapinVetoException {
        ObjectEntry retVal = null;
        try {
            DirectoryEventImpl event = new DirectoryEventImpl();
            String veto = this.notifyDirectoryEventListeners(35, fromObjEntry, null, event);
            if (veto != null && veto.length() > 0) {
                throw new SnapinVetoException(veto);
            }
            this.ctx.rename(fromObjEntry.getFullName(), newName);
            retVal = this.createObjectEntry(fromObjEntry.getParent(), newName, fromObjEntry.getObjectType().getName());
            this.notifyDirectoryEventListeners(19, fromObjEntry, retVal, event);
        }
        catch (NamingException ne) {
            throw this.resolveSPIException(ne, "");
        }
        catch (NamespaceException nse) {
            throw this.resolveSPIException(nse, "");
        }
        return retVal;
    }

    public Date getLastModificationTime(ObjectEntry objectEntry) throws SPIException {
        String MODIFY_TIMESTAMP = "modifyTimeStamp";
        try {
            Attributes attrSet = this.getAttributeSet(objectEntry.getFullName(), new String[]{"modifyTimeStamp"});
            String genTime = (String)attrSet.get("modifyTimeStamp").get();
            DateValue dv = (DateValue)LDAPSyntax.SYN_GENERALIZEDTIME.createValueComponent(genTime);
            return dv.getValue();
        }
        catch (Exception e) {
            throw this.resolveSPIException(e, "");
        }
    }

    public Date getCreationTime(ObjectEntry objectEntry) throws SPIException {
        String CREATE_TIMESTAMP = "createTimeStamp";
        try {
            Attributes attrSet = this.getAttributeSet(objectEntry.getFullName(), new String[]{"createTimeStamp"});
            String genTime = (String)attrSet.get("createTimeStamp").get();
            DateValue dv = (DateValue)LDAPSyntax.SYN_GENERALIZEDTIME.createValueComponent(genTime);
            return dv.getValue();
        }
        catch (Exception e) {
            throw this.resolveSPIException(e, "");
        }
    }

    public boolean compareAttribute(ObjectEntry obj, ObjectAttribute objAttr) throws NamespaceException, SPIException {
        try {
            NamingEnumeration<SearchResult> result;
            SearchControls ctl = new SearchControls();
            ctl.setReturningAttributes(new String[0]);
            ctl.setSearchScope(0);
            String filterExp = "(" + objAttr.getName() + "={0})";
            Enumeration myenum = objAttr.getValueComponents();
            if (!myenum.hasMoreElements()) {
                throw NamespaceException.ATTRIBUTE_NOT_VALUED;
            }
            ValueComponent val = (ValueComponent)myenum.nextElement();
            Object[] filterVal = new Object[]{val instanceof StringValue ? ((StringValue)val).getValue() : (val instanceof HexValue ? (Object)((HexValue)val).getValue() : (val instanceof DateValue ? ((DateValue)val).getGeneralizedTime() : val.toString()))};
            try {
                result = this.ctx.search(obj.getFullName(), filterExp, filterVal, ctl);
            }
            catch (NoSuchAttributeException ex) {
                return false;
            }
            return result != null && result.hasMore();
        }
        catch (Exception e) {
            throw this.resolveSPIException(e, "");
        }
    }

    public void deleteAttributeValues(ObjectEntry obj, ObjectAttribute attr) throws SPIException {
        this.setAttributes(obj, new ObjectAttribute[]{attr}, new int[]{3}, null);
    }

    public SPIException resolveSPIException(Exception x, String functionName) {
        SPIException exception = null;
        if (x instanceof NamingException) {
            Throwable rootException = ((NamingException)x).getRootCause();
            if (rootException != null) {
                if (rootException instanceof NamingException) {
                    rootException = ((NamingException)rootException).getRootCause();
                }
            } else {
                int startIndex;
                String suffix;
                int endIndex;
                int errorCode = 80;
                String messageKey = "80";
                String message = x.getMessage();
                if (message != null && message.indexOf("LDAP: error code ") > -1 && (endIndex = (suffix = message.substring(startIndex = message.indexOf("LDAP: error code ") + "LDAP: error code ".length())).indexOf(32)) > -1) {
                    messageKey = suffix.substring(0, endIndex);
                    errorCode = Integer.parseInt(messageKey);
                }
                exception = this.ldapSpiException.newException(errorCode, this.getClass().getName(), messageKey, x);
            }
        } else if (x instanceof SPIException) {
            exception = (SPIException)x;
        }
        if (exception == null) {
            exception = this.nsSpiException.newException(x);
        }
        return exception;
    }

    public void addDirectoryEventListener(DirectoryEventListener listener, int operation, String objectType) {
        ArrayList<DirectoryEventListener> list = (ArrayList<DirectoryEventListener>)this.directoryEventListeners.get(operation + "," + objectType.toUpperCase());
        if (list == null) {
            list = new ArrayList<DirectoryEventListener>();
        }
        list.add(listener);
        this.directoryEventListeners.put(operation + "," + objectType.toUpperCase(), list);
    }

    public void removeDirectoryEventListener(DirectoryEventListener listener) {
        this.directoryEventListeners.remove(listener);
    }

    private String notifyDirectoryEventListeners(int operation, ObjectEntry oldValue, ObjectEntry newValue, DirectoryEvent event) {
        ArrayList list = (ArrayList)this.directoryEventListeners.get(operation + "," + oldValue.getTypeName().toUpperCase());
        String retVal = null;
        if (list != null) {
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                DirectoryEventListener listener = (DirectoryEventListener)itr.next();
                if (event == null) {
                    event = new DirectoryEventImpl(operation, oldValue, newValue);
                } else {
                    event.setOperation(operation);
                    event.setOldValue(oldValue);
                    event.setNewValue(newValue);
                }
                if ((retVal = listener.handleDirectoryEvent(event)) == null || retVal.length() <= 0) continue;
                break;
            }
        }
        return retVal;
    }

    private String notifyDirectoryEventListeners(int operation, ObjectEntry oldValue, ObjectEntry newValue, NSObject obj, DirectoryModifyEventImpl event) {
        ArrayList list = (ArrayList)this.directoryEventListeners.get(operation + "," + oldValue.getTypeName().toUpperCase());
        String retVal = null;
        if (list != null) {
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                DirectoryEventListener listener = (DirectoryEventListener)itr.next();
                String[] modifiedAttributes = obj.getModifiedAttributes();
                Hashtable modified = this.getAttributeValueTable(modifiedAttributes, obj);
                String[] addedAttributes = obj.getAddedAttributes();
                Hashtable added = this.getAttributeValueTable(addedAttributes, obj);
                String[] deletedAttributes = obj.getDeletedAttributes();
                Hashtable deleted = this.getAttributeValueTable(deletedAttributes, obj);
                ModifiedAttributeDefinition attributeDef = new ModifiedAttributeDefinition(added, modified, deleted);
                if (event == null) {
                    event = new DirectoryModifyEventImpl(operation, oldValue, newValue, attributeDef);
                } else {
                    event.setOperation(operation);
                    event.setOldValue(oldValue);
                    event.setNewValue(newValue);
                    event.setModifiedAttributes(attributeDef);
                }
                if ((retVal = listener.handleDirectoryEvent(event)) == null || retVal.length() <= 0) continue;
                break;
            }
        }
        return retVal;
    }

    private Hashtable getAttributeValueTable(String[] attributes, NSObject obj) {
        Hashtable<String, ObjectAttribute> table = new Hashtable<String, ObjectAttribute>();
        for (int i = 0; i < attributes.length; ++i) {
            ObjectAttribute attribute = obj.getAttribute(attributes[i]);
            table.put(attributes[i], attribute);
        }
        return table;
    }

    public boolean isSupported(String key, Object param, ObjectEntry oe) throws NamespaceException, SPIException {
        if (key == null || key.length() == 0) {
            throw NamespaceException.INVALID_NAME;
        }
        SchemaDefinition schdef = null;
        if (oe == null) {
            if (this.currentSchema != null) {
                schdef = this.currentSchema.getSchemaDefinition();
            }
        } else {
            schdef = this.getSchemaDefinition(oe);
        }
        if (schdef == null) {
            throw NamespaceException.INVALID_NAME;
        }
        if (key.equalsIgnoreCase("NVDS")) {
            try {
                if (schdef.getClassDefinition("glueDSE") != null) {
                    return true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return false;
        }
        if (key.equalsIgnoreCase("eDir") || key.equalsIgnoreCase("eDirectory")) {
            try {
                if (schdef.getClassDefinition("glueDSE") != null) {
                    return false;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return true;
        }
        if (!(param instanceof String) || ((String)param).length() == 0) {
            return false;
        }
        String sparam = (String)param;
        try {
            if (key.equalsIgnoreCase("Class")) {
                if (!Character.isDigit(sparam.charAt(0))) {
                    return schdef.getClassDefinition(sparam) != null;
                }
                ClassDefinition[] cdefs = schdef.getClassDefinitions();
                for (int i = 0; i < cdefs.length; ++i) {
                    if (!((LDAPClassDefinition)cdefs[i]).getOID().equals(sparam)) continue;
                    return true;
                }
                return false;
            }
            if (key.equalsIgnoreCase("Attribute") || key.equalsIgnoreCase("Attr")) {
                if (!Character.isDigit(sparam.charAt(0))) {
                    return schdef.getAttributeDefinition(sparam) != null;
                }
                AttributeDefinition[] cdefs = schdef.getAttributeDefinitions();
                for (int i = 0; i < cdefs.length; ++i) {
                    if (!((LDAPAttributeDefinition)cdefs[i]).getOID().equals(sparam)) continue;
                    return true;
                }
                return false;
            }
            if (key.equalsIgnoreCase("Control")) {
                return this.getSupportedControls().contains(sparam);
            }
            if (key.equalsIgnoreCase("Extension")) {
                return this.getSupportedExtensions().contains(sparam);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    public boolean isSupported(String key, Object param) throws NamespaceException, SPIException {
        return this.isSupported(key, param, null);
    }

    public boolean isSupported(String key) throws NamespaceException, SPIException {
        return this.isSupported(key, null, null);
    }

    public String sendXMLRequest(String servicePath, String xmlRequest) throws NamingException {
        XMLPayloadRequest req = new XMLPayloadRequest(servicePath, xmlRequest);
        XMLPayloadResponse resp = (XMLPayloadResponse)this.ctx.extendedOperation(req);
        String retString = null;
        if (resp != null) {
            retString = resp.getXML();
        }
        return retString;
    }

    public String getProviderURL() throws NamingException {
        Hashtable<?, ?> env = this.ctx.getEnvironment();
        return (String)env.get("java.naming.provider.url");
    }

    public String[] getAttributesPresent(ObjectEntry useOE, String[] attributeName) throws SPIException {
        Object attrnames = null;
        Exception e = new Exception("This function is not defined for LDAPNamespace");
        SPIException spie = this.resolveSPIException(e, "getAttributesPresent");
        throw spie;
    }

    private String getIPAddressFromProviderURL(InitialLdapContext tContext) throws NamingException {
        int epos;
        int bpos;
        Hashtable<?, ?> env = tContext.getEnvironment();
        String provURL = (String)env.get("java.naming.provider.url");
        int tlen = provURL.length();
        for (bpos = 0; bpos < tlen && !Character.isDigit(provURL.charAt(bpos)); ++bpos) {
        }
        for (epos = bpos; epos < tlen && epos != 58; ++epos) {
        }
        String ipAddress = bpos < tlen ? provURL.substring(bpos, epos) : provURL;
        return ipAddress;
    }

    Attributes getAttributeSet(String objStr, String[] attrStrings) throws NamingException {
        return this.ctx.getAttributes(objStr, attrStrings);
    }

    UniqueSPIException getUniqueSPIException() {
        return this.uniqueSPIException;
    }

    BaseAndDseObjectClass getBaseAndDseObjectClass(String dn) throws SPIException {
        if (dn.equals("")) {
            return new BaseAndDseObjectClass("top", null);
        }
        try {
            Attribute attr;
            String baseClass = null;
            String[] dseObjectClass = new String[]{};
            Attributes attrs = this.ctx.getAttributes(dn, new String[]{"structuralObjectClass", "dseObjectClass"});
            if (attrs != null) {
                attr = attrs.get("structuralObjectClass");
                if (attr != null) {
                    baseClass = (String)attr.get(0);
                }
                if ((attr = attrs.get("dseObjectClass")) != null) {
                    dseObjectClass = new String[attr.size()];
                    for (int i = 0; i < attr.size(); ++i) {
                        dseObjectClass[i] = (String)attr.get(i);
                    }
                }
            }
            if (baseClass == null) {
                attrs = this.ctx.getAttributes(dn, new String[]{"objectClass"});
                if (attrs != null && (attr = attrs.get("objectClass")) != null) {
                    baseClass = (String)attr.get(0);
                }
                if (baseClass == null) {
                    baseClass = "systemContainer";
                }
            }
            return new BaseAndDseObjectClass(baseClass, dseObjectClass);
        }
        catch (NamingException ne) {
            throw this.resolveSPIException(ne, "");
        }
    }

    protected void clearState() {
        this.ctx = null;
        this.whoami = null;
        this.currentSchema = null;
    }

    protected ObjectAttribute convertLDAPAttributeToObjectAttribute(Attribute attr, LDAPAttributeDefinition attrDef) throws SPIException {
        NamingEnumeration<?> attrValEnum = null;
        ObjectAttribute ldapAttr = null;
        int index = 0;
        try {
            if (attr.size() > 0) {
                ValueComponent[] values = new ValueComponent[attr.size()];
                attrValEnum = attr.getAll();
                Syntax syn = attrDef.getSyntax();
                while (attrValEnum.hasMoreElements()) {
                    values[index++] = syn.createValueComponent(attrValEnum.nextElement());
                }
                ldapAttr = new ObjectAttribute((AttributeDefinition)attrDef, values);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return ldapAttr;
    }

    private Attribute convertToJndiAttribute(ObjectAttribute objAttr) {
        BasicAttribute attr = new BasicAttribute(objAttr.getName());
        Enumeration valEnum = objAttr.getValueComponents();
        while (valEnum.hasMoreElements()) {
            Object value = valEnum.nextElement();
            if (value instanceof StringValue) {
                attr.add(((StringValue)value).getValue());
                continue;
            }
            if (value instanceof HexValue) {
                attr.add(((HexValue)value).getValue());
                continue;
            }
            if (value instanceof BooleanValue) {
                attr.add(((BooleanValue)value).getBooleanValue().toString().toUpperCase());
                continue;
            }
            if (value instanceof LongValue) {
                attr.add(((LongValue)value).getLongValue().toString());
                continue;
            }
            if (value instanceof DateValue) {
                attr.add(((DateValue)value).getGeneralizedTime());
                continue;
            }
            attr.add(value.toString());
        }
        return attr;
    }

    private synchronized void deleteAttribute(ObjectEntry obj, String attrName) throws SPIException {
        try {
            ModificationItem[] modItemArray = new ModificationItem[]{new ModificationItem(3, new BasicAttribute(attrName))};
            this.ctx.modifyAttributes(this.getFullName(obj), modItemArray);
        }
        catch (NamingException ne) {
            throw this.resolveSPIException(ne, "");
        }
    }

    private synchronized void setAttributes(ObjectEntry obj, ObjectAttribute[] objAttr, int[] modifyMode, String[] attrsToDelete) throws SPIException {
        Attribute attr = null;
        try {
            int i;
            Name objName = parser.parse(obj.getFullName());
            ArrayList<ModificationItem> modItemList = new ArrayList<ModificationItem>();
            for (i = 0; i < objAttr.length; ++i) {
                if (modifyMode[i] == 2) {
                    ObjectAttribute attrValToDelete = new ObjectAttribute(objAttr[i].getAttributeDefinition());
                    ObjectAttribute attrValToAdd = new ObjectAttribute(objAttr[i].getAttributeDefinition());
                    this.getModifiedAttributeValues(objAttr[i], attrValToAdd, attrValToDelete);
                    int delCount = attrValToDelete.getComponentCount();
                    int addCount = attrValToAdd.getComponentCount();
                    if (delCount == 0 && addCount == 0) continue;
                    if (objAttr[i].getAttributeDefinition().isSingleValued()) {
                        modItemList.add(new ModificationItem(2, this.convertToJndiAttribute(attrValToAdd)));
                        continue;
                    }
                    if (delCount > 0) {
                        modItemList.add(new ModificationItem(3, this.convertToJndiAttribute(attrValToDelete)));
                    }
                    if (addCount <= 0) continue;
                    modItemList.add(new ModificationItem(1, this.convertToJndiAttribute(attrValToAdd)));
                    continue;
                }
                attr = this.convertToJndiAttribute(objAttr[i]);
                modItemList.add(new ModificationItem(modifyMode[i], attr));
            }
            if (attrsToDelete != null) {
                for (i = 0; i < attrsToDelete.length; ++i) {
                    modItemList.add(new ModificationItem(3, new BasicAttribute(attrsToDelete[i])));
                }
            }
            ModificationItem[] modItemArray = modItemList.toArray(new ModificationItem[0]);
            this.ctx.modifyAttributes(objName, modItemArray);
        }
        catch (NamingException x) {
            throw this.resolveSPIException(x, "");
        }
    }

    private synchronized void modifyAttributes(ObjectEntry obj, ObjectAttribute[] objAttr, int[] modifyMode, String[] attrsToDelete) throws SPIException {
        Attribute attr = null;
        try {
            int i;
            Name objName = parser.parse(obj.getFullName());
            ArrayList<ModificationItem> modItemList = new ArrayList<ModificationItem>();
            for (i = 0; i < objAttr.length; ++i) {
                if (modifyMode[i] == 2) {
                    ObjectAttribute attrValToAdd = new ObjectAttribute(objAttr[i].getAttributeDefinition());
                    this.getModifiedAttributeValues(objAttr[i], attrValToAdd, null);
                    if (attrValToAdd.getComponentCount() == 0) continue;
                    modItemList.add(new ModificationItem(2, this.convertToJndiAttribute(attrValToAdd)));
                    continue;
                }
                attr = this.convertToJndiAttribute(objAttr[i]);
                modItemList.add(new ModificationItem(modifyMode[i], attr));
            }
            if (attrsToDelete != null) {
                for (i = 0; i < attrsToDelete.length; ++i) {
                    modItemList.add(new ModificationItem(3, new BasicAttribute(attrsToDelete[i])));
                }
            }
            ModificationItem[] modItemArray = modItemList.toArray(new ModificationItem[0]);
            this.ctx.modifyAttributes(objName, modItemArray);
        }
        catch (NamingException x) {
            throw this.resolveSPIException(x, "");
        }
    }

    private void getModifiedAttributeValues(ObjectAttribute objAttr, ObjectAttribute attrAddValues, ObjectAttribute attrRemoveValues) {
        int i;
        if (attrAddValues != null) {
            Vector<ValueComponent> bVec = new Vector<ValueComponent>();
            Object[] addValues = objAttr.getAddedComponents();
            for (int i2 = 0; i2 < addValues.length; ++i2) {
                bVec.addElement(addValues[i2]);
            }
            ObjectAttribute.ModifyValue[] modifiedValues = objAttr.getModifiedComponents();
            for (i = 0; i < modifiedValues.length; ++i) {
                bVec.addElement(modifiedValues[i].getNewValue());
            }
            if (!bVec.isEmpty()) {
                addValues = new ValueComponent[bVec.size()];
                bVec.copyInto(addValues);
                try {
                    attrAddValues.addComponents((ValueComponent[])addValues);
                }
                catch (NamespaceException x) {
                    // empty catch block
                }
            }
        }
        if (attrRemoveValues != null) {
            Vector<ValueComponent> cVec = new Vector<ValueComponent>();
            Object[] removeValues = objAttr.getDeletedComponents();
            for (int i3 = 0; i3 < removeValues.length; ++i3) {
                cVec.addElement(removeValues[i3]);
            }
            ObjectAttribute.ModifyValue[] modifiedValues = objAttr.getModifiedComponents();
            for (i = 0; i < modifiedValues.length; ++i) {
                cVec.addElement(modifiedValues[i].getOldValue());
            }
            if (!cVec.isEmpty()) {
                removeValues = new ValueComponent[cVec.size()];
                cVec.copyInto(removeValues);
                try {
                    attrRemoveValues.addComponents((ValueComponent[])removeValues);
                }
                catch (NamespaceException x) {
                    // empty catch block
                }
            }
        }
    }

    private class BaseAndDseObjectClass {
        private String baseClass;
        private String[] dseObjectClass;

        BaseAndDseObjectClass(String baseClass, String[] dseObjectClass) {
            this.baseClass = baseClass;
            this.dseObjectClass = dseObjectClass == null ? new String[0] : dseObjectClass;
        }

        String getBaseClass() {
            return this.baseClass;
        }

        String[] getDseObjectClass() {
            return this.dseObjectClass;
        }

        boolean isGlue() {
            for (int i = 0; i < this.dseObjectClass.length; ++i) {
                String str = this.dseObjectClass[i].toLowerCase();
                if (!str.equals("gluedse") && !str.equals("subrdse") && !str.equals("suprdse") && !str.equals("immsuprdse") && !str.equals("xrdse")) continue;
                return true;
            }
            return false;
        }
    }
}

