/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ValueListFacade;
import com.novell.admin.ns.nds.NDSSyntax;
import java.util.Vector;

public final class BackLinkFacade
extends ValueListFacade {
    private static final int COMP_CREATE = 1;

    public BackLinkFacade(ValueList valueList) throws IncompatibleComponentException {
        super(valueList);
        String name = valueList.getSyntax().getName();
        if (!name.equals("Back Link") && !name.equals("Tagged Name")) {
            throw new IncompatibleComponentException();
        }
    }

    public static ValueList createValueList(String objectName, long remoteId, Syntax syn) {
        try {
            Vector<Object> list = new Vector<Object>();
            list.addElement(new Long(remoteId));
            list.addElement(objectName);
            ValueComponent vc = syn.createValueComponent(list);
            return (ValueList)vc;
        }
        catch (ComponentCreationException e) {
            throw new AdminError(1, "com.novell.admin.ns.nds.BackLinkFacade");
        }
    }

    public static ValueList createValueList(String objectName, long remoteId) {
        return BackLinkFacade.createValueList(objectName, remoteId, NDSSyntax.SYN_BACK_LINK);
    }

    public long getRemoteId() {
        LongValue v = (LongValue)this.valueList.getElementAt(1);
        return v.getValue();
    }

    public String getObjectName() {
        StringValue v = (StringValue)this.valueList.getElementAt(0);
        return v.getValue();
    }

    public void setRemoteId(long id) {
        this.replaceLongValue(id, 1);
    }

    public void setObjectName(String objectName) {
        this.replaceStringValue(objectName, 0);
    }
}

