/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ValueListFacade;
import com.novell.admin.ns.nds.NDSSyntax;
import java.util.Vector;

public final class EmailAddressFacade
extends ValueListFacade {
    private static final int COMP_CREATE = 1;

    public EmailAddressFacade(ValueList comp) throws IncompatibleComponentException {
        super(comp);
        String name = comp.getSyntax().getName();
        if (!name.equals("EMail Address") && !name.equals("Tagged String")) {
            throw new IncompatibleComponentException();
        }
    }

    public static ValueList createValueList(long type, String address, Syntax syn) {
        try {
            Vector<Object> list = new Vector<Object>();
            list.addElement(new Long(type));
            list.addElement(address);
            ValueComponent vc = syn.createValueComponent(list);
            return (ValueList)vc;
        }
        catch (ComponentCreationException e) {
            throw new AdminError(1, "com.novell.admin.ns.nds.EmailAddressFacade");
        }
    }

    public static ValueList createValueList(long type, String address) {
        return EmailAddressFacade.createValueList(type, address, NDSSyntax.SYN_EMAIL_ADDRESS);
    }

    public long getType() {
        LongValue v = (LongValue)this.valueList.getElementAt(0);
        return v.getValue();
    }

    public String getAddress() {
        StringValue v = (StringValue)this.valueList.getElementAt(1);
        return v.getValue();
    }

    public void setType(long type) {
        this.replaceLongValue(type, 0);
    }

    public void setAddress(String address) {
        this.replaceStringValue(address, 1);
    }
}

