/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.common.exceptions.FacadeParameterException;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ValueListFacade;
import com.novell.admin.ns.nds.NDSSyntax;
import java.util.Vector;

public final class FaxNumberFacade
extends ValueListFacade {
    private static final int COMP_CREATE = 1;

    public FaxNumberFacade(ValueList comp) throws IncompatibleComponentException {
        super(comp);
        String name = comp.getSyntax().getName();
        if (!name.equals("Facsimile Telephone Number")) {
            throw new IncompatibleComponentException();
        }
    }

    public static ValueList createValueList(long bits, String teleNumber, Syntax syn) {
        try {
            Vector<Object> list = new Vector<Object>();
            list.addElement(new Long(bits));
            list.addElement(teleNumber);
            ValueComponent vc = syn.createValueComponent(list);
            return (ValueList)vc;
        }
        catch (ComponentCreationException e) {
            throw new AdminError(1, "com.novell.admin.ns.nds.FaxNumberFacade");
        }
    }

    public static ValueList createValueList(long bits, String teleNumber) {
        return FaxNumberFacade.createValueList(bits, teleNumber, NDSSyntax.SYN_FAX_NUMBER);
    }

    public long getBits() {
        LongValue v = (LongValue)this.valueList.getElementAt(0);
        return v.getValue();
    }

    public String getTeleNumber() {
        StringValue v = (StringValue)this.valueList.getElementAt(1);
        return v.getValue();
    }

    public void setBits(long bits) {
        this.replaceLongValue(bits, 0);
    }

    public void setTeleNumber(String teleNumber) throws FacadeParameterException {
        this.replaceStringValue(teleNumber, 1);
    }
}

