/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.common.exceptions.FacadeParameterException;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ValueListFacade;
import com.novell.admin.ns.ValueStrategy;
import com.novell.admin.ns.nds.NDSSyntax;
import java.util.Vector;

public final class HoldFacade
extends ValueListFacade {
    private static final int COMP_CREATE = 1;

    public HoldFacade(ValueList comp) throws IncompatibleComponentException {
        super(comp);
        if (comp.getSyntax() != NDSSyntax.SYN_HOLD) {
            throw new IncompatibleComponentException();
        }
    }

    public static ValueList createValueList(String subject, long amount) {
        try {
            Vector<Object> list = new Vector<Object>();
            list.addElement(subject);
            list.addElement(new Long(amount));
            ValueComponent vc = NDSSyntax.SYN_HOLD.createValueComponent(list);
            return (ValueList)vc;
        }
        catch (ComponentCreationException e) {
            throw new AdminError(1, "com.novell.admin.ns.nds.HoldFacade");
        }
    }

    public String getSubject() {
        StringValue v = (StringValue)this.valueList.getElementAt(0);
        return v.getValue();
    }

    public int getAmount() {
        LongValue v = (LongValue)this.valueList.getElementAt(1);
        return (int)v.getValue();
    }

    public void setSubject(String subject) {
        ValueStrategy svs = (ValueStrategy)NDSSyntax.SYN_DIST_NAME.getStrategy();
        if (svs.canCreateValue(subject)) {
            this.replaceStringValue(subject, 0);
        }
        throw new FacadeParameterException();
    }

    public void setAmount(int amount) {
        this.replaceLongValue(amount, 1);
    }
}

