/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.DefaultNSObject;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSNamespaceException;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import java.util.Enumeration;
import java.util.Vector;

public class NDSObject
extends DefaultNSObject {
    protected NDSObject(ObjectEntry objEntry, Vector initialAttributes, long rev) {
        super(objEntry, initialAttributes, rev);
    }

    public boolean addAuxiliaryClassDefinition(ClassDefinition classDef, ObjectAttribute[] attributes) throws NamespaceException {
        boolean attrsAdded = super.addAuxiliaryClassDefinition(classDef, attributes);
        ObjectAttribute objClassAttr = this.getAttribute("Object Class");
        if (objClassAttr == null) {
            throw NDSNamespaceException.NO_RIGHTS_TO_ADD_AUXILIARY_CLASS;
        }
        objClassAttr.addComponent(new StringValue(NDSSyntax.SYN_CLASS_NAME, classDef.getName()));
        return attrsAdded;
    }

    public boolean deleteAuxiliaryClassDefinition(ClassDefinition classDef) throws NamespaceException {
        boolean classDeleted = super.deleteAuxiliaryClassDefinition(classDef);
        if (classDeleted) {
            String attrName;
            int i;
            ObjectAttribute objClassAttr = this.getAttribute("Object Class");
            if (objClassAttr == null) {
                throw NDSNamespaceException.NO_RIGHTS_TO_REMOVE_AUXILIARY_CLASS;
            }
            AttributeDefinition[] attr = classDef.getOptionalAttributes();
            for (i = 0; i < attr.length; ++i) {
                attrName = attr[i].getName().toLowerCase();
                if (this.modifiedAttributes.contains(attrName)) {
                    this.modifiedAttributes.remove(attrName);
                }
                if (this.addedAttributes.contains(attrName)) {
                    this.addedAttributes.remove(attrName);
                }
                if (!this.deletedAttributes.contains(attrName)) continue;
                this.deletedAttributes.remove(attrName);
            }
            attr = classDef.getMandatoryAttributes();
            for (i = 0; i < attr.length; ++i) {
                attrName = attr[i].getName().toLowerCase();
                if (this.modifiedAttributes.contains(attrName)) {
                    this.modifiedAttributes.remove(attrName);
                }
                if (this.addedAttributes.contains(attrName)) {
                    this.addedAttributes.remove(attrName);
                }
                if (!this.deletedAttributes.contains(attrName)) continue;
                this.deletedAttributes.remove(attrName);
            }
            objClassAttr.removeComponent(new StringValue(NDSSyntax.SYN_CLASS_NAME, classDef.getName()));
        }
        return classDeleted;
    }

    public NSObject clone(ObjectEntry newIdentity) throws NamespaceException {
        ObjectType[] newObjectTypes;
        ObjectType[] oldObjectTypes;
        NDSObject newNSObject = null;
        if (newIdentity.getObjectType() == this.objectEntry.getObjectType() && (oldObjectTypes = this.objectEntry.getSubTypes()).length == (newObjectTypes = newIdentity.getSubTypes()).length) {
            int i;
            Vector<ObjectType> objectTypeVec = new Vector<ObjectType>(oldObjectTypes.length);
            for (i = 0; i < oldObjectTypes.length; ++i) {
                objectTypeVec.addElement(oldObjectTypes[i]);
            }
            for (i = 0; i < oldObjectTypes.length; ++i) {
                if (objectTypeVec.contains(newObjectTypes[i])) continue;
                throw NamespaceException.OBJECTTYPE_NOT_VALID;
            }
            newNSObject = (NDSObject)this.clone();
            newNSObject.objectEntry = newIdentity;
            Enumeration myenum = newNSObject.attributes.elements();
            while (myenum.hasMoreElements()) {
                ObjectAttribute attr = (ObjectAttribute)myenum.nextElement();
                NDSAttributeDefinition attrDef = (NDSAttributeDefinition)attr.getAttributeDefinition();
                if (!attrDef.getAttributeFlag().isFlagSet(8)) continue;
                newNSObject.attributes.remove(attrDef.getName().toLowerCase());
            }
            ObjectAttribute objectClassAttr = (ObjectAttribute)newNSObject.attributes.get("object class");
            String objectClassVal = newIdentity.getObjectType().getName();
            StringValue strVal = null;
            Enumeration valEnum = objectClassAttr.getValueComponents();
            while (valEnum.hasMoreElements() && !(strVal = (StringValue)valEnum.nextElement()).getValue().equals(objectClassVal)) {
            }
            objectClassAttr.removeAllComponents();
            objectClassAttr.addComponent(strVal);
        }
        if (newNSObject == null) {
            throw NamespaceException.OBJECTTYPE_NOT_VALID;
        }
        return newNSObject;
    }
}

