/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.DefaultSchemaDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.Schema;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSClassDefinition;
import com.novell.admin.ns.nds.NDSNamespaceException;
import com.novell.admin.ns.nds.NDSSchema;
import com.novell.application.console.snapin.NamespaceSnapin;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public final class NDSSchemaDefinition
extends DefaultSchemaDefinition {
    private NDSSchema schema = null;
    private PropertyChangeSupport changeSupporter;
    private VetoableChangeSupport vetoSupporter;

    public NDSSchemaDefinition(Schema schema, NamespaceSnapin ns2) {
        super(ns2);
        this.schema = (NDSSchema)schema;
        this.changeSupporter = new PropertyChangeSupport(this);
        this.vetoSupporter = new VetoableChangeSupport(this);
    }

    public void refreshSchema() throws PropertyVetoException {
        this.vetoSupporter.fireVetoableChange(null, this.schema, null);
        this.attributes.clear();
        this.classes.clear();
        this.schema.refreshSchema();
        this.changeSupporter.firePropertyChange(null, null, this.schema);
    }

    public NDSClassDefinition getUnexpandedClassDefinition(String className) throws NamespaceException {
        NDSClassDefinition cd = (NDSClassDefinition)this.classes.get(className.toLowerCase());
        if (cd != null) {
            return cd;
        }
        String realName = (String)this.aliasClassNames.get(className.toLowerCase());
        if (realName != null && (cd = (NDSClassDefinition)this.classes.get(realName.toLowerCase())) != null) {
            return cd;
        }
        throw NamespaceException.CLASS_NOT_DEFINED;
    }

    public void putAttributeDefinition(AttributeDefinition attributeDef) throws NamespaceException, SPIException, PropertyVetoException {
        String key = attributeDef.getName().toLowerCase();
        NDSAttributeDefinition oldAttr = (NDSAttributeDefinition)this.attributes.get(key);
        if (oldAttr != null) {
            throw NDSNamespaceException.CANT_MODIFY_EXISTING_ATTRIBUTE;
        }
        this.vetoSupporter.fireVetoableChange(key, oldAttr, attributeDef);
        if (this.schema != null) {
            this.schema.writeAttributeDefinition(attributeDef);
        }
        this.attributes.put(key, attributeDef);
        this.changeSupporter.firePropertyChange(key, oldAttr, attributeDef);
    }

    public void putClassDefinition(ClassDefinition classDef) throws NamespaceException, SPIException, PropertyVetoException {
        int i;
        NDSClassDefinition ndsClass = (NDSClassDefinition)classDef;
        AttributeDefinition[] attrDefs = null;
        String key = classDef.getName();
        NDSClassDefinition oldClass = (NDSClassDefinition)this.classes.get(key.toLowerCase());
        String[] superClassNames = ndsClass.getSuperClasses();
        for (i = 0; i < superClassNames.length; ++i) {
            if (this.classes.containsKey(superClassNames[i].toLowerCase())) continue;
            throw NDSNamespaceException.SUPERCLASS_NOT_DEFINED;
        }
        attrDefs = classDef.getMandatoryAttributes();
        for (i = 0; i < attrDefs.length; ++i) {
            if (this.attributes.containsKey(attrDefs[i].getName().toLowerCase())) continue;
            throw NamespaceException.ATTRIBUTE_NOT_DEFINED;
        }
        if (oldClass != null) {
            AttributeDefinition[] oldManAttr = oldClass.getMandatoryAttributes();
            if (attrDefs.length == oldManAttr.length) {
                int i2;
                Vector<AttributeDefinition> oldManAttrVec = new Vector<AttributeDefinition>(oldManAttr.length);
                for (i2 = 0; i2 < oldManAttr.length; ++i2) {
                    oldManAttrVec.addElement(oldManAttr[i2]);
                }
                for (i2 = 0; i2 < oldManAttr.length; ++i2) {
                    if (oldManAttrVec.contains(attrDefs[i2])) continue;
                    throw NamespaceException.MODIFYING_MANDATORY_ATTRIBUTES_NOT_ALLOWED;
                }
            } else {
                throw NamespaceException.MODIFYING_MANDATORY_ATTRIBUTES_NOT_ALLOWED;
            }
        }
        attrDefs = classDef.getOptionalAttributes();
        for (int i3 = 0; i3 < attrDefs.length; ++i3) {
            if (this.attributes.containsKey(attrDefs[i3].getName().toLowerCase())) continue;
            throw NamespaceException.ATTRIBUTE_NOT_DEFINED;
        }
        if (oldClass != null && oldClass.getClassFlags().getFlags() != ((NDSClassDefinition)classDef).getClassFlags().getFlags()) {
            throw NamespaceException.MODIFY_CLASS_FLAGS_NOT_ALLOWED;
        }
        this.vetoSupporter.fireVetoableChange(key, oldClass, ndsClass);
        if (this.schema != null) {
            if (oldClass != null) {
                this.schema.modifyClassDefinition(classDef);
            } else {
                this.schema.writeClassDefinition(classDef);
            }
        }
        this.classes.put(key.toLowerCase(), classDef);
        this.generateExpandedDefinition((NDSClassDefinition)classDef);
        this.changeSupporter.firePropertyChange(key, oldClass, classDef);
    }

    public void modifyClassDefination(ClassDefinition classDef) throws SPIException {
        this.schema.modifyClassDefinition(classDef);
    }

    public void modifyAttributeDefination(AttributeDefinition attrDef) throws SPIException {
        this.schema.modifyAttributeDefinition(attrDef);
    }

    public void removeAttributeDefinition(String attrName) throws NamespaceException, SPIException, PropertyVetoException {
        AttributeDefinition attrDef = this.getAttributeDefinition(attrName);
        if (attrDef == null) {
            return;
        }
        ClassDefinition[] cd = this.getClassesUsingAttribute(attrName);
        if (cd.length != 0) {
            throw NamespaceException.ATTRIBUTE_IN_USE;
        }
        this.vetoSupporter.fireVetoableChange(attrName.toLowerCase(), attrDef, null);
        if (this.schema != null) {
            this.schema.deleteAttributeDefinition(attrDef);
        }
        this.attributes.remove(attrName.toLowerCase());
        this.changeSupporter.firePropertyChange(attrName.toLowerCase(), attrDef, null);
    }

    public void removeClassDefinition(String className) throws NamespaceException, SPIException, PropertyVetoException {
        ClassDefinition[] subClasses = this.getSubClasses(className);
        ClassDefinition oldClass = this.getRawClassDefinition(className);
        if (subClasses.length != 0) {
            throw NDSNamespaceException.CLASS_IN_USE;
        }
        this.vetoSupporter.fireVetoableChange(className, oldClass, null);
        if (this.schema != null) {
            this.schema.deleteClassDefinition(oldClass);
        }
        this.classes.remove(className.toLowerCase());
        this.expandedClasses.remove(className.toLowerCase());
        this.changeSupporter.firePropertyChange(className, oldClass, null);
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        this.vetoSupporter.addVetoableChangeListener(l);
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        this.vetoSupporter.removeVetoableChangeListener(l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupporter.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupporter.removePropertyChangeListener(l);
    }

    public void addAttributeDefinition(AttributeDefinition attrDef) {
        String key = attrDef.getName().toLowerCase();
        this.attributes.put(key, attrDef);
    }

    public void addClassDefinition(ClassDefinition classDef) {
        String key = classDef.getName();
        this.classes.put(key.toLowerCase(), classDef);
    }

    public void generateExpandedDefinitions() throws NamespaceException {
        this.expandedClasses.clear();
        Iterator iter = this.classes.values().iterator();
        while (iter.hasNext()) {
            NDSClassDefinition classDef = (NDSClassDefinition)iter.next();
            this.generateExpandedDefinition(classDef);
        }
    }

    void generateExpandedDefinition(NDSClassDefinition classDef) throws NamespaceException {
        String className = classDef.getName();
        ArrayList allSuperClasses = this.getInheritedSuperClasses(classDef);
        allSuperClasses.add(className);
        AttributeDefinition[] mandatory = this.getInheritedMandatoryAttributes(allSuperClasses);
        AttributeDefinition[] optional = this.getInheritedOptionalAttributes(allSuperClasses);
        allSuperClasses.remove(className);
        String[] containmentClasses = this.getInheritedContainmentClasses(classDef);
        AttributeDefinition[] naming = this.getInheritedNamingAttributes(classDef);
        String[] s = allSuperClasses.toArray(new String[0]);
        NDSClassDefinition newClassDef = new NDSClassDefinition(className, classDef.getClassFlags(), containmentClasses, s, mandatory, naming, optional, classDef.getASN1Data());
        newClassDef.setExpanded(true);
        this.expandedClasses.put(className.toLowerCase(), newClassDef);
    }

    private ArrayList getInheritedSuperClasses(NDSClassDefinition classDef) throws NamespaceException {
        ArrayList classList = new ArrayList(3);
        this.getAllSuperClassesOf(classDef, classList);
        return classList;
    }

    private void getAllSuperClassesOf(NDSClassDefinition classDef, ArrayList classList) throws NamespaceException {
        String[] superClassNames = classDef.getSuperClasses();
        for (int i = 0; i < superClassNames.length; ++i) {
            NDSClassDefinition superClassDef = (NDSClassDefinition)this.getRawClassDefinition(superClassNames[i]);
            if (classList.contains(superClassNames[i])) continue;
            classList.add(superClassNames[i]);
            this.getAllSuperClassesOf(superClassDef, classList);
        }
    }

    private AttributeDefinition[] getInheritedMandatoryAttributes(ArrayList allClasses) throws NamespaceException {
        ArrayList<AttributeDefinition> attrs = new ArrayList<AttributeDefinition>();
        Iterator iter = allClasses.iterator();
        while (iter.hasNext()) {
            String superName = (String)iter.next();
            ClassDefinition superDef = this.getRawClassDefinition(superName);
            AttributeDefinition[] attrDefs = superDef.getMandatoryAttributes();
            for (int i = 0; i < attrDefs.length; ++i) {
                attrs.add(attrDefs[i]);
            }
        }
        return attrs.toArray(new AttributeDefinition[0]);
    }

    private AttributeDefinition[] getInheritedOptionalAttributes(ArrayList allClasses) throws NamespaceException {
        ArrayList<AttributeDefinition> attrs = new ArrayList<AttributeDefinition>();
        Iterator iter = allClasses.iterator();
        while (iter.hasNext()) {
            String superName = (String)iter.next();
            ClassDefinition superDef = this.getRawClassDefinition(superName);
            AttributeDefinition[] attrDefs = superDef.getOptionalAttributes();
            for (int i = 0; i < attrDefs.length; ++i) {
                attrs.add(attrDefs[i]);
            }
        }
        return attrs.toArray(new AttributeDefinition[0]);
    }

    private String[] getInheritedContainmentClasses(ClassDefinition classDef) {
        try {
            if (classDef.isAuxiliary()) {
                return new String[0];
            }
            String[] classDefStrings = classDef.getContainmentClasses();
            if (classDefStrings.length != 0) {
                return classDefStrings;
            }
            String[] superNames = classDef.getSuperClasses();
            if (superNames.length == 0) {
                return new String[0];
            }
            for (int i = 0; i < superNames.length; ++i) {
                ClassDefinition superDef = this.getRawClassDefinition(superNames[i]);
                classDefStrings = this.getInheritedContainmentClasses(superDef);
                if (classDefStrings.length == 0) continue;
                return classDefStrings;
            }
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
        return new String[0];
    }

    private AttributeDefinition[] getInheritedNamingAttributes(ClassDefinition classDef) {
        try {
            AttributeDefinition[] attrDefs = classDef.getNamingAttributes();
            if (attrDefs.length != 0) {
                return attrDefs;
            }
            if (classDef.isAuxiliary()) {
                return new AttributeDefinition[0];
            }
            String[] superNames = classDef.getSuperClasses();
            if (superNames.length == 0) {
                return new AttributeDefinition[0];
            }
            for (int i = 0; i < superNames.length; ++i) {
                ClassDefinition superDef = this.getRawClassDefinition(superNames[i]);
                attrDefs = this.getInheritedNamingAttributes(superDef);
                if (attrDefs.length == 0) continue;
                return attrDefs;
            }
        }
        catch (NamespaceException ex) {
            // empty catch block
        }
        return new AttributeDefinition[0];
    }

    public synchronized Object clone() {
        NDSSchemaDefinition sd = (NDSSchemaDefinition)super.clone();
        sd.schema = null;
        sd.changeSupporter = new PropertyChangeSupport(sd);
        sd.vetoSupporter = new VetoableChangeSupport(sd);
        return sd;
    }
}

