/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.ListStrategy;
import com.novell.admin.ns.NSUtil;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.admin.ns.nds.NetAddressFacade;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

final class NetAddressStrategy
extends ListStrategy {
    NetAddressStrategy() {
    }

    public ValueComponent createValueComponent() {
        ValueList list = new ValueList(NDSSyntax.SYN_NET_ADDRESS);
        list.initList(NDSSyntax.SYN_INTEGER.createValueComponent());
        list.initList(NDSSyntax.SYN_OCTET_STRING.createValueComponent());
        return list;
    }

    public ValueComponent createValueComponent(Object paramObj) throws ComponentCreationException {
        Vector compList;
        ValueList list = new ValueList(NDSSyntax.SYN_NET_ADDRESS);
        Long type = null;
        byte[] address = null;
        if (paramObj instanceof byte[]) {
            int i;
            long num = 0L;
            byte[] buf = (byte[])paramObj;
            for (i = 0; i < buf.length; ++i) {
                if (buf[i] == 35) {
                    ++i;
                    break;
                }
                if (buf[i] < 48 || buf[i] > 57) {
                    throw new ComponentCreationException();
                }
                num = num * 10L + (long)buf[i] - 48L;
            }
            type = new Long(num);
            if (i == buf.length) {
                throw new ComponentCreationException();
            }
            address = new byte[buf.length - i];
            for (int j = i; j < buf.length; ++j) {
                address[j - i] = buf[j];
            }
        } else if (paramObj instanceof String) {
            StringTokenizer st = new StringTokenizer((String)paramObj, "#");
            type = new Long(st.nextToken());
            address = NSUtil.hexStringToByteArray(st.nextToken());
        } else if (paramObj instanceof Vector && (compList = (Vector)paramObj).size() == 2) {
            Enumeration e = compList.elements();
            while (e.hasMoreElements()) {
                Object comp = e.nextElement();
                if (comp instanceof Long) {
                    type = (Long)comp;
                    continue;
                }
                if (!(comp instanceof byte[])) continue;
                address = (byte[])comp;
            }
        }
        if (type == null || address == null) {
            throw new ComponentCreationException();
        }
        list.initList(NDSSyntax.SYN_INTEGER.createValueComponent(type));
        list.initList(NDSSyntax.SYN_OCTET_STRING.createValueComponent(address));
        return list;
    }

    public Object createFacade(ValueComponent comp) throws IncompatibleComponentException {
        return new NetAddressFacade((ValueList)comp);
    }

    public String toString(ValueComponent vc) {
        if (vc instanceof ValueList) {
            ValueList list = (ValueList)vc;
            return list.getElementAt(0) + "#" + list.getElementAt(1);
        }
        return vc.toString();
    }
}

