/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.common.exceptions.FacadeParameterException;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ValueListFacade;
import com.novell.admin.ns.ValueStrategy;
import com.novell.admin.ns.ldap.ConvertACL;
import com.novell.admin.ns.ldap.LDAPSyntax;
import com.novell.admin.ns.nds.NDSSyntax;
import java.util.Vector;

public final class ObjectACLFacade
extends ValueListFacade {
    private static final int COMP_CREATE = 1;
    public static final int E_BROWSE_ENTRY = 1;
    public static final int E_CREATE_ENTRY = 2;
    public static final int E_DELETE_ENTRY = 4;
    public static final int E_RENAME_ENTRY = 8;
    public static final int E_SUPER_ENTRY = 16;
    public static final int E_COMPARE_ATTR = 1;
    public static final int E_READ_ATTR = 2;
    public static final int E_WRITE_ATTR = 4;
    public static final int E_SELF_ATTR = 8;
    public static final int E_SUPER_ATTR = 32;
    public static final int E_INHERIT_CTL_BIT = 64;
    public static final int E_DYNAMIC_GRP_BIT = 0x20000000;
    public static final int E_NESTED_GRP_BIT = Integer.MIN_VALUE;
    public static final String E_ENTRY_RIGHTS = "[Entry Rights]";
    public static final String E_ALL_ATTRIBUTES = "[All Attributes Rights]";
    public static final String E_PUBLIC = "[Public]";
    public static final String E_ROOT = "[Root]";
    public static final String E_CREATOR = "[Creator]";
    public static final String E_SELF = "[Self]";
    public static final int V_BROWSE_ENTRY = 1;
    public static final int V_CREATE_ENTRY = 2;
    public static final int V_DELETE_ENTRY = 4;
    public static final int V_RENAME_ENTRY = 8;
    public static final int V_SUPER_ENTRY = 16;
    public static final int V_COMPARE_ATTR = 1;
    public static final int V_READ_ATTR = 2;
    public static final int V_WRITE_ATTR = 4;
    public static final int V_DELETE_ATTR = 8;
    public static final int V_SUPER_ATTR = 16;
    public static final int V_SELF_ATTR = 32;
    public static final int MODIFIER_ATTRIBUTE = 0;
    public static final int MODIFIER_ENTRY = 1;
    public static final int MODIFIER_DYNGRP = 2;
    public static final String TRUSTEE_AUTHENTICATED = "authenticated";
    public static final String TRUSTEE_UNAUTHENTICATED = "unauthenticated";
    public static final String TRUSTEE_CREATOR = "creator";
    public static final String TRUSTEE_SELF = "self";
    public static final String SCOPE_BASE_OBJECT = "baseObject";
    public static final String SCOPE_SINGLE_LEVEL = "singleLevel";
    public static final String SCOPE_SUBORDINATES = "subordinates";
    public static final String SCOPE_WHOLE_SUBTREE = "wholeSubtree";
    public static final String SCOPE_DENY_INHERITANCE = "inheritedRightsFilterWholeSubtree";
    public static final String SCOPE_DENY_INHERITANCE_SUPERIOR = "inheritedRightsFilterSubordinateSubtree";

    public ObjectACLFacade(ValueList comp) throws IncompatibleComponentException {
        super(comp);
    }

    public static ValueList createValueList(String protectedAttrName, String subjectName, long privileges) {
        return ObjectACLFacade.createValueList(protectedAttrName, subjectName, privileges, NDSSyntax.SYN_OBJECT_ACL);
    }

    public static ValueList createValueList(String protectedAttrName, String subjectName, long privileges, Syntax syntax) {
        try {
            Vector<Object> vec = new Vector<Object>();
            vec.addElement(protectedAttrName);
            vec.addElement(subjectName);
            vec.addElement(new Long(privileges));
            ValueComponent vc = syntax.createValueComponent(vec);
            return (ValueList)vc;
        }
        catch (ComponentCreationException e) {
            throw new AdminError(1, "com.novell.admin.ns.nds.ObjectACLFacade");
        }
    }

    public String getProtectedAttrName() {
        try {
            if (this.valueList.getSyntax().getId() == LDAPSyntax.SYN_NVDS_ACL.getId()) {
                Vector vec = this.extractVector();
                vec = ConvertACL.toNDSACL(vec);
                return (String)vec.get(0);
            }
            StringValue v = (StringValue)this.valueList.getElementAt(0);
            return v.getValue();
        }
        catch (ComponentCreationException ex) {
            throw new FacadeParameterException();
        }
    }

    public String getSubjectName() {
        try {
            if (this.valueList.getSyntax().getId() == LDAPSyntax.SYN_NVDS_ACL.getId()) {
                Vector vec = this.extractVector();
                vec = ConvertACL.toNDSACL(vec);
                return (String)vec.get(1);
            }
            StringValue v = (StringValue)this.valueList.getElementAt(1);
            return v.getValue();
        }
        catch (ComponentCreationException ex) {
            throw new FacadeParameterException();
        }
    }

    public long getPrivileges() {
        try {
            if (this.valueList.getSyntax().getId() == LDAPSyntax.SYN_NVDS_ACL.getId()) {
                Vector vec = this.extractVector();
                vec = ConvertACL.toNDSACL(vec);
                return (Long)vec.get(2);
            }
            LongValue v = (LongValue)this.valueList.getElementAt(2);
            return v.getValue();
        }
        catch (ComponentCreationException ex) {
            throw new FacadeParameterException();
        }
    }

    public void setProtectedAttrName(String name) {
        try {
            Syntax syn = this.valueList.getSyntax();
            if (syn.getId() == LDAPSyntax.SYN_NVDS_ACL.getId()) {
                Vector vec = this.extractVector();
                vec = ConvertACL.toNDSACL(vec);
                vec.setElementAt(name, 0);
                ValueList tmpVL = (ValueList)syn.createValueComponent(vec);
                for (int i = 0; i < tmpVL.getComponentCount(); ++i) {
                    this.valueList.replaceComponentAt(tmpVL.getElementAt(i), i);
                }
            } else {
                this.replaceStringValue(name, 0);
            }
        }
        catch (ComponentCreationException ex) {
            throw new FacadeParameterException();
        }
    }

    public void setSubjectName(String name) {
        block5: {
            try {
                Syntax syn = this.valueList.getSyntax();
                if (syn.getId() == LDAPSyntax.SYN_NVDS_ACL.getId()) {
                    Vector vec = this.extractVector();
                    vec = ConvertACL.toNDSACL(vec);
                    vec.setElementAt(name, 1);
                    ValueList tmpVL = (ValueList)syn.createValueComponent(vec);
                    for (int i = 0; i < tmpVL.getComponentCount(); ++i) {
                        this.valueList.replaceComponentAt(tmpVL.getElementAt(i), i);
                    }
                    break block5;
                }
                ValueStrategy svs = (ValueStrategy)this.valueList.getElementAt(1).getSyntax().getStrategy();
                if (svs.canCreateValue(name)) {
                    this.replaceStringValue(name, 1);
                    break block5;
                }
                throw new FacadeParameterException();
            }
            catch (ComponentCreationException ex) {
                throw new FacadeParameterException();
            }
        }
    }

    public void setPrivileges(long privileges) {
        try {
            Syntax syn = this.valueList.getSyntax();
            if (syn.getId() == LDAPSyntax.SYN_NVDS_ACL.getId()) {
                Vector vec = this.extractVector();
                vec = ConvertACL.toNDSACL(vec);
                vec.setElementAt(new Long(privileges), 2);
                ValueList tmpVL = (ValueList)syn.createValueComponent(vec);
                for (int i = 0; i < tmpVL.getComponentCount(); ++i) {
                    this.valueList.replaceComponentAt(tmpVL.getElementAt(i), i);
                }
            } else {
                this.replaceLongValue(privileges, 2);
            }
        }
        catch (ComponentCreationException ex) {
            throw new FacadeParameterException();
        }
    }

    private Vector extractVector() {
        if (this.valueList.getComponentCount() == 3) {
            Vector<Object> vec = new Vector<Object>(3);
            vec.add(((StringValue)this.valueList.getElementAt(0)).getValue());
            vec.add(((StringValue)this.valueList.getElementAt(1)).getValue());
            vec.add(((LongValue)this.valueList.getElementAt(2)).getLongValue());
            return vec;
        }
        if (this.valueList.getComponentCount() == 7) {
            Vector<Object> vec = new Vector<Object>(7);
            vec.add(((LongValue)this.valueList.getElementAt(0)).getLongValue());
            vec.add(((LongValue)this.valueList.getElementAt(1)).getLongValue());
            vec.add(((StringValue)this.valueList.getElementAt(2)).getValue());
            vec.add(((StringValue)this.valueList.getElementAt(3)).getValue());
            vec.add(((StringValue)this.valueList.getElementAt(4)).getValue());
            vec.add(((StringValue)this.valueList.getElementAt(5)).getValue());
            vec.add(((StringValue)this.valueList.getElementAt(6)).getValue());
            return vec;
        }
        throw new FacadeParameterException();
    }

    public static ValueList createValueList(long privileges, long modifier, String trusteeDN, String filterDN, String scope, String className, String attrName, Syntax syntax) {
        try {
            Vector<Object> vec = new Vector<Object>();
            vec.addElement(new Long(privileges));
            vec.addElement(new Long(modifier));
            vec.addElement(ObjectACLFacade.encodeTrustee(trusteeDN));
            vec.addElement(filterDN);
            vec.addElement(scope);
            vec.addElement(className);
            vec.addElement(attrName);
            ValueComponent vc = syntax.createValueComponent(vec);
            return (ValueList)vc;
        }
        catch (ComponentCreationException e) {
            throw new AdminError(1, "com.novell.admin.ns.nds.NVDSACLFacade");
        }
    }

    public long getNVDSPrivileges() {
        LongValue v = (LongValue)this.valueList.getElementAt(0);
        return v.getValue();
    }

    public void setNVDSPrivileges(long privileges) {
        this.replaceLongValue(privileges, 0);
    }

    public long getNVDSModifier() {
        LongValue v = (LongValue)this.valueList.getElementAt(1);
        return v.getValue();
    }

    public void setNVDSModifier(long modifier) {
        this.replaceLongValue(modifier, 1);
    }

    public String getNVDSTrustee() {
        StringValue v = (StringValue)this.valueList.getElementAt(2);
        String fullDN = v.getValue();
        return ObjectACLFacade.decodeTrustee(fullDN);
    }

    public void setNVDSTrustee(String trusteeDN) {
        this.replaceStringValue(ObjectACLFacade.encodeTrustee(trusteeDN), 2);
    }

    public String getNVDSFilter() {
        StringValue v = (StringValue)this.valueList.getElementAt(3);
        return v.getValue();
    }

    public void setNVDSFilter(String filterDN) {
        if (filterDN == null) {
            filterDN = "";
        }
        this.replaceStringValue(filterDN, 3);
    }

    public String getNVDSScope() {
        StringValue v = (StringValue)this.valueList.getElementAt(4);
        return v.getValue();
    }

    public void setNVDSScope(String scope) {
        this.replaceStringValue(scope, 4);
    }

    public String getNVDSClassName() {
        StringValue v = (StringValue)this.valueList.getElementAt(5);
        return v.getValue();
    }

    public void setNVDSClassName(String className) {
        if (className == null) {
            className = "";
        }
        this.replaceStringValue(className, 5);
    }

    public String getNVDSAttributeName() {
        StringValue v = (StringValue)this.valueList.getElementAt(6);
        return v.getValue();
    }

    public void setNVDSAttributeName(String attrName) {
        if (attrName == null) {
            attrName = "";
        }
        this.replaceStringValue(attrName, 6);
    }

    private static String encodeTrustee(String keyword) {
        if (keyword.equalsIgnoreCase(TRUSTEE_AUTHENTICATED)) {
            return "si=authenticated,sc=system,sc=local";
        }
        if (keyword.equalsIgnoreCase(TRUSTEE_UNAUTHENTICATED)) {
            return "si=unauthenticated,sc=system,sc=local";
        }
        if (keyword.equalsIgnoreCase(TRUSTEE_CREATOR)) {
            return "si=creator,sc=system,sc=local";
        }
        if (keyword.equalsIgnoreCase(TRUSTEE_SELF)) {
            return "si=self,sc=system,sc=local";
        }
        return keyword;
    }

    private static String decodeTrustee(String fullDN) {
        if (fullDN.toLowerCase().startsWith("si=authenticated")) {
            return TRUSTEE_AUTHENTICATED;
        }
        if (fullDN.toLowerCase().startsWith("si=unauthenticated")) {
            return TRUSTEE_UNAUTHENTICATED;
        }
        if (fullDN.toLowerCase().startsWith("si=creator")) {
            return TRUSTEE_CREATOR;
        }
        if (fullDN.toLowerCase().startsWith("si=self")) {
            return TRUSTEE_SELF;
        }
        return fullDN;
    }
}

