/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.HexValue;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.ListStrategy;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.admin.ns.nds.OctetListFacade;
import java.util.Enumeration;
import java.util.Vector;

final class OctetListStrategy
extends ListStrategy {
    OctetListStrategy() {
    }

    public ValueComponent createValueComponent() {
        ValueList v = new ValueList(NDSSyntax.SYN_OCTET_LIST);
        byte[] value = new byte[]{0};
        v.initList(new HexValue(NDSSyntax.SYN_OCTET_STRING, value));
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueComponent createValueComponent(Object vectorObj) throws ComponentCreationException {
        if (!(vectorObj instanceof Vector)) {
            throw new ComponentCreationException();
        }
        Vector compList = (Vector)vectorObj;
        ValueList v = new ValueList(NDSSyntax.SYN_OCTET_LIST);
        Vector vector = compList;
        synchronized (vector) {
            Enumeration e = compList.elements();
            while (e.hasMoreElements()) {
                HexValue hv;
                Object comp = e.nextElement();
                if (comp instanceof byte[]) {
                    v.initList(new HexValue(NDSSyntax.SYN_OCTET_STRING, (byte[])comp));
                    continue;
                }
                if (!(comp instanceof HexValue) || (hv = (HexValue)comp).getSyntax() != NDSSyntax.SYN_OCTET_STRING) continue;
                v.initList(hv);
            }
        }
        return v;
    }

    public Vector getAddableSyntaxes(ValueList list) {
        Vector<NDSSyntax> v = new Vector<NDSSyntax>();
        v.addElement(NDSSyntax.SYN_OCTET_STRING);
        return v;
    }

    public boolean canInsertComponent(ValueList list, ValueComponent comp) {
        if (comp.getSyntax() == NDSSyntax.SYN_OCTET_STRING) {
            return !list.contains(comp);
        }
        return false;
    }

    public boolean canRemoveComponent(ValueList list, ValueComponent comp) {
        return list.contains(comp);
    }

    public Object createFacade(ValueComponent comp) throws IncompatibleComponentException {
        return new OctetListFacade((ValueList)comp);
    }
}

