/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.common.exceptions.FacadeParameterException;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ValueListFacade;
import com.novell.admin.ns.ValueStrategy;
import com.novell.admin.ns.nds.NDSSyntax;
import java.util.Vector;

public final class PathFacade
extends ValueListFacade {
    private static final int COMP_CREATE = 1;

    public PathFacade(ValueList comp) throws IncompatibleComponentException {
        super(comp);
    }

    public static ValueList createValueList(long type, String volume, String path, Syntax syn) {
        try {
            Vector<Object> list = new Vector<Object>();
            list.addElement(new Long(type));
            list.addElement(volume);
            list.addElement(path);
            ValueComponent vc = syn.createValueComponent(list);
            return (ValueList)vc;
        }
        catch (ComponentCreationException e) {
            throw new AdminError(1, "com.novell.admin.ns.nds.PathFacade");
        }
    }

    public static ValueList createValueList(long type, String volume, String path) {
        return PathFacade.createValueList(type, volume, path, NDSSyntax.SYN_PATH);
    }

    public long getType() {
        LongValue v = (LongValue)this.valueList.getElementAt(0);
        return v.getValue();
    }

    public String getVolume() {
        StringValue v = (StringValue)this.valueList.getElementAt(1);
        return v.getValue();
    }

    public String getPath() {
        StringValue v = (StringValue)this.valueList.getElementAt(2);
        return v.getValue();
    }

    public void setType(long type) {
        this.replaceLongValue(type, 0);
    }

    public void setVolume(String volume) {
        Syntax DNsyn = this.valueList.getElementAt(1).getSyntax();
        ValueStrategy svs = (ValueStrategy)DNsyn.getStrategy();
        if (!svs.canCreateValue(volume)) {
            throw new FacadeParameterException();
        }
        this.replaceStringValue(volume, 1);
    }

    public void setPath(String path) {
        this.replaceStringValue(path, 2);
    }
}

