/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.ListStrategy;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.admin.ns.nds.PathFacade;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

final class PathStrategy
extends ListStrategy {
    private static final int WITHIN_BOUNDS = 1;

    PathStrategy() {
    }

    public ValueComponent createValueComponent() {
        ValueList list = new ValueList(NDSSyntax.SYN_PATH);
        list.initList(NDSSyntax.SYN_INTEGER.createValueComponent());
        list.initList(NDSSyntax.SYN_DIST_NAME.createValueComponent());
        list.initList(NDSSyntax.SYN_CE_STRING.createValueComponent());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueComponent createValueComponent(Object paramObj) throws ComponentCreationException {
        Long num = null;
        String dn = null;
        String str = null;
        ValueList list = new ValueList(NDSSyntax.SYN_PATH);
        if (paramObj instanceof Vector) {
            Vector compList = (Vector)paramObj;
            if (compList.size() != 3) {
                throw new ComponentCreationException();
            }
            Vector vector = compList;
            synchronized (vector) {
                Enumeration e = compList.elements();
                while (e.hasMoreElements()) {
                    Object comp = e.nextElement();
                    if (comp instanceof Long) {
                        num = (Long)comp;
                        continue;
                    }
                    if (!(comp instanceof String)) continue;
                    if (dn == null) {
                        dn = (String)comp;
                        continue;
                    }
                    str = (String)comp;
                }
            }
        } else if (paramObj instanceof String) {
            StringTokenizer st = new StringTokenizer((String)paramObj, "#");
            if (st.countTokens() != 3) {
                throw new ComponentCreationException();
            }
            dn = st.nextToken();
            num = new Long(st.nextToken());
            str = st.nextToken();
        } else {
            throw new ComponentCreationException();
        }
        list.initList(NDSSyntax.SYN_INTEGER.createValueComponent(num));
        list.initList(NDSSyntax.SYN_DIST_NAME.createValueComponent(dn));
        list.initList(NDSSyntax.SYN_CE_STRING.createValueComponent(str));
        return list;
    }

    public Object createFacade(ValueComponent comp) throws IncompatibleComponentException {
        return new PathFacade((ValueList)comp);
    }

    public boolean isWithinBounds(ValueComponent comp, long lowerBound, long upperBound) {
        ValueList vl;
        if (comp instanceof ValueList && (vl = (ValueList)comp).getSyntax() == NDSSyntax.SYN_PATH) {
            StringValue v = (StringValue)vl.getElementAt(1);
            return v.isWithinBounds(lowerBound, upperBound);
        }
        throw new AdminError(1, this.getClass());
    }

    public String toString(ValueComponent vc) {
        if (vc instanceof ValueList) {
            ValueList list = (ValueList)vc;
            return list.getElementAt(1) + "#" + list.getElementAt(0) + "#" + list.getElementAt(2);
        }
        return vc.toString();
    }
}

