/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ValueListFacade;
import com.novell.admin.ns.nds.NDSSyntax;
import java.util.Vector;

public final class PostalAddressFacade
extends ValueListFacade {
    private static final int MAX_LINES = 6;
    private static final int COMP_CREATE = 1;

    public PostalAddressFacade(ValueList comp) throws IncompatibleComponentException {
        super(comp);
    }

    public static ValueList createValueList(String[] lines, Syntax syn) {
        try {
            Vector<String> list = new Vector<String>();
            for (int lineNumber = 0; lineNumber < 6; ++lineNumber) {
                if (lineNumber < lines.length) {
                    list.addElement(lines[lineNumber]);
                    continue;
                }
                list.addElement("");
            }
            ValueComponent vc = syn.createValueComponent(list);
            return (ValueList)vc;
        }
        catch (ComponentCreationException e) {
            throw new AdminError(1, "com.novell.admin.ns.nds.PostalAddressFacade");
        }
    }

    public static ValueList createValueList(String[] lines) {
        return PostalAddressFacade.createValueList(lines, NDSSyntax.SYN_PO_ADDRESS);
    }

    public String[] getLines() {
        int count = this.valueList.getComponentCount();
        String[] strings = new String[count];
        for (int i = 0; i < count; ++i) {
            StringValue v = (StringValue)this.valueList.getElementAt(i);
            strings[i] = v.getValue();
        }
        return strings;
    }

    public String getLine(int index) throws ArrayIndexOutOfBoundsException {
        StringValue v = (StringValue)this.valueList.getElementAt(index);
        return v.getValue();
    }

    public void replaceLine(String newLine, int index) throws ArrayIndexOutOfBoundsException {
        this.replaceStringValue(newLine, index);
    }
}

