/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.DateValue;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ValueListFacade;
import com.novell.admin.ns.nds.NDSSyntax;
import java.util.Vector;

public final class TimeStampFacade
extends ValueListFacade {
    private static final int COMP_CREATE = 1;

    public TimeStampFacade(ValueList comp) throws IncompatibleComponentException {
        super(comp);
    }

    public static ValueList createValueList(long seconds, int replica, int event, Syntax syn) {
        try {
            Vector<Number> list = new Vector<Number>();
            list.addElement(new Long(seconds));
            list.addElement(new Integer(replica));
            list.addElement(new Integer(event));
            ValueComponent vc = syn.createValueComponent(list);
            return (ValueList)vc;
        }
        catch (ComponentCreationException e) {
            throw new AdminError(1, "com.novell.admin.ns.nds.TimeStampFacade");
        }
    }

    public static ValueList createValueList(long seconds, int replica, int event) {
        return TimeStampFacade.createValueList(seconds, replica, event, NDSSyntax.SYN_TIMESTAMP);
    }

    public int getSeconds() {
        ValueComponent v = this.valueList.getElementAt(0);
        if (v instanceof DateValue) {
            return (int)(((DateValue)v).getMillis() / 1000L);
        }
        return (int)((LongValue)v).getValue();
    }

    public int getReplica() {
        if (this.valueList.getComponentCount() == 3) {
            return (int)((LongValue)this.valueList.getElementAt(1)).getValue();
        }
        return 0;
    }

    public int getEvent() {
        LongValue v = this.valueList.getComponentCount() == 3 ? (LongValue)this.valueList.getElementAt(2) : (LongValue)this.valueList.getElementAt(3);
        return (int)v.getValue();
    }

    public void setSeconds(int seconds) {
        this.replaceLongValue(seconds, 0);
    }

    public void setReplica(int replica) {
        if (this.valueList.getComponentCount() == 3) {
            this.replaceLongValue(replica, 1);
        } else {
            this.replaceStringValue("", 2);
        }
    }

    public void setEvent(int event) {
        if (this.valueList.getComponentCount() == 3) {
            this.replaceLongValue(event, 2);
        } else {
            this.replaceLongValue(event, 3);
        }
    }

    public static ValueList createValueList(String genTime, int timeCount, String replicaName, int changeCount, Syntax syn) {
        try {
            Vector<Object> list = new Vector<Object>();
            list.addElement(genTime);
            list.addElement(new Integer(timeCount));
            list.addElement(replicaName);
            list.addElement(new Integer(changeCount));
            ValueComponent vc = syn.createValueComponent(list);
            return (ValueList)vc;
        }
        catch (ComponentCreationException e) {
            throw new AdminError(1, "com.novell.admin.ns.nds.TimeStampFacade");
        }
    }

    public String getGenTime() {
        ValueComponent v = this.valueList.getElementAt(0);
        if (v instanceof DateValue) {
            return ((DateValue)v).getGeneralizedTime();
        }
        long ms = ((LongValue)v).getValue() * 1000L;
        return DateValue.msToGeneralizedTime(ms);
    }

    public int getTimeCount() {
        if (this.valueList.getComponentCount() == 3) {
            return 0;
        }
        return (int)((LongValue)this.valueList.getElementAt(1)).getValue();
    }

    public String getReplicaName() {
        StringValue v = (StringValue)this.valueList.getElementAt(2);
        return v.getValue();
    }

    public int getChangeCount() {
        if (this.valueList.getComponentCount() == 3) {
            return (int)((LongValue)this.valueList.getElementAt(2)).getValue();
        }
        return (int)((LongValue)this.valueList.getElementAt(3)).getValue();
    }

    public void setGenTime(String genTime) {
        long ms = DateValue.generalizedTimeToMs(genTime);
        this.replaceLongValue(ms / 1000L, 0);
    }

    public void setTimeCount(int timeCount) {
        if (this.valueList.getComponentCount() == 4) {
            this.replaceLongValue(timeCount, 1);
        }
    }

    public void setReplicaName(String replicaName) {
        if (this.valueList.getComponentCount() == 3) {
            this.replaceLongValue(0L, 1);
        } else {
            this.replaceStringValue(replicaName, 2);
        }
    }

    public void setChangeCount(int changeCount) {
        if (this.valueList.getComponentCount() == 3) {
            this.replaceLongValue(changeCount, 2);
        } else {
            this.replaceLongValue(changeCount, 3);
        }
    }
}

