/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.DateValue;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.ListStrategy;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.admin.ns.nds.TimeStampFacade;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

final class TimeStampStrategy
extends ListStrategy {
    TimeStampStrategy() {
    }

    public ValueComponent createValueComponent() {
        ValueList list = new ValueList(NDSSyntax.SYN_TIMESTAMP);
        list.initList(NDSSyntax.SYN_TIME.createValueComponent());
        list.initList(NDSSyntax.SYN_INTEGER.createValueComponent());
        list.initList(NDSSyntax.SYN_INTEGER.createValueComponent());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueComponent createValueComponent(Object paramObj) throws ComponentCreationException {
        Number seconds = null;
        Number replica = null;
        Number event = null;
        ValueList list = new ValueList(NDSSyntax.SYN_TIMESTAMP);
        if (paramObj instanceof Vector) {
            Vector compList = (Vector)paramObj;
            if (compList.size() != 3) {
                throw new ComponentCreationException();
            }
            Vector vector = compList;
            synchronized (vector) {
                Enumeration e = compList.elements();
                while (e.hasMoreElements()) {
                    Object comp = e.nextElement();
                    if (!(comp instanceof Number)) continue;
                    if (seconds == null) {
                        seconds = (Number)comp;
                        continue;
                    }
                    if (replica == null) {
                        replica = (Number)comp;
                        continue;
                    }
                    event = (Number)comp;
                    break;
                }
            }
        } else if (paramObj instanceof String) {
            StringTokenizer st = new StringTokenizer((String)paramObj, "#");
            if (st.countTokens() != 3) {
                throw new ComponentCreationException();
            }
            seconds = new Long(st.nextToken());
            replica = new Integer(st.nextToken());
            event = new Integer(st.nextToken());
        } else {
            throw new ComponentCreationException();
        }
        list.initList(NDSSyntax.SYN_TIME.createValueComponent(seconds));
        list.initList(NDSSyntax.SYN_INTEGER.createValueComponent(replica));
        list.initList(NDSSyntax.SYN_INTEGER.createValueComponent(event));
        return list;
    }

    public Object createFacade(ValueComponent comp) throws IncompatibleComponentException {
        return new TimeStampFacade((ValueList)comp);
    }

    public String toString(ValueComponent vc) {
        if (vc instanceof ValueList) {
            ValueList list = (ValueList)vc;
            return ((DateValue)list.getElementAt(0)).getMillis() / 1000L + "#" + list.getElementAt(1).toString() + "#" + list.getElementAt(2).toString();
        }
        return vc.toString();
    }
}

