/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.ListStrategy;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.admin.ns.nds.TypedNameFacade;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

final class TypedNameStrategy
extends ListStrategy {
    TypedNameStrategy() {
    }

    public ValueComponent createValueComponent() {
        ValueList list = new ValueList(NDSSyntax.SYN_TYPED_NAME);
        list.initList(NDSSyntax.SYN_DIST_NAME.createValueComponent());
        list.initList(NDSSyntax.SYN_INTEGER.createValueComponent());
        list.initList(NDSSyntax.SYN_INTERVAL.createValueComponent());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueComponent createValueComponent(Object paramObj) throws ComponentCreationException {
        ValueList list = new ValueList(NDSSyntax.SYN_TYPED_NAME);
        String object = null;
        Long level = null;
        Long interval = null;
        if (paramObj instanceof Vector) {
            Vector compList = (Vector)paramObj;
            if (compList.size() != 3) {
                throw new ComponentCreationException();
            }
            Vector vector = compList;
            synchronized (vector) {
                Enumeration e = compList.elements();
                while (e.hasMoreElements()) {
                    Object comp = e.nextElement();
                    if (comp instanceof String) {
                        object = (String)comp;
                        continue;
                    }
                    if (!(comp instanceof Long)) continue;
                    if (level == null) {
                        level = (Long)comp;
                        continue;
                    }
                    interval = (Long)comp;
                }
            }
        } else if (paramObj instanceof String) {
            StringTokenizer st = new StringTokenizer((String)paramObj, "#");
            object = st.nextToken();
            level = new Long(st.nextToken());
            interval = new Long(st.nextToken());
        } else {
            throw new ComponentCreationException();
        }
        list.initList(NDSSyntax.SYN_DIST_NAME.createValueComponent(object));
        list.initList(NDSSyntax.SYN_INTEGER.createValueComponent(level));
        list.initList(NDSSyntax.SYN_INTERVAL.createValueComponent(interval));
        return list;
    }

    public Object createFacade(ValueComponent comp) throws IncompatibleComponentException {
        return new TypedNameFacade((ValueList)comp);
    }

    public String toString(ValueComponent vc) {
        if (vc instanceof ValueList) {
            ValueList list = (ValueList)vc;
            return list.getElementAt(0) + "#" + list.getElementAt(1) + "#" + list.getElementAt(2);
        }
        return vc.toString();
    }
}

