/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.HexValue;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ValueListFacade;
import com.novell.admin.ns.nds.NDSSyntax;
import java.util.Vector;

public final class UnknownFacade
extends ValueListFacade {
    private static final int COMP_CREATE = 1;

    public UnknownFacade(ValueList comp) throws IncompatibleComponentException {
        super(comp);
    }

    public static ValueList createValueList(String attrName, int synId, byte[] bytes) {
        return UnknownFacade.createValueList(attrName, synId, bytes, NDSSyntax.SYN_UNKNOWN);
    }

    public static ValueList createValueList(String attrName, int synId, byte[] bytes, Syntax syntax) {
        try {
            Vector<Object> list = new Vector<Object>();
            list.addElement(attrName);
            list.addElement(new Integer(synId));
            list.addElement(bytes);
            ValueComponent vc = syntax.createValueComponent(list);
            return (ValueList)vc;
        }
        catch (ComponentCreationException e) {
            throw new AdminError(1, "com.novell.admin.ns.nds.UnknownFacade");
        }
    }

    public String getAttributeName() {
        StringValue v = (StringValue)this.valueList.getElementAt(0);
        return v.getValue();
    }

    public int getSyntaxId() {
        LongValue v = (LongValue)this.valueList.getElementAt(1);
        return (int)v.getValue();
    }

    public byte[] getBytes() {
        HexValue v = (HexValue)this.valueList.getElementAt(2);
        return v.getValue();
    }

    public void setAttributeName(String attrName) {
        this.replaceStringValue(attrName, 0);
    }

    public void setSyntaxId(long id) {
        this.replaceLongValue(id, 1);
    }

    public void setBytes(byte[] bytes) {
        this.replaceHexValue(bytes, 2);
    }
}

