/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds.jclient;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.nds.NDSNCPExtension;
import com.novell.admin.ns.nds.jclient.NDSNamespaceImpl;
import com.novell.application.console.snapin.ObjectEntry;
import novell.jclient.JCContext;
import novell.jclient.JCException;
import novell.jclient.JClient;

final class NCPExtensionImpl
implements NDSNCPExtension {
    private JCContext ncpContext;
    private int xID;
    private String name;
    private ObjectEntry serverOE;
    private NDSNamespaceImpl namespace = null;

    NCPExtensionImpl(NDSNamespaceImpl ns2, String name, ObjectEntry serverOE) throws SPIException {
        this.namespace = ns2;
        this.name = name;
        this.serverOE = serverOE;
        try {
            this.ncpContext = this.namespace.getContext(serverOE, 66, serverOE);
            this.xID = JClient.getNCPExtension((JCContext)this.ncpContext, (String)name);
        }
        catch (JCException e) {
            throw this.namespace.resolveSPIException((Exception)((Object)e), "");
        }
    }

    public String getNCPExtensionName() {
        return this.name;
    }

    public ObjectEntry getNCPExtensionServerOE() {
        return this.serverOE;
    }

    public byte[] sendNCPRequest(byte[] request, int replySize) throws SPIException {
        try {
            byte[] reply = new byte[replySize];
            JClient.sendNCPExtension((JCContext)this.ncpContext, (int)this.xID, (int)request.length, (byte[])request, (byte[])reply);
            return reply;
        }
        catch (Exception e) {
            throw this.namespace.resolveSPIException(e, "");
        }
    }
}

