/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds.jclient;

import [Lnovell.jclient.JCAclValue;;
import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.common.exceptions.AdminNamespaceExceptionReference;
import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.SimpleSPIException;
import com.novell.admin.common.exceptions.UnexpectedErrorException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.common.security.ChangePassword;
import com.novell.admin.common.security.Login;
import com.novell.admin.common.security.SetPassword;
import com.novell.admin.event.DirectoryEvent;
import com.novell.admin.event.DirectoryEventImpl;
import com.novell.admin.event.DirectoryEventListener;
import com.novell.admin.event.DirectoryModifyEventImpl;
import com.novell.admin.event.ModifiedAttributeDefinition;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.AuthenticationNamespace;
import com.novell.admin.ns.BooleanValue;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.DateValue;
import com.novell.admin.ns.DefaultNSObject;
import com.novell.admin.ns.FSComparator;
import com.novell.admin.ns.HexValue;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.MODObject;
import com.novell.admin.ns.MOOManager;
import com.novell.admin.ns.MOOManagerCallBack;
import com.novell.admin.ns.MultiObjModificationCallBack;
import com.novell.admin.ns.NSFileNamespace;
import com.novell.admin.ns.NSFileObject;
import com.novell.admin.ns.NSFileRights;
import com.novell.admin.ns.NSFileTrustee;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NSObjectCache;
import com.novell.admin.ns.NSUtil;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.ObjectOperation;
import com.novell.admin.ns.PartitionService;
import com.novell.admin.ns.Rights;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.StreamValue;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.BackLinkFacade;
import com.novell.admin.ns.nds.CaseIgnoreListFacade;
import com.novell.admin.ns.nds.EmailAddressFacade;
import com.novell.admin.ns.nds.FaxNumberFacade;
import com.novell.admin.ns.nds.HoldFacade;
import com.novell.admin.ns.nds.MultiObjModificationNamespaceImpl;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSClassDefinition;
import com.novell.admin.ns.nds.NDSClassFlags;
import com.novell.admin.ns.nds.NDSNCPExtension;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSNamespaceException;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.admin.ns.nds.NDSPropertyRights;
import com.novell.admin.ns.nds.NDSSchema;
import com.novell.admin.ns.nds.NDSSchemaDefinition;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.admin.ns.nds.NetAddressFacade;
import com.novell.admin.ns.nds.ObjectACLFacade;
import com.novell.admin.ns.nds.OctetListFacade;
import com.novell.admin.ns.nds.PathFacade;
import com.novell.admin.ns.nds.PostalAddressFacade;
import com.novell.admin.ns.nds.ReplicaPointerFacade;
import com.novell.admin.ns.nds.TimeStampFacade;
import com.novell.admin.ns.nds.TypedNameFacade;
import com.novell.admin.ns.nds.UnknownFacade;
import com.novell.admin.ns.nds.jclient.BrowserObjectEntryEnumerationImpl;
import com.novell.admin.ns.nds.jclient.ChildObjectEntryEnumerationImpl;
import com.novell.admin.ns.nds.jclient.JClientRes;
import com.novell.admin.ns.nds.jclient.NCPExtensionImpl;
import com.novell.admin.ns.nds.jclient.NDSInputStreamFactoryImpl;
import com.novell.admin.ns.nds.jclient.NDSObjectImpl;
import com.novell.admin.ns.nds.jclient.NDSObjectRightsImpl;
import com.novell.admin.ns.nds.jclient.NDSPartitionServiceImpl;
import com.novell.admin.ns.nds.jclient.NDSPropertyRightsImpl;
import com.novell.admin.ns.nds.jclient.NDSSchemaImpl;
import com.novell.admin.ns.nds.jclient.NSFileObjectImpl;
import com.novell.admin.ns.nds.jclient.NSFileRightsImpl;
import com.novell.admin.ns.nds.jclient.NSFileTrusteeImpl;
import com.novell.admin.ns.nds.jclient.VirtualObjectEntryEnumerationImpl;
import com.novell.application.console.snapin.Debug;
import com.novell.application.console.snapin.DefaultIndexedObjectEntryEnumeration;
import com.novell.application.console.snapin.DefaultObjectEntryEnumeration;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.NamespaceSnapin;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryCollection;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectEntryParentAndSimpleName;
import com.novell.application.console.snapin.ObjectType;
import com.novell.application.console.snapin.ResultModifier;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.application.console.snapin.context.GetChildrenContext;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import novell.jclient.JCAclValue;
import novell.jclient.JCBacklinkValue;
import novell.jclient.JCBooleanValue;
import novell.jclient.JCCEstringValue;
import novell.jclient.JCCIlistValue;
import novell.jclient.JCCIstringValue;
import novell.jclient.JCClassnameValue;
import novell.jclient.JCContext;
import novell.jclient.JCCounterValue;
import novell.jclient.JCDistnameValue;
import novell.jclient.JCEmailValue;
import novell.jclient.JCEntryInfo;
import novell.jclient.JCEntryInfoEmptyFieldException;
import novell.jclient.JCException;
import novell.jclient.JCExceptionReference;
import novell.jclient.JCFaxnumberValue;
import novell.jclient.JCHoldValue;
import novell.jclient.JCIntegerValue;
import novell.jclient.JCIntervalValue;
import novell.jclient.JCNUstringValue;
import novell.jclient.JCNetaddressValue;
import novell.jclient.JCNetworkAddress;
import novell.jclient.JCOctetlistValue;
import novell.jclient.JCOctetstringValue;
import novell.jclient.JCPRstringValue;
import novell.jclient.JCPathValue;
import novell.jclient.JCPingInfo;
import novell.jclient.JCPostaladdressValue;
import novell.jclient.JCReadFilter;
import novell.jclient.JCReferral;
import novell.jclient.JCReplicapointerValue;
import novell.jclient.JCStreamValue;
import novell.jclient.JCTelnumberValue;
import novell.jclient.JCTimeValue;
import novell.jclient.JCTimestamp;
import novell.jclient.JCTimestampValue;
import novell.jclient.JCTypednameValue;
import novell.jclient.JCUnknownValue;
import novell.jclient.JCValue;
import novell.jclient.JClient;
import novell.jclient.NWFile;
import novell.jclient.NWFileEntryInfo;
import novell.jclient.NWFileRestriction;
import novell.jclient.NWFileScanTrusteePathsCB;
import novell.jclient.NWFileSearchCB;
import novell.jclient.NWFileSearchInfo;
import novell.jclient.NWFileTrustee;
import novell.jclient.NWFileTrusteeCB;
import novell.jclient.NWFileVolumesOnServerCB;

public final class NDSNamespaceImpl
implements NDSNamespace,
NSFileNamespace {
    private static Class JClientClass = null;
    private static Exception initException = null;
    private Shell shell;
    private Hashtable treeCache = new Hashtable();
    private Hashtable contextCache = new Hashtable();
    private HashMap fileSystemContextHashMap = new HashMap();
    private HashMap secureNCPTreeHashMap = new HashMap();
    private boolean checkForSecureNCP = false;
    private Hashtable schemaCache = new Hashtable();
    private Hashtable whoamiCache = new Hashtable();
    private Hashtable serverInfoCache = new Hashtable();
    private Hashtable blockedCache = new Hashtable();
    private Hashtable pseudoCache = new Hashtable();
    private Hashtable pseudoReverseCache = new Hashtable();
    private Hashtable defaultConnectionInfoCache = new Hashtable();
    private String currentTree = null;
    private NSObjectCache nsObjectLookupTable = new NSObjectCache();
    private ObjectType treeOT = new ObjectType("Top", this, true);
    private static final char SEP_CHAR = '.';
    private static final String SEP_STRING;
    private static final String VALUE_STRING;
    private static final String DELIMITERS;
    private static final String TYPEDNAMEDELIMITERS;
    private static final int DEFAULT_MAX_ITEMS_FOR_ENUMERATION = 1000;
    private static int MAX_ITEMS_FOR_ENUMERATION;
    private static final int MAX_NAME_LENGTH = 256;
    private static final int MODIFY_ENTRIES_SIZE = 250;
    private static final int CONTEXT_CTX_IGNORE_CONNECT_ERR = 8192;
    public static final long CONNECTION_FLAG_IGNORE_ADDR_CACHE = 4L;
    public static final Class JCContext_CLASS;
    public static final Class JCACLVALUE_CLASS;
    private UniqueSPIException uniqueSPIException = new UniqueSPIException("com.novell.admin.common.exceptions.NSIClientResourceBundle");
    private SimpleSPIException nsSpiException = new SimpleSPIException("com.novell.admin.ns.NSResourceBundle");
    private static final int COMPONENT_CREATION = 3;
    private boolean specialModeExists = false;
    private static final int ACCESSCONFIDENCESETBITS = 8;
    private static final int ACCESSCONFIDENCECLEARBITS = 6;
    private int accessConfidenceUseCount = 0;
    private static final int DISABLEDEREFERENCECLEARBITS = 64;
    private boolean disableDereferenceMode = false;
    private static final int FS_TYPE_VOLUME = 1;
    private static final int FS_TYPE_DIRECTORY = 2;
    private static final int FS_TYPE_FILE = 3;
    private static final String FS_ID_VOLUME = "Netware Volume";
    private static final String FS_ID_DIRECTORY = "Directory";
    private static final String FS_ID_FILE = "File";
    private static final String FS_ID_UNKNOWN = "Unknown";
    private static final char FS_FEDERATED_TAGCHAR = '<';
    private static final String FS_FEDERATED_BEGINTAG = "<fs>";
    private static final String FS_FEDERATED_ENDTAG = "</fs>";
    private ObjectType fsVolumeObjectType = null;
    private ObjectType fsDirectoryObjectType = null;
    private ObjectType fsFileObjectType = null;
    private Hashtable directoryEventListeners = new Hashtable();
    private static Class AJClientClass;
    private static Method JClientMethod;
    private static final String WARNSECURENCP_LOGIN = "Login tried to access an Encrypted Attribute over an insecure channel. Trying secure";
    private static final String WARNSECURENCP_READ = "Tried to read an Encrypted Attribute over an insecure channel. Trying secure";
    private static final String WARNSECURENCP_CREATE = "Tried to create with an Encrypted Attribute over an insecure channel. Trying secure";
    private static final String WARNSECURENCP_MODIFY = "Tried to modify an Encrypted Attribute over an insecure channel. Trying secure";
    private static final String WARNSECURENCP_RENAME = "Tried to rename and object with an Encrypted Attribute over an insecure channel. Trying secure";
    private static final String WARNSECURENCP_MOVE = "Tried to move an object with an Encrypted Attribute over an insecure channel. Trying secure";
    private static final String WARNSECURENCP_DELETEATTR = "Tried to delete an Encrypted Attribute over an insecure channel. Trying secure";
    private static final String WARNSECURENCP_DELETEOBJ = "Tried to delete an object with an Encrypted Attribute over an insecure channel. Trying secure";
    private static final String WARNSECURENCP_OPENSTREAM = "Tried to open stream with an Encrypted Attribute over an insecure channel. Trying secure";
    private static final String WARNSECURENCP_CLOSESTREAM = "Tried to close stream with  an Encrypted Attribute over an insecure channel. Trying secure";
    private static final String WARNSECURENCP_READSTREAM = "Tried to read stream with  an Encrypted Attribute over an insecure channel. Trying secure";
    private static final String WARNSECURENCP_WRITESTREAM = "Tried to write stream with  an Encrypted Attribute over an insecure channel. Trying secure";

    public static void setJClientInUse() {
        if (JClientClass == null) {
            JClientClass = JClient.class;
        }
    }

    public static void staticCleanup() {
        JClientClass = null;
        JClient.cleanup();
    }

    public NDSNamespaceImpl() {
        try {
            this.constructorInit();
        }
        catch (SPIException spie) {
            Debug.out("Using Default Constructor" + initException.toString(), 1);
        }
    }

    public NDSNamespaceImpl(Object holder) throws SPIException {
        this.constructorInit();
        if (holder == null) {
            // empty if block
        }
    }

    private void constructorInit() throws SPIException {
        NDSNamespaceImpl.setJClientInUse();
        this.pseudoCache.put("[Public]", ".[Public].");
        this.pseudoCache.put("[This]", ".[This].");
        this.pseudoCache.put("[Inheritance Mask]", ".[Inheritance Mask].");
        this.pseudoReverseCache.put("", "[Root]");
        this.pseudoReverseCache.put(".[Public].", "[Public]");
        this.pseudoReverseCache.put(".[This].", "[This]");
        this.pseudoReverseCache.put(".[Inheritance Mask].", "[Inheritance Mask]");
        if (initException != null) {
            throw this.resolveSPIException(initException, "constructorInit");
        }
    }

    public String getNamespaceVersion() {
        return "1.3.6.1";
    }

    public void create(NSObject obj) throws SPIException, SnapinVetoException {
        this.create(obj, null);
    }

    public void create(NSObject obj, ObjectEntry serverOE) throws SPIException, SnapinVetoException {
        JCContext ctx = null;
        try {
            String simpleOEName;
            ObjectEntry oe = obj.getObjectEntry();
            String rdnName = simpleOEName = oe.getName();
            String tree = oe.getRoot().getName();
            DirectoryEventImpl event = new DirectoryEventImpl();
            String retVal = this.notifyDirectoryEventListeners(32, oe, null, event);
            if (retVal != null && retVal.length() > 0) {
                throw new SnapinVetoException(retVal);
            }
            Vector attrs = new Vector();
            Vector<ObjectAttribute> streamAttrs = new Vector<ObjectAttribute>();
            String[] attrNames = obj.getAttributes();
            boolean foundAnyNaming = false;
            boolean foundMandatoryNaming = false;
            String namingAttrName = null;
            for (int i = 0; i < attrNames.length; ++i) {
                String attrNameToAdd = attrNames[i];
                if (!foundMandatoryNaming && obj.isNamedBy(attrNameToAdd)) {
                    StringValue strVal;
                    String attrVal;
                    boolean isMand = obj.isAttributeMandatory(attrNameToAdd);
                    if ((!foundAnyNaming || isMand) && (attrVal = (strVal = (StringValue)obj.getAttribute(attrNameToAdd).getValueComponents().nextElement()).getValue()).equals(simpleOEName)) {
                        foundAnyNaming = true;
                        if (isMand) {
                            foundMandatoryNaming = true;
                        }
                        rdnName = new String(attrNameToAdd + VALUE_STRING + simpleOEName);
                        String holdingName = namingAttrName;
                        namingAttrName = attrNameToAdd;
                        attrNameToAdd = holdingName;
                    }
                }
                if (attrNameToAdd == null) continue;
                if (obj.getAttribute(attrNameToAdd).getAttributeDefinition().getSyntax() == NDSSyntax.SYN_STREAM) {
                    streamAttrs.addElement(obj.getAttribute(attrNameToAdd));
                }
                Vector attr = this.convertToJCValue(obj.getAttribute(attrNameToAdd), 2, tree);
                for (int j = 0; attr != null && j < attr.size(); ++j) {
                    attrs.addElement(attr.elementAt(j));
                }
            }
            Object[] attrSet = new JCValue[attrs.size()];
            attrs.copyInto(attrSet);
            ctx = serverOE == null ? this.getContext(oe.getParent(), 68) : this.getContext(oe.getParent(), 68, serverOE);
            try {
                JClient.createEntry((JCContext)ctx, (String)rdnName, (JCValue[])attrSet);
            }
            catch (JCException jce) {
                this.secureRetryCreate(ctx, jce, rdnName, (JCValue[])attrSet);
            }
            for (int j = 0; streamAttrs != null && j < streamAttrs.size(); ++j) {
                this.addStreamValue(oe, (ObjectAttribute)streamAttrs.elementAt(j), 5, serverOE);
            }
            this.notifyDirectoryEventListeners(16, oe, null, event);
        }
        catch (JCException e) {
            throw this.resolveSPIException((Exception)((Object)e), "");
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    public void delete(ObjectEntry obj) throws SPIException, SnapinVetoException {
        this.delete(obj, null);
    }

    public void delete(ObjectEntry obj, ObjectEntry serverOE) throws SPIException, SnapinVetoException {
        JCContext ctx = null;
        try {
            DirectoryEventImpl event = new DirectoryEventImpl();
            String retVal = this.notifyDirectoryEventListeners(33, obj, null, event);
            if (retVal != null && retVal.length() > 0) {
                throw new SnapinVetoException(retVal);
            }
            ctx = serverOE == null ? this.getContext(obj, 4) : this.getContext(obj, 4, serverOE);
            try {
                JClient.removeEntry((JCContext)ctx);
            }
            catch (JCException jce) {
                this.secureRetryRemoveEntry(ctx, jce);
            }
            this.notifyDirectoryEventListeners(17, obj, null, event);
        }
        catch (JCException e) {
            throw this.resolveSPIException((Exception)((Object)e), "");
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    public ObjectEntry move(ObjectEntry fromObjEntry, ObjectEntry newParent) throws SPIException, SnapinVetoException {
        JCContext toContext = null;
        JCContext fromContext = null;
        try {
            ObjectEntry childObjEntry = this.createObjectEntry(newParent, fromObjEntry.getName(), fromObjEntry.getObjectType().getName());
            DirectoryEventImpl event = new DirectoryEventImpl();
            String retVal = this.notifyDirectoryEventListeners(34, fromObjEntry, childObjEntry, event);
            if (retVal != null && retVal.length() > 0) {
                throw new SnapinVetoException(retVal);
            }
            toContext = this.getContext(newParent, 8);
            fromContext = this.getContext(fromObjEntry, 8);
            try {
                JClient.moveEntry((JCContext)fromContext, (JCContext)toContext, (long)1L, (String)fromObjEntry.getName());
            }
            catch (JCException jce) {
                this.secureRetryMoveEntry(fromContext, toContext, jce, 1L, fromObjEntry.getName());
            }
            this.notifyDirectoryEventListeners(18, fromObjEntry, childObjEntry, event);
            ObjectEntry objectEntry = childObjEntry;
            return objectEntry;
        }
        catch (Exception e) {
            throw this.resolveSPIException(e, "");
        }
        finally {
            if (toContext != null) {
                toContext.free();
            }
            if (fromContext != null) {
                fromContext.free();
            }
        }
    }

    public ObjectEntry rename(ObjectEntry fromObjEntry, String newName) throws SPIException, SnapinVetoException {
        JCContext ctx = null;
        try {
            ObjectEntry newObjEntry = this.createObjectEntry(fromObjEntry.getParent(), newName, fromObjEntry.getObjectType().getName());
            DirectoryEventImpl event = new DirectoryEventImpl();
            String retVal = this.notifyDirectoryEventListeners(35, fromObjEntry, newObjEntry, event);
            if (retVal != null && retVal.length() > 0) {
                throw new SnapinVetoException(retVal);
            }
            ctx = this.getContext(fromObjEntry, 4);
            try {
                JClient.modifyRDN((JCContext)ctx, (String)newName, (boolean)true);
            }
            catch (JCException jce) {
                this.secureRetryModifyRDN(ctx, jce, newName, true);
            }
            this.notifyDirectoryEventListeners(19, fromObjEntry, newObjEntry, event);
            ObjectEntry objectEntry = newObjEntry;
            return objectEntry;
        }
        catch (Exception x) {
            throw this.resolveSPIException(x, "");
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    public NSObject createNSObject(ObjectEntry objEntry, Vector attributes, long rev) throws NamespaceException {
        return this.createNSObject(objEntry, attributes, true);
    }

    public NSObject createNSObject(ObjectEntry objEntry, Vector attributes, boolean bValidate) throws NamespaceException {
        NDSObjectImpl newNSObject = new NDSObjectImpl(objEntry, attributes, 0L);
        if (newNSObject.getAttribute("Object Class") == null) {
            try {
                NDSSchemaDefinition schema = (NDSSchemaDefinition)this.getSchemaDefinition(objEntry);
                ValueComponent[] objClassVals = new ValueComponent[]{new StringValue(NDSSyntax.SYN_CLASS_NAME, objEntry.getObjectType().getName())};
                NDSObjectAttribute objClassAttr = new NDSObjectAttribute(schema.getAttributeDefinition("Object Class"), objClassVals);
                newNSObject.initObjectClassAttribute(objClassAttr);
            }
            catch (SPIException x) {
                throw NamespaceException.MISSING_OBJECT_CLASS_ATTRIBUTE;
            }
        }
        if (!bValidate) {
            return newNSObject;
        }
        try {
            ClassDefinition classDef = this.getClassDefinition(objEntry, objEntry.getObjectType().getName());
            AttributeDefinition[] mandatoryAttributes = classDef.getMandatoryAttributes();
            for (int i = 0; i < mandatoryAttributes.length; ++i) {
                String attrName = mandatoryAttributes[i].getName();
                if (newNSObject.getAttribute(attrName) != null) continue;
                throw NamespaceException.MISSING_MANDATORY_ATTRIBUTE;
            }
            AttributeDefinition[] namingAttributes = classDef.getNamingAttributes();
            for (int i = 0; i < namingAttributes.length; ++i) {
                String attrName = namingAttributes[i].getName();
                if (newNSObject.getAttribute(attrName) == null) continue;
                return newNSObject;
            }
            if (namingAttributes.length == 0) {
                return newNSObject;
            }
            throw NamespaceException.MISSING_NAMING_ATTRIBUTE;
        }
        catch (SPIException x) {
            throw new UnexpectedErrorException();
        }
    }

    public NSObject createNSObject(ObjectEntry objEntry, Vector attributes) throws NamespaceException {
        return this.createNSObject(objEntry, attributes, true);
    }

    public NSObject createShadowNSObject(ObjectEntry objEntry) throws NamespaceException {
        NDSObjectImpl newNSObject = new NDSObjectImpl(objEntry, null, 0L);
        newNSObject.setShadowSign(true);
        if (newNSObject.getAttribute("Object Class") == null) {
            try {
                NDSSchemaDefinition schema = (NDSSchemaDefinition)this.getSchemaDefinition(objEntry);
                ValueComponent[] objClassVals = new ValueComponent[]{new StringValue(NDSSyntax.SYN_CLASS_NAME, objEntry.getObjectType().getName())};
                NDSObjectAttribute objClassAttr = new NDSObjectAttribute(schema.getAttributeDefinition("Object Class"), objClassVals);
                newNSObject.initObjectClassAttribute(objClassAttr);
            }
            catch (SPIException x) {
                throw NamespaceException.MISSING_OBJECT_CLASS_ATTRIBUTE;
            }
        }
        return newNSObject;
    }

    public ObjectAttribute getAttribute(ObjectEntry obj, String attrStr) throws SPIException {
        try {
            String[] attrs = new String[]{attrStr};
            ObjectAttribute[] attributes = this.getAttributes(obj, attrs);
            if (attributes.length > 0) {
                return attributes[0];
            }
        }
        catch (NamespaceException x) {
            throw this.resolveSPIException(x, "");
        }
        return null;
    }

    public ObjectAttribute[] getAttributes(ObjectEntry obj) throws SPIException {
        try {
            return this.getAttributes(obj, null);
        }
        catch (NamespaceException e) {
            throw this.resolveSPIException(e, "");
        }
    }

    public ObjectAttribute[] getAttributes(ObjectEntry obj, String[] attrStrings) throws SPIException, NamespaceException {
        return this.getAttributesImpl(obj, attrStrings, 0, null, null);
    }

    public ObjectAttribute[] getAttributes(ObjectEntry obj, String[] attrStrings, ObjectEntry serverOE) throws SPIException, NamespaceException {
        return this.getAttributesImpl(obj, attrStrings, 0, null, serverOE);
    }

    public ObjectAttribute[] getAttributes(ObjectEntry obj, String[] attrStrings, int getAttrFlags, ObjectEntry serverOE) throws SPIException, NamespaceException {
        return this.getAttributesImpl(obj, attrStrings, getAttrFlags, null, serverOE);
    }

    public ObjectAttribute[] getAttributes(ObjectEntry obj, String[] attrStrings, int getAttrFlags, AdminNamespaceExceptionReference aneRef, ObjectEntry serverOE) throws SPIException, NamespaceException {
        return this.getAttributesImpl(obj, attrStrings, getAttrFlags, aneRef, serverOE);
    }

    public void addDirectoryEventListener(DirectoryEventListener listener, int operation, String objectType) {
        ArrayList<DirectoryEventListener> list = (ArrayList<DirectoryEventListener>)this.directoryEventListeners.get(operation + "," + objectType.toUpperCase());
        if (list == null) {
            list = new ArrayList<DirectoryEventListener>();
        }
        list.add(listener);
        this.directoryEventListeners.put(operation + "," + objectType.toUpperCase(), list);
    }

    public void removeDirectoryEventListener(DirectoryEventListener listener) {
        this.directoryEventListeners.remove(listener);
    }

    private ObjectAttribute[] getAttributesImpl(ObjectEntry obj, String[] attrStrings, int getAttrFlags, AdminNamespaceExceptionReference aneRef, ObjectEntry serverOE) throws SPIException, NamespaceException {
        Vector<NDSObjectAttribute> ndsAttrs = new Vector<NDSObjectAttribute>();
        JCContext ctx = null;
        boolean useContextStaticValues = false;
        boolean doExceptionReference = false;
        if (aneRef != null) {
            aneRef.setAdminNamespaceException(null);
        }
        try {
            JCValue[] values;
            int resolveFlags = 66;
            if (getAttrFlags != 0) {
                if ((getAttrFlags & 2) == 2) {
                    resolveFlags = resolveFlags & 0xFFFFFFFD | 4;
                }
                if ((getAttrFlags & 1) == 1) {
                    useContextStaticValues = true;
                }
                if ((getAttrFlags & 4) == 4) {
                    doExceptionReference = true;
                }
            }
            JCReadFilter filter = new JCReadFilter(false, new JCTimestamp(), attrStrings);
            ctx = this.getContext(obj, resolveFlags, serverOE);
            if (useContextStaticValues) {
                ctx.setFlags(0x20000000, 0);
            }
            if (doExceptionReference) {
                JCExceptionReference myjcerEx = new JCExceptionReference();
                values = JClient.readEntry((JCContext)ctx, (long)1L, (JCReadFilter)filter, (JCExceptionReference)myjcerEx);
                JCException jce = myjcerEx.getException();
                if (jce != null) {
                    values = this.secureRetryReadEntry(ctx, jce, 1L, filter, myjcerEx, values);
                    jce = myjcerEx.getException();
                    if (jce != null) {
                        SPIException spie = this.resolveSPIException((Exception)((Object)jce), "getAttributesImpl");
                        if (aneRef == null) {
                            throw spie;
                        }
                        aneRef.setAdminNamespaceException(spie);
                    }
                }
            } else {
                try {
                    values = JClient.readEntry((JCContext)ctx, (long)1L, (JCReadFilter)filter);
                }
                catch (JCException jce) {
                    values = this.secureRetryReadEntry(ctx, jce, 1L, filter, null, null);
                }
            }
            if (values != null) {
                int i = 0;
                while (i < values.length) {
                    NDSAttributeDefinition attrDef = (NDSAttributeDefinition)this.getSchema(obj).getAttributeDefinition(values[i].attributeName);
                    Vector<ValueComponent> attrValues = new Vector<ValueComponent>();
                    switch (values[i].syntax) {
                        case 0: {
                            do {
                                attrValues.addElement(UnknownFacade.createValueList(values[i].attributeName, values[i].syntax, ((JCUnknownValue)values[i]).getData()));
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        case 1: {
                            do {
                                String distName = ((JCDistnameValue)values[i]).getDistname();
                                distName = this.pseudoReverseFilter(distName);
                                attrValues.addElement(NDSSyntax.SYN_DIST_NAME.createValueComponent(distName));
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        case 2: {
                            do {
                                attrValues.addElement(NDSSyntax.SYN_CE_STRING.createValueComponent(((JCCEstringValue)values[i]).getString()));
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        case 3: {
                            do {
                                attrValues.addElement(NDSSyntax.SYN_CI_STRING.createValueComponent(((JCCIstringValue)values[i]).getString()));
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        case 4: {
                            do {
                                attrValues.addElement(NDSSyntax.SYN_PR_STRING.createValueComponent(((JCPRstringValue)values[i]).getString()));
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        case 5: {
                            do {
                                attrValues.addElement(NDSSyntax.SYN_NU_STRING.createValueComponent(((JCNUstringValue)values[i]).getString()));
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        case 6: {
                            do {
                                attrValues.addElement(CaseIgnoreListFacade.createValueList(((JCCIlistValue)values[i]).getStrings()));
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        case 7: {
                            do {
                                attrValues.addElement(NDSSyntax.SYN_BOOLEAN.createValueComponent(new Boolean(((JCBooleanValue)values[i]).getState())));
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        case 8: {
                            do {
                                attrValues.addElement(NDSSyntax.SYN_INTEGER.createValueComponent(new Long(((JCIntegerValue)values[i]).getInteger())));
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        case 9: {
                            do {
                                attrValues.addElement(NDSSyntax.SYN_OCTET_STRING.createValueComponent(((JCOctetstringValue)values[i]).getOctets()));
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        case 10: {
                            do {
                                attrValues.addElement(NDSSyntax.SYN_TEL_NUMBER.createValueComponent(((JCTelnumberValue)values[i]).getTelnumber()));
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        case 11: {
                            do {
                                attrValues.addElement(FaxNumberFacade.createValueList(((JCFaxnumberValue)values[i]).getBitCount(), ((JCFaxnumberValue)values[i]).getTelephoneNumber()));
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        case 12: {
                            do {
                                JCNetworkAddress netAddr = ((JCNetaddressValue)values[i]).getAddress();
                                attrValues.addElement(NetAddressFacade.createValueList(netAddr.getType(), netAddr.getAddress()));
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        case 13: {
                            do {
                                attrValues.addElement(OctetListFacade.createValueList(((JCOctetlistValue)values[i]).getOctetstrings()));
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        case 14: {
                            do {
                                attrValues.addElement(EmailAddressFacade.createValueList(((JCEmailValue)values[i]).getType(), ((JCEmailValue)values[i]).getAddress()));
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        case 15: {
                            do {
                                attrValues.addElement(PathFacade.createValueList(((JCPathValue)values[i]).getNameSpace(), ((JCPathValue)values[i]).getVolumeDN(), ((JCPathValue)values[i]).getVolumePath()));
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        case 16: {
                            do {
                                try {
                                    JCReferral completeReferral = ((JCReplicapointerValue)values[i]).getReferral();
                                    JCNetworkAddress firstAddress = completeReferral.getReferral()[0];
                                    ValueList naValueList = NetAddressFacade.createValueList(firstAddress.getType(), firstAddress.getAddress());
                                    NetAddressFacade tmpnetAddressFacade = new NetAddressFacade(naValueList);
                                    attrValues.addElement(ReplicaPointerFacade.createValueList(((JCReplicapointerValue)values[i]).getServerDN(), ((JCReplicapointerValue)values[i]).getReplicaType(), ((JCReplicapointerValue)values[i]).getReplicaNumber(), 0, tmpnetAddressFacade));
                                }
                                catch (Exception ee) {
                                    Debug.out("Error getting SYNTAX_REPLICA_POINTER: " + ee.toString(), 1);
                                }
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        case 17: {
                            do {
                                String trustee = ((JCAclValue)values[i]).getTrusteeDN();
                                trustee = this.pseudoReverseFilter(trustee);
                                attrValues.addElement(ObjectACLFacade.createValueList(((JCAclValue)values[i]).getAttributeName(), trustee, ((JCAclValue)values[i]).getPrivileges()));
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        case 18: {
                            do {
                                attrValues.addElement(PostalAddressFacade.createValueList(((JCPostaladdressValue)values[i]).getAddresses()));
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        case 19: {
                            do {
                                attrValues.addElement(TimeStampFacade.createValueList(((JCTimestampValue)values[i]).getSeconds(), ((JCTimestampValue)values[i]).getReplica(), ((JCTimestampValue)values[i]).getEventID()));
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        case 20: {
                            do {
                                attrValues.addElement(NDSSyntax.SYN_CLASS_NAME.createValueComponent(((JCClassnameValue)values[i]).getClassname()));
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        case 21: {
                            do {
                                NDSInputStreamFactoryImpl o = new NDSInputStreamFactoryImpl(obj, (JCStreamValue)values[i], attrDef, serverOE);
                                attrValues.addElement(NDSSyntax.SYN_STREAM.createValueComponent(o));
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        case 22: {
                            do {
                                attrValues.addElement(NDSSyntax.SYN_COUNTER.createValueComponent(new Long(((JCCounterValue)values[i]).getCounter())));
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        case 23: {
                            do {
                                attrValues.addElement(BackLinkFacade.createValueList(((JCBacklinkValue)values[i]).getServerDN(), ((JCBacklinkValue)values[i]).getRemoteID()));
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        case 24: {
                            do {
                                attrValues.addElement(NDSSyntax.SYN_TIME.createValueComponent(new Date(((JCTimeValue)values[i]).getTime() * 1000L)));
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        case 25: {
                            do {
                                String nameEntryDN;
                                if ((nameEntryDN = ((JCTypednameValue)values[i]).getEntryDN()).equals("")) {
                                    nameEntryDN = obj.getRoot().getName();
                                }
                                attrValues.addElement(TypedNameFacade.createValueList(nameEntryDN, ((JCTypednameValue)values[i]).getLevel(), ((JCTypednameValue)values[i]).getInterval()));
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        case 26: {
                            do {
                                attrValues.addElement(HoldFacade.createValueList(((JCHoldValue)values[i]).getEntryDN(), ((JCHoldValue)values[i]).getAmount()));
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        case 27: {
                            do {
                                attrValues.addElement(NDSSyntax.SYN_INTERVAL.createValueComponent(new Long(((JCIntervalValue)values[i]).getInterval())));
                            } while (++i < values.length && values[i - 1].attributeName.equals(values[i].attributeName));
                            break;
                        }
                        default: {
                            ++i;
                        }
                    }
                    if (attrValues.size() <= 0) continue;
                    Object[] vc = new ValueComponent[attrValues.size()];
                    attrValues.copyInto(vc);
                    ndsAttrs.addElement(new NDSObjectAttribute((AttributeDefinition)attrDef, (ValueComponent[])vc));
                }
            }
        }
        catch (JCException jce) {
            if (jce.getErrorCode() == -603) {
                ndsAttrs.addElement(null);
            } else {
                SPIException spie = this.resolveSPIException((Exception)((Object)jce), "getAttributesImpl");
                if (aneRef == null) {
                    throw spie;
                }
                aneRef.setAdminNamespaceException(spie);
            }
        }
        catch (ComponentCreationException cce) {
            throw new AdminError(3, this.getClass());
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
        Object[] attrs = new ObjectAttribute[ndsAttrs.size()];
        ndsAttrs.copyInto(attrs);
        return attrs;
    }

    public void setAttribute(ObjectEntry obj, ObjectAttribute attribute) throws SPIException {
        this.setAttribute(obj, attribute, 5);
    }

    public void setAttributes(ObjectEntry obj, ObjectAttribute[] attributes) throws SPIException {
        for (int i = 0; i < attributes.length; ++i) {
            this.setAttribute(obj, attributes[i], 5);
        }
    }

    public void deleteAttributeValues(ObjectEntry obj, ObjectAttribute delAttr) throws SPIException {
        Vector attrDelJCValVector = this.convertToJCValue(delAttr, 7, obj.getRoot().getName());
        if (attrDelJCValVector.size() > 0) {
            JCContext ctx = null;
            try {
                ctx = this.getContext(obj, 68);
                this.modifyEntries(ctx, attrDelJCValVector);
            }
            catch (Exception x) {
                throw this.resolveSPIException(x, "");
            }
            finally {
                if (ctx != null) {
                    ctx.free();
                }
            }
        }
    }

    public synchronized boolean compareAttribute(ObjectEntry obj, ObjectAttribute objAttr) throws NamespaceException, SPIException {
        boolean result = false;
        Vector attr = null;
        String treeName = obj.getRoot().getName();
        attr = this.convertToJCValue(objAttr, 0, treeName);
        if (null != attr) {
            JCContext ctx = null;
            try {
                ctx = this.getContext(obj, 66);
                result = JClient.compareAttribute((JCContext)ctx, (JCValue)((JCValue)attr.firstElement()));
            }
            catch (Exception x) {
                throw this.resolveSPIException(x, "");
            }
            finally {
                if (ctx != null) {
                    ctx.free();
                }
            }
        }
        return result;
    }

    public AttributeDefinition getAttributeDefinition(ObjectEntry obj, String attrName) throws SPIException, NamespaceException {
        return this.getSchema(obj).getAttributeDefinition(attrName);
    }

    public NDSNCPExtension getNCPExtension(String name, ObjectEntry serverOE) throws SPIException {
        return new NCPExtensionImpl(this, name, serverOE);
    }

    public ClassDefinition getClassDefinition(ObjectEntry obj, String className) throws SPIException, NamespaceException {
        return this.getSchema(obj).getClassDefinition(className);
    }

    public SchemaDefinition getSchemaDefinition(ObjectEntry obj) throws SPIException {
        return this.getSchema(obj).getSchemaDefinition();
    }

    public ObjectEntry createObjectEntry(ObjectEntry parent, String child, String className) throws NamespaceException, SPIException {
        if (child == null || child.equals("")) {
            throw NamespaceException.INVALID_NAME;
        }
        if (parent == null && className.equalsIgnoreCase("Top")) {
            return new ObjectEntry(child, this.treeOT, null, 6L);
        }
        ObjectType ot = this.getObjectType(parent, className);
        NDSClassDefinition classDef = (NDSClassDefinition)this.getSchema(parent).getClassDefinition(className);
        if (!className.equalsIgnoreCase("Alias") && !classDef.canBeContainedBy(parent.getObjectType().getName())) {
            throw NDSNamespaceException.BAD_CONTAINMENT;
        }
        int newObjectFlags = 0;
        NDSClassFlags flags = classDef.getClassFlags();
        if (flags.isFlagSet(1)) {
            newObjectFlags = 4;
        }
        return new ObjectEntry(child, ot, parent, newObjectFlags);
    }

    public boolean doesExist(ObjectEntry parentEntry, String objStr) throws SPIException {
        if (parentEntry.getObjectType().isFileSystem() || objStr.charAt(0) == '<') {
            try {
                this.getObjectEntry(parentEntry, objStr);
            }
            catch (SPIException e) {
                if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -601) {
                    return false;
                }
                if (e instanceof SimpleSPIException && ((SimpleSPIException)e).getErrorId() != null && ((SimpleSPIException)e).getErrorId().equals("spi14")) {
                    return false;
                }
                throw e;
            }
            return true;
        }
        JCContext ctx = null;
        try {
            StringBuffer name = new StringBuffer(objStr);
            if (!this.isTreeEntryOnly(objStr) && !parentEntry.equals(parentEntry.getRoot())) {
                name.append(SEP_STRING).append(this.getUnrootedName(parentEntry));
            }
            ctx = this.getContext(parentEntry.getRoot().getName(), name.toString(), 2);
        }
        catch (SPIException e) {
            if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -601) {
                boolean bl = false;
                return bl;
            }
            throw e;
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
        return true;
    }

    public ObjectEntry getObjectEntry(String objEntryStr) throws SPIException {
        ObjectEntry parentEntry = this.getObjectEntry(null, this.getNameTree(objEntryStr));
        if (this.isTreeEntryOnly(objEntryStr)) {
            return parentEntry;
        }
        if (objEntryStr.charAt(0) == '<') {
            String[] oeStrParts = this.parseFSFederatedParts(objEntryStr);
            ObjectEntry dirOE = this.getObjectEntry(parentEntry, this.getNameDN(oeStrParts[0]));
            if (oeStrParts[1] == null) {
                return dirOE;
            }
            return this.getFSObjectEntryWithDirOE(dirOE, oeStrParts[1]);
        }
        return this.getObjectEntry(parentEntry, this.getNameDN(objEntryStr));
    }

    public ObjectEntry getObjectEntry(ObjectEntry parentEntry, String objEntryStr) throws SPIException {
        String unrootedObjName;
        String treeName;
        boolean mayBeComplexName = true;
        if (parentEntry == null) {
            treeName = this.getNameTree(objEntryStr);
            if (!treeName.equals(objEntryStr)) {
                return this.getObjectEntry(objEntryStr);
            }
            unrootedObjName = treeName;
            mayBeComplexName = false;
        } else {
            String[] oeNameParts;
            if (objEntryStr.length() <= 0) {
                return parentEntry;
            }
            if (objEntryStr.charAt(0) == '[' && (objEntryStr.equals("[Public]") || objEntryStr.equals("[Root]"))) {
                ObjectType ot = new ObjectType("Top", this, false);
                return new ObjectEntry(objEntryStr, ot, parentEntry, 0L);
            }
            if (parentEntry.getObjectType().isFileSystem()) {
                return this.getFSObjectEntryWithFSOE(parentEntry, objEntryStr);
            }
            if (objEntryStr.charAt(0) == '<' && (oeNameParts = this.parseFSFederatedParts(objEntryStr))[1] != null) {
                if (oeNameParts[0] == null) {
                    return this.getFSObjectEntryWithDirOE(parentEntry, oeNameParts[1]);
                }
                ObjectEntry tmpDirOE = this.getObjectEntry(parentEntry, oeNameParts[0]);
                return this.getFSObjectEntryWithDirOE(tmpDirOE, oeNameParts[1]);
            }
            treeName = parentEntry.getRoot().getName();
            String parentUnrootedName = this.getUnrootedName(parentEntry);
            unrootedObjName = parentUnrootedName.length() <= 0 ? objEntryStr : objEntryStr + '.' + parentUnrootedName;
        }
        JCContext ctx = null;
        try {
            ctx = this.getContext(treeName, unrootedObjName, 2, null);
            if (this.specialModeExists && this.disableDereferenceMode) {
                JCEntryInfo entry = JClient.getEntryInfo((JCContext)ctx, (int)2060);
                ObjectType ot = this.getSchema(treeName).getObjectType(entry.getBaseClass());
                ObjectEntry oe = new ObjectEntry(objEntryStr, ot, parentEntry, entry.getEntryFlags(), mayBeComplexName);
                try {
                    int subcount = entry.getSubordinateCount();
                    oe.setSubordinateCount(subcount);
                }
                catch (JCEntryInfoEmptyFieldException efe) {
                    // empty catch block
                }
                ObjectEntry efe = oe;
                return efe;
            }
            JCEntryInfo entry = JClient.getEntryInfo((JCContext)ctx, (int)131084);
            ObjectType ot = this.getSchema(treeName).getObjectType(entry.getDereferencedBaseClass());
            ObjectEntry oe = new ObjectEntry(objEntryStr, ot, parentEntry, entry.getEntryFlags(), mayBeComplexName);
            try {
                int subcount = entry.getSubordinateCount();
                oe.setSubordinateCount(subcount);
            }
            catch (JCEntryInfoEmptyFieldException efe) {
                // empty catch block
            }
            ObjectEntry objectEntry = oe;
            return objectEntry;
        }
        catch (JCException e) {
            throw this.resolveSPIException((Exception)((Object)e), "");
        }
        catch (JCEntryInfoEmptyFieldException e) {
            throw this.nsSpiException.newException("spi14");
        }
        catch (SPIException e) {
            if (!mayBeComplexName) {
                Debug.out("\"" + unrootedObjName + "\": " + e.toString(), 1);
            }
            throw e;
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    public ObjectEntryParentAndSimpleName getParentAndSimpleName(ObjectEntry oe) {
        ObjectEntry newParentOE;
        String newSimpleName;
        block12: {
            String asIsContainerPartOfName;
            block14: {
                int dotPos;
                block13: {
                    int simpleNamePos;
                    newSimpleName = oe.getAsIsName();
                    newParentOE = oe.getAsIsParent();
                    if (!oe.isComplexName()) break block12;
                    asIsContainerPartOfName = null;
                    if (!oe.getObjectType().isFileSystem()) break block13;
                    for (simpleNamePos = newSimpleName.length() - 1; simpleNamePos >= 0 && newSimpleName.charAt(simpleNamePos) != '\\' && newSimpleName.charAt(simpleNamePos) != '/' && newSimpleName.charAt(simpleNamePos) != ':'; --simpleNamePos) {
                    }
                    if (simpleNamePos < 0) break block14;
                    StringBuffer fsObjName = new StringBuffer(30);
                    boolean newParentIsFileSystem = true;
                    if (!newParentOE.getObjectType().isFileSystem()) {
                        newParentIsFileSystem = false;
                        fsObjName.append(FS_FEDERATED_BEGINTAG);
                    }
                    if (newSimpleName.charAt(simpleNamePos) == ':') {
                        fsObjName.append(newSimpleName.substring(0, simpleNamePos + 1));
                    } else {
                        fsObjName.append(newSimpleName.substring(0, simpleNamePos));
                    }
                    if (!newParentIsFileSystem) {
                        fsObjName.append(FS_FEDERATED_ENDTAG);
                    }
                    asIsContainerPartOfName = fsObjName.toString();
                    newSimpleName = newSimpleName.substring(simpleNamePos + 1);
                    break block14;
                }
                int firstchkPos = 1;
                while ((dotPos = newSimpleName.indexOf(46, firstchkPos)) > 0) {
                    try {
                        if (newSimpleName.charAt(dotPos - 1) != '\\') {
                            asIsContainerPartOfName = newSimpleName.substring(dotPos + 1);
                            newSimpleName = newSimpleName.substring(0, dotPos);
                            break;
                        }
                        firstchkPos = dotPos + 1;
                    }
                    catch (IndexOutOfBoundsException iobe) {
                        // empty catch block
                        break;
                    }
                }
            }
            if (asIsContainerPartOfName != null) {
                try {
                    newParentOE = this.getObjectEntry(newParentOE, asIsContainerPartOfName);
                }
                catch (SPIException spie) {
                    newSimpleName = oe.getAsIsName();
                    newParentOE = oe.getAsIsParent();
                    Debug.out("Warning: Unable to create parent OE for " + newSimpleName);
                    Debug.out("    " + spie.toString());
                }
            }
        }
        return new ObjectEntryParentAndSimpleName(newParentOE, newSimpleName);
    }

    public ObjectEntry[] getInitialObjectEntries() throws SPIException {
        Enumeration myenum = this.treeCache.keys();
        Vector<ObjectEntry> vec = new Vector<ObjectEntry>();
        while (myenum.hasMoreElements()) {
            vec.addElement(this.getObjectEntry((String)myenum.nextElement()));
        }
        Object[] oe = new ObjectEntry[vec.size()];
        vec.copyInto(oe);
        return oe;
    }

    public ObjectEntry[] getInitialObjectEntries(ObjectEntry oe, GetChildrenContext childrenCtx) throws SPIException {
        return this.getInitialObjectEntries();
    }

    public ObjectEntryEnumeration getChildren(ObjectEntry obj, GetChildrenContext childrenCtx) throws SPIException {
        if (childrenCtx.isForTree()) {
            return this.getChildContainers(obj, childrenCtx.getResultModifier());
        }
        return this.getChildren(obj, childrenCtx.getResultModifier());
    }

    public ObjectEntryEnumeration getChildren(ObjectEntry obj) throws SPIException {
        return this.getChildren(obj, (ResultModifier)null);
    }

    public ObjectEntryEnumeration getChildren(ObjectEntry obj, ResultModifier modifiers) throws SPIException {
        ObjectType objType = obj.getObjectType();
        String namePattern = null;
        if (!objType.isContainer() || objType.isFileSystem()) {
            int allowFSFlag;
            if (objType.isFileSystem()) {
                if (modifiers != null) {
                    namePattern = modifiers.getFilters()[0].getNameFilter();
                }
                ObjectEntryEnumeration fileObjEntryEnum = this.getFSChildrenFromFSObjectEntry(obj, namePattern);
                return fileObjEntryEnum;
            }
            int n = allowFSFlag = modifiers == null ? 0 : modifiers.getAllowFileSystemBrowse();
            if ((allowFSFlag & 1) == 1 && objType.getName().equalsIgnoreCase("Volume")) {
                ObjectEntryEnumeration fileObjEntryEnum = this.getFSChildrenFederatedFromVolume(obj);
                return fileObjEntryEnum;
            }
            if ((allowFSFlag & 2) == 2 && objType.getName().equalsIgnoreCase("NCP Server")) {
                ObjectEntryEnumeration fileObjEntryEnum = this.getFSChildrenFederatedFromServer(obj);
                return fileObjEntryEnum;
            }
            throw this.nsSpiException.newException("spi13");
        }
        if ((modifiers == null || modifiers.getBlockKey() != 1) && this.blockedCache.containsKey(objType)) {
            return new DefaultObjectEntryEnumeration();
        }
        ObjectEntryEnumeration objEntryEnum = null;
        try {
            if (!this.isSkadsServer(obj) || modifiers != null && modifiers.isSubContainerSearch()) {
                objEntryEnum = new ChildObjectEntryEnumerationImpl(obj, modifiers, false);
            } else {
                objEntryEnum = new BrowserObjectEntryEnumerationImpl(obj, modifiers);
                if (((BrowserObjectEntryEnumerationImpl)objEntryEnum).getCount() < MAX_ITEMS_FOR_ENUMERATION) {
                    ObjectEntryEnumeration holdingObjEnum = objEntryEnum;
                    objEntryEnum = new DefaultIndexedObjectEntryEnumeration(holdingObjEnum, this.shell);
                    ((BrowserObjectEntryEnumerationImpl)holdingObjEnum).close();
                    holdingObjEnum = null;
                } else if (((BrowserObjectEntryEnumerationImpl)objEntryEnum).isPositionable()) {
                    objEntryEnum = new VirtualObjectEntryEnumerationImpl((BrowserObjectEntryEnumerationImpl)objEntryEnum);
                }
            }
            return objEntryEnum;
        }
        catch (Exception x) {
            throw this.resolveSPIException(x, "");
        }
    }

    public ObjectEntryEnumeration getChildContainers(ObjectEntry obj, ResultModifier modifiers) throws SPIException {
        if (!obj.getObjectType().isContainer()) {
            throw this.nsSpiException.newException("spi13");
        }
        if ((modifiers == null || modifiers.getBlockKey() != 1) && this.blockedCache.containsKey(obj.getObjectType())) {
            return new DefaultObjectEntryEnumeration();
        }
        ChildObjectEntryEnumerationImpl objEntryEnum = new ChildObjectEntryEnumerationImpl(obj, modifiers, true);
        return objEntryEnum;
    }

    public ObjectType getObjectType(ObjectEntry obj, String className) throws SPIException {
        return this.getSchema(obj.getRoot().getName()).getObjectType(className);
    }

    public ObjectType[] getObjectType(ObjectEntry tree, String[] objectFDN) throws SPIException {
        String treeName = tree.getRoot().getName();
        NDSSchema schema = this.getSchema(treeName);
        ObjectType[] ot = new ObjectType[objectFDN.length];
        JCContext ctx = null;
        for (int i = 0; i < objectFDN.length; ++i) {
            if (objectFDN[i].equals("[Public]") || objectFDN[i].equals("[Root]")) {
                ot[i] = new ObjectType("Top", this, false);
                continue;
            }
            try {
                ctx = this.getContext(treeName, objectFDN[i], 2);
                JCEntryInfo info = JClient.getEntryInfo((JCContext)ctx, (int)2048);
                ot[i] = schema.getObjectType(info.getBaseClass());
                continue;
            }
            catch (JCEntryInfoEmptyFieldException e) {
                throw this.resolveSPIException((Exception)((Object)e), "");
            }
            catch (JCException e) {
                throw this.resolveSPIException((Exception)((Object)e), "");
            }
            finally {
                if (ctx != null) {
                    ctx.free();
                }
            }
        }
        return ot;
    }

    public ObjectType[] getObjectTypes(ObjectEntry obj) {
        ObjectType[] objectTypes = null;
        try {
            NDSSchema schema = this.getSchema(obj.getRoot().getName());
            ClassDefinition[] classes = schema.getSchemaDefinition().getEffectiveClasses(obj.getObjectType().getName());
            objectTypes = new ObjectType[classes.length];
            for (int i = 0; i < classes.length; ++i) {
                objectTypes[i] = schema.getObjectType(classes[i].getName());
            }
        }
        catch (SPIException sPIException) {
            // empty catch block
        }
        return objectTypes;
    }

    public NSObject getDetails(ObjectEntry obj, ObjectEntry serverObj) throws SPIException {
        return this.getDetailsImpl(obj, serverObj);
    }

    public NSObject getDetails(ObjectEntry obj) throws SPIException {
        return this.getDetailsImpl(obj, null);
    }

    public NSObject getDelayedAttibuteDetails(ObjectEntry objEntry, String[] delayedAttrStrings) throws SPIException {
        return this.getDelayedAttibuteDetails(objEntry, delayedAttrStrings, null);
    }

    public NSObject getDelayedAttibuteDetails(ObjectEntry objEntry, String[] delayedAttrStrings, ObjectEntry serverOE) throws SPIException {
        if (delayedAttrStrings == null) {
            delayedAttrStrings = new String[]{};
        }
        try {
            ClassDefinition tmpClassDef;
            ArrayList<ClassDefinition> classDefList = new ArrayList<ClassDefinition>(10);
            classDefList.add(this.getClassDefinition(objEntry, objEntry.getObjectType().getName()));
            ObjectAttribute[] tmpattrarr = this.getAttributesImpl(objEntry, new String[]{"Object Class"}, 0, null, serverOE);
            if (tmpattrarr.length == 0 || tmpattrarr[0] == null) {
                throw this.nsSpiException.newException("spi14");
            }
            Enumeration objClassVals = tmpattrarr[0].getValueComponents();
            while (objClassVals.hasMoreElements()) {
                tmpClassDef = this.getClassDefinition(objEntry, objClassVals.nextElement().toString());
                if (!tmpClassDef.isAuxiliary()) continue;
                classDefList.add(tmpClassDef);
            }
            HashMap<String, String> attrToGetMap = new HashMap<String, String>(100);
            ListIterator classdefIt = classDefList.listIterator();
            while (classdefIt.hasNext()) {
                int delayidx;
                boolean foundInDelayed;
                tmpClassDef = (ClassDefinition)classdefIt.next();
                AttributeDefinition[] manAttrs = tmpClassDef.getMandatoryAttributes();
                AttributeDefinition[] optAttrs = tmpClassDef.getOptionalAttributes();
                for (int midx = 0; midx < manAttrs.length; ++midx) {
                    foundInDelayed = false;
                    String maName = manAttrs[midx].getName();
                    for (delayidx = 0; delayidx < delayedAttrStrings.length; ++delayidx) {
                        if (!maName.equalsIgnoreCase(delayedAttrStrings[delayidx])) continue;
                        foundInDelayed = true;
                        break;
                    }
                    if (foundInDelayed) continue;
                    attrToGetMap.put(maName.toLowerCase(), maName);
                }
                for (int oidx = 0; oidx < optAttrs.length; ++oidx) {
                    foundInDelayed = false;
                    String oaName = optAttrs[oidx].getName();
                    for (delayidx = 0; delayidx < delayedAttrStrings.length; ++delayidx) {
                        if (!oaName.equalsIgnoreCase(delayedAttrStrings[delayidx])) continue;
                        foundInDelayed = true;
                        break;
                    }
                    if (foundInDelayed) continue;
                    attrToGetMap.put(oaName.toLowerCase(), oaName);
                }
            }
            String[] attrToReadArr = new String[attrToGetMap.size()];
            Collection attrValCollection = attrToGetMap.values();
            attrToReadArr = attrValCollection.toArray(attrToReadArr);
            ObjectAttribute[] objAttrsRead = this.getAttributesImpl(objEntry, attrToReadArr, 0, null, serverOE);
            String[] valuedDelayedAttrStrings = null;
            valuedDelayedAttrStrings = delayedAttrStrings.length == 0 ? new String[]{} : this.getAttributesPresent(objEntry, delayedAttrStrings);
            if (valuedDelayedAttrStrings == null) {
                valuedDelayedAttrStrings = new String[]{};
            }
            Vector<Object> attributeVec = new Vector<Object>(objAttrsRead.length + valuedDelayedAttrStrings.length);
            for (int aridx = 0; aridx < objAttrsRead.length; ++aridx) {
                if (objAttrsRead[aridx] == null) continue;
                attributeVec.addElement(objAttrsRead[aridx]);
            }
            for (int daidx = 0; daidx < valuedDelayedAttrStrings.length; ++daidx) {
                if (valuedDelayedAttrStrings[daidx] == null) continue;
                attributeVec.addElement(valuedDelayedAttrStrings[daidx]);
            }
            return new NDSObjectImpl(objEntry, attributeVec, 0L);
        }
        catch (NamespaceException x) {
            throw this.resolveSPIException(x, "");
        }
    }

    private NSObject getDetailsImpl(ObjectEntry obj, ObjectEntry serverOE) throws SPIException {
        try {
            ObjectAttribute[] attrs = this.getAttributes(obj, null, serverOE);
            Vector<ObjectAttribute> attributeVec = new Vector<ObjectAttribute>(attrs.length);
            for (int i = 0; i < attrs.length; ++i) {
                if (attrs[i] == null) continue;
                attributeVec.addElement(attrs[i]);
            }
            return new NDSObjectImpl(obj, attributeVec, 0L);
        }
        catch (NamespaceException e) {
            throw this.resolveSPIException(e, "");
        }
    }

    public NSObject getDetails(ObjectEntry obj, Object key) throws SPIException {
        NSObject nsObject = this.nsObjectLookupTable.getDetails(key, obj);
        if (nsObject == null) {
            nsObject = this.getDetails(obj);
            this.nsObjectLookupTable.setDetails(key, nsObject);
        }
        return nsObject;
    }

    public void freeDetails(Object key, ObjectEntry obj) {
        this.nsObjectLookupTable.freeDetails(key, obj);
    }

    public void freeDetails(Object key) {
        this.nsObjectLookupTable.freeDetails(key);
    }

    public Rights getObjectEffectiveRights(ObjectEntry objForInquire, ObjectEntry trustee) throws SPIException {
        JCContext ctx = null;
        try {
            String fullName = this.pseudoFilter(this.getUnrootedName(trustee), trustee.getRoot().getName());
            ctx = this.getContext(objForInquire, 66);
            long privileges = ctx.getEffectivePrivileges(fullName, "[Entry Rights]");
            NDSObjectRightsImpl nDSObjectRightsImpl = new NDSObjectRightsImpl(new JCAclValue(null, 0, 0L, null, null, fullName, privileges));
            return nDSObjectRightsImpl;
        }
        catch (JCException e) {
            throw this.resolveSPIException((Exception)((Object)e), "");
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    public Rights getPropertyEffectiveRights(ObjectEntry objForInquire, ObjectEntry trustee, String attrName) throws SPIException {
        String[] attrs = new String[]{attrName};
        return this.getPropertyEffectiveRights(objForInquire, trustee, attrs)[0];
    }

    public Rights[] getPropertyEffectiveRights(ObjectEntry objForInquire, ObjectEntry trustee, String[] attrNames) throws SPIException {
        JCContext ctx = null;
        try {
            Rights[] rights = new NDSPropertyRights[attrNames.length];
            String fullName = this.pseudoFilter(this.getUnrootedName(trustee), trustee.getRoot().getName());
            ctx = this.getContext(objForInquire, 66);
            for (int i = 0; i < attrNames.length; ++i) {
                String attribName = attrNames[i];
                if (null == attribName || attrNames[0] == null) {
                    attribName = new String("[All Attributes Rights]");
                }
                long privileges = ctx.getEffectivePrivileges(fullName, attribName);
                rights[i] = new NDSPropertyRightsImpl(new JCAclValue(attribName, 0, 0L, null, attribName, fullName, privileges));
            }
            Rights[] rightsArray = rights;
            return rightsArray;
        }
        catch (JCException e) {
            throw this.resolveSPIException((Exception)((Object)e), "");
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    public void updateMOO(MOOManager MOOManagerObj, MOOManagerCallBack callBack) {
        this.updateMOOImpl(MOOManagerObj, callBack, null);
    }

    public void updateMOO(MOOManager MOOManagerObj, MOOManagerCallBack callBack, ObjectEntry serverObj) {
        this.updateMOOImpl(MOOManagerObj, callBack, serverObj);
    }

    private void updateMOOImpl(MOOManager MOOManagerObj, MOOManagerCallBack callBack, ObjectEntry serverObj) {
        JCValue[] allUpdateJCVals;
        int oeCnt = 0;
        int updateInterval = callBack.getUpdateInterval();
        ObjectEntry treeOE = MOOManagerObj.getTreeObjectEntry();
        String treeName = treeOE.getName();
        ObjectEntryEnumeration oeEenum = MOOManagerObj.getObjectEntryEnumeration();
        if (!oeEenum.hasMoreElements()) {
            callBack.finished(0);
            return;
        }
        ObjectOperation[] allOperations = MOOManagerObj.getAllObjectOperations();
        ArrayList streamArrList = new ArrayList();
        try {
            allUpdateJCVals = this.createOperationJCValues(allOperations, streamArrList, treeName);
        }
        catch (SPIException ss) {
            callBack.handleException(ss, null);
            callBack.finished(0);
            return;
        }
        if (allUpdateJCVals == null || allUpdateJCVals.length == 0) {
            callBack.finished(0);
            return;
        }
        while (oeEenum.hasMoreElements()) {
            DirectoryEventImpl event;
            ObjectEntry thisOE;
            block20: {
                try {
                    thisOE = (ObjectEntry)oeEenum.nextElement();
                }
                catch (NoSuchElementException nsee) {
                    break;
                }
                ++oeCnt;
                event = new DirectoryEventImpl();
                try {
                    String retVal = this.notifyDirectoryEventListeners(37, thisOE, null, event);
                    if (retVal != null) {
                        if ("VETO_RESPONSE_RESPONSE".equals(retVal)) continue;
                        if ("VETO_APPLY_ALL_RESPONSE".equals(retVal)) {
                            return;
                        }
                    }
                    JCContext ctx = null;
                    try {
                        ctx = serverObj == null ? this.getContext(thisOE, 68) : this.getContext(thisOE, 68, serverObj);
                        this.modifyEntriesWithArray(ctx, allUpdateJCVals);
                        ListIterator lit = streamArrList.listIterator();
                        while (lit.hasNext()) {
                            ObjectAttribute streamObjAttr = (ObjectAttribute)lit.next();
                            Enumeration streamValue = streamObjAttr.getValueComponents();
                            if (!streamValue.hasMoreElements()) continue;
                            InputStream inStream = ((StreamValue)streamValue.nextElement()).getValue();
                            byte[] sbuffer = new byte[inStream.available()];
                            inStream.read(sbuffer);
                            this.writeActualStreamBuffer(ctx, streamObjAttr.getName(), sbuffer);
                        }
                    }
                    catch (Exception x) {
                        throw this.resolveSPIException(x, "");
                    }
                    finally {
                        if (ctx != null) {
                            ctx.free();
                        }
                    }
                    if (updateInterval != 0 && oeCnt % updateInterval == 0 && callBack.update(thisOE, oeCnt) == 1) {
                        callBack.finished(oeCnt);
                        return;
                    }
                }
                catch (Exception e) {
                    if (callBack.handleException(e, thisOE) != 1) break block20;
                    callBack.finished(oeCnt);
                    return;
                }
            }
            this.notifyDirectoryEventListeners(21, thisOE, null, event);
        }
        callBack.finished(oeCnt);
    }

    private JCValue[] createOperationJCValues(ObjectOperation[] operations, ArrayList streamArrList, String treeName) throws SPIException {
        JCValue[] retJCValues = null;
        ArrayList<JCValue> allAttrList = new ArrayList<JCValue>();
        block7: for (int i = 0; i < operations.length; ++i) {
            ObjectAttribute objAttr = operations[i].getObjectAttribute();
            switch (operations[i].getMode()) {
                case 1: {
                    Vector attrJCValVector = this.convertToJCValue(objAttr, 5, treeName);
                    if (attrJCValVector.size() <= 0) continue block7;
                    allAttrList.addAll(attrJCValVector);
                    if (objAttr.getAttributeDefinition().getSyntax() != NDSSyntax.SYN_STREAM) continue block7;
                    streamArrList.add(objAttr);
                    continue block7;
                }
                case 2: {
                    Vector attrJCValVector = this.convertToJCValue(objAttr, 7, treeName);
                    if (attrJCValVector.size() <= 0) continue block7;
                    allAttrList.addAll(attrJCValVector);
                    continue block7;
                }
                case 3: {
                    Vector attrJCValVector = this.convertToJCValue(objAttr, 3, treeName);
                    if (attrJCValVector.size() > 0) {
                        allAttrList.addAll(attrJCValVector);
                    }
                    if ((attrJCValVector = this.convertToJCValue(objAttr, 5, treeName)).size() <= 0) continue block7;
                    allAttrList.addAll(attrJCValVector);
                    if (objAttr.getAttributeDefinition().getSyntax() != NDSSyntax.SYN_STREAM) continue block7;
                    streamArrList.add(objAttr);
                    continue block7;
                }
                case 4: {
                    JCValue emptyJCValue = this.createEmptyJCValue(objAttr, 6);
                    allAttrList.add(emptyJCValue);
                    continue block7;
                }
                case 5: {
                    continue block7;
                }
                default: {
                    throw this.resolveSPIException(NamespaceException.UNSUPPORTED_OPERATION, "createOperationJCValues");
                }
            }
        }
        if (allAttrList.size() > 0) {
            retJCValues = allAttrList.toArray(new JCValue[allAttrList.size()]);
        }
        return retJCValues;
    }

    public void update(NSObject obj, ObjectEntry serverOE) throws SPIException, SnapinVetoException {
        this.updateImpl(obj, serverOE);
    }

    public void update(NSObject obj) throws SPIException, SnapinVetoException {
        this.updateImpl(obj, null);
    }

    private void updateImpl(NSObject obj, ObjectEntry serverOE) throws SPIException, SnapinVetoException {
        int i;
        int i2;
        boolean isNonAuxAttr = false;
        ObjectEntry oe = obj.getObjectEntry();
        Vector attributeVector = new Vector();
        DirectoryModifyEventImpl event = new DirectoryModifyEventImpl();
        String retVal = this.notifyDirectoryEventListeners(36, oe, null, obj, event);
        if (retVal != null && retVal.length() > 0) {
            throw new SnapinVetoException(retVal);
        }
        String[] addedAttributeNames = obj.getAddedAttributes();
        Hashtable auxClassAttribDefs = ((DefaultNSObject)obj).getAddedAttributeDefinitions();
        boolean hasAuxClassAdded = false;
        Vector<String> mandAttribVec = new Vector<String>();
        Vector<String> optAttribVec = new Vector<String>();
        ObjectAttribute[] nonAuxattr = new ObjectAttribute[addedAttributeNames.length];
        ObjectAttribute[] auxAttr = null;
        ObjectAttribute[] modifiedAttr = null;
        for (i2 = 0; i2 <= addedAttributeNames.length - 1; ++i2) {
            if (auxClassAttribDefs.get(addedAttributeNames[i2]) != null) continue;
            nonAuxattr[i2] = obj.getAttribute(addedAttributeNames[i2]);
            isNonAuxAttr = true;
        }
        if (isNonAuxAttr) {
            this.setAttributeImpl(obj.getObjectEntry(), nonAuxattr, 2, serverOE, attributeVector);
        }
        for (i2 = 0; i2 < addedAttributeNames.length; ++i2) {
            if (auxClassAttribDefs.get(addedAttributeNames[i2]) == null) continue;
            hasAuxClassAdded = true;
            if (obj.isAttributeMandatory(addedAttributeNames[i2])) {
                mandAttribVec.addElement(addedAttributeNames[i2]);
                continue;
            }
            optAttribVec.addElement(addedAttributeNames[i2]);
        }
        if (hasAuxClassAdded) {
            this.setAuxAttribute(obj, mandAttribVec);
            for (i2 = 0; i2 < mandAttribVec.size(); ++i2) {
                ObjectAttribute objAttr = obj.getAttribute("Object Class");
                objAttr = obj.getAttribute((String)mandAttribVec.elementAt(i2));
                if (objAttr == null || objAttr.getAttributeDefinition().getSyntax() != NDSSyntax.SYN_STREAM) continue;
                this.addStreamValue(obj.getObjectEntry(), objAttr, 5, serverOE);
            }
        }
        auxAttr = new ObjectAttribute[optAttribVec.size()];
        if (!optAttribVec.isEmpty()) {
            for (i2 = 0; i2 < optAttribVec.size(); ++i2) {
                auxAttr[i2] = obj.getAttribute((String)optAttribVec.elementAt(i2));
            }
        }
        if (!optAttribVec.isEmpty()) {
            this.setAttributeImpl(obj.getObjectEntry(), auxAttr, 2, serverOE, attributeVector);
        }
        String[] modifiedAttributeNames = obj.getModifiedAttributes();
        modifiedAttr = new ObjectAttribute[modifiedAttributeNames.length];
        for (i = 0; i < modifiedAttributeNames.length; ++i) {
            modifiedAttr[i] = obj.getAttribute(modifiedAttributeNames[i]);
        }
        this.setAttributeImpl(obj.getObjectEntry(), modifiedAttr, 5, serverOE, attributeVector);
        this.modifyAll(attributeVector, obj.getObjectEntry(), serverOE);
        for (i = 0; i < addedAttributeNames.length; ++i) {
            if (auxClassAttribDefs.get(addedAttributeNames[i]) != null) continue;
            obj.clearAddedAttribute(addedAttributeNames[i]);
            nonAuxattr[i].clearAddedAttributeValues();
            nonAuxattr[i].clearDeletedAttributeValues();
            nonAuxattr[i].resetBeginningAttributeValues();
        }
        if (!optAttribVec.isEmpty()) {
            for (i = 0; i < optAttribVec.size(); ++i) {
                obj.clearAddedAttribute((String)optAttribVec.elementAt(i));
                auxAttr[i].clearAddedAttributeValues();
                auxAttr[i].clearDeletedAttributeValues();
                auxAttr[i].resetBeginningAttributeValues();
            }
        }
        for (i = 0; i < modifiedAttributeNames.length; ++i) {
            modifiedAttr[i].clearDeletedAttributeValues();
            modifiedAttr[i].clearAddedAttributeValues();
            modifiedAttr[i].clearModifiedAttributeValues();
            if (modifiedAttr[i].getComponentCount() == 0) {
                try {
                    obj.deleteAttribute(modifiedAttributeNames[i]);
                    obj.clearDeletedAttribute(modifiedAttributeNames[i]);
                }
                catch (Exception x) {
                    throw this.resolveSPIException(x, "");
                }
            }
            obj.clearModifiedAttribute(modifiedAttributeNames[i]);
            modifiedAttr[i].resetBeginningAttributeValues();
        }
        String[] deletedAttributeNames = obj.getDeletedAttributes();
        for (int i3 = 0; i3 < deletedAttributeNames.length; ++i3) {
            this.deleteAttributeImpl(obj.getObjectEntry(), deletedAttributeNames[i3], serverOE);
            obj.clearDeletedAttribute(deletedAttributeNames[i3]);
        }
        this.notifyDirectoryEventListeners(20, oe, null, obj, event);
    }

    public MODObject getMODDetails(ObjectEntryCollection oeCollection, Object key) {
        MultiObjModificationNamespaceImpl modNamespace = new MultiObjModificationNamespaceImpl(this, this.nsObjectLookupTable);
        return modNamespace.getMODDetails(oeCollection, key);
    }

    public void updateMultipleObjects(ObjectEntryCollection collection, MODObject referenceObj, MultiObjModificationCallBack callBack) {
        MultiObjModificationNamespaceImpl modNamespace = new MultiObjModificationNamespaceImpl(this, this.nsObjectLookupTable);
        modNamespace.updateMultipleObjects(collection, referenceObj, callBack);
    }

    public String getFullName(ObjectEntry obj) {
        String unrootedName = this.getUnrootedName(obj);
        if (unrootedName.equals("")) {
            return obj.getRoot().getName();
        }
        return unrootedName + obj.getRoot().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFullyTypedName(ObjectEntry obj) {
        JCContext ctx = null;
        try {
            ctx = this.getContext(obj, 2);
            ctx.setBaseDN(null, TYPEDNAMEDELIMITERS);
            JCEntryInfo entry = JClient.getEntryInfo((JCContext)ctx, (int)8192);
            StringBuffer DNBuff = entry.getEntryDN();
            int begPos = 0;
            int endPos = DNBuff.length() - 1;
            if (DNBuff.charAt(0) == '.') {
                begPos = 1;
            }
            while (endPos >= 0) {
                if (DNBuff.charAt(endPos) == '=') {
                    if (endPos >= 1 && DNBuff.charAt(endPos - 1) == '\\') {
                        --endPos;
                        continue;
                    }
                    --endPos;
                    break;
                }
                --endPos;
            }
            while (endPos >= 0) {
                if (DNBuff.charAt(endPos) == '.') {
                    if (endPos < 1 || DNBuff.charAt(endPos - 1) != '\\') break;
                    --endPos;
                    continue;
                }
                --endPos;
            }
            String retStr = null;
            try {
                retStr = DNBuff.substring(begPos, endPos);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (retStr != null && retStr.length() > 0) {
                String string = retStr;
                return string;
            }
        }
        catch (SPIException e) {
            Debug.out("Exception getting fully typed name: " + e.toString(), 1);
        }
        catch (JCException e) {
            Debug.out("Exception getting fully typed name: " + e.toString(), 1);
        }
        catch (JCEntryInfoEmptyFieldException e) {
            Debug.out("Exception getting fully typed name: " + e.toString(), 1);
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
        StringBuffer objName = new StringBuffer(30);
        String[] namingAttribute = null;
        while (null != obj.getParent() && obj.getObjectType().getNamespace() instanceof NDSNamespaceImpl) {
            try {
                namingAttribute = this.getNamingAttributesForObject(obj);
            }
            catch (Exception e) {
                Debug.out("Exception getNamingAttributesForObject: " + e.toString(), 1);
            }
            objName.append(namingAttribute[0]).append(VALUE_STRING).append(obj.getName());
            if ((obj = obj.getParent()).getParent() == null) continue;
            objName.append(SEP_STRING);
        }
        return objName.toString();
    }

    public String[] getNameComponents(ObjectEntry oe) {
        String objFDN = this.getUnrootedName(oe);
        Vector<String> componentVec = new Vector<String>();
        int len = objFDN.length();
        int begIndex = 0;
        boolean escaped = false;
        for (int i = 0; i < len; ++i) {
            if (escaped) {
                escaped = false;
                continue;
            }
            if (objFDN.charAt(i) == '\\') {
                escaped = true;
                continue;
            }
            if (objFDN.charAt(i) != '.') continue;
            componentVec.addElement(objFDN.substring(begIndex, i));
            begIndex = i + 1;
        }
        componentVec.addElement(objFDN.substring(begIndex, len));
        Object[] components = new String[componentVec.size()];
        componentVec.copyInto(components);
        return components;
    }

    public String getUnrootedName(ObjectEntry obj) {
        StringBuffer objName = new StringBuffer(25);
        if (obj.getObjectType().isFileSystem()) {
            StringBuffer fsObjBuf = new StringBuffer(30);
            while (obj.getObjectType().isFileSystem()) {
                String asIsName = obj.getAsIsName();
                if (asIsName.charAt(asIsName.length() - 1) == ':' || fsObjBuf.length() <= 0) {
                    fsObjBuf.insert(0, asIsName);
                } else {
                    fsObjBuf.insert(0, asIsName + "\\");
                }
                obj = obj.getAsIsParent();
            }
            objName.append(FS_FEDERATED_BEGINTAG);
            objName.append(fsObjBuf);
            objName.append(FS_FEDERATED_ENDTAG);
            objName.append(SEP_STRING);
        }
        while (null != obj.getAsIsParent() && obj.getObjectType().getNamespace() instanceof NDSNamespaceImpl) {
            objName.append(obj.getAsIsName());
            if ((obj = obj.getAsIsParent()).getAsIsParent() == null) continue;
            objName.append(SEP_STRING);
        }
        return objName.toString();
    }

    public synchronized void authenticate(String dn, String tree, String password) throws SPIException {
        if (initException != null) {
            throw this.resolveSPIException(initException, "Authenticate");
        }
        JCContext newctx = null;
        boolean connectedByIp = false;
        if (password != null && password.length() > 127) {
            throw this.nsSpiException.newException("spi2");
        }
        if (password == null) {
            password = "";
        }
        ServerAndIpInfo saiInfo = new ServerAndIpInfo();
        try {
            SPIException spiToThrow;
            block31: {
                if (NDSNamespaceImpl.isIPAddress(tree, saiInfo)) {
                    JCPingInfo pingInfo;
                    connectedByIp = true;
                    JCNetworkAddress netAddr = new JCNetworkAddress(9, saiInfo.ipAddress, (long)saiInfo.ipPort);
                    newctx = new JCContext();
                    try {
                        newctx.connect(0L, netAddr);
                        pingInfo = newctx.ping();
                    }
                    catch (JCException e) {
                        if (e.getErrorCode() == -625) {
                            newctx.connect(4L, netAddr);
                            pingInfo = newctx.ping();
                        }
                        throw e;
                    }
                    tree = pingInfo.treeName;
                    if (this.checkForSecureNCP) {
                        this.checkAndSetSecureNCP(newctx, tree);
                    }
                    tree = this.getNameTreeDotted(tree);
                    newctx.setBaseDN(tree, DELIMITERS);
                    this.setupServerDNInfo(newctx, saiInfo);
                } else {
                    if (this.checkForSecureNCP) {
                        this.checkAndSetSecureNCP(newctx, tree);
                    }
                    tree = this.getNameTreeDotted(tree);
                    newctx = new JCContext();
                    newctx.setBaseDN(tree, DELIMITERS);
                }
                try {
                    newctx.setFlagSetFlags(2, 288, 0);
                }
                catch (Throwable te) {
                    Debug.out("Currently installed eDir library versions do not support authentication with case insensitive passwords");
                    Debug.out("  Exception: " + te.toString() + "\n");
                }
                if (this.treeCache.get(tree) != null || this.contextCache.get(tree) != null) {
                    JCContext oldctx = (JCContext)this.contextCache.get(tree);
                    oldctx.free();
                    this.freeFileSystemLicenseCache();
                    this.clearCache(tree);
                }
                spiToThrow = null;
                try {
                    int authCtxFlags = 68;
                    if (this.specialModeExists) {
                        if (this.accessConfidenceUseCount >= 1) {
                            authCtxFlags = authCtxFlags & 0xFFFFFFF9 | 8;
                        }
                        if (this.disableDereferenceMode) {
                            authCtxFlags &= 0xFFFFFFBF;
                        }
                    }
                    if (password.length() == 0 && dn.equalsIgnoreCase("[Public]")) {
                        if (!connectedByIp) {
                            newctx.resolve(2, "");
                        }
                        try {
                            newctx.login();
                        }
                        catch (JCException jce) {
                            this.secureRetryLogin(newctx, jce, null);
                        }
                    } else {
                        newctx.resolve(authCtxFlags, dn);
                        try {
                            newctx.login(password);
                        }
                        catch (JCException jce) {
                            this.secureRetryLogin(newctx, jce, password);
                        }
                    }
                }
                catch (JCException je) {
                    spiToThrow = je.getErrorCode() == -6042 ? this.nsSpiException.newException("spi24") : this.resolveSPIException((Exception)((Object)je), "Authenticate");
                    if (je.getErrorCode() == -223) break block31;
                    throw spiToThrow;
                }
            }
            if (!connectedByIp) {
                this.setupServerIpInfo(newctx, saiInfo);
                this.setupServerDNInfo(newctx, saiInfo);
            }
            try {
                newctx.connect(0L, (JCNetworkAddress)null);
            }
            catch (JCException e) {
                // empty catch block
            }
            this.currentTree = tree;
            this.contextCache.put(tree, newctx);
            this.defaultConnectionInfoCache.put(tree, saiInfo);
            this.treeCache.put(tree, "");
            if (spiToThrow != null) {
                throw spiToThrow;
            }
        }
        catch (JCException e) {
            throw this.resolveSPIException((Exception)((Object)e), "Authenticate");
        }
    }

    private void secureRetryLogin(JCContext sctx, JCException jce, String password) throws JCException, SPIException {
        if (jce.getErrorCode() == -6089) {
            Debug.out(WARNSECURENCP_LOGIN);
            this.setSecureNCP(sctx);
            if (password == null) {
                sctx.login();
            } else {
                sctx.login(password);
            }
        } else {
            throw jce;
        }
        this.clearSecureNCP(sctx);
    }

    private void secureRetryModify(JCContext sctx, JCException jce, JCValue[] modItemsAll) throws JCException, SPIException {
        if (jce.getErrorCode() != -6089) {
            throw jce;
        }
        Debug.out(WARNSECURENCP_MODIFY);
        this.setSecureNCP(sctx);
        JClient.modifyEntry((JCContext)sctx, (JCValue[])modItemsAll);
        this.clearSecureNCP(sctx);
    }

    private JCValue[] secureRetryReadEntry(JCContext sctx, JCException jce, long infoType, JCReadFilter attributeFilter, JCExceptionReference jceRef, JCValue[] origValues) throws JCException, SPIException {
        if (jce.getErrorCode() == -6089) {
            JCValue[] retryValues;
            Debug.out(WARNSECURENCP_READ);
            this.setSecureNCP(sctx);
            if (jceRef != null) {
                jceRef.setException(null);
                retryValues = JClient.readEntry((JCContext)sctx, (long)infoType, (JCReadFilter)attributeFilter, (JCExceptionReference)jceRef);
            } else {
                retryValues = JClient.readEntry((JCContext)sctx, (long)infoType, (JCReadFilter)attributeFilter);
            }
            this.clearSecureNCP(sctx);
            return retryValues;
        }
        if (jceRef != null) {
            return origValues;
        }
        throw jce;
    }

    private void secureRetryCreate(JCContext sctx, JCException jce, String rdnName, JCValue[] attrSet) throws JCException, SPIException {
        if (jce.getErrorCode() != -6089) {
            throw jce;
        }
        Debug.out(WARNSECURENCP_CREATE);
        this.setSecureNCP(sctx);
        JClient.createEntry((JCContext)sctx, (String)rdnName, (JCValue[])attrSet);
        this.clearSecureNCP(sctx);
    }

    private void secureRetryRemoveEntry(JCContext sctx, JCException jce) throws JCException, SPIException {
        if (jce.getErrorCode() != -6089) {
            throw jce;
        }
        Debug.out(WARNSECURENCP_DELETEOBJ);
        this.setSecureNCP(sctx);
        JClient.removeEntry((JCContext)sctx);
        this.clearSecureNCP(sctx);
    }

    private void secureRetryRemoveAttribute(JCContext sctx, JCException jce, String attrName) throws JCException, SPIException {
        if (jce.getErrorCode() != -6089) {
            throw jce;
        }
        Debug.out(WARNSECURENCP_DELETEATTR);
        this.setSecureNCP(sctx);
        JClient.removeAttribute((JCContext)sctx, (String)attrName);
        this.clearSecureNCP(sctx);
    }

    private void secureRetryModifyRDN(JCContext sctx, JCException jce, String newName, boolean deleteOld) throws JCException, SPIException {
        if (jce.getErrorCode() != -6089) {
            throw jce;
        }
        Debug.out(WARNSECURENCP_RENAME);
        this.setSecureNCP(sctx);
        JClient.modifyRDN((JCContext)sctx, (String)newName, (boolean)deleteOld);
        this.clearSecureNCP(sctx);
    }

    private void secureRetryMoveEntry(JCContext sctxFrom, JCContext sctxTo, JCException jce, long flags, String newRDN) throws JCException, SPIException {
        if (jce.getErrorCode() != -6089) {
            throw jce;
        }
        Debug.out(WARNSECURENCP_MOVE);
        this.setSecureNCP(sctxFrom);
        this.setSecureNCP(sctxTo);
        JClient.moveEntry((JCContext)sctxFrom, (JCContext)sctxTo, (long)flags, (String)newRDN);
        this.clearSecureNCP(sctxTo);
        this.clearSecureNCP(sctxFrom);
    }

    long secureRetryOpenStream(JCContext sctx, JCException jce, String attributeName, int streamMode) throws JCException, SPIException {
        if (jce.getErrorCode() == -6089) {
            Debug.out(WARNSECURENCP_OPENSTREAM);
            this.setSecureNCP(sctx);
            long streamSize = JClient.openStream((JCContext)sctx, (String)attributeName, (int)streamMode);
            this.clearSecureNCP(sctx);
            return streamSize;
        }
        throw jce;
    }

    void secureRetryCloseStream(JCContext sctx, JCException jce) throws JCException, SPIException {
        if (jce.getErrorCode() != -6089) {
            throw jce;
        }
        Debug.out(WARNSECURENCP_CLOSESTREAM);
        this.setSecureNCP(sctx);
        JClient.closeStream((JCContext)sctx);
        this.clearSecureNCP(sctx);
    }

    long secureRetryReadStream(JCContext sctx, JCException jce, long position, long sizeToRead, byte[] streamBuffer) throws JCException, SPIException {
        if (jce.getErrorCode() == -6089) {
            Debug.out(WARNSECURENCP_READSTREAM);
            this.setSecureNCP(sctx);
            long numBytesRead = JClient.readStream((JCContext)sctx, (long)position, (long)sizeToRead, (byte[])streamBuffer);
            this.clearSecureNCP(sctx);
            return numBytesRead;
        }
        throw jce;
    }

    private long secureRetryWriteStream(JCContext sctx, JCException jce, long position, long sizeToWrite, byte[] streamBuffer) throws JCException, SPIException {
        if (jce.getErrorCode() == -6089) {
            Debug.out(WARNSECURENCP_WRITESTREAM);
            this.setSecureNCP(sctx);
            long numBytesWritten = JClient.writeStream((JCContext)sctx, (long)position, (long)sizeToWrite, (byte[])streamBuffer);
            this.clearSecureNCP(sctx);
            return numBytesWritten;
        }
        throw jce;
    }

    public void initializeSecureNCPTrees(boolean IWillNotUseThisMethod, String[] treeList) throws SPIException {
        if (IWillNotUseThisMethod) {
            if (treeList != null) {
                this.checkForSecureNCP = true;
                for (int tc = 0; tc < treeList.length; ++tc) {
                    this.secureNCPTreeHashMap.put(treeList[tc].toLowerCase(), treeList[tc]);
                    Debug.out("Setting Tree: " + treeList[tc] + " for Secure NCP access");
                }
            }
        } else {
            throw this.nsSpiException.newException("spi26", "initializeSecureNCPTrees() cannot be called");
        }
    }

    private void checkAndSetSecureNCP(JCContext sctx, String givenTree) throws SPIException {
        if (this.secureNCPTreeHashMap.get(givenTree.toLowerCase()) != null) {
            this.setSecureNCP(sctx);
        }
    }

    private void setSecureNCP(JCContext sctx) throws SPIException {
        try {
            sctx.setSecurityInfo(0, "");
            sctx.setFlagSetFlags(2, 64, 0);
        }
        catch (Throwable te2) {
            SPIException te2;
            if (te2 instanceof JCException) {
                te2 = this.resolveSPIException((Exception)((Object)((JCException)te2)), "checkAndSetSecureNCP");
            }
            throw this.nsSpiException.newException("spi27", te2.toString());
        }
    }

    private void clearSecureNCP(JCContext sctx) throws SPIException {
        try {
            sctx.setFlagSetFlags(2, 0, 64);
        }
        catch (Throwable te2) {
            SPIException te2;
            if (te2 instanceof JCException) {
                te2 = this.resolveSPIException((Exception)((Object)((JCException)te2)), "checkAndSetSecureNCP");
            }
            throw this.nsSpiException.newException("spi27", te2.toString());
        }
    }

    private void clearCache(String tree) {
        this.treeCache.remove(tree);
        this.whoamiCache.remove(tree);
        this.schemaCache.remove(tree);
        this.contextCache.remove(tree);
        this.defaultConnectionInfoCache.remove(tree);
    }

    private void setupServerIpInfo(JCContext ctx, ServerAndIpInfo saiInfo) {
        try {
            ContextAddressInfo cai = NDSNamespaceImpl.getConnectedAddressInformation(ctx, true);
            saiInfo.ipPort = cai.ipPort;
            saiInfo.ipAddress = cai.addressId;
        }
        catch (Exception ee) {
            saiInfo.ipSPIExcept = this.resolveSPIException(ee, "setupServerIpInfo");
        }
    }

    private void setupServerDNInfo(JCContext ctx, ServerAndIpInfo saiInfo) {
        try {
            String serverContext;
            saiInfo.serverDN = serverContext = ctx.getServerName();
        }
        catch (JCException je) {
            saiInfo.dnSPIExcept = this.resolveSPIException((Exception)((Object)je), "setupServerDNInfo");
        }
    }

    public String getDefaultIpAddress(ObjectEntry useOE) throws SPIException {
        String tree = useOE.getRoot().getName();
        ServerAndIpInfo saiInfo = (ServerAndIpInfo)this.defaultConnectionInfoCache.get(tree);
        if (saiInfo != null) {
            if (saiInfo.ipSPIExcept != null) {
                throw saiInfo.ipSPIExcept;
            }
            return saiInfo.ipAddress;
        }
        throw this.resolveSPIException(NamespaceException.UNSUPPORTED_OPERATION, "");
    }

    public int getDefaultIpPort(ObjectEntry useOE) throws SPIException {
        String tree = useOE.getRoot().getName();
        ServerAndIpInfo saiInfo = (ServerAndIpInfo)this.defaultConnectionInfoCache.get(tree);
        if (saiInfo != null) {
            if (saiInfo.ipSPIExcept != null) {
                throw saiInfo.ipSPIExcept;
            }
            return saiInfo.ipPort;
        }
        throw this.resolveSPIException(NamespaceException.UNSUPPORTED_OPERATION, "");
    }

    public String getDefaultServerDN(ObjectEntry useOE) throws SPIException {
        String tree = useOE.getRoot().getName();
        ServerAndIpInfo saiInfo = (ServerAndIpInfo)this.defaultConnectionInfoCache.get(tree);
        if (saiInfo != null) {
            if (saiInfo.dnSPIExcept != null) {
                throw saiInfo.dnSPIExcept;
            }
            return saiInfo.serverDN;
        }
        throw this.resolveSPIException(NamespaceException.UNSUPPORTED_OPERATION, "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void authenticate(ObjectEntry obj) throws SPIException {
        if (obj == null || obj.getRoot() == null) {
            Login loginDlg = new Login(this.shell, (Object)this, JClientRes.getString("Login Tree Label"), SEP_STRING);
            if (loginDlg != null) return;
        }
        Login loginDlg = new Login(this.shell, (Object)this, JClientRes.getString("Login Tree Label"), obj.getRoot().getName(), SEP_STRING);
        if (loginDlg != null) return;
    }

    public void authenticateServer(String serverName) throws SPIException {
    }

    public void changePassword(ObjectEntry obj, String oldPassword, String newPassword) throws SPIException {
        JCContext ctx = null;
        try {
            ctx = this.getContext(obj, 68);
            try {
                ctx.setFlagSetFlags(2, 32, 0);
            }
            catch (Throwable te) {
                Debug.out("Currently installed eDir library versions do not support changing Universal Password");
                Debug.out("  Exception: " + te.toString() + "\n");
            }
            ctx.changePassword(oldPassword, newPassword);
        }
        catch (JCException x) {
            if (x.getErrorCode() == -6042) {
                throw this.nsSpiException.newException("spi16");
            }
            throw this.resolveSPIException((Exception)((Object)x), "changePassword");
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    public void changePassword(ObjectEntry obj) throws SPIException {
        new ChangePassword(this.shell, (AuthenticationNamespace)this, obj);
    }

    public ObjectEntry getAuthenticatedIdentity(ObjectEntry obj) throws SPIException {
        String treeName = obj.getRoot().getName();
        ObjectEntry whoamiOE = (ObjectEntry)this.whoamiCache.get(treeName);
        if (whoamiOE == null) {
            String userFullName = this.getAuthenticatedIdentity(treeName);
            if (userFullName != null) {
                whoamiOE = this.getObjectEntry(userFullName);
            } else {
                ObjectEntry parentEntry = new ObjectEntry(treeName, this.treeOT, null, 6L);
                ObjectType childOt = new ObjectType("", this, false);
                whoamiOE = new ObjectEntry("[Public]", childOt, parentEntry, 0L);
            }
            this.whoamiCache.put(treeName, whoamiOE);
        }
        return whoamiOE;
    }

    public void setPassword(ObjectEntry obj, String password) throws SPIException {
        JCContext ctx = null;
        try {
            ctx = this.getContext(obj, 68);
            try {
                ctx.setFlagSetFlags(2, 32, 0);
            }
            catch (Throwable te) {
                Debug.out("Currently installed eDir library versions do not support setting Universal Password");
                Debug.out("  Exception: " + te.toString() + "\n");
            }
            ctx.generateKeyPair(password);
        }
        catch (JCException x) {
            if (x.getErrorCode() == -6042) {
                throw this.nsSpiException.newException("spi16");
            }
            throw this.resolveSPIException((Exception)((Object)x), "setPassword");
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    public void setPassword(ObjectEntry obj) throws SPIException {
        new SetPassword(this.shell, (AuthenticationNamespace)this, obj);
    }

    public void setPassword(ObjectEntry obj, boolean showSetException) throws SPIException {
        new SetPassword(this.shell, (AuthenticationNamespace)this, obj, showSetException);
    }

    public void unAuthenticate(ObjectEntry obj, String password) throws SPIException {
        this.unAuthenticate(obj);
    }

    public synchronized void unAuthenticate(ObjectEntry obj) throws SPIException {
        String tree = obj.getRoot().getName();
        JCContext ctx = (JCContext)this.contextCache.get(tree);
        ctx.free();
        this.freeFileSystemLicenseCache();
        this.clearCache(tree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isServerUp(ObjectEntry serverOE) {
        JCContext ctx = null;
        try {
            String pingedTree;
            block10: {
                ctx = this.getContext(serverOE, 2);
                ctx.connect(this.getUnrootedName(serverOE));
                try {
                    String compatTreeName = ctx.getCompatInfo(null);
                    pingedTree = this.getNameTreeDotted(compatTreeName);
                    if (!pingedTree.equalsIgnoreCase(serverOE.getRoot().getName())) break block10;
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    Debug.out("\nNote: \"" + serverOE.getName() + "\"", 1);
                    Debug.out("  This server is up but cannot determine tree name.", 1);
                    Debug.out("  Exception: " + e.toString() + "\n", 1);
                    boolean bl = false;
                    return bl;
                }
            }
            Debug.out("\nNote: \"" + serverOE.getName() + "\"", 1);
            Debug.out("  This server object is in tree \"" + serverOE.getRoot().getName() + "\"", 1);
            Debug.out("  However, the actual server was found in tree \"" + pingedTree + "\"", 1);
            Debug.out("  Therefore, for this scope, the server does not exist\n", 1);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    public boolean isSkadsServer(ObjectEntry oe) throws SPIException {
        JCContext ctx = null;
        try {
            ctx = this.getContext(oe, 2);
            JCNetworkAddress addr = ctx.getConnectedAddress();
            JCPingInfo ping = (JCPingInfo)this.serverInfoCache.get(addr.toString());
            if (ping == null) {
                ping = ctx.ping();
                this.serverInfoCache.put(addr.toString(), ping);
            }
            boolean bl = ping.buildNumber >= 800;
            return bl;
        }
        catch (JCException e) {
            throw this.resolveSPIException((Exception)((Object)e), "");
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    public String getTreeNameFromServer(String server) throws SPIException {
        try {
            String treeName = NDSNamespaceImpl.internalGetTreeNameFromID(server);
            return treeName;
        }
        catch (Exception e) {
            throw this.resolveSPIException(e, "");
        }
    }

    public static String getTreeNameFromID(String treeAddressID) {
        if (initException != null) {
            Debug.out("Unable to determine treename for " + treeAddressID + " (" + initException.toString() + ")", 1);
            return null;
        }
        try {
            String treeName = NDSNamespaceImpl.internalGetTreeNameFromID(treeAddressID);
            return treeName;
        }
        catch (Exception jce) {
            Debug.out("Unable to determine treename for " + treeAddressID + " (" + jce.toString() + ")", 1);
            return null;
        }
    }

    private static String internalGetTreeNameFromID(String treeAddressID) throws Exception {
        if (initException != null) {
            throw initException;
        }
        JCContext ctx = null;
        try {
            String compatTreeName;
            ctx = new JCContext();
            ServerAndIpInfo saiInfo = new ServerAndIpInfo();
            if (NDSNamespaceImpl.isIPAddress(treeAddressID, saiInfo)) {
                JCNetworkAddress netAddr = new JCNetworkAddress(9, saiInfo.ipAddress, (long)saiInfo.ipPort);
                try {
                    ctx.connect(0L, netAddr);
                }
                catch (JCException e) {
                    if (e.getErrorCode() == -625) {
                        ctx.connect(4L, netAddr);
                    }
                    throw e;
                }
            } else {
                StringBuffer treeBuf = new StringBuffer();
                if (treeAddressID.charAt(0) != '.') {
                    treeBuf.append('.');
                }
                treeBuf.append(treeAddressID);
                if (treeAddressID.charAt(treeAddressID.length() - 1) != '.') {
                    treeBuf.append('.');
                }
                String newTreeName = treeBuf.toString();
                ctx.setBaseDN(newTreeName, DELIMITERS);
                ctx.resolve(2, "");
            }
            String string = compatTreeName = ctx.getCompatInfo(null);
            return string;
        }
        catch (JCException jce) {
            throw jce;
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConnectedAddressFromID(String treeAddressID) {
        if (initException != null) {
            Debug.out("Unable to determine connection address for " + treeAddressID + " (" + initException.toString() + ")", 1);
            return null;
        }
        JCContext ctx = null;
        try {
            ctx = new JCContext();
            ServerAndIpInfo saiInfo = new ServerAndIpInfo();
            if (NDSNamespaceImpl.isIPAddress(treeAddressID, saiInfo)) {
                JCNetworkAddress netAddr = new JCNetworkAddress(9, saiInfo.ipAddress, (long)saiInfo.ipPort);
                try {
                    ctx.connect(0L, netAddr);
                }
                catch (JCException e) {
                    if (e.getErrorCode() == -625) {
                        ctx.connect(4L, netAddr);
                    }
                    throw e;
                }
            } else {
                StringBuffer treeBuf = new StringBuffer();
                if (treeAddressID.charAt(0) != '.') {
                    treeBuf.append('.');
                }
                treeBuf.append(treeAddressID);
                if (treeAddressID.charAt(treeAddressID.length() - 1) != '.') {
                    treeBuf.append('.');
                }
                String newTreeName = treeBuf.toString();
                ctx.setBaseDN(newTreeName, DELIMITERS);
                ctx.resolve(2, "");
            }
            ContextAddressInfo cai = NDSNamespaceImpl.getConnectedAddressInformation(ctx, false);
            String string = cai.addressId;
            return string;
        }
        catch (Exception ee) {
            Debug.out("Unable to determine connection address for " + treeAddressID + " (" + ee.toString() + ")", 1);
            String string = null;
            return string;
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    private static ContextAddressInfo getConnectedAddressInformation(JCContext jctx, boolean onlyIP) throws JCException, NamespaceException {
        ContextAddressInfo caInfo = new ContextAddressInfo();
        boolean foundIPAddress = false;
        JCNetworkAddress connectedNetAddr = jctx.getConnectedAddress();
        int tmpAddrType = connectedNetAddr.getType();
        byte[] rawIPAddress = connectedNetAddr.getAddress();
        if (tmpAddrType == 9 && rawIPAddress.length == 6) {
            foundIPAddress = true;
        } else {
            JCNetworkAddress[] tmpAddArr;
            JCReferral jcr = jctx.getServerReferral();
            if (jcr != null && (tmpAddArr = jcr.getReferral()) != null) {
                for (int ia = 0; ia < tmpAddArr.length; ++ia) {
                    tmpAddrType = tmpAddArr[ia].getType();
                    rawIPAddress = tmpAddArr[ia].getAddress();
                    if (tmpAddrType != 9 || rawIPAddress.length != 6) continue;
                    foundIPAddress = true;
                    break;
                }
            }
        }
        if (foundIPAddress) {
            caInfo.isIpAddress = true;
            byte[] portNumber = new byte[]{rawIPAddress[0], rawIPAddress[1]};
            caInfo.ipPort = Integer.parseInt(NSUtil.toHexString(portNumber), 16);
            StringBuffer ipbuff = new StringBuffer();
            ipbuff.append(NSUtil.byteToDecimal(rawIPAddress[2]));
            ipbuff.append('.');
            ipbuff.append(NSUtil.byteToDecimal(rawIPAddress[3]));
            ipbuff.append('.');
            ipbuff.append(NSUtil.byteToDecimal(rawIPAddress[4]));
            ipbuff.append('.');
            ipbuff.append(NSUtil.byteToDecimal(rawIPAddress[5]));
            caInfo.addressId = ipbuff.toString();
        } else {
            if (onlyIP) {
                throw NamespaceException.UNSUPPORTED_OPERATION;
            }
            caInfo.isIpAddress = false;
            caInfo.addressId = connectedNetAddr.toString();
            caInfo.ipPort = 0;
        }
        return caInfo;
    }

    public String getDereferencedAliasObjectDN(ObjectEntry oe) throws SPIException {
        JCContext ctx = null;
        try {
            ctx = this.getContext(oe, 66);
            JCEntryInfo entry = JClient.getEntryInfo((JCContext)ctx, (int)8192);
            String string = entry.getEntryDN().toString();
            return string;
        }
        catch (JCException e) {
            throw this.resolveSPIException((Exception)((Object)e), "");
        }
        catch (JCEntryInfoEmptyFieldException e) {
            throw this.resolveSPIException((Exception)((Object)e), "");
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    public Date getLastModificationTime(ObjectEntry oe) throws SPIException {
        JCContext ctx = null;
        try {
            ctx = this.getContext(oe, 2);
            JCEntryInfo entry = JClient.getEntryInfo((JCContext)ctx, (int)16);
            Date date = entry.getModificationTime();
            return date;
        }
        catch (JCException e) {
            throw this.resolveSPIException((Exception)((Object)e), "");
        }
        catch (JCEntryInfoEmptyFieldException e) {
            throw this.resolveSPIException((Exception)((Object)e), "");
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    public Date getCreationTime(ObjectEntry oe) throws SPIException {
        JCContext ctx = null;
        try {
            ctx = this.getContext(oe, 2);
            JCEntryInfo entry = JClient.getEntryInfo((JCContext)ctx, (int)64);
            JCTimestamp tstamp = entry.getCreationTimestamp();
            Date date = tstamp.seconds;
            return date;
        }
        catch (JCException e) {
            throw this.resolveSPIException((Exception)((Object)e), "");
        }
        catch (JCEntryInfoEmptyFieldException e) {
            throw this.resolveSPIException((Exception)((Object)e), "");
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    public PartitionService getPartitionService(ObjectEntry oe) throws SPIException {
        return new NDSPartitionServiceImpl(this, oe.getRoot());
    }

    private int byteArraySize(byte[][] byteArray) {
        int size = 0;
        for (int i = 0; i < byteArray.length; ++i) {
            size += byteArray[i].length;
        }
        return size;
    }

    public int ncpFragmentRequest(ObjectEntry oe, int ncp, int verb, byte[][] requestFrags, byte[][] replyFrags) throws SPIException {
        int size = this.byteArraySize(requestFrags);
        byte[] request = new byte[size];
        int index = 0;
        for (int i = 0; i < requestFrags.length; ++i) {
            for (int j = 0; j < requestFrags[i].length; ++j) {
                request[index++] = requestFrags[i][j];
            }
        }
        size = this.byteArraySize(replyFrags);
        byte[] reply = new byte[size];
        JCContext ctx = null;
        int ret = 0;
        try {
            ctx = this.getContext(oe, 4, oe);
            ret = JClient.ndsRequest((JCContext)ctx, (int)verb, (int)request.length, (byte[])request, (int)reply.length, (byte[])reply);
        }
        catch (JCException e) {
            throw this.resolveSPIException((Exception)((Object)e), "");
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
        index = 0;
        for (int i = 0; i < replyFrags.length; ++i) {
            for (int j = 0; j < replyFrags[i].length; ++j) {
                replyFrags[i][j] = reply[index++];
            }
        }
        return ret;
    }

    public int getMaxNameLength(ObjectEntry parentOE, AttributeDefinition attrDef) throws SPIException {
        int length = 256 - this.getUnrootedName(parentOE).length();
        if (attrDef != null) {
            if (attrDef.isSized()) {
                length = Math.min(length, (int)attrDef.getUpperBound());
            }
        } else {
            length = Math.min(length, 64);
        }
        return length;
    }

    public SPIException resolveSPIException(Exception e, String functionName) {
        SPIException exception = null;
        exception = e instanceof JCException ? this.uniqueSPIException.newException(((JCException)((Object)e)).getErrorCode(), functionName, e) : (e instanceof SPIException ? (SPIException)e : this.nsSpiException.newException(e));
        return exception;
    }

    public SPIException createSPIException(int errCode) {
        return this.uniqueSPIException.newException(errCode, "", null);
    }

    public String getUniqueID() {
        return NDSNamespace.name;
    }

    public boolean initSnapin(InitSnapinInfo info) {
        if (info != null) {
            this.shell = info.getShell();
            MAX_ITEMS_FOR_ENUMERATION = this.shell.getNDSVirtualEnumerationLimit();
            if (this.shell.getForceMasterReplica()) {
                try {
                    this.setAccessConfidence(2);
                }
                catch (Exception ne) {
                    Debug.out("\nWarning: Unable to force operations to master replica", 1);
                    Debug.out("    " + ne.toString() + "\n", 1);
                }
            }
            String[] blocked = this.shell.getTypesToBlockNativeChildrenOn(NDSNamespace.name);
            for (int i = 0; i < blocked.length; ++i) {
                this.blockedCache.put(blocked[i], null);
            }
            this.shell.addTranslatedStringResourceBundle(NDSNamespace.name, "com.novell.admin.ns.nds.jclient.JClientResourceBundle");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownSnapin() {
        try {
            this.freeFileSystemLicenseCache();
            Enumeration treeEnum = this.treeCache.keys();
            while (treeEnum.hasMoreElements()) {
                String tree = (String)treeEnum.nextElement();
                JCContext ctx = (JCContext)this.contextCache.get(tree);
                ctx.free();
                this.clearCache(tree);
            }
            Enumeration myenum = this.contextCache.keys();
            while (myenum.hasMoreElements()) {
                String tree = (String)myenum.nextElement();
                JCContext ctx = (JCContext)this.contextCache.get(tree);
                ctx.free();
                this.clearCache(tree);
            }
        }
        catch (Exception exception) {
        }
        finally {
            NDSNamespaceImpl.staticCleanup();
        }
    }

    public String getSnapinName() {
        return new String(JClientRes.getString("s1"));
    }

    public String getSnapinDescription() {
        return new String(JClientRes.getString("s2"));
    }

    public Object getContext(ObjectEntry oe) throws SPIException {
        return this.getContext(oe, 4);
    }

    JCContext getContext(String tree, int flags) throws SPIException {
        return this.getContext(tree, tree, flags);
    }

    public JCContext getContext(ObjectEntry oe, int flags) throws SPIException {
        if (oe.getAsIsParent() == null) {
            return this.getContext(oe.getRoot().getName(), oe.getName(), flags);
        }
        return this.getContext(oe.getRoot().getName(), this.getUnrootedName(oe), flags);
    }

    public JCContext getContext(ObjectEntry oe, int flags, ObjectEntry serverOE) throws SPIException {
        if (oe.getAsIsParent() == null) {
            return this.getContext(oe.getRoot().getName(), oe.getName(), flags, serverOE);
        }
        return this.getContext(oe.getRoot().getName(), this.getUnrootedName(oe), flags, serverOE);
    }

    synchronized JCContext getContext(String tree, String dn, int flags) throws SPIException {
        return this.getContext(tree, dn, flags, null);
    }

    synchronized JCContext getContext(String tree, String dn, int flags, ObjectEntry serverOE) throws SPIException {
        try {
            JCContext dup;
            block23: {
                JCContext ctx = (JCContext)this.contextCache.get(tree);
                if (ctx == null) {
                    if (this.currentTree != null) {
                        JCContext credentialedCtx = (JCContext)this.contextCache.get(this.currentTree);
                        if (credentialedCtx != null) {
                            ctx = credentialedCtx.duplicate(8192L);
                        } else {
                            ctx = new JCContext();
                            if (this.checkForSecureNCP) {
                                Debug.out("Creating new JCContext for previously unknown tree: " + tree + " and checking for Secure NCP access", 1);
                                throw this.nsSpiException.newException("spi26");
                            }
                        }
                    } else {
                        ctx = new JCContext();
                        if (this.checkForSecureNCP) {
                            Debug.out("Creating new JCContext for previously unknown tree: " + tree + " and checking for Secure NCP access", 1);
                            throw this.nsSpiException.newException("spi26");
                        }
                    }
                    ctx.setBaseDN(tree, DELIMITERS);
                    this.contextCache.put(tree, ctx);
                }
                dup = ctx.duplicate(8192L);
                if (serverOE != null) {
                    dup.connect(0L, this.getServerAddress(serverOE));
                    flags = 1;
                } else if (this.specialModeExists) {
                    if (this.accessConfidenceUseCount >= 1) {
                        flags = flags & 0xFFFFFFF9 | 8;
                    }
                    if (this.disableDereferenceMode) {
                        flags &= 0xFFFFFFBF;
                    }
                }
                String resolveDN = this.pseudoFilter(dn, tree);
                try {
                    dup.resolve(flags, resolveDN);
                }
                catch (JCException ex) {
                    int i;
                    if (-601 != ex.getErrorCode() || (flags & 0x40) != 0) {
                        throw this.resolveSPIException((Exception)((Object)ex), "");
                    }
                    for (i = 0; i < resolveDN.length() && resolveDN.charAt(i) != '.'; ++i) {
                        if (resolveDN.charAt(i) != '\\') continue;
                        ++i;
                    }
                    if (i <= 0 || i >= resolveDN.length() - 1) {
                        throw this.resolveSPIException((Exception)((Object)ex), "");
                    }
                    String resolveLeaf = resolveDN.substring(0, i);
                    String resolveParent = resolveDN.substring(i + 1, resolveDN.length());
                    try {
                        dup.resolve(flags | 0x40, resolveParent);
                        JCEntryInfo einfo = JClient.getEntryInfo((JCContext)dup, (int)8192);
                        String realDN = resolveLeaf + "." + einfo.getEntryDN();
                        dup.resolve(flags, realDN);
                    }
                    catch (Exception ex1) {
                        throw this.resolveSPIException(ex1, "");
                    }
                }
                try {
                    dup.authenticate();
                }
                catch (JCException ex) {
                    if (-601 == ex.getErrorCode()) break block23;
                    throw this.resolveSPIException((Exception)((Object)ex), "");
                }
            }
            this.currentTree = tree;
            return dup;
        }
        catch (JCException e) {
            throw this.resolveSPIException((Exception)((Object)e), "");
        }
    }

    public String escapeTheRDNDot(String rdn) {
        if (rdn != null && rdn.length() != 0 && rdn.indexOf(".") != -1) {
            int indexOfDot;
            int fromIndex = rdn.length() - 1;
            StringBuffer escapedString = new StringBuffer(rdn);
            while ((indexOfDot = rdn.lastIndexOf(".", fromIndex)) != -1) {
                if (indexOfDot > 1) {
                    boolean isEscaped = false;
                    for (int tempIndex = indexOfDot - 1; tempIndex > 0 && rdn.charAt(tempIndex) == '\\'; --tempIndex) {
                        isEscaped = !isEscaped;
                    }
                    if (!isEscaped) {
                        escapedString.insert(indexOfDot, "\\");
                    }
                } else {
                    escapedString.insert(indexOfDot, "\\");
                }
                fromIndex = indexOfDot - 1;
            }
            return escapedString.toString();
        }
        return rdn;
    }

    private JCReferral getServerAddress(ObjectEntry serverOE) throws SPIException {
        try {
            Vector<JCNetworkAddress> netAddrs = new Vector<JCNetworkAddress>();
            String[] attrs = new String[]{"Network Address"};
            ObjectAttribute oa = this.getAttributes(serverOE, attrs)[0];
            Enumeration values = oa.getValueComponents();
            while (values.hasMoreElements()) {
                NetAddressFacade netAddressFacade = (NetAddressFacade)((ValueList)values.nextElement()).createFacade();
                netAddrs.addElement(new JCNetworkAddress((int)netAddressFacade.getAddressType(), netAddressFacade.getAddress()));
            }
            Object[] jcn = new JCNetworkAddress[netAddrs.size()];
            netAddrs.copyInto(jcn);
            JCNetworkAddress prefAddr = null;
            try {
                JCContext pctx = this.getContext(serverOE, 0, null);
                prefAddr = pctx.getConnectedAddress();
                pctx.free();
            }
            catch (Exception e) {
                // empty catch block
            }
            Arrays.sort(jcn, new NetAddrComparator(prefAddr));
            return new JCReferral((JCNetworkAddress[])jcn);
        }
        catch (NamespaceException e) {
            return null;
        }
    }

    private String pseudoFilter(String dn, String tree) {
        if (dn.length() == 0) {
            return tree;
        }
        if (dn.charAt(0) == '[') {
            if (dn.equalsIgnoreCase("[Root]")) {
                return tree;
            }
            String filtered = (String)this.pseudoCache.get(dn);
            return filtered == null ? dn : filtered;
        }
        return dn;
    }

    private String pseudoReverseFilter(String dn) {
        if (dn.length() == 0 || dn.charAt(0) == '.') {
            String filtered = (String)this.pseudoReverseCache.get(dn);
            return filtered == null ? dn : filtered;
        }
        return dn;
    }

    private void modifyEntries(JCContext ctx, Vector entries) throws JCException, SPIException {
        int numEntries = entries.size();
        if (numEntries > 0) {
            JCValue[] modItemsAll = null;
            modItemsAll = new JCValue[numEntries];
            modItemsAll = entries.toArray(modItemsAll);
            this.modifyEntriesWithArray(ctx, modItemsAll);
            entries.removeAllElements();
        }
    }

    private void modifyEntriesWithArray(JCContext ctx, JCValue[] modItemsAll) throws JCException, SPIException {
        int numEntries = modItemsAll.length;
        if (numEntries > 0) {
            if (numEntries <= 250) {
                try {
                    JClient.modifyEntry((JCContext)ctx, (JCValue[])modItemsAll);
                }
                catch (JCException jce) {
                    this.secureRetryModify(ctx, jce, modItemsAll);
                }
            } else {
                JCValue[] someModItems = new JCValue[250];
                int maxEntryLoopSize = 250;
                int allArrayPos = 0;
                while (numEntries > 0) {
                    if (numEntries < 250) {
                        maxEntryLoopSize = numEntries;
                        someModItems = new JCValue[numEntries];
                    }
                    int loopcnt = 0;
                    while (loopcnt < maxEntryLoopSize) {
                        someModItems[loopcnt++] = modItemsAll[allArrayPos++];
                        --numEntries;
                    }
                    try {
                        JClient.modifyEntry((JCContext)ctx, (JCValue[])someModItems);
                    }
                    catch (JCException jce) {
                        this.secureRetryModify(ctx, jce, someModItems);
                    }
                }
            }
        }
    }

    UniqueSPIException getUniqueSPIException() {
        return this.uniqueSPIException;
    }

    private String notifyDirectoryEventListeners(int operation, ObjectEntry oldValue, ObjectEntry newValue, DirectoryEvent event) {
        ArrayList list = (ArrayList)this.directoryEventListeners.get(operation + "," + oldValue.getTypeName().toUpperCase());
        String retVal = null;
        if (list != null) {
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                DirectoryEventListener listener = (DirectoryEventListener)itr.next();
                if (event == null) {
                    event = new DirectoryEventImpl(operation, oldValue, newValue);
                } else {
                    event.setOperation(operation);
                    event.setOldValue(oldValue);
                    event.setNewValue(newValue);
                }
                if ((retVal = listener.handleDirectoryEvent(event)) == null || retVal.length() <= 0) continue;
                break;
            }
        }
        return retVal;
    }

    private String notifyDirectoryEventListeners(int operation, ObjectEntry oldValue, ObjectEntry newValue, NSObject obj, DirectoryModifyEventImpl event) {
        ArrayList list = (ArrayList)this.directoryEventListeners.get(operation + "," + oldValue.getTypeName().toUpperCase());
        String retVal = null;
        if (list != null) {
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                DirectoryEventListener listener = (DirectoryEventListener)itr.next();
                String[] modifiedAttributes = obj.getModifiedAttributes();
                Hashtable modified = this.getAttributeValueTable(modifiedAttributes, obj);
                String[] addedAttributes = obj.getAddedAttributes();
                Hashtable added = this.getAttributeValueTable(addedAttributes, obj);
                String[] deletedAttributes = obj.getDeletedAttributes();
                Hashtable deleted = this.getAttributeValueTable(deletedAttributes, obj);
                ModifiedAttributeDefinition attributeDef = new ModifiedAttributeDefinition(added, modified, deleted);
                if (event == null) {
                    event = new DirectoryModifyEventImpl(operation, oldValue, newValue, attributeDef);
                } else {
                    event.setOperation(operation);
                    event.setOldValue(oldValue);
                    event.setNewValue(newValue);
                    event.setModifiedAttributes(attributeDef);
                }
                if ((retVal = listener.handleDirectoryEvent(event)) == null || retVal.length() <= 0) continue;
                break;
            }
        }
        return retVal;
    }

    private Hashtable getAttributeValueTable(String[] attributes, NSObject obj) {
        Hashtable<String, ObjectAttribute> table = new Hashtable<String, ObjectAttribute>();
        for (int i = 0; i < attributes.length; ++i) {
            ObjectAttribute attribute = obj.getAttribute(attributes[i]);
            table.put(attributes[i], attribute);
        }
        return table;
    }

    private boolean isTreeEntryOnly(String tree) {
        return tree.charAt(0) == '.' && tree.charAt(tree.length() - 1) == '.';
    }

    private String getNameTreeDotted(String treeName) {
        StringBuffer strBuf;
        if (treeName.charAt(0) != '.') {
            strBuf = new StringBuffer();
            strBuf.append('.');
            strBuf.append(treeName);
        } else {
            if (treeName.charAt(treeName.length() - 1) == '.') {
                return treeName;
            }
            strBuf = new StringBuffer();
            strBuf.append(treeName);
        }
        if (treeName.charAt(treeName.length() - 1) != '.') {
            strBuf.append('.');
        }
        return strBuf.toString();
    }

    private String getNameTree(String fdn) throws SPIException {
        if (this.isTreeEntryOnly(fdn)) {
            return this.getNameTreeDotted(fdn);
        }
        if (fdn.length() > 1 && fdn.charAt(fdn.length() - 1) == '.' && fdn.charAt(fdn.length() - 2) != '\\') {
            int end = fdn.length() - 1;
            int beg = fdn.lastIndexOf(46, end - 1);
            if (beg == -1) {
                return this.currentTree;
            }
            return fdn.substring(beg);
        }
        return this.currentTree;
    }

    private String getNameDN(String fdn) throws SPIException {
        if (this.isTreeEntryOnly(fdn)) {
            return "";
        }
        if (fdn.length() > 1 && fdn.charAt(fdn.length() - 1) == '.' && fdn.charAt(fdn.length() - 2) != '\\') {
            int end = fdn.length() - 1;
            int beg = fdn.lastIndexOf(46, end - 1);
            if (beg == -1) {
                return fdn;
            }
            return fdn.substring(0, beg);
        }
        return fdn;
    }

    private NDSSchema getSchema(ObjectEntry obj) throws SPIException {
        return this.getSchema(obj.getRoot().getName());
    }

    private NDSSchema getSchema(String tree) throws SPIException {
        NDSSchema schema = (NDSSchema)this.schemaCache.get(tree);
        if (schema == null) {
            schema = new NDSSchemaImpl(this, tree);
            this.schemaCache.put(tree, schema);
        }
        return schema;
    }

    private String getAuthenticatedIdentity(String tree) throws SPIException {
        String userFDN = null;
        if (this.contextCache.get(tree) == null) {
            return null;
        }
        JCContext ctx = null;
        try {
            ctx = this.getContext(tree, 2);
            StringBuffer userFullName = new StringBuffer(ctx.getIdentityName());
            userFullName.append(tree);
            String string = userFDN = userFullName.toString();
            return string;
        }
        catch (JCException e) {
            throw this.resolveSPIException((Exception)((Object)e), "");
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    private Vector convertToJCValue(ObjectAttribute objAttr, int mode, String treeName) {
        Vector<Object> attr = new Vector<Object>();
        try {
            String attrName = objAttr.getAttributeDefinition().getName();
            Enumeration<ValueComponent> values = objAttr.getValueComponents();
            if (mode == 3) {
                values = new Vector<ValueComponent>(Arrays.asList(objAttr.getDeletedComponents())).elements();
                mode = 7;
            }
            switch (objAttr.getAttributeDefinition().getSyntax().getId()) {
                case 0: {
                    break;
                }
                case 1: {
                    while (values.hasMoreElements()) {
                        String distName = ((StringValue)values.nextElement()).getValue();
                        distName = this.pseudoFilter(distName, treeName);
                        attr.addElement(new JCDistnameValue(attrName, mode, 0L, new JCTimestamp(), distName));
                    }
                    break;
                }
                case 2: {
                    while (values.hasMoreElements()) {
                        attr.addElement(new JCCEstringValue(attrName, mode, 0L, new JCTimestamp(), ((StringValue)values.nextElement()).getValue()));
                    }
                    break;
                }
                case 3: {
                    while (values.hasMoreElements()) {
                        attr.addElement(new JCCIstringValue(attrName, mode, 0L, new JCTimestamp(), ((StringValue)values.nextElement()).getValue()));
                    }
                    break;
                }
                case 4: {
                    while (values.hasMoreElements()) {
                        attr.addElement(new JCPRstringValue(attrName, mode, 0L, new JCTimestamp(), ((StringValue)values.nextElement()).getValue()));
                    }
                    break;
                }
                case 5: {
                    while (values.hasMoreElements()) {
                        attr.addElement(new JCNUstringValue(attrName, mode, 0L, new JCTimestamp(), ((StringValue)values.nextElement()).getValue()));
                    }
                    break;
                }
                case 6: {
                    while (values.hasMoreElements()) {
                        CaseIgnoreListFacade caseIgnoreListFacade = new CaseIgnoreListFacade((ValueList)values.nextElement());
                        attr.addElement(new JCCIlistValue(attrName, mode, 0L, new JCTimestamp(), caseIgnoreListFacade.getStrings()));
                    }
                    break;
                }
                case 7: {
                    while (values.hasMoreElements()) {
                        attr.addElement(new JCBooleanValue(attrName, mode, 0L, new JCTimestamp(), ((BooleanValue)values.nextElement()).getValue()));
                    }
                    break;
                }
                case 8: {
                    while (values.hasMoreElements()) {
                        attr.addElement(new JCIntegerValue(attrName, mode, 0L, new JCTimestamp(), ((LongValue)values.nextElement()).getValue()));
                    }
                    break;
                }
                case 9: {
                    while (values.hasMoreElements()) {
                        attr.addElement(new JCOctetstringValue(attrName, mode, 0L, new JCTimestamp(), ((HexValue)values.nextElement()).getValue()));
                    }
                    break;
                }
                case 10: {
                    while (values.hasMoreElements()) {
                        attr.addElement(new JCTelnumberValue(attrName, mode, 0L, new JCTimestamp(), ((StringValue)values.nextElement()).getValue()));
                    }
                    break;
                }
                case 11: {
                    while (values.hasMoreElements()) {
                        FaxNumberFacade faxNumberFacade = new FaxNumberFacade((ValueList)values.nextElement());
                        attr.addElement(new JCFaxnumberValue(attrName, mode, 0L, new JCTimestamp(), faxNumberFacade.getTeleNumber(), 0, null));
                    }
                    break;
                }
                case 12: {
                    while (values.hasMoreElements()) {
                        NetAddressFacade netAddressFacade = new NetAddressFacade((ValueList)values.nextElement());
                        attr.addElement(new JCNetaddressValue(attrName, mode, 0L, new JCTimestamp(), new JCNetworkAddress((int)netAddressFacade.getAddressType(), netAddressFacade.getAddress())));
                    }
                    break;
                }
                case 13: {
                    while (values.hasMoreElements()) {
                        OctetListFacade octetListFacade = new OctetListFacade((ValueList)values.nextElement());
                        attr.addElement(new JCOctetlistValue(attrName, mode, 0L, new JCTimestamp(), octetListFacade.getOctets()));
                    }
                    break;
                }
                case 14: {
                    while (values.hasMoreElements()) {
                        EmailAddressFacade emailAddressFacade = new EmailAddressFacade((ValueList)values.nextElement());
                        attr.addElement(new JCEmailValue(attrName, mode, 0L, new JCTimestamp(), emailAddressFacade.getAddress(), (int)emailAddressFacade.getType()));
                    }
                    break;
                }
                case 15: {
                    while (values.hasMoreElements()) {
                        PathFacade pathFacade = new PathFacade((ValueList)values.nextElement());
                        attr.addElement(new JCPathValue(attrName, mode, 0L, new JCTimestamp(), pathFacade.getVolume(), pathFacade.getPath(), (int)pathFacade.getType()));
                    }
                    break;
                }
                case 17: {
                    while (values.hasMoreElements()) {
                        ObjectACLFacade objectACLFacade = new ObjectACLFacade((ValueList)values.nextElement());
                        String subject = this.pseudoFilter(objectACLFacade.getSubjectName(), treeName);
                        attr.addElement(new JCAclValue(attrName, mode, 0L, new JCTimestamp(), objectACLFacade.getProtectedAttrName(), subject, objectACLFacade.getPrivileges()));
                    }
                    break;
                }
                case 18: {
                    while (values.hasMoreElements()) {
                        PostalAddressFacade postalAddressFacade = new PostalAddressFacade((ValueList)values.nextElement());
                        attr.addElement(new JCPostaladdressValue(attrName, mode, 0L, new JCTimestamp(), postalAddressFacade.getLines()));
                    }
                    break;
                }
                case 19: {
                    while (values.hasMoreElements()) {
                        TimeStampFacade timeStampFacade = new TimeStampFacade((ValueList)values.nextElement());
                        attr.addElement(new JCTimestampValue(attrName, mode, 0L, new JCTimestamp(), (long)timeStampFacade.getSeconds(), timeStampFacade.getEvent(), timeStampFacade.getReplica()));
                    }
                    break;
                }
                case 20: {
                    while (values.hasMoreElements()) {
                        attr.addElement(new JCClassnameValue(attrName, mode, 0L, new JCTimestamp(), ((StringValue)values.nextElement()).getValue()));
                    }
                    break;
                }
                case 21: {
                    while (values.hasMoreElements()) {
                        attr.addElement(new JCStreamValue(attrName, mode, 0L, new JCTimestamp()));
                        values.nextElement();
                    }
                    break;
                }
                case 22: {
                    while (values.hasMoreElements()) {
                        attr.addElement(new JCCounterValue(attrName, mode, 0L, new JCTimestamp(), (int)((LongValue)values.nextElement()).getValue()));
                    }
                    break;
                }
                case 23: {
                    while (values.hasMoreElements()) {
                        BackLinkFacade backLinkFacade = new BackLinkFacade((ValueList)values.nextElement());
                        attr.addElement(new JCBacklinkValue(attrName, mode, 0L, new JCTimestamp(), backLinkFacade.getRemoteId(), backLinkFacade.getObjectName()));
                    }
                    break;
                }
                case 24: {
                    while (values.hasMoreElements()) {
                        attr.addElement(new JCTimeValue(attrName, mode, 0L, new JCTimestamp(), ((DateValue)values.nextElement()).getValue().getTime() / 1000L));
                    }
                    break;
                }
                case 25: {
                    while (values.hasMoreElements()) {
                        TypedNameFacade typedNameFacade = new TypedNameFacade((ValueList)values.nextElement());
                        attr.addElement(new JCTypednameValue(attrName, mode, 0L, new JCTimestamp(), typedNameFacade.getObject(), (int)typedNameFacade.getLevel(), (int)typedNameFacade.getInterval()));
                    }
                    break;
                }
                case 26: {
                    while (values.hasMoreElements()) {
                        HoldFacade holdFacade = new HoldFacade((ValueList)values.nextElement());
                        attr.addElement(new JCHoldValue(attrName, mode, 0L, new JCTimestamp(), holdFacade.getAmount(), holdFacade.getSubject()));
                    }
                    break;
                }
                case 27: {
                    while (values.hasMoreElements()) {
                        attr.addElement(new JCIntervalValue(attrName, mode, 0L, new JCTimestamp(), (long)((int)((LongValue)values.nextElement()).getValue())));
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attr;
    }

    private JCValue createEmptyJCValue(ObjectAttribute objAttr, int mode) {
        JCDistnameValue retJCValue = null;
        switch (objAttr.getAttributeDefinition().getSyntax().getId()) {
            case 0: {
                break;
            }
            case 1: {
                retJCValue = new JCDistnameValue();
                break;
            }
            case 2: {
                retJCValue = new JCCEstringValue();
                break;
            }
            case 3: {
                retJCValue = new JCCIstringValue();
                break;
            }
            case 4: {
                retJCValue = new JCPRstringValue();
                break;
            }
            case 5: {
                retJCValue = new JCNUstringValue();
                break;
            }
            case 6: {
                retJCValue = new JCCIlistValue();
                break;
            }
            case 7: {
                retJCValue = new JCBooleanValue();
                break;
            }
            case 8: {
                retJCValue = new JCIntegerValue();
                break;
            }
            case 9: {
                retJCValue = new JCOctetstringValue();
                break;
            }
            case 10: {
                retJCValue = new JCTelnumberValue();
                break;
            }
            case 11: {
                retJCValue = new JCFaxnumberValue();
                break;
            }
            case 12: {
                retJCValue = new JCNetaddressValue();
                break;
            }
            case 13: {
                retJCValue = new JCOctetlistValue();
                break;
            }
            case 14: {
                retJCValue = new JCEmailValue();
                break;
            }
            case 15: {
                retJCValue = new JCPathValue();
                break;
            }
            case 17: {
                retJCValue = new JCAclValue();
                break;
            }
            case 18: {
                retJCValue = new JCPostaladdressValue();
                break;
            }
            case 19: {
                retJCValue = new JCTimestampValue();
                break;
            }
            case 20: {
                retJCValue = new JCClassnameValue();
                break;
            }
            case 21: {
                retJCValue = new JCStreamValue();
                break;
            }
            case 22: {
                retJCValue = new JCCounterValue();
                break;
            }
            case 23: {
                retJCValue = new JCBacklinkValue();
                break;
            }
            case 24: {
                retJCValue = new JCTimeValue();
                break;
            }
            case 25: {
                retJCValue = new JCTypednameValue();
                break;
            }
            case 26: {
                retJCValue = new JCHoldValue();
                break;
            }
            case 27: {
                retJCValue = new JCIntervalValue();
            }
        }
        if (retJCValue != null) {
            retJCValue.attributeName = objAttr.getAttributeDefinition().getName();
            retJCValue.operation = mode;
        }
        return retJCValue;
    }

    private synchronized void setAuxAttribute(NSObject obj, Vector mandAttribVec) throws SPIException {
        String treeName = obj.getObjectEntry().getRoot().getName();
        Vector modItems = new Vector();
        ObjectAttribute objAttr = obj.getAttribute("Object Class");
        ObjectAttribute attrValToDelete = new ObjectAttribute(objAttr.getAttributeDefinition());
        ObjectAttribute attrValToAdd = new ObjectAttribute(objAttr.getAttributeDefinition());
        this.getModifiedAttributeValues(objAttr, attrValToAdd, attrValToDelete, false);
        if (attrValToAdd.getComponentCount() == 0) {
            return;
        }
        modItems = this.convertToJCValue(attrValToAdd, 2, treeName);
        objAttr.clearAddedAttributeValues();
        objAttr.clearDeletedAttributeValues();
        objAttr.resetBeginningAttributeValues();
        obj.clearModifiedAttribute(objAttr.getName());
        for (int i = 0; i < mandAttribVec.size(); ++i) {
            objAttr = obj.getAttribute((String)mandAttribVec.elementAt(i));
            Vector mandAttr = null;
            mandAttr = this.convertToJCValue(objAttr, 2, treeName);
            for (int j = 0; mandAttr != null && j < mandAttr.size(); ++j) {
                modItems.addElement(mandAttr.elementAt(j));
            }
            objAttr.clearAddedAttributeValues();
            objAttr.clearDeletedAttributeValues();
            objAttr.resetBeginningAttributeValues();
            obj.clearModifiedAttribute(objAttr.getName());
        }
        if (null != modItems) {
            JCContext ctx = null;
            try {
                ctx = this.getContext(obj.getObjectEntry(), 68);
                this.modifyEntries(ctx, modItems);
            }
            catch (Exception x) {
                throw this.resolveSPIException(x, "");
            }
            finally {
                if (ctx != null) {
                    ctx.free();
                }
            }
        }
    }

    private void setAttribute(ObjectEntry obj, ObjectAttribute objAttr, int modifyMode) throws SPIException {
        this.setAttributeImpl(obj, objAttr, modifyMode, null);
    }

    private synchronized void setAttributeImpl(ObjectEntry obj, ObjectAttribute objAttr, int modifyMode, ObjectEntry serverOE) throws SPIException {
        Vector attr = null;
        String treeName = obj.getRoot().getName();
        if (modifyMode == 5) {
            ObjectAttribute attrValToDelete = new ObjectAttribute(objAttr.getAttributeDefinition());
            ObjectAttribute attrValToAdd = new ObjectAttribute(objAttr.getAttributeDefinition());
            this.getModifiedAttributeValues(objAttr, attrValToAdd, attrValToDelete, false);
            if (attrValToDelete.getComponentCount() == 0 && attrValToAdd.getComponentCount() == 0) {
                return;
            }
            if (attrValToDelete.getComponentCount() > 0) {
                if (objAttr.getAttributeDefinition().getSyntax() == NDSSyntax.SYN_STREAM) {
                    if (attrValToAdd.getComponentCount() == 0) {
                        this.deleteStreamValue(obj, objAttr, serverOE);
                    }
                } else {
                    attr = this.convertToJCValue(attrValToDelete, 7, treeName);
                }
            }
            if (attrValToAdd.getComponentCount() > 0) {
                Vector addAttr = null;
                if (objAttr.getAttributeDefinition().getSyntax() == NDSSyntax.SYN_STREAM) {
                    if (attrValToDelete.getComponentCount() == 0) {
                        this.addStreamValue(obj, objAttr, 0, serverOE);
                    } else {
                        this.addStreamValue(obj, objAttr, 5, serverOE);
                    }
                } else {
                    addAttr = objAttr.getAttributeDefinition().isSingleValued() ? this.convertToJCValue(attrValToAdd, 5, treeName) : this.convertToJCValue(attrValToAdd, 2, treeName);
                }
                if (null == attr) {
                    attr = addAttr;
                } else if (null != addAttr) {
                    for (int i = 0; i < addAttr.size(); ++i) {
                        attr.addElement(addAttr.elementAt(i));
                    }
                }
            }
        } else if (objAttr.getAttributeDefinition().getSyntax() == NDSSyntax.SYN_STREAM) {
            this.addStreamValue(obj, objAttr, 0, serverOE);
        } else {
            attr = this.convertToJCValue(objAttr, modifyMode, treeName);
        }
        if (null != attr) {
            JCContext ctx = null;
            try {
                ctx = serverOE == null ? this.getContext(obj, 68) : this.getContext(obj, 68, serverOE);
                this.modifyEntries(ctx, attr);
            }
            catch (Exception x) {
                throw this.resolveSPIException(x, "");
            }
            finally {
                if (ctx != null) {
                    ctx.free();
                }
            }
        }
    }

    private synchronized void deleteAttributeImpl(ObjectEntry obj, String attrName, ObjectEntry serverOE) throws SPIException {
        JCContext ctx = null;
        try {
            ctx = serverOE == null ? this.getContext(obj, 68) : this.getContext(obj, 68, serverOE);
            try {
                JClient.removeAttribute((JCContext)ctx, (String)attrName);
            }
            catch (JCException jce) {
                this.secureRetryRemoveAttribute(ctx, jce, attrName);
            }
        }
        catch (Exception x) {
            throw this.resolveSPIException(x, "");
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    private void getModifiedAttributeValues(ObjectAttribute objAttr, ObjectAttribute attrAddValues, ObjectAttribute attrRemoveValues, boolean isNaming) {
        int i;
        int i2;
        Object[] modifiedValues = objAttr.getModifiedComponents();
        if (isNaming) {
            Vector<Object> aVec = new Vector<Object>();
            for (int i3 = 0; i3 < modifiedValues.length; ++i3) {
                if (modifiedValues[i3].getOldValue().equals(objAttr.getBeginningComponents()[0])) continue;
                aVec.addElement(modifiedValues[i3]);
            }
            modifiedValues = new ObjectAttribute.ModifyValue[aVec.size()];
            aVec.copyInto(modifiedValues);
        }
        Object[] addValues = objAttr.getAddedComponents();
        Vector<ValueComponent> bVec = new Vector<ValueComponent>();
        for (i2 = 0; i2 < addValues.length; ++i2) {
            bVec.addElement(addValues[i2]);
        }
        for (i2 = 0; i2 < modifiedValues.length; ++i2) {
            bVec.addElement(((ObjectAttribute.ModifyValue)modifiedValues[i2]).getNewValue());
        }
        if (!bVec.isEmpty()) {
            addValues = new ValueComponent[bVec.size()];
            bVec.copyInto(addValues);
            try {
                attrAddValues.addComponents((ValueComponent[])addValues);
            }
            catch (NamespaceException x) {
                // empty catch block
            }
        }
        Object[] removeValues = objAttr.getDeletedComponents();
        Vector<ValueComponent> cVec = new Vector<ValueComponent>();
        for (i = 0; i < removeValues.length; ++i) {
            cVec.addElement(removeValues[i]);
        }
        for (i = 0; i < modifiedValues.length; ++i) {
            cVec.addElement(((ObjectAttribute.ModifyValue)modifiedValues[i]).getOldValue());
        }
        if (!cVec.isEmpty()) {
            removeValues = new ValueComponent[cVec.size()];
            cVec.copyInto(removeValues);
            try {
                attrRemoveValues.addComponents((ValueComponent[])removeValues);
            }
            catch (NamespaceException x) {
                // empty catch block
            }
        }
    }

    private String[] getNamingAttributesForObject(ObjectEntry entry) throws SPIException, NamespaceException {
        Vector<String> namingAttrVec = new Vector<String>();
        ClassDefinition classDef = this.getClassDefinition(entry, entry.getObjectType().getName());
        AttributeDefinition[] namingAtributes = classDef.getNamingAttributes();
        for (int i = 0; i < namingAtributes.length; ++i) {
            if (!classDef.isAttributeMandatory(namingAtributes[i].getName()) || namingAttrVec.contains(namingAtributes[i].getName())) continue;
            namingAttrVec.addElement(namingAtributes[i].getName());
        }
        if (namingAttrVec.isEmpty()) {
            NSObject nsobject = this.getDetails(entry);
            for (int i = 0; i < namingAtributes.length; ++i) {
                ObjectAttribute namingAttr;
                if (namingAttrVec.contains(namingAtributes[i].getName()) || (namingAttr = nsobject.getAttribute(namingAtributes[i].getName())) == null || !namingAttr.getValueComponents().nextElement().toString().equals(entry.getName())) continue;
                namingAttrVec.addElement(namingAtributes[i].getName());
            }
        }
        Object[] namingAttrs = new String[namingAttrVec.size()];
        namingAttrVec.copyInto(namingAttrs);
        return namingAttrs;
    }

    private void addStreamValue(ObjectEntry oe, ObjectAttribute objAttr, int modifyMode, ObjectEntry serverOE) throws SPIException {
        JCContext ctx = null;
        try {
            String attributeName = objAttr.getAttributeDefinition().getName();
            Enumeration valueSet = objAttr.getValueComponents();
            while (valueSet.hasMoreElements()) {
                InputStream inStream = ((StreamValue)valueSet.nextElement()).getValue();
                byte[] buffer = new byte[inStream.available()];
                inStream.read(buffer);
                ctx = serverOE == null ? this.getContext(oe, 68) : this.getContext(oe, 68, serverOE);
                if (modifyMode == 5) {
                    JCStreamValue clearValue = new JCStreamValue(attributeName, 1, 0L, new JCTimestamp());
                    JCStreamValue streamValue = new JCStreamValue(attributeName, 0, 0L, new JCTimestamp());
                    JCValue[] modItemArray = new JCValue[]{clearValue, streamValue};
                    try {
                        JClient.modifyEntry((JCContext)ctx, (JCValue[])modItemArray);
                    }
                    catch (JCException jce) {
                        this.secureRetryModify(ctx, jce, modItemArray);
                    }
                } else {
                    JCStreamValue streamValue = new JCStreamValue(attributeName, modifyMode, 0L, new JCTimestamp());
                    JCValue[] modItemArray = new JCValue[]{streamValue};
                    try {
                        JClient.modifyEntry((JCContext)ctx, (JCValue[])modItemArray);
                    }
                    catch (JCException jce) {
                        this.secureRetryModify(ctx, jce, modItemArray);
                    }
                }
                this.writeActualStreamBuffer(ctx, attributeName, buffer);
            }
        }
        catch (Exception x) {
            throw this.resolveSPIException(x, "");
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    private void writeActualStreamBuffer(JCContext ctx, String attributeName, byte[] buffer) throws JCException, SPIException {
        boolean updated = false;
        int lcount = 0;
        while (!updated) {
            try {
                try {
                    JClient.openStream((JCContext)ctx, (String)attributeName, (int)2);
                }
                catch (JCException jce) {
                    this.secureRetryOpenStream(ctx, jce, attributeName, 2);
                }
                try {
                    JClient.writeStream((JCContext)ctx, (long)0L, (long)buffer.length, (byte[])buffer);
                }
                catch (JCException jce) {
                    this.secureRetryWriteStream(ctx, jce, 0L, buffer.length, buffer);
                }
                updated = true;
                try {
                    JClient.closeStream((JCContext)ctx);
                }
                catch (JCException jce) {
                    this.secureRetryCloseStream(ctx, jce);
                }
            }
            catch (JCException jce) {
                int errorCode = jce.getErrorCode();
                if ((errorCode == -128 || errorCode == -255) && lcount++ <= 7) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (Exception ex) {}
                    continue;
                }
                updated = true;
                throw jce;
            }
        }
    }

    private void deleteStreamValue(ObjectEntry oe, ObjectAttribute objAttr, ObjectEntry serverOE) throws SPIException {
        JCContext ctx = null;
        try {
            String attributeName = objAttr.getAttributeDefinition().getName();
            ctx = serverOE == null ? this.getContext(oe, 68) : this.getContext(oe, 68, serverOE);
            JCStreamValue streamValue = new JCStreamValue(attributeName, 1, 0L, new JCTimestamp());
            JCValue[] modItemArray = new JCValue[]{streamValue};
            try {
                JClient.modifyEntry((JCContext)ctx, (JCValue[])modItemArray);
            }
            catch (JCException jce) {
                this.secureRetryModify(ctx, jce, modItemArray);
            }
        }
        catch (Exception x) {
            throw this.resolveSPIException(x, "");
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    private static boolean isIPAddress(String tree, ServerAndIpInfo retSaiInfo) {
        if (tree.indexOf(46) >= 0) {
            try {
                String treeAddress;
                block8: {
                    int colonOff = tree.indexOf(58);
                    if (colonOff >= 0) {
                        try {
                            treeAddress = tree.substring(0, colonOff);
                            String portStr = tree.substring(colonOff + 1);
                            if (portStr != null && portStr.length() >= 1) {
                                retSaiInfo.ipPort = Integer.parseInt(portStr);
                                break block8;
                            }
                            retSaiInfo.ipPort = 524;
                        }
                        catch (IndexOutOfBoundsException iobe) {
                            treeAddress = tree;
                            retSaiInfo.ipPort = 524;
                        }
                    } else {
                        treeAddress = tree;
                        retSaiInfo.ipPort = 524;
                    }
                }
                InetAddress na = InetAddress.getByName(treeAddress);
                retSaiInfo.ipAddress = na.getHostAddress();
                return true;
            }
            catch (UnknownHostException uhe) {
                return false;
            }
        }
        return false;
    }

    public boolean isSupported(String key, Object param, ObjectEntry oe) throws NamespaceException, SPIException {
        if (key == null || key.length() == 0) {
            throw NamespaceException.INVALID_NAME;
        }
        SchemaDefinition schdef = null;
        if (oe == null) {
            if (this.currentTree != null) {
                schdef = this.getSchema(this.currentTree).getSchemaDefinition();
            }
        } else {
            schdef = this.getSchemaDefinition(oe);
        }
        if (schdef == null) {
            throw NamespaceException.INVALID_NAME;
        }
        if (key.equalsIgnoreCase("NVDS")) {
            return false;
        }
        if (key.equalsIgnoreCase("eDir") || key.equalsIgnoreCase("eDirectory")) {
            return true;
        }
        if (!(param instanceof String) || ((String)param).length() == 0) {
            return false;
        }
        String sparam = (String)param;
        try {
            if (key.equalsIgnoreCase("Class")) {
                return schdef.getClassDefinition(sparam) != null;
            }
        }
        catch (Exception e) {
            return false;
        }
        try {
            if (key.equalsIgnoreCase("Attribute") || key.equalsIgnoreCase("Attr")) {
                return schdef.getAttributeDefinition(sparam) != null;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public boolean isSupported(String key, Object param) throws NamespaceException, SPIException {
        return this.isSupported(key, param, null);
    }

    public boolean isSupported(String key) throws NamespaceException, SPIException {
        return this.isSupported(key, null, null);
    }

    public int getAccessConfidence() throws NamespaceException {
        if (this.accessConfidenceUseCount > 0) {
            return 2;
        }
        return 1;
    }

    public void setAccessConfidence(int newConfidence) throws NamespaceException, SPIException {
        if (newConfidence == 1) {
            if (this.accessConfidenceUseCount >= 1) {
                --this.accessConfidenceUseCount;
                if (this.accessConfidenceUseCount <= 0 && !this.disableDereferenceMode) {
                    this.specialModeExists = false;
                }
            }
        } else if (newConfidence == 2) {
            ++this.accessConfidenceUseCount;
            this.specialModeExists = true;
        } else {
            throw NamespaceException.UNSUPPORTED_OPERATION;
        }
    }

    public int getAliasDereference() throws NamespaceException {
        if (this.disableDereferenceMode) {
            return 2;
        }
        return 1;
    }

    public void setAliasDereference(int newDereference) throws NamespaceException {
        if (newDereference == 1) {
            this.disableDereferenceMode = false;
            if (this.accessConfidenceUseCount <= 0) {
                this.specialModeExists = false;
            }
        } else if (newDereference == 2) {
            this.disableDereferenceMode = true;
            this.specialModeExists = true;
        } else {
            throw NamespaceException.UNSUPPORTED_OPERATION;
        }
    }

    public void freeObjectEntryEnumeration(ObjectEntryEnumeration oeEnum) throws SPIException {
        if (oeEnum instanceof BrowserObjectEntryEnumerationImpl) {
            ((BrowserObjectEntryEnumerationImpl)oeEnum).close();
        } else if (oeEnum instanceof VirtualObjectEntryEnumerationImpl) {
            ((VirtualObjectEntryEnumerationImpl)oeEnum).close();
        }
        oeEnum = null;
    }

    public boolean isFileSystemObject(String nameToCheck) throws SPIException {
        boolean isFSObject = false;
        if (nameToCheck.charAt(0) == '<' && nameToCheck.startsWith(FS_FEDERATED_BEGINTAG) && nameToCheck.indexOf(FS_FEDERATED_ENDTAG) != -1) {
            isFSObject = true;
        }
        return isFSObject;
    }

    public String[] getFileSystemAndDirectoryElements(String nameToParse) throws SPIException {
        return this.parseFSFederatedParts(nameToParse);
    }

    public ObjectEntry getFileSystemObjectEntry(String DirectoryStr, String FileSystemStr) throws SPIException {
        StringBuffer fsObjName = new StringBuffer(60);
        fsObjName.append(FS_FEDERATED_BEGINTAG);
        fsObjName.append(FileSystemStr);
        fsObjName.append(FS_FEDERATED_ENDTAG);
        fsObjName.append(SEP_STRING);
        fsObjName.append(DirectoryStr);
        return this.getObjectEntry(fsObjName.toString());
    }

    private ObjectEntry getFSObjectEntryWithFSOE(ObjectEntry parentEntry, String objEntryStr) throws SPIException {
        Object[] dfna = this.getDirOEAndFileName(parentEntry);
        String parentFileName = (String)dfna[1];
        String fullFileStr = parentFileName == null ? objEntryStr : (parentFileName.charAt(parentFileName.length() - 1) == ':' ? parentFileName + objEntryStr : parentFileName + "\\" + objEntryStr);
        ObjectEntry retFSOE = this.getFSObjectEntryWithDirOE((ObjectEntry)dfna[0], fullFileStr);
        return retFSOE;
    }

    private Object[] getDirOEAndFileName(ObjectEntry fobj) throws SPIException {
        StringBuffer fsObjBuf = new StringBuffer(30);
        while (fobj.getObjectType().isFileSystem()) {
            String asIsName = fobj.getAsIsName();
            if (asIsName.charAt(asIsName.length() - 1) == ':' || fsObjBuf.length() <= 0) {
                fsObjBuf.insert(0, asIsName);
            } else {
                fsObjBuf.insert(0, asIsName + "\\");
            }
            fobj = fobj.getAsIsParent();
        }
        Object[] robja = new Object[]{fobj, fsObjBuf.length() <= 0 ? null : fsObjBuf.toString()};
        return robja;
    }

    private ObjectEntry getFSObjectEntryWithDirOE(ObjectEntry dirOE, String fileObjEntryStr) throws SPIException {
        String fsVolumeNameWColon;
        String serverNameDN;
        String objTypeName = dirOE.getObjectType().getName();
        ObjectEntry retFSOE = null;
        if (objTypeName.equalsIgnoreCase("Volume")) {
            String[] sarr = this.getServerDNAndVolId(dirOE);
            serverNameDN = sarr[0];
            fsVolumeNameWColon = sarr[1] + ":";
        } else if (objTypeName.equalsIgnoreCase("NCP Server")) {
            serverNameDN = this.getUnrootedName(dirOE);
            fsVolumeNameWColon = this.getVolumeNameWColon(fileObjEntryStr);
        } else {
            throw this.resolveSPIException(NamespaceException.UNSUPPORTED_OPERATION, "");
        }
        String simpleServerNameDN = this.getSimpleServerNameFromServerDN(serverNameDN);
        String expectedfsSerVolName = "\\\\" + simpleServerNameDN + "\\" + fsVolumeNameWColon;
        if (fileObjEntryStr.startsWith(expectedfsSerVolName)) {
            int begidx = expectedfsSerVolName.length();
            String tmpDirFileName = fileObjEntryStr.substring(begidx);
            if (tmpDirFileName.length() <= 0) {
                ObjectType fsVolObjType = this.getFSObjectType(1);
                int newObjectFlags = 4;
                retFSOE = new ObjectEntry(fileObjEntryStr, fsVolObjType, dirOE, newObjectFlags, false);
            } else {
                NSFileObject nsfo = this.newNSFileObject(tmpDirFileName);
                JCContext fs_ctx = this.getFileSystemContext(serverNameDN);
                this.getNSFileObjectTypesWithFSContext(fs_ctx, fsVolumeNameWColon, new NSFileObject[]{nsfo});
                long newObjectFlags = 0L;
                switch (nsfo.getType()) {
                    case 1: {
                        ObjectType fsTypeFile = this.getFSObjectType(3);
                        if (nsfo.isJunctionFile()) {
                            newObjectFlags = 64L;
                        }
                        retFSOE = new ObjectEntry(fileObjEntryStr, fsTypeFile, dirOE, newObjectFlags, true);
                        break;
                    }
                    case 2: {
                        ObjectType fsTypeDir = this.getFSObjectType(2);
                        newObjectFlags = 4L;
                        retFSOE = new ObjectEntry(fileObjEntryStr, fsTypeDir, dirOE, newObjectFlags, true);
                        break;
                    }
                    default: {
                        throw this.nsSpiException.newException("spi14");
                    }
                }
            }
        } else {
            throw this.nsSpiException.newException("spi14");
        }
        return retFSOE;
    }

    private String getVolumeNameWColon(String fsDirName) throws SPIException {
        int endidx;
        int begidx;
        for (begidx = endidx = fsDirName.indexOf(58); begidx >= 0 && fsDirName.charAt(begidx) != '\\'; --begidx) {
        }
        if (begidx <= -1) {
            throw this.nsSpiException.newException("spi14");
        }
        return fsDirName.substring(begidx + 1, endidx + 1);
    }

    private ObjectEntryEnumeration getFSChildrenFederatedFromServer(ObjectEntry serverOE) throws SPIException {
        String[] volNames = this.getVolumesOnServer(serverOE);
        ObjectType fsVolObjType = this.getFSObjectType(1);
        int newObjectFlags = 4;
        DefaultIndexedObjectEntryEnumeration diOEEnum = new DefaultIndexedObjectEntryEnumeration(null, this.shell);
        String fsVolOEPrefix = "\\\\" + serverOE.getName() + "\\";
        for (int vi = 0; vi < volNames.length; ++vi) {
            String fsVolOEName = fsVolOEPrefix + volNames[vi] + ":";
            ObjectEntry fsVolOE = new ObjectEntry(fsVolOEName, fsVolObjType, serverOE, newObjectFlags, false);
            diOEEnum.append(fsVolOE);
        }
        return diOEEnum;
    }

    private ObjectEntryEnumeration getFSChildrenFederatedFromVolume(ObjectEntry volumeOE) throws SPIException {
        ObjectType fsVolObjType = this.getFSObjectType(1);
        int newObjectFlags = 4;
        DefaultIndexedObjectEntryEnumeration diOEEnum = new DefaultIndexedObjectEntryEnumeration(null, this.shell);
        String[] sarr = this.getServerDNAndVolId(volumeOE);
        String fsVolOEName = "\\\\" + this.getSimpleServerNameFromServerDN(sarr[0]) + "\\" + sarr[1] + ":";
        ObjectEntry fsVolOE = new ObjectEntry(fsVolOEName, fsVolObjType, volumeOE, newObjectFlags, false);
        diOEEnum.append(fsVolOE);
        return diOEEnum;
    }

    private ObjectEntryEnumeration getFSChildrenFromFSObjectEntry(ObjectEntry fsOE, String namePattern) throws SPIException {
        String fsVolumeNameWColon;
        JCContext fs_ctx;
        String simpleServerNameDN;
        Object[] dfna = this.getDirOEAndFileName(fsOE);
        ObjectEntry federatedOE = (ObjectEntry)dfna[0];
        String parentFileName = (String)dfna[1];
        if (federatedOE.getObjectType().getName().equalsIgnoreCase("Volume")) {
            String[] sarr = this.getServerDNAndVolId(federatedOE);
            simpleServerNameDN = this.getSimpleServerNameFromServerDN(sarr[0]);
            fs_ctx = this.getFileSystemContext(sarr[0]);
            fsVolumeNameWColon = sarr[1] + ":";
        } else {
            simpleServerNameDN = federatedOE.getName();
            fs_ctx = this.getFileSystemContext(this.getUnrootedName(federatedOE));
            fsVolumeNameWColon = this.getVolumeNameWColon(parentFileName);
        }
        String actualfsSerVolName = "\\\\" + simpleServerNameDN + "\\" + fsVolumeNameWColon;
        String dirFileName = parentFileName.substring(actualfsSerVolName.length());
        NSFileObject parentnsfo = this.newNSFileObject(dirFileName);
        NSFileObject[] children_nsfoarr = this.getNSFileChildrenWithFSContext(fs_ctx, fsVolumeNameWColon, parentnsfo, namePattern);
        DefaultIndexedObjectEntryEnumeration diOEEnum = new DefaultIndexedObjectEntryEnumeration(null, this.shell);
        for (int ii = 0; ii < children_nsfoarr.length; ++ii) {
            ObjectType fileOT;
            NSFileObject tnsfo = children_nsfoarr[ii];
            String fullFileName = actualfsSerVolName + tnsfo.getName();
            int fileType = tnsfo.getType();
            long newObjectFlags = 0L;
            if (fileType == 2) {
                fileOT = this.getFSObjectType(2);
                newObjectFlags = 4L;
            } else {
                fileOT = this.getFSObjectType(3);
                if (tnsfo.isJunctionFile()) {
                    newObjectFlags = 64L;
                }
            }
            ObjectEntry foe = new ObjectEntry(fullFileName, fileOT, federatedOE, newObjectFlags, true);
            diOEEnum.append(foe);
        }
        return diOEEnum;
    }

    private ObjectType getFSObjectType(int fsObjTypeId) {
        ObjectType retObjType;
        ObjectType parentType = null;
        switch (fsObjTypeId) {
            case 1: {
                if (this.fsVolumeObjectType == null) {
                    this.fsVolumeObjectType = new ObjectType(FS_ID_VOLUME, (NamespaceSnapin)this, true, parentType);
                    this.fsVolumeObjectType.setIsFileSystem(true);
                }
                retObjType = this.fsVolumeObjectType;
                break;
            }
            case 2: {
                if (this.fsDirectoryObjectType == null) {
                    this.fsDirectoryObjectType = new ObjectType(FS_ID_DIRECTORY, (NamespaceSnapin)this, true, parentType);
                    this.fsDirectoryObjectType.setIsFileSystem(true);
                }
                retObjType = this.fsDirectoryObjectType;
                break;
            }
            case 3: {
                if (this.fsFileObjectType == null) {
                    this.fsFileObjectType = new ObjectType(FS_ID_FILE, (NamespaceSnapin)this, false, parentType);
                    this.fsFileObjectType.setIsFileSystem(true);
                }
                retObjType = this.fsFileObjectType;
                break;
            }
            default: {
                retObjType = new ObjectType(FS_ID_UNKNOWN, (NamespaceSnapin)this, false, parentType);
            }
        }
        return retObjType;
    }

    private String[] parseFSFederatedParts(String nameToParse) {
        String[] rStrArr = new String[2];
        if (nameToParse.startsWith(FS_FEDERATED_BEGINTAG)) {
            int fnameStartIdx = FS_FEDERATED_BEGINTAG.length();
            int fnameEndIdx = nameToParse.indexOf(FS_FEDERATED_ENDTAG, fnameStartIdx);
            if (fnameEndIdx >= 0) {
                int parsePoint = fnameEndIdx + FS_FEDERATED_ENDTAG.length() + 1;
                rStrArr[0] = parsePoint >= nameToParse.length() ? null : nameToParse.substring(parsePoint);
                rStrArr[1] = nameToParse.substring(fnameStartIdx, fnameEndIdx);
            } else {
                rStrArr[0] = nameToParse;
                rStrArr[1] = null;
            }
        } else {
            rStrArr[0] = nameToParse;
            rStrArr[1] = null;
        }
        return rStrArr;
    }

    private String getSimpleServerNameFromServerDN(String fullServerName) {
        int dotidx;
        int slen = fullServerName.length();
        for (dotidx = 0; dotidx < slen && fullServerName.charAt(dotidx) != '.'; ++dotidx) {
            if (fullServerName.charAt(dotidx) != '\\') continue;
            ++dotidx;
        }
        return fullServerName.substring(0, dotidx);
    }

    public String[] getVolumesOnServer(ObjectEntry serverOE) throws SPIException {
        VolumesOnServerCallback volumesOnServerCB;
        try {
            JCContext fs_ctx = this.getFileSystemContext(this.getUnrootedName(serverOE));
            volumesOnServerCB = new VolumesOnServerCallback();
            NWFile.getVolumesOnServerToCB((JCContext)fs_ctx, (String)serverOE.getName(), (NWFileVolumesOnServerCB)volumesOnServerCB);
        }
        catch (JCException jce) {
            throw this.resolveSPIException((Exception)((Object)jce), "getVolumesOnServer");
        }
        ArrayList volarrlist = volumesOnServerCB.getVolumeNames();
        int vsfize = volarrlist.size();
        String[] vsfoa = new String[vsfize];
        if (vsfize > 0) {
            vsfoa = volarrlist.toArray(vsfoa);
        }
        return vsfoa;
    }

    public NSFileObject newNSFileObject(String name) throws SPIException {
        NSFileObjectImpl nsfoi = new NSFileObjectImpl(name, 0);
        return nsfoi;
    }

    public NSFileObject newNSFileObject(String name, int type) throws SPIException {
        NSFileObjectImpl nsfoi = new NSFileObjectImpl(name, type);
        return nsfoi;
    }

    public NSFileRights newNSFileRights(int fileRights) throws SPIException {
        NSFileRightsImpl nsfri = new NSFileRightsImpl();
        nsfri.setRights(fileRights);
        return nsfri;
    }

    public NSFileRights newNSFileRights(ObjectAttribute rightsAttr) throws SPIException {
        if (rightsAttr == null || rightsAttr.getAttributeDefinition().getSyntax() != NDSSyntax.SYN_INTEGER) {
            throw this.nsSpiException.newException("spi20");
        }
        Long rightsLongVal = ((LongValue)rightsAttr.getValueComponents().nextElement()).getLongValue();
        short rawRights = rightsLongVal.shortValue();
        NSFileRightsImpl nsfri = new NSFileRightsImpl();
        try {
            nsfri.setRawFileRights(rawRights);
        }
        catch (JCException jce) {
            throw this.resolveSPIException((Exception)((Object)jce), "newNSFileRights");
        }
        return nsfri;
    }

    public NSFileTrustee newNSFileTrustee(String trusteeName, NSFileRights fileRights) throws SPIException {
        NSFileTrusteeImpl nsfti = new NSFileTrusteeImpl(trusteeName, fileRights);
        return nsfti;
    }

    public NSFileObject[] getTrusteeNSFileList(ObjectEntry volumeOE, String trusteeName, boolean determineTrusteeRights, boolean determineFileType) throws SPIException {
        ScanTrusteePathsCallback scanTrusteeCB;
        try {
            String[] sarr = this.getServerDNAndVolId(volumeOE);
            String serverNameDN = sarr[0];
            String fsVolumeName = sarr[1];
            scanTrusteeCB = new ScanTrusteePathsCallback();
            JCContext fs_ctx = this.getFileSystemContext(serverNameDN);
            NWFile.scanTrusteePathsCB((JCContext)fs_ctx, (String)fsVolumeName, (String)trusteeName, (NWFileScanTrusteePathsCB)scanTrusteeCB);
        }
        catch (JCException jce) {
            throw this.resolveSPIException((Exception)((Object)jce), "getTrusteeNSFileList");
        }
        ArrayList fsarrlist = scanTrusteeCB.getTrusteesPaths();
        int nsfize = fsarrlist.size();
        NSFileObject[] nsfoa = new NSFileObject[nsfize];
        if (nsfize > 0) {
            nsfoa = fsarrlist.toArray(nsfoa);
        }
        if (determineTrusteeRights) {
            for (int ii = 0; ii < nsfize; ++ii) {
                this.getNSFileTrustee(volumeOE, nsfoa[ii], trusteeName);
            }
        }
        if (determineFileType) {
            this.getNSFileObjectTypes(volumeOE, nsfoa);
        }
        return nsfoa;
    }

    public void getNSFileObjectType(ObjectEntry volumeOE, NSFileObject fileObject) throws SPIException {
        this.getNSFileObjectTypes(volumeOE, new NSFileObject[]{fileObject});
    }

    public void getNSFileObjectTypes(ObjectEntry volumeOE, NSFileObject[] nsfileobjectearr) throws SPIException {
        String[] sarr = this.getServerDNAndVolId(volumeOE);
        JCContext fs_ctx = this.getFileSystemContext(sarr[0]);
        String fsVolumeNameWColon = sarr[1] + ":";
        this.getNSFileObjectTypesWithFSContext(fs_ctx, fsVolumeNameWColon, nsfileobjectearr);
    }

    private void getNSFileObjectTypesWithFSContext(JCContext fs_ctx, String fsVolumeNameWColon, NSFileObject[] nsfileobjectearr) throws SPIException {
        if (nsfileobjectearr == null) {
            throw this.nsSpiException.newException("spi22");
        }
        for (int ii = 0; ii < nsfileobjectearr.length; ++ii) {
            if (!(nsfileobjectearr[ii] instanceof NSFileObjectImpl)) {
                throw this.nsSpiException.newException("spi22");
            }
            NSFileObjectImpl nsfoi = (NSFileObjectImpl)nsfileobjectearr[ii];
            String[] dirFileArr = nsfoi.getDirNameBaseNameBackslashed();
            try {
                NWFileEntryInfo fileei = NWFile.searchForEntry((JCContext)fs_ctx, (String)(fsVolumeNameWColon + dirFileArr[0]), (String)dirFileArr[1], (int)4);
                if ((fileei.flags & 4) == 4) {
                    nsfoi.setType(2);
                    continue;
                }
                if (nsfoi.getName().length() == 0) {
                    nsfoi.setType(2);
                    continue;
                }
                nsfoi.setType(1);
                if ((fileei.attributes & 0x200000L) != 0x200000L) continue;
                nsfoi.setJunctionFile(true);
                continue;
            }
            catch (JCException jce) {
                if (jce.getErrorCode() == -255) {
                    nsfoi.setType(3);
                    continue;
                }
                throw this.resolveSPIException((Exception)((Object)jce), "getNSFileObjectTypes");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addNSFileTrustee(ObjectEntry volumeOE, NSFileObject fileObject, NSFileTrustee trusteeObject, int retryCount) throws SPIException {
        JCContext fs_ctx = null;
        String fileNameBackslashed = fileObject.getNameBackslashed();
        if (retryCount < 0) {
            retryCount = 0;
        }
        try {
            String trusteeName = trusteeObject.getTrusteeName();
            NSFileRights fileRights = trusteeObject.getFileRights();
            if (!(fileRights instanceof NSFileRightsImpl)) {
                throw this.nsSpiException.newException("spi21");
            }
            String[] sarr = this.getServerDNAndVolId(volumeOE);
            String serverNameDN = sarr[0];
            String fsVolumeNameWColon = sarr[1] + ":";
            fs_ctx = this.getFileSystemContext(serverNameDN);
            NWFileTrustee[] trusteeArray = new NWFileTrustee[1];
            short rawRights = ((NSFileRightsImpl)fileRights).getRawFileRights();
            trusteeArray[0] = new NWFileTrustee(trusteeName, rawRights);
            boolean completedTrustee = false;
            while (!completedTrustee) {
                try {
                    NWFile.addTrustees((JCContext)fs_ctx, (String)(fsVolumeNameWColon + fileNameBackslashed), (short)0, (NWFileTrustee[])trusteeArray);
                    return;
                }
                catch (JCException jce) {
                    if (jce.getErrorCode() != -601) throw jce;
                    if (retryCount <= 0) {
                        throw jce;
                    }
                    --retryCount;
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception ex) {}
                }
            }
            return;
        }
        catch (JCException jce) {
            throw this.resolveSPIException((Exception)((Object)jce), "addNSFileTrustee");
        }
    }

    public void deleteNSFileTrustee(ObjectEntry volumeOE, NSFileObject fileObject, String trusteeName) throws SPIException {
        JCContext fs_ctx = null;
        String fileNameBackslashed = fileObject.getNameBackslashed();
        try {
            String[] sarr = this.getServerDNAndVolId(volumeOE);
            String serverNameDN = sarr[0];
            String fsVolumeNameWColon = sarr[1] + ":";
            fs_ctx = this.getFileSystemContext(serverNameDN);
            NWFileTrustee[] trusteeArray = new NWFileTrustee[]{new NWFileTrustee(trusteeName, 0)};
            NWFile.deleteTrustees((JCContext)fs_ctx, (String)(fsVolumeNameWColon + fileNameBackslashed), (NWFileTrustee[])trusteeArray);
        }
        catch (JCException jce) {
            throw this.resolveSPIException((Exception)((Object)jce), "deleteNSFileTrustee");
        }
    }

    public void createNSFileObject(ObjectEntry volumeOE, NSFileObject fileObject) throws SPIException {
        short accessRights;
        int createAttr;
        JCContext fs_ctx = null;
        String fileNameBackslashed = fileObject.getNameBackslashed();
        int fileType = fileObject.getType();
        if (fileType == 1) {
            createAttr = 0;
            accessRights = 3;
        } else if (fileType == 2) {
            createAttr = 16;
            accessRights = 251;
        } else {
            throw this.nsSpiException.newException("spi23");
        }
        try {
            String[] sarr = this.getServerDNAndVolId(volumeOE);
            String serverNameDN = sarr[0];
            String fsVolumeNameWColon = sarr[1] + ":";
            fs_ctx = this.getFileSystemContext(serverNameDN);
            int fileHandle = NWFile.open((JCContext)fs_ctx, (String)(fsVolumeNameWColon + fileNameBackslashed), (byte)8, (short)0, (int)createAttr, (short)accessRights);
            if (fileType == 1) {
                NWFile.close((JCContext)fs_ctx, (int)fileHandle);
            }
        }
        catch (JCException jce) {
            throw this.resolveSPIException((Exception)((Object)jce), "createNSFileObject");
        }
    }

    public void deleteNSFileObject(ObjectEntry volumeOE, NSFileObject fileObject) throws SPIException {
        short searchAttr = Short.MIN_VALUE;
        try {
            JCContext fs_ctx = null;
            String fileNameBackslashed = fileObject.getNameBackslashed();
            String[] sarr = this.getServerDNAndVolId(volumeOE);
            String serverNameDN = sarr[0];
            String fsVolumeNameWColon = sarr[1] + ":";
            fs_ctx = this.getFileSystemContext(serverNameDN);
            NWFile.delete((JCContext)fs_ctx, (String)(fsVolumeNameWColon + fileNameBackslashed), (short)searchAttr);
        }
        catch (JCException jce) {
            throw this.resolveSPIException((Exception)((Object)jce), "deleteNSFileObject");
        }
    }

    public NSFileObject[] getNSFileChildren(ObjectEntry volumeOE, NSFileObject dirObject) throws SPIException {
        return this.getNSFileChildren(volumeOE, dirObject, null);
    }

    public NSFileObject[] getNSFileChildren(ObjectEntry volumeOE, NSFileObject dirObject, String namePattern) throws SPIException {
        String[] sarr = this.getServerDNAndVolId(volumeOE);
        JCContext fs_ctx = this.getFileSystemContext(sarr[0]);
        String fsVolumeNameWColon = sarr[1] + ":";
        return this.getNSFileChildrenWithFSContext(fs_ctx, fsVolumeNameWColon, dirObject, namePattern);
    }

    private NSFileObject[] getNSFileChildrenWithFSContext(JCContext fs_ctx, String fsVolumeNameWColon, NSFileObject dirObject, String namePattern) throws SPIException {
        FileSearchCallback fileSearchCB;
        if (!(dirObject instanceof NSFileObjectImpl)) {
            throw this.nsSpiException.newException("spi22");
        }
        String dirNameBackslashed = dirObject.getNameBackslashed();
        if (namePattern == null) {
            namePattern = "*";
        }
        try {
            fileSearchCB = new FileSearchCallback(dirObject);
            String fullSearchName = dirNameBackslashed.length() == 0 ? fsVolumeNameWColon + namePattern : fsVolumeNameWColon + dirNameBackslashed + "\\" + namePattern;
            NWFile.searchToCB((JCContext)fs_ctx, (String)fullSearchName, (short)Short.MIN_VALUE, (NWFileSearchCB)fileSearchCB);
        }
        catch (JCException jce) {
            throw this.resolveSPIException((Exception)((Object)jce), "getNSFileChildrenWithFSContext");
        }
        ArrayList fsarrlist = fileSearchCB.getNSFileObjects();
        FSComparator fsComp = new FSComparator();
        Collections.sort(fsarrlist, fsComp);
        int nsfize = fsarrlist.size();
        NSFileObject[] nsfoa = new NSFileObject[nsfize];
        if (nsfize > 0) {
            nsfoa = fsarrlist.toArray(nsfoa);
        }
        return nsfoa;
    }

    public NSFileRights getTrusteeNSFileEffectiveRights(ObjectEntry volumeOE, String trusteeName, NSFileObject fileObject) throws SPIException {
        try {
            String[] sarr = this.getServerDNAndVolId(volumeOE);
            String serverNameDN = sarr[0];
            String fsVolumeNameWColon = sarr[1] + ":";
            JCContext fs_ctx = this.getFileSystemContext(serverNameDN);
            String[] dirFileArr = fileObject.getDirNameBaseNameBackslashed();
            int rawEffectiveRights = NWFile.getObjectEffectiveRights((JCContext)fs_ctx, (String)trusteeName, (String)(fsVolumeNameWColon + dirFileArr[0]), (String)dirFileArr[1]);
            NSFileRightsImpl nsferi = new NSFileRightsImpl();
            nsferi.setRawFileRights((short)rawEffectiveRights);
            return nsferi;
        }
        catch (JCException jce) {
            throw this.resolveSPIException((Exception)((Object)jce), "getTrusteeNSFileEffectiveRights");
        }
    }

    public void getNSFileTrustees(ObjectEntry volumeOE, NSFileObject fileObject) throws SPIException {
        this.getNSFileTrustee(volumeOE, fileObject, null);
    }

    public void getNSFileTrustee(ObjectEntry volumeOE, NSFileObject fileObject, String trusteeName) throws SPIException {
        if (!(fileObject instanceof NSFileObjectImpl)) {
            throw this.nsSpiException.newException("spi22");
        }
        try {
            String[] sarr = this.getServerDNAndVolId(volumeOE);
            String serverNameDN = sarr[0];
            String fsVolumeNameWColon = sarr[1] + ":";
            TrusteeCallback trusteeCB = new TrusteeCallback();
            JCContext fs_ctx = this.getFileSystemContext(serverNameDN);
            NWFile.getTrusteesToCB((JCContext)fs_ctx, (String)(fsVolumeNameWColon + fileObject.getNameBackslashed()), (short)0, (NWFileTrusteeCB)trusteeCB);
            ArrayList tarrlist = trusteeCB.getNSFileTrustees();
            int nstsize = tarrlist.size();
            NSFileTrustee[] nsftrusteearr = new NSFileTrustee[nstsize];
            if (nstsize > 0) {
                nsftrusteearr = tarrlist.toArray(nsftrusteearr);
            }
            if (trusteeName != null) {
                NSFileTrustee foundTrustee = null;
                for (int ii = 0; ii < nstsize; ++ii) {
                    if (!nsftrusteearr[ii].getTrusteeName().equalsIgnoreCase(trusteeName)) continue;
                    foundTrustee = nsftrusteearr[ii];
                    break;
                }
                if (foundTrustee == null) {
                    NSFileTrusteeImpl nsfti = new NSFileTrusteeImpl(trusteeName, null);
                    nsftrusteearr = new NSFileTrustee[]{nsfti};
                } else {
                    nsftrusteearr = new NSFileTrustee[]{foundTrustee};
                }
            }
            ((NSFileObjectImpl)fileObject).setTrustees(nsftrusteearr);
        }
        catch (JCException jce) {
            throw this.resolveSPIException((Exception)((Object)jce), "getNSFileTrustee");
        }
    }

    private String[] getServerDNAndVolId(ObjectEntry volumeOE) throws SPIException {
        try {
            String attrHostServer = "Host Server";
            String attrHostResource = "Host Resource Name";
            String[] attrs = new String[]{attrHostServer, attrHostResource};
            ObjectAttribute[] volObjectAttrs = this.getAttributesImpl(volumeOE, attrs, 0, null, null);
            String serverNameDN = null;
            String volumeLocalId = null;
            for (int ii = 0; ii < volObjectAttrs.length; ++ii) {
                ObjectAttribute oa = volObjectAttrs[ii];
                if (attrHostServer.equals(oa.getAttributeDefinition().getName())) {
                    serverNameDN = ((StringValue)oa.getValueComponents().nextElement()).getValue();
                    continue;
                }
                if (!attrHostResource.equals(oa.getAttributeDefinition().getName())) continue;
                volumeLocalId = ((StringValue)oa.getValueComponents().nextElement()).getValue();
            }
            if (serverNameDN == null || volumeLocalId == null) {
                throw this.resolveSPIException(NamespaceException.UNSUPPORTED_OPERATION, "");
            }
            String[] sarr = new String[]{serverNameDN, volumeLocalId};
            return sarr;
        }
        catch (NamespaceException nse) {
            throw this.resolveSPIException(nse, "getServerDNAndVolId");
        }
    }

    private JCContext getFileSystemContext(String serverNameDN) throws SPIException {
        JCContext fs_ctx = (JCContext)this.fileSystemContextHashMap.get(serverNameDN);
        if (fs_ctx == null) {
            ObjectEntry serverOE = this.getObjectEntry(serverNameDN);
            JCReferral serverAddress = this.getServerAddress(serverOE);
            fs_ctx = this.getContext(serverOE, 0);
            try {
                fs_ctx.setFlags(2, 0);
                fs_ctx.connect(0L, serverAddress);
                fs_ctx.authenticate();
                fs_ctx.licenseConnection();
                this.fileSystemContextHashMap.put(serverNameDN, fs_ctx);
            }
            catch (JCException e) {
                throw this.resolveSPIException((Exception)((Object)e), "getFileSystemContext");
            }
        }
        return fs_ctx;
    }

    private void freeFileSystemLicenseCache() {
        if (this.fileSystemContextHashMap.size() > 0) {
            Collection licensedServerCollection = this.fileSystemContextHashMap.values();
            Iterator lsIterator = licensedServerCollection.iterator();
            while (lsIterator.hasNext()) {
                JCContext lsctx = (JCContext)lsIterator.next();
                lsctx.free();
            }
            this.fileSystemContextHashMap.clear();
        }
    }

    public void setTrusteeRestriction(ObjectEntry volumeOE, ObjectEntry trusteeOE, int limit) throws SPIException {
        String fsVolumeName = null;
        try {
            String[] sarr = this.getServerDNAndVolId(volumeOE);
            String serverNameDN = sarr[0];
            fsVolumeName = sarr[1];
            JCContext context = this.getFileSystemContext(serverNameDN);
            NWFileRestriction[] restrictionList = new NWFileRestriction[]{new NWFileRestriction(this.getUnrootedName(trusteeOE), limit / 4, 0)};
            NWFile.addDiskSpaceRestrictions((JCContext)context, (String)fsVolumeName, (NWFileRestriction[])restrictionList);
        }
        catch (JCException e) {
            Debug.out("Error in setTrusteeRestriction for volume: " + this.getUnrootedName(volumeOE));
            Debug.out("FSVolumeName: " + fsVolumeName);
            Debug.out("TrusteeOE was: " + this.getUnrootedName(trusteeOE));
            Debug.out("Disk space limit was: " + limit + " 1K blocks");
            throw this.resolveSPIException((Exception)((Object)e), "setTrusteeRestriction");
        }
    }

    private synchronized Vector setAttributeImpl(ObjectEntry obj, ObjectAttribute[] objAttr, int modifyMode, ObjectEntry serverOE, Vector attVec) throws SPIException {
        Vector attr = null;
        String treeName = obj.getRoot().getName();
        for (int counter = 0; counter <= objAttr.length - 1; ++counter) {
            if (modifyMode == 5) {
                ObjectAttribute attrValToDelete = new ObjectAttribute(objAttr[counter].getAttributeDefinition());
                ObjectAttribute attrValToAdd = new ObjectAttribute(objAttr[counter].getAttributeDefinition());
                this.getModifiedAttributeValues(objAttr[counter], attrValToAdd, attrValToDelete, false);
                if (attrValToDelete.getComponentCount() == 0 && attrValToAdd.getComponentCount() == 0) continue;
                if (attrValToDelete.getComponentCount() > 0) {
                    if (objAttr[counter].getAttributeDefinition().getSyntax() == NDSSyntax.SYN_STREAM) {
                        if (attrValToAdd.getComponentCount() == 0) {
                            this.deleteStreamValue(obj, objAttr[counter], serverOE);
                        }
                    } else {
                        attr = this.convertToJCValue(attrValToDelete, 7, treeName);
                    }
                }
                if (attrValToAdd.getComponentCount() > 0) {
                    Vector addAttr = null;
                    if (objAttr[counter].getAttributeDefinition().getSyntax() == NDSSyntax.SYN_STREAM) {
                        if (attrValToDelete.getComponentCount() == 0) {
                            this.addStreamValue(obj, objAttr[counter], 0, serverOE);
                        } else {
                            this.addStreamValue(obj, objAttr[counter], 5, serverOE);
                        }
                    } else {
                        addAttr = objAttr[counter].getAttributeDefinition().isSingleValued() ? this.convertToJCValue(attrValToAdd, 5, treeName) : this.convertToJCValue(attrValToAdd, 2, treeName);
                    }
                    if (null == attr) {
                        attr = addAttr;
                    } else if (null != addAttr) {
                        for (int i = 0; i < addAttr.size(); ++i) {
                            attr.addElement(addAttr.elementAt(i));
                        }
                    }
                }
            } else if (objAttr[counter] != null) {
                if (objAttr[counter].getAttributeDefinition().getSyntax() == NDSSyntax.SYN_STREAM) {
                    this.addStreamValue(obj, objAttr[counter], 0, serverOE);
                } else {
                    attr = this.convertToJCValue(objAttr[counter], modifyMode, treeName);
                }
            }
            if (attr == null) continue;
            for (int i = 0; i < attr.size(); ++i) {
                attVec.addElement(attr.elementAt(i));
            }
            attr.clear();
        }
        return attVec;
    }

    public String[] getAttributesPresent(ObjectEntry useOE, String[] attributeNames) throws SPIException {
        String[] attrNames;
        block6: {
            JCContext ctx = null;
            int resolveFlags = 66;
            attrNames = null;
            String[] attrbNames = null;
            attrbNames = attributeNames;
            JCReadFilter filter = new JCReadFilter(false, new JCTimestamp(), attributeNames);
            ctx = this.getContext(useOE, resolveFlags, null);
            try {
                JCValue[] values;
                try {
                    values = JClient.readEntry((JCContext)ctx, (long)0L, (JCReadFilter)filter);
                }
                catch (JCException jce) {
                    values = this.secureRetryReadEntry(ctx, jce, 0L, filter, null, null);
                }
                if (values != null) {
                    attrNames = new String[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        attrNames[i] = values[i].attributeName;
                    }
                }
            }
            catch (JCException jce) {
                if (jce.getErrorCode() == -603) break block6;
                SPIException spie = this.resolveSPIException((Exception)((Object)jce), "getAttributesPresent");
                throw spie;
            }
        }
        return attrNames;
    }

    private void modifyAll(Vector attr, ObjectEntry obj, ObjectEntry serverOE) throws SPIException {
        if (null != attr) {
            JCContext ctx = null;
            try {
                ctx = serverOE == null ? this.getContext(obj, 68) : this.getContext(obj, 68, serverOE);
                this.modifyEntries(ctx, attr);
            }
            catch (Exception x) {
                throw this.resolveSPIException(x, "");
            }
            finally {
                if (ctx != null) {
                    ctx.free();
                }
            }
        }
    }

    public boolean getDefinedMethod(String methodName, Class[] parameters) {
        boolean isMethodDefined = false;
        AJClientClass = JClient.class;
        try {
            JClientMethod = AJClientClass.getDeclaredMethod(methodName, parameters);
            isMethodDefined = JClientMethod != null && JClientMethod.getName().equals(methodName);
        }
        catch (SecurityException e) {
            isMethodDefined = false;
        }
        catch (NoSuchMethodException e) {
            isMethodDefined = false;
        }
        return isMethodDefined;
    }

    static {
        try {
            String nsPlatform = NSUtil.getPlatform();
            if (nsPlatform.equals("windows")) {
                System.loadLibrary("ntls");
                System.loadLibrary("nmasmsg");
                System.loadLibrary("nmas");
            }
            NDSNamespaceImpl.setJClientInUse();
            JClient.initialize();
        }
        catch (Throwable t) {
            initException = new Exception("Unable to initialize JClient: " + t.toString(), t);
            Debug.out(initException.toString(), 1);
            Debug.out("This could be because of NICI or native library issues\n", 1);
        }
        SEP_STRING = new String(".");
        VALUE_STRING = new String("=");
        DELIMITERS = new String(new char[]{'0', '0', '.', '.', '+', '=', '*', '\\', '\u0000'});
        TYPEDNAMEDELIMITERS = new String(new char[]{'1', '0', '.', '.', '+', '=', '*', '\\', '\u0000'});
        MAX_ITEMS_FOR_ENUMERATION = 1000;
        JCContext_CLASS = JCContext.class;
        JCACLVALUE_CLASS = JCAclValue;.class;
        AJClientClass = null;
        JClientMethod = null;
    }

    class TrusteeCallback
    implements NWFileTrusteeCB {
        private ArrayList m_trusteeList = new ArrayList();

        public int trusteeCallback(JCContext context, int entryID, String trusteeDN, short trusteeRights) {
            try {
                NSFileRightsImpl nsfri = new NSFileRightsImpl();
                nsfri.setRawFileRights(trusteeRights);
                NSFileTrusteeImpl nsftrustee = new NSFileTrusteeImpl(trusteeDN, nsfri);
                this.m_trusteeList.add(nsftrustee);
            }
            catch (JCException jce) {
                Debug.out("Error in trusteeCallback for: " + trusteeDN);
                Debug.out("    " + jce.toString());
                return jce.getErrorCode();
            }
            return 0;
        }

        public ArrayList getNSFileTrustees() {
            return this.m_trusteeList;
        }
    }

    class FileSearchCallback
    implements NWFileSearchCB {
        private ArrayList m_fileList = new ArrayList();
        private String parentDirWithSep;

        public FileSearchCallback(NSFileObject dirObject) {
            try {
                String dirName = dirObject.getNameBackslashed();
                this.parentDirWithSep = dirName.length() == 0 ? "" : dirName + '\\';
            }
            catch (SPIException e) {
                this.parentDirWithSep = "?\\";
            }
        }

        public int searchCallback(JCContext context, NWFileSearchInfo searchInfo) {
            int fileType = 1;
            if ((searchInfo.flags & 4) == 4) {
                fileType = 2;
            }
            NSFileObjectImpl nsfoi = new NSFileObjectImpl(this.parentDirWithSep + searchInfo.name, fileType);
            if ((searchInfo.attributes & 0x200000) == 0x200000) {
                nsfoi.setJunctionFile(true);
            }
            this.m_fileList.add(nsfoi);
            return 0;
        }

        public ArrayList getNSFileObjects() {
            return this.m_fileList;
        }
    }

    class ScanTrusteePathsCallback
    implements NWFileScanTrusteePathsCB {
        private ArrayList m_trusteeFileList = new ArrayList();

        public int scanTrusteePathsCallback(JCContext context, String trusteeDN, String path, short trusteeRights) {
            int colonOff = path.indexOf(58);
            String fileName = path.substring(colonOff + 1);
            NSFileObjectImpl nsfo = new NSFileObjectImpl(fileName, 0);
            this.m_trusteeFileList.add(nsfo);
            return 0;
        }

        public ArrayList getTrusteesPaths() {
            return this.m_trusteeFileList;
        }
    }

    class NetAddrComparator
    implements Comparator {
        private byte[] prefAddr = null;

        NetAddrComparator(JCNetworkAddress pref) {
            if (pref != null) {
                this.prefAddr = pref.getAddress();
            }
        }

        public int compare(Object a, Object b) {
            int btype;
            int atype = ((JCNetworkAddress)a).getType();
            if (atype == (btype = ((JCNetworkAddress)b).getType())) {
                if (this.prefAddr != null) {
                    if (this.addrComp(((JCNetworkAddress)a).getAddress(), this.prefAddr)) {
                        return -1;
                    }
                    if (this.addrComp(((JCNetworkAddress)b).getAddress(), this.prefAddr)) {
                        return 1;
                    }
                    if (((JCNetworkAddress)b).getAddress().equals(this.prefAddr)) {
                        return 1;
                    }
                }
                return 0;
            }
            if (atype == 9) {
                return -1;
            }
            if (btype == 9) {
                return 1;
            }
            if (atype == 11) {
                return -1;
            }
            if (btype == 11) {
                return 1;
            }
            return 0;
        }

        private boolean addrComp(byte[] a, byte[] b) {
            if (a.length != b.length) {
                return false;
            }
            for (int i = 0; i < a.length; ++i) {
                if (a[i] == b[i]) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object a) {
            return a == this;
        }
    }

    class VolumesOnServerCallback
    implements NWFileVolumesOnServerCB {
        private ArrayList m_volumeNameList = new ArrayList();

        public int volumesOnServerCallback(JCContext context, String volumeName) {
            this.m_volumeNameList.add(volumeName);
            return 0;
        }

        public ArrayList getVolumeNames() {
            return this.m_volumeNameList;
        }
    }

    static class ContextAddressInfo {
        boolean isIpAddress = false;
        String addressId = "";
        int ipPort = 0;
    }

    static class ServerAndIpInfo {
        String ipAddress = null;
        int ipPort = 0;
        SPIException ipSPIExcept = null;
        String serverDN = null;
        SPIException dnSPIExcept = null;
    }
}

