/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds.jclient;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.UnexpectedErrorException;
import com.novell.admin.ns.OperationStatus;
import com.novell.admin.ns.PartitionOperationCallBack;
import com.novell.admin.ns.nds.OperationThreadStatus;
import com.novell.admin.ns.nds.jclient.NDSNamespaceImpl;
import com.novell.application.console.snapin.ObjectEntry;
import novell.jclient.JCContext;
import novell.jclient.JClient;

public class NDSPartitionOperationStatus
implements OperationStatus {
    private NDSNamespaceImpl myNS;
    private String partFDN;
    private int st = 4;
    private Thread myOperationT;
    String tree;

    NDSPartitionOperationStatus(ObjectEntry partObjEntry, String tree_name, NDSNamespaceImpl ns2, Thread operationT) {
        this.tree = tree_name;
        this.myNS = ns2;
        this.partFDN = ns2.getUnrootedName(partObjEntry);
        this.myOperationT = operationT;
        this.st = 3;
    }

    public void waitForOperation(int length, PartitionOperationCallBack cb) throws SPIException {
        boolean stopOperation = false;
        while (!stopOperation && this.myOperationT.isAlive()) {
            JCContext myPartContext = null;
            try {
                this.myOperationT.join(length);
                int action = cb.toDo();
                if (action == 0) {
                    myPartContext = this.myNS.getContext(this.tree, this.partFDN, 2);
                    JClient.abortPartitionOperation((JCContext)myPartContext, (long)0L);
                    stopOperation = true;
                    this.st = 2;
                    continue;
                }
                if (action != 2) continue;
                stopOperation = true;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new UnexpectedErrorException();
            }
            catch (Exception e) {
                throw this.myNS.resolveSPIException(e, "");
            }
            finally {
                if (myPartContext == null) continue;
                myPartContext.free();
            }
        }
        if (!this.myOperationT.isAlive()) {
            this.st = 1;
        }
        cb.toDo();
    }

    public void waitForOperation(int length) {
        if (this.myOperationT.isAlive()) {
            try {
                this.myOperationT.join(length);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new UnexpectedErrorException();
            }
        }
    }

    public int getStatus() throws SPIException {
        this.st = ((OperationThreadStatus)((Object)this.myOperationT)).operationStatus();
        return this.st;
    }
}

