/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds.jclient;

import com.novell.admin.ns.nds.NDSPropertyRights;
import novell.jclient.JCAclValue;

public final class NDSPropertyRightsImpl
implements NDSPropertyRights {
    private JCAclValue rights;
    private long privileges;

    public NDSPropertyRightsImpl(JCAclValue aclValue) {
        this.rights = aclValue;
        this.privileges = this.rights.getPrivileges();
    }

    public String getAttributeName() {
        return this.rights.getAttributeName();
    }

    public int getPrivileges() {
        return (int)this.privileges;
    }

    public boolean hasCompareRights() {
        return (this.privileges & 1L) > 0L;
    }

    public boolean hasReadRights() {
        return (this.privileges & 2L) > 0L;
    }

    public boolean hasWriteRights() {
        return (this.privileges & 4L) > 0L;
    }

    public boolean hasSelfRights() {
        return (this.privileges & 8L) > 0L;
    }

    public boolean hasSupervisorRights() {
        return (this.privileges & 0x20L) > 0L;
    }

    public boolean hasInheritCtlRights() {
        return (this.privileges & 0x40L) > 0L;
    }

    public boolean hasDeleteRights() {
        return (this.privileges & 4L) > 0L;
    }

    public boolean hasAddRights() {
        return (this.privileges & 4L) > 0L;
    }

    public boolean canModify() {
        return this.hasWriteRights() && this.hasReadRights();
    }
}

