/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds.jclient;

import com.novell.admin.common.util.EndianInputStream;
import java.io.IOException;

public class NDSReplicaSyncInfo {
    protected int statusFlags;
    protected int timeStamp;
    protected int replicaNumber;
    protected int errorCode;
    protected String serverName;
    protected String entryName;
    private String typelessServerName = null;

    public NDSReplicaSyncInfo(byte[] octetString) throws IOException {
        EndianInputStream edis = new EndianInputStream(octetString);
        edis.readLoHiInt();
        this.statusFlags = edis.readLoHiInt();
        this.timeStamp = edis.readLoHiInt();
        this.replicaNumber = edis.readLoHiInt();
        this.errorCode = edis.readLoHiInt();
        int length = edis.readLoHiInt();
        this.serverName = length > 0 ? edis.readLoHiChars() : null;
        edis.align32();
        length = edis.readLoHiInt();
        this.entryName = length > 0 ? edis.readLoHiChars() : null;
        edis.align32();
    }

    public int getStatusFlags() {
        return this.statusFlags;
    }

    public int getTimeStamp() {
        return this.timeStamp;
    }

    public int getReplicaNumber() {
        return this.replicaNumber;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getServerName() {
        if (this.typelessServerName == null && this.serverName != null) {
            int equIndex;
            this.typelessServerName = this.serverName;
            while (-1 != (equIndex = this.typelessServerName.indexOf("="))) {
                String temp;
                int index;
                for (index = equIndex - 1; index > 0 && this.typelessServerName.charAt(index) != '.'; --index) {
                }
                if (index == 0) {
                    temp = this.typelessServerName.substring(equIndex + 1);
                } else {
                    temp = this.typelessServerName.substring(0, index + 1);
                    temp = temp + this.typelessServerName.substring(equIndex + 1);
                }
                this.typelessServerName = temp;
            }
        }
        return this.typelessServerName;
    }

    public String getEntryName() {
        return this.entryName;
    }
}

