/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds.jclient;

import [Ljava.lang.String;;
import [Lnovell.jclient.JCAclValue;;
import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.SimpleSPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSClassDefinition;
import com.novell.admin.ns.nds.NDSClassFlags;
import com.novell.admin.ns.nds.NDSSchema;
import com.novell.admin.ns.nds.NDSSchemaDefinition;
import com.novell.admin.ns.nds.jclient.NDSNamespaceImpl;
import com.novell.application.console.snapin.Debug;
import com.novell.application.console.snapin.ObjectType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import novell.jclient.JCAclValue;
import novell.jclient.JCAttributeDef;
import novell.jclient.JCClassDef;
import novell.jclient.JCContext;
import novell.jclient.JCException;
import novell.jclient.JCReadClassDefCB;
import novell.jclient.JClient;

final class NDSSchemaImpl
implements NDSSchema {
    private String tree;
    private NDSSchemaDefinition schemaDef;
    private NDSNamespaceImpl namespace = null;
    private UniqueSPIException uniqueSPIException;
    private SimpleSPIException nsSpiException = new SimpleSPIException("com.novell.admin.ns.NSResourceBundle");
    protected boolean schemaRead = false;
    private static final int GET_ATTR_DEF1 = 1;
    private static final int ATTRIBUTE_SET_ADD = 2;
    private static final int ATTRIBUTE_SET_MODIFY = 3;
    private static final int BAD_ATTR_GET1 = 4;
    private static final int BAD_ATTR_GET2 = 5;
    private static final int GET_ATTR_DEF2 = 6;
    private static final int NO_SYNTAX = 7;
    private static final int BAD_ATTR_DEF_GET = 8;
    private static Class JClientClass = null;
    private static Method JClientMethod = null;

    NDSSchemaImpl(NDSNamespaceImpl ns2, String tree_name) throws SPIException {
        this.tree = tree_name;
        this.namespace = ns2;
        this.uniqueSPIException = ns2.getUniqueSPIException();
        this.schemaDef = new NDSSchemaDefinition(this, ns2);
        this.readTheSchema();
    }

    public void refreshSchema() {
        this.schemaDef.clearAttributes();
        this.schemaDef.clearClasses();
        this.schemaDef.clearObjectTypeCache();
        this.schemaRead = false;
        try {
            this.readTheSchema();
        }
        catch (SPIException e) {
            Debug.out("Unable to read schema: " + e);
        }
    }

    public SchemaDefinition getSchemaDefinition() {
        if (this.schemaRead) {
            return this.schemaDef;
        }
        try {
            this.readTheSchema();
        }
        catch (SPIException e) {
            Debug.out("Unable to read or parse schema: " + e);
        }
        return this.schemaDef;
    }

    public ObjectType getObjectType(String className) throws SPIException {
        return this.schemaDef.getObjectType(className);
    }

    public AttributeDefinition getAttributeDefinition(String attrName) throws SPIException {
        try {
            return this.schemaDef.getAttributeDefinition(attrName);
        }
        catch (NamespaceException ex) {
            JCContext ctx = null;
            try {
                ctx = this.namespace.getContext(this.tree, 2);
                JCAttributeDef[] defs = JClient.readAttributeDef((JCContext)ctx, (long)1L, (String[])new String[]{attrName});
                NDSAttributeDefinition nDSAttributeDefinition = this.crackJCAttrDef(defs[0]);
                return nDSAttributeDefinition;
            }
            catch (JCException e) {
                throw this.uniqueSPIException.newException(e.getErrorCode(), "", e);
            }
            finally {
                if (ctx != null) {
                    ctx.free();
                }
            }
        }
    }

    public ClassDefinition getClassDefinition(String className) throws SPIException {
        ClassDefinition classDef = null;
        try {
            classDef = this.schemaDef.getClassDefinition(className);
        }
        catch (NamespaceException ex) {
            JCContext ctx = null;
            try {
                ctx = this.namespace.getContext(this.tree, 2);
                JCClassDef[] defs = JClient.readClassDef((JCContext)ctx, (long)2L, (String[])new String[]{className});
                classDef = this.crackJCClassDef(defs[0]);
            }
            catch (JCException e) {
                throw this.uniqueSPIException.newException(e.getErrorCode(), "", e);
            }
            finally {
                if (ctx != null) {
                    ctx.free();
                }
            }
        }
        return classDef;
    }

    public void writeAttributeDefinition(AttributeDefinition attributeDef) throws SPIException {
        JCContext ctx = null;
        try {
            ctx = this.namespace.getContext(this.tree, 2);
            JClient.defineAttribute((JCContext)ctx, (String)attributeDef.getName(), (JCAttributeDef)this.convertToJCAttrDef(attributeDef));
        }
        catch (JCException e) {
            throw this.uniqueSPIException.newException(e.getErrorCode(), "", e);
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    public void deleteAttributeDefinition(AttributeDefinition attributeDef) throws SPIException {
        JCContext ctx = null;
        try {
            ctx = this.namespace.getContext(this.tree, 2);
            JClient.undefineAttribute((JCContext)ctx, (String)attributeDef.getName());
        }
        catch (JCException e) {
            throw this.uniqueSPIException.newException(e.getErrorCode(), "", e);
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    public void modifyClassDefinition(ClassDefinition newClassDef) throws SPIException {
        JCContext ctx = null;
        long flag = 0L;
        Class[] parameters = new Class[]{JCContext.class, String.class, Long.TYPE, [B.class, String;.class, String;.class, String;.class, String;.class, String;.class, String;.class, JCAclValue;.class, JCAclValue;.class};
        try {
            AttributeDefinition[] newAttribs = newClassDef.getOptionalAttributes();
            ClassDefinition oldClassDef = this.schemaDef.getClassDefinition(newClassDef.getName());
            AttributeDefinition[] oldAttribs = oldClassDef.getOptionalAttributes();
            NDSClassFlags classFlags = ((NDSClassDefinition)newClassDef).getClassFlags();
            if (classFlags != null) {
                flag = classFlags.getFlags();
            }
            byte[] asnId = ((NDSClassDefinition)newClassDef).getASN1Data();
            String temp = new String(asnId);
            System.out.println("<<<< From modifyClassDefinition modified ASN1>>" + temp);
            Vector<String> newVec = new Vector<String>();
            for (int i = 0; i < newAttribs.length; ++i) {
                if (oldClassDef.isClassUsingAttribute(newAttribs[i].getName())) continue;
                newVec.addElement(newAttribs[i].getName());
            }
            Vector<String> remVec = new Vector<String>();
            for (int i = 0; i < oldAttribs.length; ++i) {
                if (newClassDef.isClassUsingAttribute(oldAttribs[i].getName())) continue;
                remVec.addElement(oldAttribs[i].getName());
            }
            Object[] addAttribs = new String[newVec.size()];
            newVec.copyInto(addAttribs);
            Object[] remAttribs = new String[remVec.size()];
            remVec.copyInto(remAttribs);
            ctx = this.namespace.getContext(this.tree, 2);
            Object[] invokingParams = new Object[]{ctx, newClassDef.getName(), new Long(flag), asnId, addAttribs, remAttribs, null, null, null, null, null, null};
            try {
                if (!this.getDefinedMethod("modifyClassDefinition", parameters, invokingParams)) {
                    JClient.modifyClass((JCContext)ctx, (String)newClassDef.getName(), (String[])addAttribs, (String[])remAttribs, null, null);
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        catch (JCException e) {
            throw this.uniqueSPIException.newException(e.getErrorCode(), "", e);
        }
        catch (NamespaceException e) {
            throw new AdminError(0, this.getClass().getName());
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyAttributeDefinition(AttributeDefinition newAttributeDef) throws SPIException {
        byte[] asnOneID = null;
        int syntax = 0;
        long setFlags = 0L;
        long clearFlags = 0L;
        long changeBounds = 0L;
        long lowLimit = 0L;
        long upperLimit = 0L;
        String attributeName = null;
        JCContext ctx = null;
        Class[] parameters = new Class[]{JCContext.class, String.class, Long.TYPE, Long.TYPE, Integer.TYPE, [B.class, Long.TYPE, Long.TYPE, Long.TYPE};
        try {
            attributeName = newAttributeDef.getName();
            asnOneID = ((NDSAttributeDefinition)newAttributeDef).getASN1Data();
            ctx = this.namespace.getContext(this.tree, 66);
            Object[] invokingParams = new Object[]{ctx, attributeName, new Long(setFlags), new Long(clearFlags), new Integer(syntax), asnOneID, new Long(changeBounds), new Long(lowLimit), new Long(upperLimit)};
            try {
                if (this.getDefinedMethod("modifyAttributeDefinition", parameters, invokingParams)) {
                    // empty if block
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            if (e instanceof JCException) {
                throw this.uniqueSPIException.newException(((JCException)((Object)e)).getErrorCode(), "", e);
            }
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    private boolean getDefinedMethod(String methodName, Class[] parameters, Object[] invokingParams) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        boolean isMethodDefined = false;
        JClientClass = JClient.class;
        try {
            JClientMethod = JClientClass.getDeclaredMethod(methodName, parameters);
            if (JClientMethod != null && JClientMethod.getName().equals(methodName)) {
                isMethodDefined = true;
                JClientMethod.invoke(null, invokingParams);
            }
        }
        catch (SecurityException e) {
            return isMethodDefined;
        }
        catch (NoSuchMethodException e) {
            return isMethodDefined;
        }
        return isMethodDefined;
    }

    public void writeClassDefinition(ClassDefinition classDef) throws SPIException {
        JCContext ctx = null;
        try {
            ctx = this.namespace.getContext(this.tree, 2);
            JClient.defineClass((JCContext)ctx, (String)classDef.getName(), (JCClassDef)this.convertToJCClassDef(classDef));
        }
        catch (JCException e) {
            throw this.uniqueSPIException.newException(e.getErrorCode(), "", e);
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    public void deleteClassDefinition(ClassDefinition classDef) throws SPIException {
        JCContext ctx = null;
        try {
            ctx = this.namespace.getContext(this.tree, 2);
            JClient.undefineClass((JCContext)ctx, (String)classDef.getName());
        }
        catch (JCException e) {
            throw this.uniqueSPIException.newException(e.getErrorCode(), "", e);
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    void readAttributeDefinitions(String[] attributeNames) throws SPIException {
        JCContext ctx = null;
        try {
            ctx = this.namespace.getContext(this.tree, 2);
            JCAttributeDef[] def = JClient.readAttributeDef((JCContext)ctx, (long)1L, (String[])attributeNames);
            for (int i = 0; i < def.length; ++i) {
                this.schemaDef.addAttributeDefinition(this.crackJCAttrDef(def[i]));
            }
        }
        catch (JCException e) {
            throw this.uniqueSPIException.newException(e.getErrorCode(), "", e);
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    void readClassDefinitions(String[] classNames) throws SPIException {
        JCContext ctx = null;
        try {
            ctx = this.namespace.getContext(this.tree, 2);
            JClient.readClassDef((JCContext)ctx, (long)1L, (String[])classNames, (JCReadClassDefCB)new SchemaReadClassDefinitionCallback());
        }
        catch (JCException e) {
            throw this.uniqueSPIException.newException(e.getErrorCode(), "", e);
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    private NDSAttributeDefinition crackJCAttrDef(JCAttributeDef def) {
        try {
            NDSAttributeDefinition attrDef = new NDSAttributeDefinition(def.getName(), def.getSyntax(), (int)def.getConstraints(), def.getLowerLimit(), def.getUpperLimit(), def.getAsnOneID());
            return attrDef;
        }
        catch (NamespaceException e) {
            throw new AdminError(1, this.getClass().getName());
        }
    }

    private NDSClassDefinition crackJCClassDef(JCClassDef def) throws SPIException {
        String[] mandatoryNames = def.getMandatoryAttributes();
        AttributeDefinition[] mandatoryAttribs = null;
        if (mandatoryNames != null) {
            mandatoryAttribs = new AttributeDefinition[mandatoryNames.length];
            for (int i = 0; i < mandatoryNames.length; ++i) {
                mandatoryAttribs[i] = this.getAttributeDefinition(mandatoryNames[i]);
            }
        }
        String[] namingNames = def.getNamingAttributes();
        AttributeDefinition[] namingAttribs = null;
        if (namingNames != null) {
            namingAttribs = new AttributeDefinition[namingNames.length];
            for (int i = 0; i < namingNames.length; ++i) {
                namingAttribs[i] = this.getAttributeDefinition(namingNames[i]);
            }
        }
        String[] optionalNames = def.getOptionalAttributes();
        AttributeDefinition[] optionalAttribs = null;
        if (optionalNames != null) {
            optionalAttribs = new AttributeDefinition[optionalNames.length];
            for (int i = 0; i < optionalNames.length; ++i) {
                optionalAttribs[i] = this.getAttributeDefinition(optionalNames[i]);
            }
        }
        return new NDSClassDefinition(def.getName(), new NDSClassFlags((int)def.getCharacteristics()), def.getContainmentClasses(), def.getSuperClasses(), mandatoryAttribs, namingAttribs, optionalAttribs, def.getAsnOneID());
    }

    private JCAttributeDef convertToJCAttrDef(AttributeDefinition attributeDef) {
        NDSAttributeDefinition def = (NDSAttributeDefinition)attributeDef;
        return new JCAttributeDef(def.getName(), (long)def.getAttributeFlag().getFlags(), def.getSyntax().getId(), def.getLowerBound(), def.getUpperBound(), def.getASN1Data());
    }

    private JCClassDef convertToJCClassDef(ClassDefinition def) {
        AttributeDefinition[] namingAttribs = def.getNamingAttributes();
        String[] namingNames = new String[namingAttribs.length];
        for (int i = 0; i < namingAttribs.length; ++i) {
            namingNames[i] = namingAttribs[i].getName();
        }
        AttributeDefinition[] mandatoryAttribs = def.getMandatoryAttributes();
        String[] mandatoryNames = new String[mandatoryAttribs.length];
        for (int i = 0; i < mandatoryAttribs.length; ++i) {
            mandatoryNames[i] = mandatoryAttribs[i].getName();
        }
        AttributeDefinition[] optionalAttribs = def.getOptionalAttributes();
        String[] optionalNames = new String[optionalAttribs.length];
        for (int i = 0; i < optionalAttribs.length; ++i) {
            optionalNames[i] = optionalAttribs[i].getName();
        }
        NDSClassDefinition classDef = (NDSClassDefinition)def;
        return new JCClassDef(def.getName(), (long)classDef.getClassFlags().getFlags(), classDef.getSuperClasses(), classDef.getContainmentClasses(), namingNames, mandatoryNames, optionalNames, new JCAclValue[]{new JCAclValue()}, classDef.getASN1Data());
    }

    private void readTheSchema() throws SPIException {
        try {
            this.readAttributeDefinitions(null);
            this.readClassDefinitions(null);
            this.schemaDef.generateExpandedDefinitions();
            this.schemaRead = true;
        }
        catch (SPIException e) {
            throw e;
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
    }

    private class SchemaReadClassDefinitionCallback
    implements JCReadClassDefCB {
        private int cInvocations;

        private SchemaReadClassDefinitionCallback() {
        }

        public int readClassDefCallback(JCContext context, String className, JCClassDef classDef) {
            NDSClassDefinition ndsClassDef;
            try {
                ndsClassDef = NDSSchemaImpl.this.crackJCClassDef(classDef);
            }
            catch (SPIException e) {
                int retval;
                if (e instanceof UniqueSPIException) {
                    UniqueSPIException sx = (UniqueSPIException)e;
                    retval = sx.getErrorCode();
                } else {
                    retval = -754;
                }
                return retval;
            }
            NDSSchemaImpl.this.schemaDef.addClassDefinition(ndsClassDef);
            return 0;
        }

        public String toString() {
            return Integer.toString(this.cInvocations);
        }
    }
}

