/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.snapin;

import com.novell.application.console.snapin.CountableObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.Shell;
import java.util.NoSuchElementException;
import java.util.Vector;

public class BaseDefaultVirtualEnumeration
implements CountableObjectEntryEnumeration {
    protected Vector m_enumerationData;
    protected int m_iEnumerationIndex;
    protected Shell m_shell;
    private int internalCountReliability = 5;

    public BaseDefaultVirtualEnumeration(ObjectEntryEnumeration oee, Shell shell) {
        this.m_shell = shell;
        this.m_enumerationData = new Vector();
        if (oee != null) {
            while (oee.hasMoreElements()) {
                try {
                    ObjectEntry child = oee.next();
                    this.m_enumerationData.addElement(child);
                }
                catch (NoSuchElementException x) {
                    // empty catch block
                    break;
                }
            }
        }
        this.m_iEnumerationIndex = 0;
        this.internalCountReliability = 1;
        if (oee instanceof CountableObjectEntryEnumeration && ((CountableObjectEntryEnumeration)((Object)oee)).getCountReliability() == 3) {
            this.internalCountReliability = 3;
        }
    }

    public void setBlockSize(int size) {
    }

    public void refresh() {
    }

    protected int findEntry(String strTarget) {
        int i;
        int iBestMatchCharCount = 0;
        int iBestMatchIndex = -1;
        if (null == strTarget || 0 == strTarget.length()) {
            return 0;
        }
        boolean bIgnoreCase = false;
        for (int p = 0; p < 2; ++p) {
            for (i = 0; i < this.m_enumerationData.size(); ++i) {
                ObjectEntry oe = (ObjectEntry)this.m_enumerationData.elementAt(i);
                String strCandidate = this.getDisplayNameForObject(oe);
                for (int k = 1; k <= strCandidate.length(); ++k) {
                    if (strTarget.length() < k || !strTarget.regionMatches(bIgnoreCase, 0, strCandidate, 0, k)) continue;
                    if (k == strCandidate.length() && k == strTarget.length()) {
                        return i;
                    }
                    if (iBestMatchCharCount >= k) continue;
                    iBestMatchCharCount = k;
                    iBestMatchIndex = i;
                }
            }
            bIgnoreCase = true;
        }
        if (-1 != iBestMatchIndex) {
            return iBestMatchIndex;
        }
        for (i = 0; i < this.m_enumerationData.size(); ++i) {
            ObjectEntry oe = (ObjectEntry)this.m_enumerationData.elementAt(i);
            String strCandidate = this.getDisplayNameForObject(oe);
            if (0 < strTarget.compareTo(strCandidate)) continue;
            return i;
        }
        if (this.m_enumerationData.size() != 0) {
            this.m_iEnumerationIndex = this.m_enumerationData.size() - 1;
        }
        return this.m_iEnumerationIndex;
    }

    protected String getDisplayNameForObject(ObjectEntry oe) {
        String strName = null == this.m_shell ? oe.getName() : this.m_shell.getDisplayName(oe);
        return strName;
    }

    public int getCount() {
        return this.m_enumerationData.size();
    }

    public int getCountReliability() {
        return this.internalCountReliability;
    }
}

