/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.snapin;

import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.TraceWindow;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Debug {
    private static String[] modules = new String[]{"su", "Startup", "rg", "Registry", "mp", "MPEC", "tb", "ToolBar", "cl", "SnapinClassLoader", "vw", "Views"};
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFO = 3;
    public static final boolean debug = false;
    public static final int DOSBOX = 1;
    public static final int WINDOW = 2;
    public static final int FILE = 4;
    private static int media = 1;
    private static boolean traceOn = false;
    private static Hashtable timeTable = new Hashtable();
    private static String fileName = "trace.txt";
    private static PrintWriter printWriter;
    private static boolean stackTraceOn;
    static TraceWindow window;
    private static Hashtable debugModules;
    private static Hashtable debugOn;
    private static boolean firstWriteMedia;
    private static Object firstLockObject;
    private static Method dout_ReflectedMethod;

    public static boolean isDebug() {
        return traceOn;
    }

    public static boolean getTrace() {
        return traceOn;
    }

    public static void setTrace(boolean traceMode) {
        traceOn = traceMode;
        if (window != null) {
            window.setVisible(traceMode);
        }
    }

    public static void setDebugModules(String modules) {
        StringTokenizer tokenizer = new StringTokenizer(modules, ";");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            debugOn.put(debugModules.get(token), " ");
        }
    }

    public static void startTime(String key) {
        if (traceOn) {
            timeTable.put(key, new Long(new Date().getTime()));
        }
    }

    public static void stopTime(String key) {
        if (traceOn) {
            long now = new Date().getTime();
            long start = (Long)timeTable.get(key);
            long diff = now - start;
            Debug.out("Time for " + key + " = " + (double)diff / 1000.0);
        }
    }

    public static void closeMedia() {
        if ((media & 2) == 2 && window != null) {
            window.dispose();
            window = null;
        }
        if ((media & 4) == 4 && printWriter != null) {
            printWriter.close();
            printWriter = null;
        }
    }

    public static void setFileName(String string) {
        if (fileName.compareTo(string) != 0) {
            File file = new File(fileName);
            if (file.length() == 0L) {
                if (printWriter != null) {
                    printWriter.flush();
                    printWriter.close();
                }
                file.delete();
            }
            fileName = string;
            try {
                printWriter = new PrintWriter(new FileWriter(new File(fileName)));
            }
            catch (IOException e) {
                System.err.println("IOException in Debug::setFileName() trying to open file " + fileName + " - " + e);
            }
        }
    }

    public static void setMedia(int mediaFlags) {
        media = mediaFlags;
        Debug.closeMedia();
        if ((media & 2) == 2) {
            window = new TraceWindow();
            window.setVisible(true);
        }
        if ((media & 4) == 4) {
            try {
                printWriter = new PrintWriter(new FileWriter(new File(fileName)));
            }
            catch (IOException e) {
                System.err.println("IOException in Debug::setMedia() trying to open file " + fileName + " - " + e);
            }
        }
    }

    public static void out(String message, ObjectEntry entry) {
        Debug.out(message + ":" + entry.getName());
    }

    public static void out(ObjectEntry[] entries) {
        for (int i = 0; i < entries.length; ++i) {
            Debug.out("", entries[i]);
        }
    }

    public static void reportSnapinError(Throwable e) {
        Debug.out("Snapin error - ");
        e.printStackTrace();
    }

    public static void reportException(String message, Throwable e) {
        Debug.out(message);
        e.printStackTrace();
    }

    public static void devout(String module, String string) {
        if (traceOn && debugOn.contains(module)) {
            Debug.out(string);
        }
    }

    public static void out(String module, String string) {
        if (traceOn && debugOn.contains(module)) {
            Debug.out(string);
        }
    }

    public static void out(String string) {
        Debug.writeToMedia(string);
    }

    public static void out(String string, int logLevel) {
        Debug.writeToMedia(string, logLevel, 6);
    }

    public static void out(int value) {
        String string = String.valueOf(value);
        Debug.out(string);
    }

    public static void out(float value) {
        Debug.out(String.valueOf(value));
    }

    public static void out(long value) {
        Debug.out(String.valueOf(value));
    }

    public static void out(String message, Object obj) {
        Debug.writeToMedia(message);
        Debug.out(obj);
    }

    public static void out(Object object) {
        if (object == null) {
            Debug.out("null");
        } else if (object instanceof Vector) {
            Debug.out(((Vector)object).elements());
        } else if (object instanceof Dictionary) {
            Debug.out(((Dictionary)object).elements());
        } else if (!object.getClass().isArray()) {
            Debug.out(object.toString());
        }
    }

    public static void out(Enumeration myenum) {
        while (myenum.hasMoreElements()) {
            Debug.out(myenum.nextElement());
        }
    }

    public static void setStackTrace(boolean b) {
        stackTraceOn = b;
    }

    public static void n_assert(boolean condition, Object obj, String msg) {
        block12: {
            if (traceOn && !condition) {
                Debug.out("*************************************");
                Debug.out("ASSERTION FAILURE");
                if (msg != null) {
                    Debug.out("Note: " + msg);
                }
                if (obj != null) {
                    Debug.out("Class: " + obj.getClass().getName());
                    Debug.out("Object: " + obj);
                }
                Debug.out("*************************************");
                if (stackTraceOn) {
                    try {
                        if (msg == null) {
                            throw new Exception();
                        }
                        throw new Exception(msg);
                    }
                    catch (Exception e) {
                        Debug.out("Stack Trace...");
                        if ((media & 1) == 1) {
                            e.printStackTrace();
                        }
                        if ((media & 2) == 2 && window != null) {
                            try {
                                File tmpFile = new File("tmp.txt");
                                PrintWriter tmpWriter = new PrintWriter(new FileWriter(tmpFile));
                                e.printStackTrace(tmpWriter);
                                tmpWriter.flush();
                                tmpWriter.close();
                                FileReader reader = new FileReader(tmpFile);
                                String buffer = "";
                                int c = reader.read();
                                while (c != -1) {
                                    buffer = buffer + (char)c;
                                    c = reader.read();
                                }
                                reader.close();
                                window.write(buffer);
                                tmpFile.delete();
                            }
                            catch (IOException ioE) {
                                // empty catch block
                            }
                        }
                        if ((media & 4) != 4 || printWriter == null) break block12;
                        e.printStackTrace(printWriter);
                        printWriter.flush();
                    }
                }
            }
        }
    }

    public static void n_assert(boolean condition) {
        Debug.n_assert(condition, null, null);
    }

    public static void n_assert(boolean condition, String message) {
        Debug.n_assert(condition, null, message);
    }

    public static void writeToMedia(String string) {
        Debug.writeToMedia(string, 3, 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToMedia(String string, int logLevel, int callSiteRewindCount) {
        if (firstWriteMedia) {
            Object object = firstLockObject;
            synchronized (object) {
                if (firstWriteMedia) {
                    try {
                        Class<?> iman_D = Class.forName("com.novell.emframe.dev.D");
                        dout_ReflectedMethod = iman_D.getMethod("log", string.getClass(), Integer.TYPE, Integer.TYPE);
                    }
                    catch (Throwable te) {
                        dout_ReflectedMethod = null;
                    }
                    firstWriteMedia = false;
                }
            }
        }
        if (dout_ReflectedMethod != null) {
            try {
                if (logLevel < 1 || logLevel > 3) {
                    logLevel = 3;
                }
                dout_ReflectedMethod.invoke(null, string, new Integer(logLevel), new Integer(callSiteRewindCount));
            }
            catch (Throwable te) {
                System.out.println("Error in Debug Output: " + te.toString());
                System.out.println(string);
            }
        } else if (traceOn) {
            if ((media & 1) == 1) {
                System.out.println(string);
            }
            if ((media & 2) == 2 && window != null) {
                window.setVisible(true);
                window.write(string);
            }
            if ((media & 4) == 4 && printWriter != null) {
                printWriter.println(string);
                printWriter.flush();
            }
        }
    }

    static {
        stackTraceOn = true;
        debugModules = new Hashtable();
        debugOn = new Hashtable();
        firstWriteMedia = true;
        firstLockObject = new Object();
        dout_ReflectedMethod = null;
        for (int i = 0; i < modules.length; i += 2) {
            debugModules.put(modules[i + 1], modules[i]);
        }
        Debug.setDebugModules("Startup;Views");
    }
}

