/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.snapin;

import com.novell.application.console.snapin.BaseDefaultVirtualEnumeration;
import com.novell.application.console.snapin.Debug;
import com.novell.application.console.snapin.IndexedObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.snapin.SnapinException;

public class DefaultIndexedObjectEntryEnumeration
extends BaseDefaultVirtualEnumeration
implements IndexedObjectEntryEnumeration {
    private static final int IENUMPOS_BEFOREENUM = -1;
    private static final int IENUMPOS_AFTERENUM = -2;

    public DefaultIndexedObjectEntryEnumeration(ObjectEntryEnumeration oee, Shell shell) {
        super(oee, shell);
    }

    public boolean hasMoreElements() {
        return -2 != this.m_iEnumerationIndex && this.m_iEnumerationIndex < this.m_enumerationData.size();
    }

    public Object nextElement() {
        ObjectEntry next = null;
        ObjectEntry[] arNext = this.getNext(1);
        if (0 != arNext.length) {
            next = arNext[0];
        }
        return next;
    }

    public ObjectEntry next() {
        return (ObjectEntry)this.nextElement();
    }

    public ObjectEntry previous() {
        ObjectEntry prev = null;
        ObjectEntry[] arPrev = this.getPrev(1);
        if (0 != arPrev.length) {
            prev = arPrev[0];
        }
        return prev;
    }

    public int moveFirst() {
        this.m_iEnumerationIndex = 0;
        return this.m_iEnumerationIndex;
    }

    public int moveLast() {
        this.m_iEnumerationIndex = this.m_enumerationData.size() != 0 ? this.m_enumerationData.size() - 1 : 0;
        return this.m_iEnumerationIndex;
    }

    public int moveTo(int index) {
        this.m_iEnumerationIndex = index < this.m_enumerationData.size() ? index : -2;
        return this.m_iEnumerationIndex;
    }

    public int moveTo(String targetName) throws SnapinException {
        int iNewEntryIndex = this.findEntry(targetName);
        if (-1 != iNewEntryIndex) {
            this.m_iEnumerationIndex = iNewEntryIndex;
            return this.m_iEnumerationIndex;
        }
        if (-1 == this.m_iEnumerationIndex) {
            this.m_iEnumerationIndex = 0;
        } else if (-2 == this.m_iEnumerationIndex) {
            this.m_iEnumerationIndex = 0;
            if (0 != this.m_enumerationData.size()) {
                this.m_iEnumerationIndex = this.m_enumerationData.size() - 1;
            }
        }
        return this.m_iEnumerationIndex;
    }

    public ObjectEntry[] getNext(int count) {
        if (-2 == this.m_iEnumerationIndex || 0 == count) {
            return new ObjectEntry[0];
        }
        if (-1 == this.m_iEnumerationIndex) {
            this.m_iEnumerationIndex = 0;
        }
        if (this.m_iEnumerationIndex + count > this.m_enumerationData.size()) {
            count = this.m_enumerationData.size() - this.m_iEnumerationIndex;
        }
        ObjectEntry[] oes = new ObjectEntry[count];
        for (int i = 0; i < count; ++i) {
            oes[i] = null;
            if (this.m_iEnumerationIndex >= this.m_enumerationData.size()) continue;
            oes[i] = (ObjectEntry)this.m_enumerationData.elementAt(this.m_iEnumerationIndex);
            ++this.m_iEnumerationIndex;
        }
        if (this.m_iEnumerationIndex >= this.m_enumerationData.size()) {
            this.m_iEnumerationIndex = -2;
        }
        return oes;
    }

    public ObjectEntry[] getPrev(int count) {
        boolean bResultIndexIsBeforeList = false;
        if (-1 == this.m_iEnumerationIndex || 0 == count) {
            return new ObjectEntry[0];
        }
        if (-2 == this.m_iEnumerationIndex) {
            this.m_iEnumerationIndex = this.m_enumerationData.size();
        }
        if (this.m_iEnumerationIndex - count < 0) {
            count += this.m_iEnumerationIndex - count;
            bResultIndexIsBeforeList = true;
            this.m_iEnumerationIndex = 0;
        } else {
            this.m_iEnumerationIndex -= count;
        }
        int iNewIndex = this.m_iEnumerationIndex;
        ObjectEntry[] oes = this.getNext(count);
        this.m_iEnumerationIndex = iNewIndex;
        if (bResultIndexIsBeforeList) {
            this.m_iEnumerationIndex = -1;
        }
        return oes;
    }

    public void insert(ObjectEntry oe, int index) {
        Debug.n_assert(index >= 0 && index <= this.m_enumerationData.size(), "Invalid index passed to DefaultIndexedObjectEntryEnumeration.insert(): Size = " + this.m_enumerationData.size() + " index = " + index);
        if (index < 0 || index > this.m_enumerationData.size()) {
            return;
        }
        this.m_enumerationData.insertElementAt(oe, index);
    }

    public void append(ObjectEntry oe) {
        this.m_enumerationData.addElement(oe);
    }

    public int remove(ObjectEntry oe) {
        int location = this.m_enumerationData.indexOf(oe);
        if (location != -1) {
            this.m_enumerationData.removeElementAt(location);
            int count = this.getCount();
            if (this.m_iEnumerationIndex >= count) {
                this.moveLast();
            }
        } else {
            Debug.out("Could not find ObjectEntry to delete in DefaultIndexedObjectEntryEnumration.remove(): ObjectEntry = " + oe);
        }
        return location;
    }

    public void replace(ObjectEntry oldEntry, ObjectEntry newEntry) {
        int indexOfOld = this.m_enumerationData.indexOf(oldEntry);
        if (indexOfOld != -1) {
            this.m_enumerationData.setElementAt(newEntry, indexOfOld);
        } else {
            Debug.out("Could not find ObjectEntry to replace in DefaultIndexedObjectEntryEnumration.replace(): ObjectEntry = " + oldEntry);
        }
    }
}

