/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.snapin;

import com.novell.admin.ns.AdminNamespace;
import com.novell.application.console.snapin.NamespaceSnapin;
import java.io.Serializable;

public class ObjectType
implements Serializable {
    private String m_className;
    private NamespaceSnapin m_nameSpace;
    protected boolean m_container;
    protected ObjectType[] m_parentType;
    protected boolean m_filesystem = false;
    protected boolean m_shortcut = false;
    protected boolean m_isNull = false;
    protected boolean m_isHidden = false;
    private String key = null;

    public ObjectType(String name, NamespaceSnapin space, boolean container, ObjectType parentType) {
        this.m_className = name;
        this.m_nameSpace = space;
        this.m_container = container;
        if (parentType == null) {
            this.m_parentType = null;
        } else {
            this.m_parentType = new ObjectType[1];
            this.m_parentType[0] = parentType;
        }
        this.createKey();
    }

    public ObjectType(String name, NamespaceSnapin space, boolean container, ObjectType[] parentTypes) {
        this.m_className = name;
        this.m_nameSpace = space;
        this.m_container = container;
        this.m_parentType = parentTypes;
        this.createKey();
    }

    public ObjectType(String name, NamespaceSnapin space, boolean container) {
        this.m_className = name;
        this.m_nameSpace = space;
        this.m_container = container;
        this.m_parentType = null;
        this.createKey();
    }

    public ObjectType(NamespaceSnapin space, boolean container, ObjectType[] parentTypes) {
        this.m_className = "";
        this.m_nameSpace = space;
        this.m_container = container;
        this.m_parentType = parentTypes;
        this.m_isNull = true;
        this.createKey();
    }

    public ObjectType(String name, NamespaceSnapin space, boolean container, ObjectType parentType, boolean shortcut) {
        this.m_className = name;
        this.m_shortcut = shortcut;
        this.m_nameSpace = space;
        this.m_container = container;
        if (parentType == null) {
            this.m_parentType = null;
        } else {
            this.m_parentType = new ObjectType[1];
            this.m_parentType[0] = parentType;
        }
        this.createKey();
    }

    public ObjectType(String name, NamespaceSnapin space, boolean container, ObjectType[] parentTypes, boolean shortcut) {
        this.m_className = name;
        this.m_shortcut = shortcut;
        this.m_nameSpace = space;
        this.m_container = container;
        this.m_parentType = parentTypes;
        this.createKey();
    }

    public ObjectType[] getParentTypes() {
        if (this.m_parentType == null || this.m_parentType.length == 0) {
            return null;
        }
        return this.m_parentType;
    }

    public boolean isShortcut() {
        return this.m_shortcut;
    }

    public final String getName() {
        return this.m_className;
    }

    public boolean isContainer() {
        return this.m_container;
    }

    public boolean isFileSystem() {
        return this.m_filesystem;
    }

    public void setIsFileSystem(boolean isFileSystem) {
        this.m_filesystem = isFileSystem;
    }

    public final AdminNamespace getAdminNamespace() {
        return (AdminNamespace)this.m_nameSpace;
    }

    public final NamespaceSnapin getNamespace() {
        return this.m_nameSpace;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ObjectType)) {
            return false;
        }
        ObjectType ot = (ObjectType)object;
        return this.getKey().equals(ot.getKey());
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public final String getKey() {
        return this.key;
    }

    public boolean isNull() {
        return this.m_isNull;
    }

    public void setHidden(boolean hide) {
        this.m_isHidden = hide;
    }

    public boolean isHidden() {
        return this.m_isHidden;
    }

    private final void createKey() {
        this.key = this.m_nameSpace.getUniqueID() + "%" + this.m_className;
    }

    public String toString() {
        String ret = "OTName = '" + this.m_className + "',  Namespace = '" + this.m_nameSpace.getUniqueID() + "',  Container = " + this.m_container;
        if (this.m_parentType != null) {
            for (int i = 0; i < this.m_parentType.length; ++i) {
                ret = this.m_parentType.length > 1 ? ret + "\n  Parent " + i + " = '" + this.m_parentType[i].getName() + "'" : ret + "\n  Parent = '" + this.m_parentType[i].getName() + "'";
            }
        }
        return ret;
    }
}

