/*
 * Decompiled with CFR 0.152.
 */
package com.novell.java.security;

import java.util.Properties;

public abstract class Provider
extends Properties {
    private String name;
    private String info;
    private double version;
    static final long serialVersionUID = -4298000515446427739L;

    protected Provider(String string, double d, String string2) {
        this.name = string;
        this.version = d;
        this.info = string2;
    }

    Provider(String string) {
        this(string, 1.0, "no information available");
    }

    public String getName() {
        return this.name;
    }

    public double getVersion() {
        return this.version;
    }

    public String getInfo() {
        return this.info;
    }

    static Provider loadProvider(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            if (obj instanceof Provider) {
                return (Provider)obj;
            }
        }
        catch (Exception exception) {
            Provider.debug("error loading provider " + string, exception);
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.name) + " version " + this.version;
    }

    public synchronized void clear() {
        Provider.check("Provider.clear." + this.name);
        super.clear();
    }

    public synchronized Object put(Object object, Object object2) {
        Provider.check("Provider.put." + this.name);
        return super.put(object, object2);
    }

    public synchronized Object remove(Object object) {
        Provider.check("Provider.remove." + this.name);
        return super.remove(object);
    }

    private static void check(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess(string);
        }
    }

    private static void debug(String string) {
    }

    private static void debug(String string, Throwable throwable) {
    }
}

