/*
 * Decompiled with CFR 0.152.
 */
package com.novell.java.security.cert;

import com.novell.java.security.cert.CRLException;
import com.novell.java.security.cert.RevokedCertificate;
import com.novell.java.security.cert.X509Extension;
import com.novell.java.security.cert.X509ExtensionException;
import com.novell.java.util.Set;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.util.Date;

public abstract class X509CRL
implements X509Extension {
    private static final String X509_PROVIDER = "crl.provider.x509";
    static /* synthetic */ Class class$java$io$InputStream;

    public static final X509CRL getInstance(InputStream inputStream) throws CRLException, X509ExtensionException {
        return X509CRL.getInst(inputStream);
    }

    public static final X509CRL getInstance(byte[] byArray) throws CRLException, X509ExtensionException {
        return X509CRL.getInst(byArray);
    }

    private static final X509CRL getInst(Object object) throws CRLException, X509ExtensionException {
        String string = Security.getProperty(X509_PROVIDER);
        if (string == null) {
            string = "sun.security.x509.X509CRLImpl";
        }
        try {
            Class[] classArray = null;
            if (object instanceof InputStream) {
                classArray = new Class[]{class$java$io$InputStream != null ? class$java$io$InputStream : (class$java$io$InputStream = X509CRL.class$("java.io.InputStream"))};
            } else if (object instanceof byte[]) {
                classArray = new Class[]{object.getClass()};
            } else {
                throw new CRLException("Unsupported arg type");
            }
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object obj = constructor.newInstance(object);
            return (X509CRL)obj;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CRLException("Could not find class: " + classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CRLException("Could not access class: " + illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new CRLException("Problems instantiating: " + instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CRLException("InvocationTargetException: " + invocationTargetException.getTargetException());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new CRLException("Could not find class method: " + noSuchMethodException.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof X509CRL)) {
            return false;
        }
        try {
            byte[] byArray = this.getEncoded();
            byte[] byArray2 = ((X509CRL)object).getEncoded();
            if (byArray.length != byArray2.length) {
                return false;
            }
            int n = 0;
            while (n < byArray.length) {
                if (byArray[n] != byArray2[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        catch (CRLException cRLException) {
            return false;
        }
    }

    public int hashCode() {
        int n = 0;
        try {
            byte[] byArray = this.getEncoded();
            int n2 = 1;
            while (n2 < byArray.length) {
                n += byArray[n2] * n2;
                ++n2;
            }
            return n;
        }
        catch (CRLException cRLException) {
            return n;
        }
    }

    public abstract byte[] getEncoded() throws CRLException;

    public abstract void verify(PublicKey var1) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract void verify(PublicKey var1, String var2) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract String toString();

    public abstract boolean isRevoked(BigInteger var1);

    public abstract int getVersion();

    public abstract Principal getIssuerDN();

    public abstract Date getThisUpdate();

    public abstract Date getNextUpdate();

    public abstract RevokedCertificate getRevokedCertificate(BigInteger var1);

    public abstract Set getRevokedCertificates();

    public abstract byte[] getTBSCertList() throws CRLException, X509ExtensionException;

    public abstract byte[] getSignature();

    public abstract String getSigAlgName();

    public abstract String getSigAlgOID();

    public abstract byte[] getSigAlgParams();

    public abstract Set getCriticalExtensionOIDs();

    public abstract Set getNonCriticalExtensionOIDs();

    public abstract byte[] getExtensionValue(String var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

