/*
 * Decompiled with CFR 0.152.
 */
package com.novell.java.security.cert;

import com.novell.java.security.Principal;
import com.novell.java.security.cert.Certificate;
import com.novell.java.security.cert.CertificateEncodingException;
import com.novell.java.security.cert.CertificateException;
import com.novell.java.security.cert.CertificateExpiredException;
import com.novell.java.security.cert.CertificateNotYetValidException;
import com.novell.java.security.cert.CertificateParsingException;
import com.novell.java.security.cert.X509Extension;
import com.novell.java.util.Set;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.security.Security;
import java.util.Date;

public abstract class X509Certificate
extends Certificate
implements X509Extension {
    private static final String X509_PROVIDER = "cert.provider.x509";
    static /* synthetic */ Class class$java$io$InputStream;

    public static final X509Certificate getInstance(InputStream inputStream) throws CertificateException {
        return X509Certificate.getInst(inputStream);
    }

    public static final X509Certificate getInstance(byte[] byArray) throws CertificateException {
        return X509Certificate.getInst(byArray);
    }

    private static final X509Certificate getInst(Object object) throws CertificateException {
        String string = Security.getProperty(X509_PROVIDER);
        if (string == null) {
            string = "sun.security.x509.X509CertImpl";
        }
        try {
            Class[] classArray = null;
            if (object instanceof InputStream) {
                classArray = new Class[]{class$java$io$InputStream != null ? class$java$io$InputStream : (class$java$io$InputStream = X509Certificate.class$("java.io.InputStream"))};
            } else if (object instanceof byte[]) {
                classArray = new Class[]{object.getClass()};
            } else {
                throw new CertificateException("Unsupported argument type");
            }
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object obj = constructor.newInstance(object);
            return (X509Certificate)obj;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CertificateException("Could not find class: " + classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CertificateException("Could not access class: " + illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new CertificateException("Problems instantiating: " + instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CertificateException("InvocationTargetException: " + invocationTargetException.getTargetException());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new CertificateException("Could not find class method: " + noSuchMethodException.getMessage());
        }
    }

    public abstract void checkValidity() throws CertificateParsingException, CertificateExpiredException, CertificateNotYetValidException;

    public abstract void checkValidity(Date var1) throws CertificateParsingException, CertificateExpiredException, CertificateNotYetValidException;

    public abstract int getVersion();

    public abstract BigInteger getSerialNumber();

    public abstract Principal getIssuerDN();

    public abstract Principal getSubjectDN();

    public abstract Date getNotBefore();

    public abstract Date getNotAfter();

    public abstract byte[] getTBSCertificate() throws CertificateEncodingException;

    public abstract byte[] getSignature();

    public abstract String getSigAlgName();

    public abstract String getSigAlgOID();

    public abstract byte[] getSigAlgParams();

    public abstract boolean[] getIssuerUniqueID();

    public abstract boolean[] getSubjectUniqueID();

    public abstract boolean[] getKeyUsage();

    public abstract int getBasicConstraints();

    public abstract Set getCriticalExtensionOIDs();

    public abstract Set getNonCriticalExtensionOIDs();

    public abstract byte[] getExtensionValue(String var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

