/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.file.nw.calls;

import com.novell.service.file.nw.DirectoryEntryInformation;
import com.novell.service.file.nw.NameSpace;
import com.novell.service.file.nw.calls.ObjectName;
import com.novell.service.file.nw.calls.ObjectNameImpl;
import com.novell.service.file.nw.naming.FSAttribute;
import com.novell.service.file.nw.naming.FSEnvironment;
import com.novell.service.file.nw.naming.SchemaAttrDef;
import com.novell.service.file.nw.naming.SchemaSyntaxDef;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.rfc1960.SearchStringComponent;
import com.novell.service.session.SessionException;
import com.novell.service.session.xplat.CallsService;
import com.novell.utility.naming.directory.StaticAttributeValue;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeModificationException;
import javax.naming.directory.InvalidSearchFilterException;

public class DirectoryEntryInfoImpl
extends DirectoryEntryInformation
implements StaticAttributeValue {
    public static final int FA_NORMAL = 0;
    public static final int FA_READ_ONLY = 1;
    public static final int FA_HIDDEN = 2;
    public static final int FA_SYSTEM = 4;
    public static final int FA_EXECUTE_ONLY = 8;
    public static final int FA_DIRECTORY = 16;
    public static final int FA_NEEDS_ARCHIVED = 32;
    public static final int FA_SHAREABLE = 128;
    public static final int IM_ENTRY_NAME = 1;
    static final int IM_SPACE_ALLOWED = 2;
    public static final int IM_ATTRIBUTES = 4;
    static final int IM_SIZE = 8;
    static final int IM_TOTAL_SIZE = 16;
    static final int IM_EA = 32;
    static final int IM_ARCHIVE = 64;
    static final int IM_MODIFY = 128;
    static final int IM_CREATION = 256;
    static final int IM_OWNING_NAMESPAC = 512;
    static final int IM_DIRECTORY = 1024;
    static final int IM_RIGHTS = 2048;
    private FSEnvironment environment;
    private String fullNodeName;
    private String nameSpace;
    private NetService netService;
    private CallsService callsService;
    private boolean sessionIsNDS;
    private boolean hasMoreElements = true;
    private final int refreshMask = 4095;

    public DirectoryEntryInfoImpl(FSEnvironment fSEnvironment) throws NSIException {
        this.environment = fSEnvironment;
        this.fullNodeName = fSEnvironment.getFullNodeName();
        this.nameSpace = fSEnvironment.getNameSpace();
        try {
            this.callsService = fSEnvironment.getCallsService();
            this.netService = fSEnvironment.getNetService();
            this.sessionIsNDS = fSEnvironment.sessionIsNDS();
            return;
        }
        catch (NamingException namingException) {
            throw new NSIException(String.valueOf(namingException), namingException);
        }
    }

    private DirectoryEntryInfoImpl(DirectoryEntryInformation directoryEntryInformation, int n, int n2, int n3) {
        super(directoryEntryInformation.getSpaceAlloc(), directoryEntryInformation.getAttributes(), directoryEntryInformation.getFlags(), directoryEntryInformation.getDataStreamSize(), directoryEntryInformation.getTotalStreamSize(), directoryEntryInformation.getNumberOfStreams(), directoryEntryInformation.getCreationTime(), directoryEntryInformation.getCreationDate(), directoryEntryInformation.getCreator(), directoryEntryInformation.getModifyTime(), directoryEntryInformation.getModifyDate(), directoryEntryInformation.getModifier(), directoryEntryInformation.getLastAccessDate(), directoryEntryInformation.getArchiveTime(), directoryEntryInformation.getArchiveDate(), directoryEntryInformation.getArchiver(), directoryEntryInformation.getInheritedRightsMask(), directoryEntryInformation.getDirEntNum(), directoryEntryInformation.getDosDirNum(), directoryEntryInformation.getVolNumber(), directoryEntryInformation.getEADataSize(), directoryEntryInformation.getEAKeyCount(), directoryEntryInformation.getEAKeySize(), directoryEntryInformation.getNSCreator(), directoryEntryInformation.getNameLength(), directoryEntryInformation.getEntryName(), directoryEntryInformation.getModifySearchAttributes());
        this.creatorID = n;
        this.modifierID = n2;
        this.archiverID = n3;
    }

    public boolean hasMoreElements() {
        return this.hasMoreElements;
    }

    public Object nextElement() {
        if (!this.hasMoreElements) {
            throw new NoSuchElementException();
        }
        this.hasMoreElements = false;
        this.refresh(4095);
        return this;
    }

    public Attribute buildAttribute() throws NamingException {
        DirectoryEntryInfoImpl directoryEntryInfoImpl = null;
        try {
            directoryEntryInfoImpl = new DirectoryEntryInfoImpl(this.environment);
        }
        catch (NSIException nSIException) {
            NamingException namingException = new NamingException(nSIException.getMessage());
            namingException.setRootCause(nSIException);
            throw namingException;
        }
        return new FSAttribute("Entry Information", directoryEntryInfoImpl, new SchemaAttrDef(0, this.environment), new SchemaSyntaxDef(0, this.environment));
    }

    public void addAttribute(Attribute attribute) throws NamingException {
        throw new AttributeModificationException();
    }

    public void deleteAttribute(Attribute attribute) throws NamingException {
        throw new AttributeModificationException();
    }

    public void modifyAttribute(Attribute attribute) throws NamingException {
        NamingEnumeration<?> namingEnumeration = attribute.getAll();
        while (namingEnumeration.hasMoreElements()) {
            DirectoryEntryInformation directoryEntryInformation = (DirectoryEntryInformation)namingEnumeration.nextElement();
            try {
                this.modify(directoryEntryInformation);
            }
            catch (NSIException nSIException) {
                AttributeModificationException attributeModificationException = new AttributeModificationException();
                attributeModificationException.setRootCause(nSIException);
                throw attributeModificationException;
            }
        }
    }

    public String getID() {
        return "Entry Information";
    }

    public boolean compare(SearchStringComponent searchStringComponent) throws NamingException {
        try {
            return this.equals(searchStringComponent);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            InvalidSearchFilterException invalidSearchFilterException = new InvalidSearchFilterException();
            invalidSearchFilterException.setRootCause(illegalArgumentException);
            throw invalidSearchFilterException;
        }
    }

    public boolean equals(SearchStringComponent searchStringComponent) {
        if (searchStringComponent == null) {
            return false;
        }
        int n = searchStringComponent.getOperationType();
        if (n == 4) {
            return true;
        }
        if (n != 0 && n != 5) {
            return false;
        }
        DirectoryEntryInformation directoryEntryInformation = null;
        String string = null;
        boolean bl = true;
        if (searchStringComponent.operandReplacement()) {
            directoryEntryInformation = (DirectoryEntryInformation)searchStringComponent.getReplacementObject();
            if (directoryEntryInformation == null) {
                throw new IllegalArgumentException(searchStringComponent.getOperation());
            }
            DirectoryEntryInformation directoryEntryInformation2 = directoryEntryInformation;
            synchronized (directoryEntryInformation2) {
                string = directoryEntryInformation.getEntryName();
            }
            bl = false;
        } else {
            string = searchStringComponent.getOperand();
        }
        this.refresh(4095);
        if (n == 0) {
            if (bl) {
                return string.equalsIgnoreCase(this.getEntryName());
            }
            try {
                DirectoryEntryInformation directoryEntryInformation3 = directoryEntryInformation;
                synchronized (directoryEntryInformation3) {
                    boolean bl2 = this.equals(directoryEntryInformation);
                    Object var8_9 = null;
                    return bl2;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (n == 5) {
            return SearchStringComponent.compareSubString(string, this.getEntryName(), true);
        }
        return false;
    }

    public Object getStaticInterface() {
        DirectoryEntryInfoImpl directoryEntryInfoImpl = null;
        directoryEntryInfoImpl = new DirectoryEntryInfoImpl(this.environment);
        directoryEntryInfoImpl.refresh(4095);
        return directoryEntryInfoImpl;
    }

    public void refresh(int n) throws NSIException {
        ObjectName objectName;
        int n2 = 511;
        try {
            this.callsService.getNSEntryInfo(0, this.fullNodeName, NameSpace.nameToNumber(this.nameSpace), NameSpace.nameToNumber(this.nameSpace), n2, n, this);
        }
        catch (SessionException sessionException) {
            throw new NSIException(sessionException.getMessage(), 0, sessionException);
        }
        try {
            objectName = ObjectNameImpl.objectIdToObjectName(this.creatorID, this.callsService, this.netService, this.sessionIsNDS);
            this.setCreator(objectName.getName());
        }
        catch (NSIException nSIException) {
            this.setCreator("");
        }
        try {
            objectName = ObjectNameImpl.objectIdToObjectName(this.modifierID, this.callsService, this.netService, this.sessionIsNDS);
            this.setModifier(objectName.getName());
        }
        catch (NSIException nSIException) {
            this.setModifier("");
        }
        try {
            objectName = ObjectNameImpl.objectIdToObjectName(this.archiverID, this.callsService, this.netService, this.sessionIsNDS);
            this.setArchiver(objectName.getName());
            return;
        }
        catch (NSIException nSIException) {
            this.setArchiver("");
            return;
        }
    }

    public void modify(DirectoryEntryInformation directoryEntryInformation) throws NSIException {
        DirectoryEntryInformation directoryEntryInformation2 = directoryEntryInformation;
        synchronized (directoryEntryInformation2) {
            int n = directoryEntryInformation.getModifyMask();
            if (n == 0) {
                Object var3_4 = null;
                return;
            }
            int n2 = (n & 0x10) != 0 ? ObjectNameImpl.nameToObjectId(directoryEntryInformation.getCreator(), this.callsService, this.netService, this.sessionIsNDS) : 0;
            int n3 = (n & 0x80) != 0 ? ObjectNameImpl.nameToObjectId(directoryEntryInformation.getArchiver(), this.callsService, this.netService, this.sessionIsNDS) : 0;
            int n4 = (n & 0x400) != 0 ? ObjectNameImpl.nameToObjectId(directoryEntryInformation.getModifier(), this.callsService, this.netService, this.sessionIsNDS) : 0;
            DirectoryEntryInfoImpl directoryEntryInfoImpl = null;
            if (directoryEntryInformation instanceof DirectoryEntryInfoImpl) {
                directoryEntryInfoImpl = (DirectoryEntryInfoImpl)directoryEntryInformation;
                directoryEntryInfoImpl.creatorID = n2;
                directoryEntryInfoImpl.modifierID = n4;
                directoryEntryInfoImpl.archiverID = n3;
            } else {
                directoryEntryInfoImpl = new DirectoryEntryInfoImpl(directoryEntryInformation, n2, n4, n3);
            }
            try {
                this.callsService.setNSEntryDOSInfo(0, this.fullNodeName, NameSpace.nameToNumber(this.nameSpace), directoryEntryInformation.getModifySearchAttributes(), directoryEntryInformation.getModifyMask(), directoryEntryInfoImpl);
            }
            catch (SessionException sessionException) {
                throw new NSIException(sessionException.getMessage(), 0, sessionException);
            }
            return;
        }
    }
}

