/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.file.nw.calls;

import com.novell.service.file.nw.EffectiveRights;
import com.novell.service.file.nw.NameSpace;
import com.novell.service.file.nw.calls.ObjectNameImpl;
import com.novell.service.file.nw.naming.FSAttribute;
import com.novell.service.file.nw.naming.FSEnvironment;
import com.novell.service.file.nw.naming.SchemaAttrDef;
import com.novell.service.file.nw.naming.SchemaSyntaxDef;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.rfc1960.SearchStringComponent;
import com.novell.service.session.SessionException;
import com.novell.service.session.xplat.CallsService;
import com.novell.utility.naming.directory.StaticAttributeValue;
import java.util.NoSuchElementException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeModificationException;
import javax.naming.directory.InvalidSearchFilterException;

public class EffectiveRightsImpl
extends EffectiveRights
implements StaticAttributeValue {
    private FSEnvironment environment;
    private String fullNodeName;
    private String nameSpace;
    private NetService netService;
    private CallsService callsService;
    private boolean sessionIsNDS;
    private boolean hasMoreElements = true;

    public EffectiveRightsImpl(FSEnvironment fSEnvironment) throws NSIException {
        this.environment = fSEnvironment;
        this.fullNodeName = fSEnvironment.getFullNodeName();
        if (this.fullNodeName.indexOf(58) == -1) {
            this.fullNodeName = String.valueOf(this.fullNodeName) + ":";
        }
        this.nameSpace = fSEnvironment.getNameSpace();
        try {
            this.callsService = fSEnvironment.getCallsService();
            this.netService = fSEnvironment.getNetService();
            this.sessionIsNDS = fSEnvironment.sessionIsNDS();
            return;
        }
        catch (NamingException namingException) {
            throw new NSIException(String.valueOf(namingException), namingException);
        }
    }

    private EffectiveRightsImpl(EffectiveRights effectiveRights, int n) {
        super(effectiveRights.getRights(), effectiveRights.getUser());
        this.userId = this.userId;
    }

    public boolean hasMoreElements() {
        return this.hasMoreElements;
    }

    public Object nextElement() {
        if (!this.hasMoreElements) {
            throw new NoSuchElementException();
        }
        this.hasMoreElements = false;
        this.refresh();
        return this;
    }

    public Attribute buildAttribute() throws NamingException {
        EffectiveRightsImpl effectiveRightsImpl = null;
        try {
            effectiveRightsImpl = new EffectiveRightsImpl(this.environment);
        }
        catch (NSIException nSIException) {
            NamingException namingException = new NamingException(nSIException.getMessage());
            namingException.setRootCause(nSIException);
            throw namingException;
        }
        return new FSAttribute("Effective Rights", effectiveRightsImpl, new SchemaAttrDef(7, this.environment), new SchemaSyntaxDef(7, this.environment));
    }

    public void addAttribute(Attribute attribute) throws NamingException {
        throw new AttributeModificationException();
    }

    public void deleteAttribute(Attribute attribute) throws NamingException {
        throw new AttributeModificationException();
    }

    public void modifyAttribute(Attribute attribute) throws NamingException {
        throw new AttributeModificationException();
    }

    public String getID() {
        return "Effective Rights";
    }

    public boolean compare(SearchStringComponent searchStringComponent) throws NamingException {
        try {
            return this.equals(searchStringComponent);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            InvalidSearchFilterException invalidSearchFilterException = new InvalidSearchFilterException();
            invalidSearchFilterException.setRootCause(illegalArgumentException);
            throw invalidSearchFilterException;
        }
    }

    public boolean equals(SearchStringComponent searchStringComponent) {
        if (searchStringComponent == null) {
            return false;
        }
        int n = searchStringComponent.getOperationType();
        if (n == 4) {
            return true;
        }
        if (n != 0 && n != 5) {
            return false;
        }
        EffectiveRights effectiveRights = null;
        String string = null;
        boolean bl = true;
        if (searchStringComponent.operandReplacement()) {
            effectiveRights = (EffectiveRights)searchStringComponent.getReplacementObject();
            if (effectiveRights == null) {
                throw new IllegalArgumentException(searchStringComponent.getOperation());
            }
            EffectiveRights effectiveRights2 = effectiveRights;
            synchronized (effectiveRights2) {
                string = effectiveRights.getUser();
            }
            bl = false;
        } else {
            string = searchStringComponent.getOperand();
        }
        this.refresh();
        if (n == 0) {
            if (bl) {
                return string.equalsIgnoreCase(this.getUser());
            }
            try {
                EffectiveRights effectiveRights3 = effectiveRights;
                synchronized (effectiveRights3) {
                    boolean bl2 = this.equals(effectiveRights);
                    Object var8_9 = null;
                    return bl2;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (n == 5) {
            return SearchStringComponent.compareSubString(string, this.getUser(), true);
        }
        return false;
    }

    public Object getStaticInterface() {
        EffectiveRightsImpl effectiveRightsImpl = null;
        effectiveRightsImpl = new EffectiveRightsImpl(this.environment);
        effectiveRightsImpl.refresh();
        return effectiveRightsImpl;
    }

    public void setUser(String string) {
        super.setUser(string);
        this.refresh();
    }

    public void refresh() throws NSIException {
        try {
            int[] nArray = new int[1];
            if (this.userWasSet) {
                this.userId = ObjectNameImpl.nameToObjectId(this.user, this.callsService, this.netService, this.sessionIsNDS);
                String string = this.fullNodeName;
                if (string.indexOf(58) == -1) {
                    string = String.valueOf(string) + ":";
                }
                this.callsService.getObjectEffectiveRights(this.userId, 0, string, NameSpace.nameToNumber(this.nameSpace), nArray);
                this.rights = nArray[0];
                return;
            }
            this.callsService.getEffectiveRights(0, this.fullNodeName, NameSpace.nameToNumber(this.nameSpace), nArray);
            this.rights = nArray[0];
            this.user = (String)this.environment.getSession().getAttributes(new String[]{"USER_NAME"}).getValue("USER_NAME");
            return;
        }
        catch (SessionException sessionException) {
            throw new NSIException(sessionException.getMessage(), 0, sessionException);
        }
        catch (NamingException namingException) {
            throw new NSIException(namingException.getMessage(), 0, namingException);
        }
    }

    public void modify(EffectiveRights effectiveRights) throws NSIException {
        throw new NSIException();
    }
}

