/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.file.nw.naming;

import com.novell.service.file.nw.naming.FSAttributeValueEnumerator;
import com.novell.utility.naming.directory.StaticAttributeValue;
import java.util.Enumeration;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;

public class FSAttribute
extends BasicAttribute {
    private StaticAttributeValue attributeValue;
    private DirContext attrDef;
    private DirContext syntaxDef;
    private Enumeration attributeEnumerator;
    private boolean avStripped = false;
    private boolean lazyAlreadyReturned = false;

    public FSAttribute(String string, StaticAttributeValue staticAttributeValue, DirContext dirContext, DirContext dirContext2) {
        super(string);
        this.attributeValue = staticAttributeValue;
        this.attrDef = dirContext;
        this.syntaxDef = dirContext2;
        this.checkState();
    }

    public Object clone() {
        this.checkState();
        FSAttribute fSAttribute = (FSAttribute)super.clone();
        fSAttribute.attributeValue = this.attributeValue;
        fSAttribute.attrDef = this.attrDef;
        fSAttribute.syntaxDef = this.syntaxDef;
        fSAttribute.attributeEnumerator = this.attributeEnumerator;
        fSAttribute.avStripped = this.avStripped;
        fSAttribute.lazyAlreadyReturned = this.lazyAlreadyReturned;
        return fSAttribute;
    }

    public boolean contains(Object object) {
        this.checkState();
        return super.contains(object);
    }

    public boolean equals(Object object) {
        FSAttribute fSAttribute;
        this.checkState();
        return super.equals(object) && object instanceof FSAttribute && (fSAttribute = (FSAttribute)object).getAttributeDefinition() == this.attrDef && fSAttribute.getAttributeSyntaxDefinition() == this.syntaxDef;
    }

    public DirContext getAttributeDefinition() {
        return this.attrDef;
    }

    public DirContext getAttributeSyntaxDefinition() {
        return this.syntaxDef;
    }

    public int size() {
        this.checkState();
        return super.size();
    }

    public NamingEnumeration getAll() throws NamingException {
        this.checkState();
        return super.getAll();
    }

    public Enumeration getValuesLazyEvaluation() {
        if (this.lazyAlreadyReturned) {
            throw new IllegalStateException();
        }
        if (this.avStripped) {
            throw new IllegalStateException();
        }
        this.lazyAlreadyReturned = true;
        return new FSAttributeValueEnumerator(this.attributeValue);
    }

    public void clear() {
        this.checkState();
        super.clear();
    }

    public boolean remove(Object object) {
        this.checkState();
        return super.remove(object);
    }

    public boolean add(Object object) {
        this.checkState();
        return super.add(object);
    }

    public String toString() {
        this.checkState();
        String string = super.toString();
        String string2 = String.valueOf(this.attrDef.toString()) + ", " + this.syntaxDef.toString() + ", ";
        return String.valueOf(string2) + string;
    }

    private void checkState() {
        if (this.lazyAlreadyReturned) {
            throw new IllegalStateException();
        }
        if (!this.avStripped) {
            while (this.attributeValue.hasMoreElements()) {
                super.add(this.attributeValue.nextElement());
            }
            this.avStripped = true;
        }
    }
}

