/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.jncpv2.net;

import com.novell.java.io.EndianInputStream;
import com.novell.service.jncp.NSIException;
import com.novell.service.nds.NdsAttributeDefinitionInfo;
import java.io.IOException;
import java.io.Serializable;

public final class NetAttrInfo
implements NdsAttributeDefinitionInfo,
Serializable {
    private int type;
    private String name;
    private int flags;
    private int syntaxId;
    private int lowerLimit;
    private int upperLimit;
    private byte[] ASN1ID;

    public NetAttrInfo(EndianInputStream endianInputStream, int n) throws NSIException {
        this.type = n;
        try {
            endianInputStream.align32();
            endianInputStream.readLoHiInt();
            this.name = endianInputStream.readLoHiChars();
            if (n == 0) {
                return;
            }
            endianInputStream.align32();
            this.flags = endianInputStream.readLoHiInt();
            this.syntaxId = endianInputStream.readLoHiInt();
            this.lowerLimit = endianInputStream.readLoHiInt();
            this.upperLimit = endianInputStream.readLoHiInt();
            int n2 = endianInputStream.readLoHiInt();
            this.ASN1ID = new byte[n2];
            endianInputStream.readFully(this.ASN1ID);
            return;
        }
        catch (IOException iOException) {
            throw new NSIException();
        }
    }

    public String getName() {
        return this.name;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getAttributeFlags() {
        return this.flags;
    }

    public int getSyntaxID() {
        return this.syntaxId;
    }

    public int getLowerLimit() {
        return this.lowerLimit;
    }

    public int getUpperLimit() {
        return this.upperLimit;
    }

    public byte[] getASN1ID() {
        return this.ASN1ID;
    }
}

