/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.jncpv2.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetBuffer;
import com.novell.service.jncpv2.net.NetIterationHandle;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.NdsIteratorInfo;
import com.novell.service.session.SessionException;

public final class NetIterator
implements Cloneable {
    public static final int DS_ITR_INVALID = 0;
    public static final int DS_ITR_INVALID_HANDLE = -399;
    public static final int DS_ITR_INVALID_POSITION = -398;
    public static final int DS_ITR_INVALID_SEARCH_DATA = -397;
    public static final int DS_ITR_INVALID_SCOPE = -395;
    public static final int ERR_BOF_HIT = -764;
    public static final int ERR_EOF_HIT = -765;
    private NetService service;
    private int handle;

    public NetIterator(NetService netService, String string, int n, boolean bl, int n2) throws NSIException {
        this(netService, string, 1, true, n, 0, 1, bl, n2, "", "", 0, 0);
    }

    public NetIterator(NetService netService, String string, int n, boolean bl, int n2, int n3, int n4, boolean bl2, int n5, String string2, String string3, int n6, int n7) throws NSIException {
        this.service = netService;
        try {
            int[] nArray = new int[1];
            netService.itrCreateSearch(string, n, bl, n2, n3, n4, bl2, n5, string2, string3, n6, n7, nArray);
            this.handle = nArray[0];
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public NetIterator(NetService netService, String string, String string2, String string3, int n, int n2) throws NSIException {
        this.service = netService;
        try {
            int[] nArray = new int[1];
            netService.itrCreateList(string, string2, string3, n, n2, nArray);
            this.handle = nArray[0];
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public void finalize() {
        try {
            if (this.handle != 0) {
                this.service.itrDestroy(this.handle);
                this.handle = 0;
                return;
            }
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public void destroy() throws NSIException {
        try {
            this.service.itrDestroy(this.handle);
            this.handle = 0;
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public boolean atFirst() throws NSIException {
        try {
            return this.service.itrAtFirst(this.handle);
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public boolean atEOF() throws NSIException {
        try {
            return this.service.itrAtEOF(this.handle);
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public NdsIteratorInfo getInfo() throws NSIException {
        boolean[] blArray = new boolean[1];
        boolean[] blArray2 = new boolean[1];
        try {
            this.service.itrGetInfo(this.handle, blArray, blArray2);
            return new Info(blArray[0], blArray2[0]);
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public int getPosition(int n) throws NSIException {
        try {
            int[] nArray = new int[1];
            this.service.itrGetPosition(this.handle, nArray, n);
            return nArray[0];
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public void setPosition(int n, int n2) throws NSIException {
        try {
            this.service.itrSetPosition(this.handle, n, n2);
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public void setPosition(NetIterator netIterator, int n) throws NSIException {
        try {
            this.service.itrSetPositionFromIterator(this.handle, netIterator.handle, n);
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public void setPosition(String string, String string2, int n) throws NSIException {
        try {
            this.service.itrTypeDown(this.handle, string, string2, n);
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public int skip(int n, int n2) throws NSIException {
        try {
            int[] nArray = new int[1];
            this.service.itrSkip(this.handle, n, n2, nArray);
            return nArray[0];
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public void getNext(int n, int n2, NetIterationHandle netIterationHandle, NetBuffer netBuffer) throws NSIException {
        try {
            this.service.itrGetNext(this.handle, n, n2, netIterationHandle, netBuffer.getHandle());
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public void getPrev(int n, int n2, NetIterationHandle netIterationHandle, NetBuffer netBuffer) throws NSIException {
        try {
            this.service.itrGetPrev(this.handle, n, n2, netIterationHandle, netBuffer.getHandle());
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public void getCurrent(NetIterationHandle netIterationHandle, NetBuffer netBuffer) throws NSIException {
        try {
            this.service.itrGetCurrent(this.handle, netIterationHandle, netBuffer.getHandle());
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public int count(int n, int n2, boolean bl) throws NSIException {
        try {
            int[] nArray = new int[1];
            this.service.itrCount(this.handle, n, n2, bl, nArray);
            return nArray[0];
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public Object clone() {
        try {
            int[] nArray = new int[1];
            NetIterator netIterator = (NetIterator)super.clone();
            this.service.itrClone(this.handle, nArray);
            netIterator.service = this.service;
            netIterator.handle = nArray[0];
            return netIterator;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    class Info
    implements NdsIteratorInfo {
        boolean scalable;
        boolean positionable;

        Info(boolean bl, boolean bl2) {
            NetIterator.this = NetIterator.this;
            this.scalable = bl;
            this.positionable = bl2;
        }

        public boolean isScalable() {
            return this.scalable;
        }

        public boolean isPositionable() {
            return this.positionable;
        }
    }
}

