/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.jncpv2.net;

import com.novell.java.io.EndianInputStream;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetEntryInfo;
import com.novell.service.jncpv2.net.NetService;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class NetListBuffer
implements Serializable {
    private byte[] buffer;

    public NetListBuffer(NetService netService) {
        this.buffer = new byte[4096];
    }

    public NetListBuffer(NetService netService, int n) {
        this.buffer = new byte[n];
    }

    byte[] getBuffer() {
        return this.buffer;
    }

    public Enumeration getEntries() throws NSIException {
        return new EntryEnumerator();
    }

    class EntryEnumerator
    implements Enumeration {
        private int entriesLeft;
        private EndianInputStream eisEntries;

        protected EntryEnumerator() throws NSIException {
            NetListBuffer.this = NetListBuffer.this;
            try {
                this.eisEntries = new EndianInputStream(NetListBuffer.this.buffer);
                this.entriesLeft = this.eisEntries.readLoHiInt();
                return;
            }
            catch (IOException iOException) {
                throw new NSIException();
            }
        }

        public boolean hasMoreElements() {
            return this.entriesLeft != 0;
        }

        public Object nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            --this.entriesLeft;
            return new NetEntryInfo(this.eisEntries, true);
        }
    }
}

