/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds;

import com.novell.service.nds.NdsAttributeValue;
import com.novell.service.nds.NdsInteger;
import com.novell.service.nds.NdsString;
import com.novell.service.schema.SchemaComposite;
import com.novell.service.schema.SchemaValue;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class NdsPath
implements NdsAttributeValue,
SchemaComposite,
Cloneable,
Serializable {
    private static final int matchingRules = 1;
    private static String[] compositeIds = new String[3];
    protected int nameSpaceType;
    protected String volumeName;
    protected String path;
    private String name;

    public NdsPath(long l, String string, String string2) {
        this("", l, string, string2);
    }

    protected NdsPath() {
        this.nameSpaceType = -1;
    }

    private NdsPath(String string, long l, String string2, String string3) {
        this.nameSpaceType = (int)(l & 0xFFFFFFFFL);
        this.volumeName = string2;
        this.path = string3;
        this.name = string;
    }

    protected NdsPath(NdsPath ndsPath) {
        this.nameSpaceType = ndsPath.nameSpaceType;
        this.volumeName = ndsPath.volumeName;
        this.path = ndsPath.path;
        this.name = ndsPath.name;
    }

    public int compareTo(Object object) throws Exception {
        throw new Exception();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof NdsPath) {
            NdsPath ndsPath = (NdsPath)object;
            if (this.nameSpaceType != ndsPath.nameSpaceType) {
                return false;
            }
            if (!this.volumeName.equals(ndsPath.volumeName)) {
                return false;
            }
            return this.path.equals(ndsPath.path);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getSyntaxId() {
        return "Path";
    }

    public int count() {
        return compositeIds.length;
    }

    public SchemaValue getValue(String string) {
        if (string.equalsIgnoreCase(compositeIds[0])) {
            return new NdsInteger(compositeIds[0], this.nameSpaceType);
        }
        if (string.equalsIgnoreCase(compositeIds[1])) {
            return new NdsString(compositeIds[1], this.volumeName);
        }
        if (string.equalsIgnoreCase(compositeIds[2])) {
            return new NdsString(compositeIds[2], this.path);
        }
        return null;
    }

    public Enumeration getValueIds() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < compositeIds.length) {
            vector.addElement(compositeIds[n]);
            ++n;
        }
        return vector.elements();
    }

    public Enumeration getValues() {
        Vector<SchemaValue> vector = new Vector<SchemaValue>();
        vector.addElement(new NdsInteger(compositeIds[0], this.nameSpaceType));
        vector.addElement(new NdsString(compositeIds[1], this.volumeName));
        vector.addElement(new NdsString(compositeIds[2], this.path));
        return vector.elements();
    }

    public boolean approximate(Object object) throws Exception {
        throw new Exception();
    }

    public int getNdsSyntaxId() {
        return 15;
    }

    public boolean supportsMatchingRules(int n) {
        return (n & 1) == n;
    }

    public Object clone() {
        try {
            NdsPath ndsPath = (NdsPath)super.clone();
            ndsPath.nameSpaceType = this.nameSpaceType;
            ndsPath.volumeName = this.volumeName;
            ndsPath.path = this.path;
            ndsPath.name = this.name;
            return ndsPath;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.nameSpaceType)) + ";" + this.volumeName + ";" + this.path;
    }

    public long getNameSpaceType() {
        return (long)this.nameSpaceType & 0xFFFFFFFFL;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getPath() {
        return this.path;
    }

    static {
        NdsPath.compositeIds[0] = "nameSpaceType";
        NdsPath.compositeIds[1] = "volumeName";
        NdsPath.compositeIds[2] = "path";
    }
}

