/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds;

import com.novell.service.nds.NdsAttributeValue;
import com.novell.service.nds.NdsInteger;
import com.novell.service.nds.NdsString;
import com.novell.service.schema.SchemaComposite;
import com.novell.service.schema.SchemaValue;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class NdsTypedName
implements NdsAttributeValue,
SchemaComposite,
Cloneable,
Serializable {
    private static final int matchingRules = 1;
    private static String[] compositeIds = new String[3];
    protected String objectName;
    protected int level;
    protected int interval;
    private String name;

    public NdsTypedName(String string, long l, long l2) {
        this.objectName = string;
        this.level = (int)(l & 0xFFFFFFFFL);
        this.interval = (int)(l2 & 0xFFFFFFFFL);
    }

    protected NdsTypedName() {
        this.level = -1;
        this.interval = -1;
    }

    private NdsTypedName(String string, String string2, int n, int n2) {
        this.name = string;
        this.objectName = string2;
        this.level = n;
        this.interval = n2;
    }

    protected NdsTypedName(NdsTypedName ndsTypedName) {
        this.objectName = ndsTypedName.objectName;
        this.level = ndsTypedName.level;
        this.interval = ndsTypedName.interval;
        this.name = ndsTypedName.name;
    }

    public int compareTo(Object object) throws Exception {
        throw new Exception();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof NdsTypedName) {
            NdsTypedName ndsTypedName = (NdsTypedName)object;
            if (!this.objectName.equals(ndsTypedName.objectName)) {
                return false;
            }
            if (this.level != ndsTypedName.level) {
                return false;
            }
            return this.interval == ndsTypedName.interval;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getSyntaxId() {
        return "Typed Name";
    }

    public int count() {
        return compositeIds.length;
    }

    public SchemaValue getValue(String string) {
        if (string.equalsIgnoreCase(compositeIds[0])) {
            return new NdsString(compositeIds[0], this.objectName);
        }
        if (string.equalsIgnoreCase(compositeIds[1])) {
            return new NdsInteger(compositeIds[1], this.level);
        }
        if (string.equalsIgnoreCase(compositeIds[2])) {
            return new NdsInteger(compositeIds[2], this.interval);
        }
        return null;
    }

    public Enumeration getValueIds() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < compositeIds.length) {
            vector.addElement(compositeIds[n]);
            ++n;
        }
        return vector.elements();
    }

    public Enumeration getValues() {
        Vector<SchemaValue> vector = new Vector<SchemaValue>();
        vector.addElement(new NdsString(compositeIds[0], this.objectName));
        vector.addElement(new NdsInteger(compositeIds[1], this.level));
        vector.addElement(new NdsInteger(compositeIds[2], this.interval));
        return vector.elements();
    }

    public boolean approximate(Object object) throws Exception {
        throw new Exception();
    }

    public int getNdsSyntaxId() {
        return 25;
    }

    public boolean supportsMatchingRules(int n) {
        return (n & 1) == n;
    }

    public Object clone() {
        try {
            NdsTypedName ndsTypedName = (NdsTypedName)super.clone();
            ndsTypedName.objectName = this.objectName;
            ndsTypedName.level = this.level;
            ndsTypedName.interval = this.interval;
            ndsTypedName.name = this.name;
            return ndsTypedName;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return String.valueOf(this.objectName) + ";" + String.valueOf(this.level) + ";" + String.valueOf(this.interval);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public long getLevel() {
        return (long)this.level & 0xFFFFFFFFL;
    }

    public long getInterval() {
        return (long)this.interval & 0xFFFFFFFFL;
    }

    static {
        NdsTypedName.compositeIds[0] = "objectName";
        NdsTypedName.compositeIds[1] = "level";
        NdsTypedName.compositeIds[2] = "interval";
    }
}

