/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming;

import com.novell.service.session.Session;
import com.novell.service.session.SessionEnv;
import com.novell.service.session.SessionException;
import com.novell.service.session.SessionManager;
import com.novell.service.session.SessionManagerFactory;
import com.novell.utility.naming.Environment;
import java.io.Serializable;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;

public class NdsEnvironment
extends Environment
implements Cloneable,
Serializable {
    public static final String DISALLOW_REFERRALS = "java.naming.nds.disallowReferrals";
    public static final String LAST_CONNECTION = "java.naming.nds.lastConnection";
    public static final String CONFIDENCE = "java.naming.nds.confidence";
    public static final String NAME_CACHE_DEPTH = "java.naming.nds.nameCacheDepth";
    public static final String TYPELESS_NAMES = "java.naming.nds.typelessNames";
    public static final Integer DCV_LOW_CONF = new Integer(0);
    public static final Integer DCV_MED_CONF = new Integer(1);
    public static final Integer DCV_HIGH_CONF = new Integer(2);
    public static final String OBJECT_ATTRS = "OBJECT_ATTRS";
    public static final String OBJECT_ATTR_NAMES = "OBJECT_ATTR_NAMES";
    public static final String DSI_OBJECT_ATTRS = "DSI_OBJECT_ATTRS";
    public static final String OBJECT_ATTRIBUTE_LEVEL = "java.naming.nds.objectAttributeLevel";
    public static final String DEFAULT_ATTRS = "OBJECT_ATTRS";
    public static final String CLASS_DEFS = "CLASS_DEFS";
    public static final String EXPANDED_CLASS_DEFS = "EXPANDED_CLASS_DEFS";
    public static final String INFO_CLASS_DEFS = "INFO_CLASS_DEFS";
    public static final String FULL_CLASS_DEFS = "FULL_CLASS_DEFS";
    public static final String CLASS_ATTRIBUTE_LEVEL = "java.naming.nds.classAttributeLevel";
    public static final String DEFAULT_DEFS = "CLASS_DEFS";
    public static final String NDS_TRANSPORT_PROTOCOL = "java.naming.nds.transport.protocol";

    public NdsEnvironment(Hashtable hashtable) {
        super(hashtable);
    }

    public NdsEnvironment(Environment environment) throws NamingException {
        super(environment);
    }

    public Session getSession() throws NamingException {
        throw new OperationNotSupportedException();
    }

    public SessionManager getSessionManager() throws NamingException {
        try {
            SessionManager sessionManager = super.getSessionManager();
            if (sessionManager == null) {
                SessionEnv sessionEnv = new SessionEnv();
                sessionEnv.put("com.novell.service.session.spi.InitialSessionFactory", "com.novell.service.session.nds.NDSInitialSessionFactory:com.novell.service.session.bindery.BinderyInitialSessionFactory");
                sessionManager = SessionManagerFactory.getSessionManager(sessionEnv);
                this.environment.put("java.naming.session.manager", sessionManager);
            }
            return sessionManager;
        }
        catch (SessionException sessionException) {
            AuthenticationException authenticationException = new AuthenticationException();
            authenticationException.setRootCause(sessionException);
            throw authenticationException;
        }
    }

    public String getNdsTransportProtocol() throws NamingException {
        String string = (String)this.environment.get(NDS_TRANSPORT_PROTOCOL);
        if (string == null) {
            return "ncp";
        }
        if ((string = string.toLowerCase()).equals("ncp")) {
            return string;
        }
        if (string.equals("ldap")) {
            return string;
        }
        throw new NamingException();
    }
}

