/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.nds.NdsCaseExactString;
import com.novell.service.nds.NdsClassName;
import com.novell.service.nds.NdsOctetString;
import com.sun.jndi.toolkit.chars.BASE64Decoder;
import com.sun.jndi.toolkit.chars.BASE64Encoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.InvalidAttributesException;

public class JavaObject {
    protected static Attributes encodeObject(char c, Object object, Attributes attributes, boolean bl) throws NamingException {
        if (attributes == null) {
            attributes = new BasicAttributes();
        }
        Attribute attribute = JavaObject.getObjectClass(attributes);
        if (object instanceof Referenceable) {
            return JavaObject.encodeReference(c, ((Referenceable)object).getReference(), attributes, attribute);
        }
        if (object instanceof Reference) {
            return JavaObject.encodeReference(c, (Reference)object, attributes, attribute);
        }
        if (!(object instanceof Serializable)) {
            throw new IllegalArgumentException();
        }
        JavaObject.encodeSerializedObject(object, attributes, attribute);
        return attributes;
    }

    static Object decodeObject(Attributes attributes) throws NamingException {
        Attribute attribute = JavaObject.getObjectClass(attributes);
        String string = JavaObject.javaCodeBase(attributes);
        try {
            if (attribute.contains(new NdsClassName("javaSerializedObject"))) {
                return JavaObject.decodeSerializedObject(attributes);
            }
            if (attribute.contains(new NdsClassName("javaNamingReference"))) {
                return JavaObject.decodeReference(attributes, string);
            }
            throw new NamingException();
        }
        catch (IOException iOException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(iOException);
            throw namingException;
        }
    }

    private static Attributes encodeReference(char c, Reference reference, Attributes attributes, Attribute attribute) throws NamingException {
        int n;
        attribute.add(new NdsClassName("javaNamingReference"));
        attributes.put(attribute);
        String string = reference.getClassName();
        if (string != null) {
            attributes.put(new BasicAttribute("javaClassName", new NdsCaseExactString(string)));
        }
        if ((string = reference.getFactoryClassName()) != null) {
            attributes.put(new BasicAttribute("javaFactory", new NdsCaseExactString(string)));
        }
        if ((string = reference.getFactoryClassLocation()) != null) {
            attributes.put(new BasicAttribute("javaCodeBase", new NdsCaseExactString(string)));
        }
        if ((n = reference.size()) > 0) {
            BasicAttribute basicAttribute = new BasicAttribute("javaReferenceAddress");
            BASE64Encoder bASE64Encoder = null;
            int n2 = 0;
            while (n2 < n) {
                RefAddr refAddr = reference.get(n2);
                if (refAddr instanceof StringRefAddr) {
                    basicAttribute.add(new NdsCaseExactString("" + c + n2 + c + refAddr.getType() + c + refAddr.getContent()));
                } else {
                    if (bASE64Encoder == null) {
                        bASE64Encoder = new BASE64Encoder();
                    }
                    basicAttribute.add(new NdsCaseExactString("" + c + n2 + c + refAddr.getType() + c + c + bASE64Encoder.encodeBuffer(JavaObject.serializeObject(refAddr))));
                }
                ++n2;
            }
            attributes.put(basicAttribute);
        }
        return attributes;
    }

    private static Reference decodeReference(Attributes attributes, String string) throws NamingException, IOException {
        String string2 = null;
        Attribute attribute = attributes.get("javaClassName");
        if (attribute == null) {
            throw new InvalidAttributesException("javaClassName attribute is required");
        }
        String string3 = ((NdsCaseExactString)attribute.get()).getCaseExactString();
        attribute = attributes.get("javaFactory");
        if (attribute != null) {
            string2 = ((NdsCaseExactString)attribute.get()).getCaseExactString();
        }
        Reference reference = new Reference(string3, string2, string);
        attribute = attributes.get("javaReferenceAddress");
        if (attribute != null) {
            BASE64Decoder bASE64Decoder = null;
            NamingEnumeration<?> namingEnumeration = attribute.getAll();
            while (namingEnumeration.hasMore()) {
                int n;
                int n2;
                String string4 = ((NdsCaseExactString)namingEnumeration.next()).getCaseExactString();
                if (string4.length() == 0) {
                    throw new InvalidAttributeValueException("malformed javaReferenceAddress attribute - empty attribute value");
                }
                char c = string4.charAt(0);
                int n3 = string4.indexOf(c, n2 = 1);
                if (n3 < 0) {
                    throw new InvalidAttributeValueException("malformed javaReferenceAddress attribute - separator '" + c + "'" + "not found");
                }
                String string5 = string4.substring(n2, n3);
                if (string5 == null) {
                    throw new InvalidAttributeValueException("malformed javaReferenceAddress attribute - empty RefAddr position");
                }
                try {
                    n = Integer.parseInt(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidAttributeValueException("malformed javaReferenceAddress attribute - RefAddr position not an integer");
                }
                n2 = n3 + 1;
                n3 = string4.indexOf(c, n2);
                if (n3 < 0) {
                    throw new InvalidAttributeValueException("malformed javaReferenceAddress attribute - RefAddr type not found");
                }
                String string6 = string4.substring(n2, n3);
                if (string6 == null) {
                    throw new InvalidAttributeValueException("malformed javaReferenceAddress attribute - empty RefAddr type");
                }
                n2 = n3 + 1;
                if (n2 == string4.length()) {
                    reference.add(n, new StringRefAddr(string6, null));
                    continue;
                }
                if (string4.charAt(n2) == c) {
                    ++n2;
                    if (bASE64Decoder == null) {
                        bASE64Decoder = new BASE64Decoder();
                    }
                    RefAddr refAddr = (RefAddr)JavaObject.deserializeObject(bASE64Decoder.decodeBuffer(string4.substring(n2)));
                    reference.add(n, refAddr);
                    continue;
                }
                reference.add(n, new StringRefAddr(string6, string4.substring(n2)));
            }
        }
        return reference;
    }

    private static Attributes encodeRemoteObject(Object object, Attributes attributes, Attribute attribute) throws NamingException {
        return null;
    }

    private static Object decodeRemoteObject(Attributes attributes) throws NamingException {
        return null;
    }

    private static Attributes encodeSerializedObject(Object object, Attributes attributes, Attribute attribute) throws NamingException {
        attribute.add(new NdsClassName("javaSerializedObject"));
        attributes.put(attribute);
        attributes.put("javaClassName", new NdsCaseExactString(object.getClass().getName()));
        attributes.put("javaSerializedData", new NdsOctetString(JavaObject.serializeObject(object)));
        return attributes;
    }

    private static Object decodeSerializedObject(Attributes attributes) throws NamingException {
        return JavaObject.deserializeObject(JavaObject.javaSerializedData(attributes));
    }

    private static Attribute getObjectClass(Attributes attributes) throws NamingException {
        Attribute attribute = attributes.get("Object Class");
        if (attribute == null) {
            attribute = new BasicAttribute("Object Class", new NdsClassName("javaContainer"));
        }
        return attribute;
    }

    private static String javaCodeBase(Attributes attributes) throws NamingException {
        Attribute attribute = attributes.get("javaCodeBase");
        if (attribute != null) {
            return ((NdsCaseExactString)attribute.get()).getCaseExactString();
        }
        return null;
    }

    private static byte[] javaSerializedData(Attributes attributes) throws NamingException {
        Attribute attribute = attributes.get("javaSerializedData");
        if (attribute != null) {
            NdsOctetString ndsOctetString = (NdsOctetString)attribute.get();
            return ndsOctetString.getOctetString();
        }
        throw new NamingException();
    }

    private static byte[] serializeObject(Object object) throws NamingException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(iOException);
            throw namingException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object deserializeObject(byte[] byArray) throws NamingException {
        try {
            Object object;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            try {
                try {
                    object = objectInputStream.readObject();
                    Object var5_6 = null;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    NamingException namingException = new NamingException();
                    namingException.setRootCause(classNotFoundException);
                    throw namingException;
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                objectInputStream.close();
                throw throwable;
            }
            objectInputStream.close();
            return object;
        }
        catch (IOException iOException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(iOException);
            throw namingException;
        }
    }
}

